include <BOSL2/std.scad>

wrist_width = 28; //mm
wrist_thickness = 49; //mm
wrist_band_thickness = 5; //mm
wrist_band_length = 35; //mm
wrist_band_rounding = 4; //mm
flat_width = 10; //mm
flat_thickness = 7; //mm

laces_width = 5; //mm
laces_thickness = 10; //mm
laces_holes = 3; //mm
laces_holes_diameter = 6.5; //mm
laces_hole_spacing = 0; //mm

pick_holder_radius = 50; //mm
pick_holder_thickness = 7; //mm
pick_holder_protrusion = 20; //mm
pick_holder_screws_padding = 1; //mm
pick_holder_screws_diameter = 2; //mm

logo_depth = 1; //mm
logo_padding = 1.5; //mm
text_padding = 1; //mm
text_size = 2.9; //mm
text_depth = 1; //mm
text_content = "T-Shred v0.2";
text_font = "Iosevka:style=bold";

a_rounding = 1.5; //mm
b_rounding = 1.5; //mm

tolerances = 0.1; //mm

fix_floating_point_small_value = 0.001; //mm

resolution = 100;

// Code
non_flat_width = wrist_width-flat_width;
non_flat_thickness = wrist_thickness-flat_thickness;
wrist_width_edge = wrist_band_thickness*2+non_flat_width;
wrist_thickness_edge = wrist_band_thickness*2+non_flat_thickness;

module quarter_wrist_band(){
translate([flat_width/2-wrist_width_edge/2,flat_thickness/2-wrist_thickness_edge/2,0])
difference(){
translate([wrist_width_edge/2,wrist_thickness_edge/2,wrist_band_length/2])
difference(){
scale([wrist_width_edge/wrist_thickness_edge,1,1])
union(){
cyl(d=wrist_thickness_edge,length=wrist_band_length,rounding=a_rounding,$fn=resolution);
translate([non_flat_thickness/2,-flat_thickness/2,-wrist_band_length/2])
cuboid([wrist_band_thickness,flat_thickness/2,wrist_band_length],anchor=BOTTOM+LEFT+FRONT,rounding=a_rounding,edges=[RIGHT+TOP,RIGHT+BOTTOM],$fn=resolution);
}
scale([non_flat_width/non_flat_thickness,1,1])
union(){
cyl(d=non_flat_thickness,length=wrist_band_length,rounding=-a_rounding,$fn=resolution);

translate([non_flat_thickness/2-wrist_band_thickness,-flat_thickness/2,-wrist_band_length/2])
cuboid([wrist_band_thickness,flat_thickness/2,wrist_band_length],anchor=BOTTOM+LEFT+FRONT);
}
}
cube([wrist_width_edge/2,wrist_thickness_edge,wrist_band_length]);
translate([0,-flat_thickness,0])
cube([wrist_width_edge,wrist_thickness_edge/2+flat_thickness/2,wrist_band_length]);
}
translate([0,flat_thickness/2+non_flat_thickness/2,0])
cuboid([flat_width/2+fix_floating_point_small_value,wrist_band_thickness,wrist_band_length],anchor=BOTTOM+LEFT+FRONT,rounding=a_rounding,edges=[FRONT+LEFT,FRONT+TOP,FRONT+BOTTOM],$fn=resolution);
translate([0,flat_thickness/2+non_flat_thickness/2+wrist_band_thickness,0])
difference(){
cuboid([laces_width,laces_thickness,wrist_band_length],anchor=BOTTOM+LEFT+FRONT,rounding=a_rounding,edges=[BACK],$fn=resolution);
length_of_holes = laces_holes*laces_holes_diameter+(laces_holes-1)*laces_hole_spacing;
translate ([laces_width/2,laces_thickness/2,0])
for ( i = [0:laces_holes-1]) {
translate ([0,0,wrist_band_length/2-length_of_holes/2+length_of_holes/(laces_holes-1)*i])
     xcyl(d=laces_holes_diameter,length=laces_width,$fn=resolution);
}
}
}

module pick_holder(){
difference(){
intersection(){
cuboid([pick_holder_protrusion,pick_holder_thickness,wrist_band_length],anchor=BOTTOM+LEFT+FRONT,rounding=b_rounding,edges=[BACK+TOP,BACK+BOTTOM,FRONT+TOP,FRONT+BOTTOM],$fn=resolution);
translate([0,pick_holder_radius+pick_holder_thickness/2,wrist_band_length/2])
translate([pick_holder_protrusion/2,0,0])
difference(){
translate([0,-pick_holder_thickness/2,0])
xcyl(r=pick_holder_radius,length=pick_holder_protrusion,$fn=resolution*2);
xcyl(r=pick_holder_radius,length=pick_holder_protrusion,$fn=resolution*2);
}
}
pick_holder_screws_diameter_with_tolerance=tolerances*2+pick_holder_screws_diameter;

for (i = [0:1]){
z_offset = (1-i*2)*(pick_holder_screws_diameter_with_tolerance+pick_holder_screws_diameter/2);
translate ([pick_holder_screws_diameter_with_tolerance+pick_holder_screws_diameter/2,pick_holder_thickness/2,i*wrist_band_length+z_offset])
     ycyl(d=pick_holder_screws_diameter_with_tolerance,length=pick_holder_thickness,$fn=resolution);
}
}
}

module half_wrist_band(invert=false){
    difference(){
    union(){
quarter_wrist_band();
scale([1,-1,1])quarter_wrist_band();
    }
    if (invert){
        {
    translate([wrist_width_edge/2+flat_width/2,flat_thickness/2,logo_padding])
    rotate([90,0,-90])
            union(){
                
                rotate([180,0,90]) #translate([flat_thickness+text_padding,(flat_thickness-text_size)/2,-text_depth]) linear_extrude(text_depth) text(text_content,size=text_size,font=text_font,$fn=resolution/4);
    scale([flat_thickness/168,flat_thickness/168,logo_depth/100])
surface(file = "assets/dinosaur.png", center = false);
            }
}}
}
if (!invert){
translate([wrist_width/2+wrist_band_thickness,-pick_holder_thickness/2,0])
pick_holder();
}
}