// Eclipse by OnTake
// Version 1
// 22/12/2021 - 20:56 UTC
// A pencil-sharpening plane.


include <BOSL/constants.scad>
use <BOSL/masks.scad>

renderResolution = 10;

sharpenerBodySize = [60,30,10]; // mm
sharpenerAngle = 45; // °
sharpenerScrewDiameter = 2; //mm
ScrewHeadDiameter = 4; // mm
ScrewHeadHeight = 5; //mm : Use a flat head screw or it's going to get ugly.
bladeDimensions = [23,7,1]; //mm : KUM Spare Blades for Standard Sharpeners
bladeTolerances = 0.1; //mm
bladeAlignOffset = [0,0,-1.1]; // mm
bladeClearanceAlignOffset = [-6,0,0]; //mm
bladeClearanceExtraY = 6; //mm
ScrewHeadAlignOffset = [0,0,4.5]; // mm
bevelRadius = 2; // mm
textAValue = "Eclipse";
textAFont = "Arial:style=Bold";
textAHeight = 1;
textASize = 5; // mm
textAOffset = [15,0,0.4]; // mm
textBValue = "by OnTake";
textBFont = "Arial:style=Bold";
textBHeight = 1;
textBSize = 3.5; // mm
textBOffset = [22,0,0.4]; // mm

difference() {
    // Body shape
    cube(center = false, size = sharpenerBodySize);
    // Blade shape
    translate([sharpenerBodySize.x/2,sharpenerBodySize.y/2,10])
    rotate([0,sharpenerAngle,0])
    translate(bladeAlignOffset)
    cube(center = true, size = [bladeDimensions.y+bladeTolerances,bladeDimensions.x+bladeTolerances,20]);   
    // Blade clearance shape
    translate([sharpenerBodySize.x/2,sharpenerBodySize.y/2,10])
    rotate([0,sharpenerAngle,0])
    translate(bladeAlignOffset)
    translate(bladeClearanceAlignOffset)
    cube(center = true, size = [bladeDimensions.y+bladeTolerances+bladeClearanceExtraY,bladeDimensions.x+bladeTolerances,20]);   
    // Screw hole shape
    translate([sharpenerBodySize.x/2,sharpenerBodySize.y/2,10])
    rotate([0,sharpenerAngle,0])
    translate(bladeAlignOffset)
    translate([0,0,-20])
    cylinder(h = 20, r1 = sharpenerScrewDiameter/2, r2 = sharpenerScrewDiameter/2, center = false, $fn=10*renderResolution);
    // Screw head hole shape 
    translate([sharpenerBodySize.x/2,sharpenerBodySize.y/2,10])
    rotate([0,sharpenerAngle,0])
    translate(bladeAlignOffset)
    translate([0,0,-20])
    translate(ScrewHeadAlignOffset)
    cylinder(h = ScrewHeadHeight, r1 = ScrewHeadDiameter/2, r2 = ScrewHeadDiameter/2, center = false, $fn=10*renderResolution);
    // Bevels
    // Height Filet
    translate([0,0,sharpenerBodySize.z]) fillet_mask_z(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    translate([sharpenerBodySize.x,0,sharpenerBodySize.z]) fillet_mask_z(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    translate([0,sharpenerBodySize.y,sharpenerBodySize.z]) fillet_mask_z(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    translate(sharpenerBodySize) fillet_mask_z(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    // Top Start
    // First Corner
    translate([0,0,sharpenerBodySize.z]) fillet_mask_x(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    translate([0,0,sharpenerBodySize.z]) fillet_mask_y(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    // Opposite Corner
    translate(sharpenerBodySize) fillet_mask_x(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    translate(sharpenerBodySize) fillet_mask_y(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    // Corner Filet
    translate([0,0,sharpenerBodySize.z]) fillet_corner_mask(r=bevelRadius, $fn=10*renderResolution);
    translate([sharpenerBodySize.x,0,sharpenerBodySize.z]) fillet_corner_mask(r=bevelRadius, $fn=10*renderResolution);
    translate([0,sharpenerBodySize.y,sharpenerBodySize.z]) fillet_corner_mask(r=bevelRadius, $fn=10*renderResolution);
    translate(sharpenerBodySize) fillet_corner_mask(r=bevelRadius, $fn=10*renderResolution);
    // Top End
    // Bottom Start
    // First Corner
    translate([0,0,0]) fillet_mask_x(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    translate([0,0,0]) fillet_mask_y(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    // Opposite Corner
    translate([sharpenerBodySize.x,sharpenerBodySize.y,0]) fillet_mask_x(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    translate([sharpenerBodySize.x,sharpenerBodySize.y,0]) fillet_mask_y(l=sharpenerBodySize.x*3, r=bevelRadius, $fn=10*renderResolution);
    // Corner Filet
    translate([0,0,0]) fillet_corner_mask(r=bevelRadius, $fn=10*renderResolution);
    translate([sharpenerBodySize.x,0,0]) fillet_corner_mask(r=bevelRadius, $fn=10*renderResolution);
    translate([0,sharpenerBodySize.y,0]) fillet_corner_mask(r=bevelRadius, $fn=10*renderResolution);
    translate([sharpenerBodySize.x,sharpenerBodySize.y,0]) fillet_corner_mask(r=bevelRadius, $fn=10*renderResolution);
    // Bottom End
}
// TextA
translate([sharpenerBodySize.x/2,sharpenerBodySize.y/2,sharpenerBodySize.z])
translate(textAOffset)
rotate([0,0,90])
linear_extrude(height=textAHeight)
text(textAValue,font=textAFont,size=textASize,valign="center",halign="center",$fn=10*renderResolution);
// TextB
translate([sharpenerBodySize.x/2,sharpenerBodySize.y/2,sharpenerBodySize.z])
translate(textBOffset)
rotate([0,0,90])
linear_extrude(height=textBHeight)
text(textBValue,font=textBFont,size=textBSize,valign="center",halign="center",$fn=10*renderResolution);