include <BOSL2/std.scad>


ruler_dimensions = [73,51]; //mm
ruler_thickness = 2; //mm
ruler_edge_radii = [2,4,6,8]; //mm

resolution = 200;
padding = 4; //mm
spacing = 1; //mm

squares_sizes = [1,2,3,4,5,6,8,10,12]; //mm

circles_offset = [0,6]; //mm
circles_diameters = [1,2,3,4,5,6,8,10,12]; //mm

rectangles_sizes = [[0.5,1,3,4,6,8],[0.5,1,2,4,6,8],[0.5,1,2,3,6,8],[0.5,1,2,3,4,6,8],[0.5,1,2,3,4,8]]; //mm
rectangles_lengths = [2,3,4,5,6]; //mm

polygon_offset = [Sum(rectangles_sizes[0])+len(rectangles_sizes[0])*spacing,0]; //mm
polygon_diameters = [[1,2,3,4,5,6,8],[1,2,3,4,6,8]]; //mm
polygon_spacings = [0,6]; //mm 6 is from sin(30deg)*(max diameter)/2+(max diameter)/2
polygon_sides = [3,6]; //mm

half_circle_diameters = [4,6,8,10]; //mm
half_circle_thickness = 2; //mm

graduations_thickness = 0.5; //mm
graduations_depth = 1; //mm
graduations_cm_length = 3;
graduations_mm_length = 2;


text_contents = "OnTake N°1";
text_font = "Iosevka Heavy";
text_size = 4; //mm
text_depth = 1; //mm 
text_offset = [36,25];


function SubSum(x=0,Index=0)=x[Index]+((Index<=0)?0:SubSum(x=x,Index=Index-1));
function Sum(x)=SubSum(x=x,Index=len(x)-1);

function partial(list,start,end) = [for (i = [start:end]) list[i]];

module rectangles(rectangle_lengths=[],rectangle_width=0){
    for (i=[0:len(rectangle_lengths)-1]){
    if (i > 0){
    j = Sum(partial(rectangle_lengths,0,i-1))+i*spacing;
    translate([j,0,0]) cube([rectangle_lengths[i],rectangle_width,ruler_thickness]);
    } else {
    cube([rectangle_lengths[i],rectangle_width,ruler_thickness]);
    }
    }
}

module regular_polygons(polygon_diameters=[],polygon_sides=4){
    for (i=[0:len(polygon_diameters)-1]){
        translate([(polygon_sides % 2)*polygon_diameters[i]*cos((polygon_sides-2)*90/polygon_sides)/2,(polygon_sides % 2)*polygon_diameters[i]*sin((polygon_sides-2)*90/polygon_sides)/2,0])
        translate([(1-polygon_sides % 2)*polygon_diameters[i]/2,(1-polygon_sides % 2)*polygon_diameters[i]/2,0])
        if (i > 0){
    j = Sum(partial(polygon_diameters,0,i-1))+i*spacing;
    translate([j,0,0]) rotate([0,0,90]) cylinder(d=polygon_diameters[i],h=ruler_thickness,$fn=polygon_sides);
    } else {
     rotate([0,0,90]) cylinder(d=polygon_diameters[i],h=ruler_thickness,$fn=polygon_sides);
    }
    }
}

difference(){
    prismoid(size1=[ruler_dimensions.x,ruler_dimensions.y],size2=[ruler_dimensions.x,ruler_dimensions.y],h=ruler_thickness,anchor=BOTTOM+LEFT+FRONT,rounding=ruler_edge_radii,$fn=resolution);
    translate([padding,padding,0])
    for (i=[0:len(squares_sizes)-1]){
    if (i > 0){
    j = Sum(partial(squares_sizes,0,i-1))+i*spacing;
    translate([j,0,0]) cube([squares_sizes[i],squares_sizes[i],ruler_thickness]);
    } else {
    cube([squares_sizes[i],squares_sizes[i],ruler_thickness]);
    }
    }
    translate([padding+Sum(circles_diameters)+(len(circles_diameters)-1)*spacing+circles_offset.x,padding+max(circles_diameters)+circles_offset.y,0])
    scale([-1,-1,1])
    regular_polygons(polygon_diameters=circles_diameters,polygon_sides=resolution);
    for (i=[0:len(rectangles_lengths)-1]){
    translate([padding,ruler_dimensions.y-padding-(Sum(partial(rectangles_lengths,0,i))+i*spacing),0])
    rectangles(rectangle_lengths=rectangles_sizes[i],rectangle_width=rectangles_lengths[i]);
    }
    for (i=[0:len(rectangles_lengths)-1]){
    translate([padding,ruler_dimensions.y-padding-(Sum(partial(rectangles_lengths,0,i))+i*spacing),0])
    rectangles(rectangle_lengths=rectangles_sizes[i],rectangle_width=rectangles_lengths[i]);
    }
    for (i=[0:len(rectangles_lengths)-1]){
    translate([padding,ruler_dimensions.y-padding-(Sum(partial(rectangles_lengths,0,i))+i*spacing),0])
    rectangles(rectangle_lengths=rectangles_sizes[i],rectangle_width=rectangles_lengths[i]);
    }
    translate([polygon_offset.x,polygon_offset.y,0])
    for (i=[0:len(polygon_sides)-1]){
    translate([padding,ruler_dimensions.y-padding-(Sum(partial(polygon_spacings,0,i))+i*spacing),0])
    scale([1,-1,1])
    regular_polygons(polygon_diameters=polygon_diameters[i],polygon_sides=polygon_sides[i]);
    }
    for (i=[0:len(half_circle_diameters)-1]){
        if (i>0){
    translate([ruler_dimensions.x-padding,padding+(Sum(partial(half_circle_diameters,0,i-1))+i*spacing),0])
    half_circle(diameter=half_circle_diameters[i],thickness=half_circle_thickness);
        } else {
        translate([ruler_dimensions.x-padding,padding+i*spacing,0])
    half_circle(diameter=half_circle_diameters[i],thickness=half_circle_thickness);
            }
        }
    translate([text_offset.x,text_offset.y,ruler_thickness-text_depth]) linear_extrude(text_depth) text(text_contents,size=text_size,font=text_font);
    for (i=[0:round(ruler_dimensions.x*10)]){
    translate([i-graduations_thickness/2,0,ruler_thickness-graduations_depth])
        if (i%10 == 0){
            cube([graduations_thickness,graduations_cm_length,graduations_depth]);
        } else {
            cube([graduations_thickness,graduations_mm_length,graduations_depth]);
        }
    }
}


module half_circle(diameter=0,thickness=0){
    translate([0,diameter/2,0])
    difference(){
    cylinder(d=diameter,h=ruler_thickness,$fn=resolution);
    cylinder(d=diameter-thickness,h=ruler_thickness,$fn=resolution);
    translate([0,-diameter/2,0]) cube([diameter/2,diameter,ruler_thickness]);
    }
}