include <BOSL2/std.scad>

card_dimensions = [87,18.5]; //mm
card_thickness = 1.5; //mm
border_thickness = 1; //mm
border_height = 3; //mm
text_size = 5.5; //mm
text_padding = 2.5; //mm
text_line_spacing = 7; //mm
text_thickness = 2; //mm
text_contents = [
["Dalibard Louis;65kg"],
["12/02/2007;A+;177cm"],
];
/*
text_contents = [
["DOB:","12 feb. 2007"],
["Blood type:","A+"],
["Height:","177cm"],
["Weight:","65kg"],
["Medications:","None"],
["Allergies:","None"],
["Addr.:","10 r. d. Fécamp,"],
["75012, France",""],
];*/
text_font = "Iosevka Curly:style=Bold";

keyring_hole_padding = [5,18.5/2]; //mm
keyring_hole_diameter = 4; //mm
keyring_hole = true;

rounding = 3; //mm
resolution = 200;

difference(){
cuboid([card_dimensions.x,card_dimensions.y,card_thickness],anchor=BOTTOM+LEFT+FRONT,edges=[LEFT+FRONT,LEFT+BACK,RIGHT+FRONT,RIGHT+BACK],rounding=rounding,$fn=resolution);
translate([card_dimensions.x-keyring_hole_padding.x,keyring_hole_padding.y,card_thickness/2])
zcyl(d=keyring_hole_diameter,length=card_thickness,$fn=resolution);
}
translate([0,0,card_thickness])
union(){
difference(){
cuboid([card_dimensions.x,card_dimensions.y,border_height],anchor=BOTTOM+LEFT+FRONT,edges=[LEFT+FRONT,LEFT+BACK,RIGHT+FRONT,RIGHT+BACK],rounding=rounding,$fn=resolution);
translate([border_thickness,border_thickness,0])
cuboid([card_dimensions.x-border_thickness*2,card_dimensions.y-border_thickness*2,border_height],anchor=BOTTOM+LEFT+FRONT,edges=[LEFT+FRONT,LEFT+BACK,RIGHT+FRONT,RIGHT+BACK],rounding=rounding-border_thickness,$fn=resolution);
}
linear_extrude(text_thickness)
translate([0,card_dimensions.y-text_padding-text_size,0])
for (i=[0:len(text_contents)-1]){
translate([text_padding,-text_line_spacing*i,0])
text(text_contents[i][0],font=text_font,size=text_size,halign="left",$fn=resolution);
translate([card_dimensions.x-text_padding,-text_line_spacing*i,0])
text(text_contents[i][1],font=text_font,size=text_size,halign="right",$fn=resolution);
}
}
