#include <BOSL2/std.scad>

dimensions = [83,36,25]; // mm
rib_count = [4,3];
rib_thickness = 2; // mm
wall_thickness = 2; // mm
rounding = 4; // mm

dove_tail_dimensions = [4,5,2]; // mm
dove_tail_part_thickness = 2; // mm
tolerance = 0.2; // mm

rtl_sdr_body_dimensions = [61,18,15]; // mm
rtl_sdr_sda_connector_offset = 7; // mm
rtl_sdr_usb_connector_dimensions = [11,12,5]; // mm
rtl_sdr_usb_connector_offset = 7; // mm

rf_filter_body_dimensions = [54,30.5,19]; // mm
rf_filter_output_sda_connector_offset = [15.5,12]; // mm
rf_filter_input_sda_connector_offset = [18,11]; // mm

sda_connector_dimensions = [10,12]; // mm (diameter,length)

resolution = 100;
top_part = true;
dovetail_part = true;
rf_filter_part = true;

text_contents = ["Flamingo","OnTake's"];
text_depth = 1; // mm
font_size = 10; // mm
font = "Iosevka Heavy";

module rtl_sdr(){
      cuboid(rtl_sdr_body_dimensions);
     translate([rtl_sdr_body_dimensions.x/2+sda_connector_dimensions.x/2,0,-rtl_sdr_body_dimensions.z/2+rtl_sdr_sda_connector_offset]) xcyl(d=sda_connector_dimensions.x,h=sda_connector_dimensions.y,$fn=resolution);
    
     translate([-rtl_sdr_body_dimensions.x/2-rtl_sdr_usb_connector_dimensions.x/2,0,-rtl_sdr_body_dimensions.z/2+rtl_sdr_usb_connector_offset]) cuboid(rtl_sdr_usb_connector_dimensions);
}

module rf_filter(){
      cuboid(rf_filter_body_dimensions);
     translate([rf_filter_body_dimensions.x/2+sda_connector_dimensions.x/2,rf_filter_output_sda_connector_offset.x-rf_filter_body_dimensions.y/2,-rf_filter_body_dimensions.z/2+rf_filter_output_sda_connector_offset.y]) xcyl(d=sda_connector_dimensions.x,h=sda_connector_dimensions.y,$fn=resolution);
    
     translate([-rf_filter_body_dimensions.x/2-sda_connector_dimensions.x/2,rf_filter_input_sda_connector_offset.x-rf_filter_body_dimensions.y/2,-rf_filter_body_dimensions.z/2+rf_filter_input_sda_connector_offset.y]) xcyl(d=sda_connector_dimensions.x,h=sda_connector_dimensions.y,$fn=resolution);
}

module dovetail(flip=false){
    difference(){
    prismoid(size1=[dimensions.x-rounding*2-dove_tail_part_thickness,dove_tail_dimensions.x],size2=[dimensions.x-rounding*2-dove_tail_part_thickness,dove_tail_dimensions.y],h=dove_tail_dimensions.z,anchor=LEFT+BOTTOM);
     if (flip){   
         translate([0,-max(dove_tail_dimensions.x,dove_tail_dimensions.y)/2,0]) cuboid([dimensions.x-rounding*2-dove_tail_part_thickness,max(dove_tail_dimensions.x,dove_tail_dimensions.y),dove_tail_dimensions.z],anchor=LEFT+BOTTOM);
     } else {
         translate([0,max(dove_tail_dimensions.x,dove_tail_dimensions.y)/2,0]) cuboid([dimensions.x-rounding*2-dove_tail_part_thickness,max(dove_tail_dimensions.x,dove_tail_dimensions.y),dove_tail_dimensions.z],anchor=LEFT+BOTTOM);
         }
    }
}
if (dovetail_part){
    difference(){
        prismoid(size1=[dimensions.x-rounding*2+tolerance*2,dove_tail_dimensions.x+tolerance*2+dove_tail_part_thickness*2],size2=[dimensions.x-rounding*2+tolerance*2,dove_tail_dimensions.y+tolerance*2+dove_tail_part_thickness*2],h=dove_tail_dimensions.z+tolerance+dove_tail_part_thickness,anchor=LEFT+BOTTOM);
        prismoid(size1=[dimensions.x-rounding*2+tolerance*2-dove_tail_part_thickness,dove_tail_dimensions.x+tolerance*2],size2=[dimensions.x-rounding*2+tolerance*2-dove_tail_part_thickness,dove_tail_dimensions.y+tolerance*2],h=dove_tail_dimensions.z+tolerance,anchor=LEFT+BOTTOM);
        }
    } else {
difference(){
union(){
difference(){
    cuboid([dimensions.x,dimensions.y,dimensions.z/2],anchor=LEFT+BOTTOM+FRONT,edges=[BOTTOM,LEFT+FRONT,LEFT+BACK,RIGHT+FRONT,RIGHT+BACK],rounding=rounding,$fn=resolution);
    translate([wall_thickness,wall_thickness,wall_thickness]) cuboid([dimensions.x-wall_thickness*2,dimensions.y-wall_thickness*2,dimensions.z/2],anchor=LEFT+BOTTOM+FRONT,edges=[BOTTOM,LEFT+FRONT,LEFT+BACK,RIGHT+FRONT,RIGHT+BACK],rounding=rounding-wall_thickness,$fn=resolution);
    

}
    for (i=[1:rib_count.x]){
        translate([dimensions.x/(rib_count.x+1)*i-rib_thickness/2,0,0])
    cuboid([rib_thickness,dimensions.y,dimensions.z/2],anchor=LEFT+BOTTOM+FRONT,edges=[BOTTOM+FRONT,BOTTOM+BACK],rounding=rounding,$fn=resolution);
        }
        
         for (i=[1:rib_count.y]){
        translate([0,dimensions.y/(rib_count.y+1)*i-rib_thickness/2,0])
    cuboid([dimensions.x,rib_thickness,dimensions.z/2],anchor=LEFT+BOTTOM+FRONT,edges=[BOTTOM+LEFT,BOTTOM+RIGHT],rounding=rounding,$fn=resolution);
        }
        translate([rounding,0,dimensions.z/2]) rotate([90,0,0]) dovetail();
        translate([rounding,dimensions.y,dimensions.z/2]) rotate([-90,0,0]) dovetail(flip=true);
}
translate([dimensions.x/2,dimensions.y/2,dimensions.z/2]) 
if (top_part){
    rotate([180,0,0]) 
    if (rf_filter_part){
        rf_filter();
    } else {
        rtl_sdr();
    }
} else {
if (rf_filter_part){
        rf_filter();
    } else {
        rtl_sdr();
    }
    }
    
    translate ([dimensions.x/2,dimensions.y/2,text_depth]) rotate ([180,0,0]) linear_extrude(text_depth)
   if (top_part){ text(text_contents.x,size=font_size,font=font,halign="center",valign="center");
   } else { text(text_contents.y,size=font_size,font=font,halign="center",valign="center");
   }
}
}
