package battery

import (
	"machine"
)

var adc machine.ADC

func Init(bPin machine.Pin) {
	adc = machine.ADC{
		Pin: bPin,
	}
	adc.Configure(machine.ADCConfig{})
}

func GetVoltage() float64 {
	return float64(adc.Get()) * 2 * 3.6 / 65535 // double-100K resistor divider
}

func GetPercentage() (bool, float64) {
	ratio := (GetVoltage() - 3.6) / 0.6
	if ratio > 1.5 {
		return true, ratio * 100
	}
	return false, ratio * 100 // Non-linear, fix this later.
}
