package main

import (
	"odoki-firmware/battery"
	"odoki-firmware/ecg"
	"odoki-firmware/ui"
	"time"

	"machine"
)

func main() {

	machine.InitADC()
	machine.InitSerial()

	//comms.Init()

	//led.Init(machine.D8)
	//go led.RainbowLED(10*time.Millisecond, 0.01, 0)

	battery.Init(machine.A6)
	machine.SPI0.Configure(machine.SPIConfig{
		Frequency: 4 * machine.MHz,
		SCK:       machine.D26,
		SDO:       machine.D25,
		SDI:       machine.D24,
		LSBFirst:  false,
		Mode:      0,
	})

	machine.SPI1.Configure(machine.SPIConfig{
		Frequency: 4 * machine.MHz,
		SCK:       machine.D10,
		SDO:       machine.D9,
		SDI:       machine.NoPin,
		LSBFirst:  false,
		Mode:      0,
	})

	ecg.Init(machine.A0, machine.D2, machine.SPI0)
	ecg.SetReadoutInterrupt()

	ui.Init(machine.SPI1, machine.D6, machine.D5, machine.A1, machine.A2)
	ui.DrawLoop()

	/*
		go comms.SimulateHR()
		comms.SimulateECG()
	*/
	for true {
		time.Sleep(time.Hour)
	}
}
