package utils

import (
	"log"
	"math/rand"
)

func CheckError(err error) {
	if err != nil {
		log.Fatal(err)
	}
}

func RemapInt32FromRange(min, max int, value int32) float64 {
	return (float64(value) - float64(min)) / float64(max-min)
}

func RandomInt(min, max int) uint8 {
	return uint8(min + rand.Intn(max-min))
}

func MinMaxInt32(array []int32) (int32, int32) {
	var max int32 = array[0]
	var min int32 = array[0]
	for _, value := range array {
		if max < value {
			max = value
		}
		if min > value {
			min = value
		}
	}
	return min, max
}
