package constants

import (
	"image/color"
	"math"
	"time"

	"fyne.io/fyne/v2"
	"github.com/wcharczuk/go-chart/v2/drawing"
)

const (
	AppTitle = "odoki v0.0.1"

	TitleSize = 48

	BluetoothScanTimeout = time.Second * 30

	ChannelCount              = 3
	BufferSize                = 1024
	SamplesReceivedBeforeDraw = 10
	BufferDuration            = 10 //s
	LeadMaxBValue             = math.MaxInt32
	LeadMaxVValue             = 200 // mV
)

var (
	DefaultWindowSize = fyne.Size{Height: 1200, Width: 900}
	SuccessColor      = color.RGBA{97, 255, 97, 255}
	ErrorColor        = color.RGBA{255, 97, 97, 255}

	TraceColor = drawing.Color{237, 81, 174, 255}
)
