package ui

import (
	"odoki/constants"
	"odoki/ui/config"
	"odoki/ui/onelead"

	"fyne.io/fyne/v2/app"
	"fyne.io/fyne/v2/container"
)

func RunUI() {
	a := app.New()
	w := a.NewWindow(constants.AppTitle)

	tabs := container.NewAppTabs(
		container.NewTabItem("Config", config.Widget()),
		container.NewTabItem("1 Lead", onelead.Widget()),
	)

	tabs.SetTabLocation(container.TabLocationLeading)

	w.SetContent(tabs)
	w.Resize(constants.DefaultWindowSize)
	w.ShowAndRun()
}
