package ui

import (
	"machine"
	"odoki-firmware/ui/info"
	"odoki-firmware/ui/onelead"
	"runtime"

	"tinygo.org/x/drivers"
	"tinygo.org/x/drivers/st7789"
)

const (
	InfoScreen int = iota
	OneLeadScreen
)

var DrawFunctions = []func(bool, st7789.Device) bool{info.Draw, onelead.Draw}

var CurrentScreen = OneLeadScreen
var CursorPosition = 0
var VoidDisplayed = true

var display st7789.Device

func Init(bus drivers.SPI, resetPin machine.Pin, dcPin machine.Pin, csPin machine.Pin, blPin machine.Pin) {
	display = st7789.New(bus, resetPin, dcPin, csPin, blPin)
	// ToDo: read backlight brightness from flash with https://github.com/tinygo-org/tinyfs
	display.Configure(st7789.Config{
		Rotation:   st7789.NO_ROTATION,
		RowOffset:  0,
		FrameRate:  st7789.FRAMERATE_111,
		VSyncLines: st7789.MAX_VSYNC_SCANLINES,
	})
	display.EnableBacklight(true)
}

func UpdateScreen() {
	VoidDisplayed = DrawFunctions[CurrentScreen](VoidDisplayed, display)
}

func DrawLoop() {
	for true {
		UpdateScreen()
		runtime.Gosched()
	}
}
