package info

import (
	"image/color"
	"odoki-firmware/battery"
	"odoki-firmware/constants"
	"strconv"

	"tinygo.org/x/drivers/st7789"
	"tinygo.org/x/tinyfont"
	"tinygo.org/x/tinyfont/freemono"
)

func Draw(VoidDisplayed bool, display st7789.Device) bool {
	if VoidDisplayed {
		display.FillScreen(color.RGBA{0, 0, 0, 255})
		tinyfont.WriteLine(&display, &freemono.Bold18pt7b, constants.Padding, constants.Padding+constants.LineHeight*2, "Info", color.RGBA{255, 255, 255, 255})
		tinyfont.WriteLine(&display, &freemono.Bold9pt7b, constants.Padding, constants.Padding+constants.LineHeight*3, "Go v"+constants.GoVersion, color.RGBA{255, 255, 255, 255})
		tinyfont.WriteLine(&display, &freemono.Bold9pt7b, constants.Padding, constants.Padding+constants.LineHeight*4, "Firmware v"+constants.FirmwareVersion, color.RGBA{255, 255, 255, 255})
		tinyfont.WriteLine(&display, &freemono.Bold9pt7b, constants.Padding, constants.Padding+constants.LineHeight*5, "Battery: "+string(strconv.FormatFloat(battery.GetVoltage(), 'f', 3, 64))+" V", color.RGBA{255, 255, 255, 255})
		charging, percentage := battery.GetPercentage()
		if charging {
			tinyfont.WriteLine(&display, &freemono.Bold9pt7b, constants.Padding, constants.Padding+constants.LineHeight*6, "Battery: Charging", color.RGBA{255, 255, 255, 255})
		} else {
			tinyfont.WriteLine(&display, &freemono.Bold9pt7b, constants.Padding, constants.Padding+constants.LineHeight*6, "Battery: "+string(strconv.FormatFloat(percentage, 'f', 1, 64))+" %", color.RGBA{255, 255, 255, 255})
		}
	}
	return false
}
