include <BOSL2/std.scad>
include <BOSL2/hinges.scad>
include <BOSL2/std.scad>
include <BOSL2/turtle3d.scad>
include<BOSL2/skin.scad>

bracelet_inner_diameter = 60; //mm
bracelet_width = 9; //mm
bracelet_drawing_width = 7;//mm
bracelet_thickness = 3; //mm
bracelet_rounding_radius = 1.5; //mm

bracelet_pattern_count = 24;
bracelet_pattern_path_diameter = 0.6; //mm

bracelet_text = "Name: Louis Dalibard; DoB: Feb 12, 2007; Blood type: A+; Height: 177cm; Weight: 65kg; Allergies: possibly Propofol, be careful while sedating me; Vaccinated but non responsive for Hepatitis B; Organ donor by default in French law"; // "3.14159265358979323846264338327950288419716939937510582097494459230781640628620899862803482534211706798214808651328230664709384460955058223172535940812848111745028410270193852110555964462294895493038196442881097566593344612847564823378678316527...";
bracelet_text_font = "Iosevka Etoile:style=bold";
bracelet_text_height = 2.; //mm
bracelet_text_spacing = 4; //°
bracelet_text_depth = 1; //mm

bracelet_cut_angle = 20; //°
bracelet_text_padding_angle = 2;

bracelet_fastener_inner_diameter = 4; //mm
bracelet_fastener_outer_diameter = 7; //mm
bracelet_overlap = 0.2; // fraction
bracelet_fastener_thickness = 2; //mm


bracelet_pattern_path_resolution = 180;
bracelet_pattern_path_sweep_resolution = 24;
resolution = 100;
text_resolution = 10;


// Calc
outer_circumference = (bracelet_inner_diameter+bracelet_thickness)*PI;


bracelet_cut_dimensions = [bracelet_inner_diameter/2+bracelet_thickness,(bracelet_inner_diameter/2+bracelet_thickness)*2*sin(bracelet_cut_angle/2),bracelet_width];



difference(){
zcyl(l=bracelet_width, d=bracelet_inner_diameter+bracelet_thickness*2, rounding = bracelet_rounding_radius, $fn=resolution);
zcyl(l=bracelet_width, d=bracelet_inner_diameter, rounding = -bracelet_rounding_radius, $fn=resolution);
for (b = [0 : 360/bracelet_pattern_count : 360]){
path = [ for (a = [0 : 360/bracelet_pattern_path_resolution : 360]) [(bracelet_inner_diameter/2+bracelet_thickness)*sin(a), (bracelet_inner_diameter/2+bracelet_thickness)*cos(a),bracelet_drawing_width/2-bracelet_drawing_width*exp((a-180)/10)/(1+exp((a-180)/10))]];
rotate([0,0,b]) path_sweep(circle(d=bracelet_pattern_path_diameter, $fn=bracelet_pattern_path_sweep_resolution), path);
}
cuboid(bracelet_cut_dimensions,anchor=LEFT);
#for (i = [0:len(bracelet_text)-1]){
rot_angle=i*bracelet_text_spacing;
rot_angle_normalised = rot_angle%(360-bracelet_cut_angle-bracelet_text_padding_angle-bracelet_text_spacing);
rot_count = floor(rot_angle/(360-bracelet_cut_angle-bracelet_text_padding_angle-bracelet_text_spacing));

rot_offset= (floor(bracelet_text_spacing*(len(bracelet_text)-1)/(360-bracelet_cut_angle-bracelet_text_padding_angle-bracelet_text_spacing)) == 0) ? (-bracelet_drawing_width+bracelet_text_height)/2: -((bracelet_drawing_width-bracelet_text_height)*floor(rot_angle/(360-bracelet_cut_angle-bracelet_text_padding_angle-bracelet_text_spacing))/floor(bracelet_text_spacing*(len(bracelet_text)-1)/(360-bracelet_cut_angle-bracelet_text_padding_angle-bracelet_text_spacing)));

rotate([0,0,bracelet_text_padding_angle/2+bracelet_cut_angle/2+i*bracelet_text_spacing%(360-bracelet_cut_angle-bracelet_text_padding_angle-bracelet_text_spacing)]) translate([bracelet_inner_diameter/2+bracelet_thickness-bracelet_text_depth,0,rot_offset+bracelet_drawing_width/2-bracelet_text_height]) rotate([90,0,90]) linear_extrude(bracelet_text_depth) text(bracelet_text[i],size=bracelet_text_height,font=bracelet_text_font,$fn=text_resolution);
}
}

fastener_translate = [(bracelet_inner_diameter+bracelet_thickness)/2*cos(bracelet_cut_angle/2),bracelet_cut_dimensions.y/2+bracelet_fastener_outer_diameter*(bracelet_overlap-1/2),0];

translate(fastener_translate)
difference(){
xcyl(l=bracelet_thickness,d=bracelet_fastener_outer_diameter,rounding=bracelet_rounding_radius,$fn=resolution);
xcyl(l=bracelet_thickness,d=bracelet_fastener_inner_diameter,rounding=-bracelet_rounding_radius,$fn=resolution);
}

translate([fastener_translate.x,-fastener_translate.y,0])
difference(){
zcyl(l=bracelet_thickness,d=bracelet_fastener_outer_diameter,rounding=bracelet_rounding_radius,$fn=resolution);
zcyl(l=bracelet_thickness,d=bracelet_fastener_inner_diameter,rounding=-bracelet_rounding_radius,$fn=resolution);
cuboid([bracelet_fastener_outer_diameter/2,bracelet_fastener_outer_diameter/2,bracelet_thickness],anchor=RIGHT+BACK);
}

