include <BOSL2/std.scad>

board_size = 19;

board_length=100;//mm
board_thickness=4;//mm

wall_thickness = 2;//mm

star_points = [[3,3],[9,3],[15,3],[3,9],[9,9],[15,9],[3,15],[9,15],[15,15]];
star_point_length = 5; //mm

piece_dimensions=[4,4,2];

rounding = 1;//mm
rounding_internal = 0.5;//mm

resolution = 20;

// Code
internal_board_length = board_length-wall_thickness;
internal_board_origin = [wall_thickness/2,wall_thickness/2,0];
squares_on_board = board_size-1;
square_scale = internal_board_length/squares_on_board;
difference(){
    cuboid([board_length,board_length,board_thickness],anchor=BOTTOM+FRONT+LEFT,edges=[TOP+FRONT,TOP+RIGHT,TOP+LEFT,TOP+BACK,LEFT+BACK,LEFT+FRONT,RIGHT+BACK,RIGHT+FRONT],rounding=rounding,$fn=resolution);
    translate(internal_board_origin) cube([internal_board_length,internal_board_length,board_thickness]);
}

difference(){
    union(){
for ( x = [0 : squares_on_board-1] ){
    for ( y = [0 : squares_on_board-1] ){
    translate(internal_board_origin) translate([x*square_scale, y*square_scale, 0])
        difference(){
    cube([square_scale,square_scale,board_thickness]);
            translate([wall_thickness/2,wall_thickness/2,-board_thickness]) cuboid([square_scale-wall_thickness,square_scale-wall_thickness,board_thickness*3],anchor=BOTTOM+FRONT+LEFT,edges=[LEFT+BACK,LEFT+FRONT,RIGHT+BACK,RIGHT+FRONT],rounding=rounding_internal,$fn=resolution);
        }
}
}
    for (i = [0 : len(star_points)-1]){
        star_point_f_x = star_points[i].x;
        star_point_f_y = star_points[i].y;
        translate(internal_board_origin) translate([0,0,board_thickness/2]) translate([star_point_f_x*square_scale,star_point_f_y*square_scale,0]) rotate([0,0,45]) cube([star_point_length,star_point_length,board_thickness],center=true);
    }
}
for ( x = [0 : squares_on_board-2] ){
    for ( y = [0 : squares_on_board-2] ){
        f_x = x+1;
        f_y = y+1;
        translate(internal_board_origin) translate([0,0,board_thickness]) translate([f_x*square_scale,f_y*square_scale,0]) scale(piece_dimensions) sphere(d=1,$fn=resolution*2);
}
}
}