package utils

import (
	"image/color"

	"github.com/crazy3lf/colorconv"
	"github.com/rs/zerolog/log"
)

func CheckError(err error) {
	if err != nil {
		log.Fatal().Err(err).Msg("utils: fatal error occurred")
	}
}

func ColorFromHash(inputString string) color.RGBA {
	if len(inputString) < 3 {
		log.Debug().Str("input", inputString).Msg("utils: input string too short, returning black")
		return color.RGBA{0, 0, 0, 255}
	}
	r, g, b, _ := colorconv.HSVToRGB(float64(uint8(inputString[0])), 0.5, 0.5)
	log.Trace().Str("input", inputString).Int("r", int(r)).Int("g", int(g)).Int("b", int(b)).Msg("utils: generated color from hash")
	return color.RGBA{r, g, b, 255}
}
