package config

import (
	"time"

	"github.com/rs/zerolog"
)

const Debug = true
const DebugFunctionAreas = 200
const DebugBoundingBoxPadding = 0.02 // rad
const DebugResolution = 1440

const BufferSize = 36000 //36000 // in samples (6 minutes)

var WebUITrackedStations = []string{"CKHZ", "ALRZ", "TEME", "LZG", "TEO"}

// Close to ALRZ: https://dataview.raspberryshake.org/#/AM/R3D73/00/EHZ

var DelayBetweenHandshakes = 50 * time.Millisecond

const FastStartup = true

const ColdStartCalibrationTime = 5 * time.Minute

const MinWaveDelayInSamples = 50

const PWaveSensitivity = 2.0 // 2.0
const SWaveSensitivity = 8.0 // 8.0

const DefaultSampleRate = 100 // Hz

const EventTimeout = 20 * time.Second // Time before final conclusions are drawn after last detection

const EventExtent = 1.0472 / 2 //rad

const NumberOfDetectionsThreshold = 4

const GlobalLogLevel = zerolog.InfoLevel
