package main

import (
	"ewdetect/calibration"
	"ewdetect/comms"
	"ewdetect/config"
	"ewdetect/detect"
	"ewdetect/locate"
	"ewdetect/stations"
	"ewdetect/webui"
	"os"
	"time"

	"github.com/rs/zerolog"
	"github.com/rs/zerolog/log"
	"github.com/rs/zerolog/pkgerrors"
)

func main() {
	log.Logger = log.Output(zerolog.ConsoleWriter{Out: os.Stderr, TimeFormat: time.RFC1123})
	zerolog.TimeFieldFormat = zerolog.TimeFormatUnix
	zerolog.ErrorStackMarshaler = pkgerrors.MarshalStack
	zerolog.SetGlobalLevel(config.GlobalLogLevel)
	detect.Init()
	locate.Init()
	stations.Init()
	go webui.Init()
	go calibration.Init()

	for _, url := range stations.URLs /*[]string{"link.geonet.org.nz:18000"}*/ /* you could also retrict this to a single network if need be */ {
		go comms.StreamThread(url)
		time.Sleep(config.DelayBetweenHandshakes)
	}
	select {}
	/*
		// Example https://www.mtu.edu/geo/community/seismology/learn/earthquake-epicenter/
		fmt.Println(locate.NelderMeadOptimization("mtu.edu example", &[]locate.Observation{
			{StationName: "TEIG", Lat: (20.0 + 14.0/.60 + 30.0/3600.) * math.Pi / 180, Lon: -(88 + 2.0/60 + 30.0/3600) * math.Pi / 180, PWaveArrival: 1.0 * 60, SWaveArrival: 2.5 * 60},   // TEIG
			{StationName: "SOCO", Lat: (18.0 + 47.0/.60 + 04.0/3600.) * math.Pi / 180, Lon: -(110 + 58.0/60 + 30.0/3600) * math.Pi / 180, PWaveArrival: 3.0 * 60, SWaveArrival: 6.0 * 60}, // SOCO
			{StationName: "SSPA", Lat: (41.0 + 44.0/60 + 30.0/3600.) * math.Pi / 180, Lon: -(76 + 21.0/60 + 59.0/3600) * math.Pi / 180, PWaveArrival: 4.3 * 60, SWaveArrival: 9.1 * 60},   // SSPA
		}))

		// Converges to 20.2967558432, -93.5205907499, not bad

		// Example https://stationview.raspberryshake.org/#/?lat=35.57462&lon=139.73858&zoom=10.925&event=rs2025fvnavr&sta=R7F8D
		// time 0 is 12:50:00 UTC

		fmt.Println(locate.NelderMeadOptimization("rs2025fvnavr", &[]locate.Observation{
			{StationName: "R7F8D", Lat: 35.63214 * math.Pi / 180, Lon: 139.73389 * math.Pi / 180, PWaveArrival: -6, SWaveArrival: 53.},  // R7F8D
			{StationName: "S9AF3", Lat: 36.12860 * math.Pi / 180, Lon: 140.07353 * math.Pi / 180, PWaveArrival: -2.5, SWaveArrival: 79}, // S9AF3
			{StationName: "R38DC", Lat: 35.13378 * math.Pi / 180, Lon: 138.92544 * math.Pi / 180, PWaveArrival: 1.5, SWaveArrival: 196}, // R38DC
		}))

		// Converges to 41.3762277742, 149.672389364, ass

		// Example https://stationview.raspberryshake.org/#/?lat=36.83152&lon=136.82668&zoom=7.859&event=rs2025flrsdg&sta=R44C0
		// time 0 is 04:25:00 UTC (epoch is t +15s according to USGS)
		fmt.Println(locate.NelderMeadOptimization("rs2025flrsdg", &[]locate.Observation{
			//{StationName: "R7F8D", Lat: 36.72115 * math.Pi / 180, Lon: 138.89604 * math.Pi / 180, PWaveArrival: 46.8, SWaveArrival: 2*60 + 14.8}, // R7F8D
			//{StationName: "R38DC", Lat: 35.13137 * math.Pi / 180, Lon: 138.92348 * math.Pi / 180, PWaveArrival: 60.5, SWaveArrival: 2*60 + 51}, // R38DC
			//{StationName: "R28BA", Lat: 35.39698 * math.Pi / 180, Lon: 133.87849 * math.Pi / 180, PWaveArrival: 61, SWaveArrival: 2*60 + 52},        // R28BA
			{StationName: "RBB9C", Lat: 37.09561 * math.Pi / 180, Lon: 127.02144 * math.Pi / 180, PWaveArrival: 2*60 + 55, SWaveArrival: 4*60 + 23}, // RBB9C
			{StationName: "R74A7", Lat: 34.91235 * math.Pi / 180, Lon: 135.79596 * math.Pi / 180, PWaveArrival: 52, SWaveArrival: 60 + 40},          // R74A7
			{StationName: "RDBC2", Lat: 35.99544 * math.Pi / 180, Lon: 140.16287 * math.Pi / 180, PWaveArrival: 51, SWaveArrival: 60 + 27},          // RDBC2

		}))

		// Converges to 0.6474711480835122 2.4033395498559242, in rad, not bad

		// Example https://stationview.raspberryshake.org/#/?lat=-45.41139&lon=168.89573&zoom=5.934&event=rs2025fwmrzv&sta=RF862
		//
		// time 0 is 01:43:00 UTC (epoch is t +12s according to USGS)
		fmt.Println(locate.NelderMeadOptimization("rs2025fwmrzv", &[]locate.Observation{
			{StationName: "RF862", Lat: -45.05554 * math.Pi / 180, Lon: 168.55697 * math.Pi / 180, PWaveArrival: 53.5, SWaveArrival: 60 + 27},
			{StationName: "SC651", Lat: -17.75192 * math.Pi / 180, Lon: 168.31555 * math.Pi / 180, PWaveArrival: 6*60 + 15, SWaveArrival: 13 * 60},
			//{StationName: "R6707", Lat: -35.20988 * math.Pi / 180, Lon: 149.08611 * math.Pi / 180, PWaveArrival: 4*60+10, SWaveArrival: 9*60+50},
			{StationName: "R7A67", Lat: -42.85049 * math.Pi / 180, Lon: 147.35653 * math.Pi / 180, PWaveArrival: 3*60 + 20, SWaveArrival: 6 * 60},

			/*R7A67
			-42.85049
			147.35653*/
	/*}))
	 */
}
