// ==============================
// MCOT — TIPE 2025–2026
// ==============================

#set document(
  title: "Mise en Cohérence des Objectifs du TIPE",
  author: "Dalibard Louis",
  date: auto,
)

#set page(
  margin: (top: 2.5cm, bottom: 2.5cm, left: 2.5cm, right: 2.5cm),
  numbering: "1"
)

#set text(
  font: "Libertinus Serif",
  size: 11pt,
)

#set heading(
  numbering: "1.1",
  outlined: true
)

#align(center)[
  *Mise en Cohérence des Objectifs du TIPE*  
]

#v(1cm)

= Titre du TIPE

Détéction et multilatération de séismes en temps réel.

= Ancrage au thème de l’année
*(50 mots maximum)*

Ce TIPE s’inscrit dans le thème « boucles et cycles » à travers l’analyse de signaux par décomposition en signaux *périodiques* afin d'en optimiser le calcul, et des algorithmes itératifs de multilatération basés sur des *boucles* de convergence numérique.

= Motivation du choix du sujet
*(50 mots maximum)*

Les technologies sur lesquelles reposent les systèmes ayant pour but la protection de la population en cas d'urgence ainsi que le traitement de signaux sont des sujets qui m'intéressent.

= Positionnements thématiques et mots-clés

== Positionnements thématiques

MATHEMATIQUES (Mathématiques Appliquées), INFORMATIQUE (Informatique pratique)

== Mots-clés (français)

- Traitement du signal digital (DSP)

- Ondes sismiques (ondes P et S)

- Corrélation croisée

- Transformée de Fourier rapide (FFT)

- Multilatération sismique

== Keywords (English)

- Digital signal processing (DSP)

- Seismic waves (P and S waves)

- Cross-correlation

- Fast Fourier Transform (FFT)

- Seismic multilateration

= Bibliographie commentée
*(650 mots maximum)*

Les ondes sismiques proviennent de différentes formes d'activité géologique de la croûte terrestre [1] relativement imprévisibles. Mais elles peuvent avoir des conséquences dévastatrices sur la vie et l'activité humaine (effets des ondes sismiques, effets de tsunamis...). Ainsi, est-il crucial d'avoir des systèmes d'alerte sismiques capable de signaler la réalisation d'un évenement sismique à une population pour qu'elle puisse se préparer à ses effets. En utilisant des sismographes libres d'accès [2], il est possible de détecter de tels évenements en comparant les signaux reçus à des signaux de référence (corrélation croisée) [3] [4]. Le calcul naïf de telles opérations étant coûteux, il est possible de passer par une transformée de Fourier discrète [5] en utilisant l'algorithme de FFT [6] pour en réduire le coût. Les temps de détections peuvent ensuite être exploités en utilisant des données sur la durée de propagation des différent types d'ondes sismiques dans la croûte terrestre [7],[8] ainsi que des techniques de recherche d'optima [9] afin d'en réaliser la multilatération et l'attribution d'une magnitude [10].

= Problématique retenue
*(50 mots maximum)*

Comment déterminer de manière fiable une source d'ondes sismiques ainsi que sa position à partir de signaux bruités enregistrés par plusieurs stations, en exploitant les temps d’arrivée des ondes P et S et les outils du traitement du signal (corrélation, FFT) ?

= Objectifs du TIPE
*(100 mots maximum)*

Créer un algorithme de détection d'événements sismiques.

Accéder au temps d'arrivée des ondes P et S.

Créer un algorithme de multilatération de ces évenements sismiques à partir de modèles de propagation de la croute terrestre.

= Liste des références bibliographiques
*(2 à 10 références)*

[1] R. J. Mitchell. _Earthquake Sources_. Lecture notes, Western Washington University. https://www.geol.wwu.edu/rjmitch/L4_EQsources.pdf

[2] Yacine Boussoufa. _Earthquake Data Centers_. GitHub repository, 2023. https://github.com/YacineBoussoufa/EarthquakeDataCenters

[3] School of Informatics, University of Edinburgh. _Computational Foundations of Cognitive Science: Lecture 15 (Convolutions and Kernels)_. https://www.inf.ed.ac.uk/teaching/courses/cfcs1/lectures/cfcs_l15.pdf

[4] Penn State Eberly College of Science. _STAT 510: Lesson 8.2 – Cross Correlation Functions and Lagged Regressions_. Online course material, 2023. https://online.stat.psu.edu/stat510/lesson/8/8.2

[5] Elias M. Stein & Rami Shakarchi. Fourier Analysis: An Introduction. 2003. https://kryakin.site/am2/Stein-Shakarchi-1-Fourier_Analysis.pdf. (ISBN to lie. ISBN 978-0-691-11384-5)

[6] Charles Van Loan. _The FFT Via Matrix Factorizations_. Lecture notes, 2010. https://www.cs.cornell.edu/~bindel/class/cs5220-s10/slides/FFT.pdf

[7] Peter Bormann. _Global 1-D Earth Models (IASP91 Tables)_. GFZ German Research Centre for Geosciences, 2010. https://gfzpublic.gfz-potsdam.de/rest/items/item_4031/component/file_4032/content

[8] Moritz Beyreuther, Robert Barsch, Lion Krischer, Tobias Megies, Yannik Behr, Joachim Wassermann. _ObsPy: A Python Toolbox for Seismology_. Seismological Research Letters, 81(3), 530–533, 2010. doi:10.1785/gssrl.81.3.530

[9] Jason Cantarella. _Nelder–Mead Method_. Lecture notes, 2023. https://jasoncantarella.com/downloads/NelderMeadProof.pdf

[10] Tatsuhiko Hara. _Determination of Broadband Moment Magnitude_. IISEE / BRI, 2007. https://iisee.kenken.go.jp/lna/download.php?f=2011082925678c01.pdf&n=T0-100-2007_Mwp-2-new.pdf&cid=T0-100-2007

