#!/bin/bash

# This is working under the assumption that you have connected to the internet and that the extra efi boots have been deleted
# Stage 1
mkfs.btrfs -f /dev/nvme0n1p6
mount /dev/nvme0n1p6 /mnt
mount --mkdir /dev/nvme0n1p1 /mnt/boot
reflector --save /etc/pacman.d/mirrorlist --protocol https --country USA --latest 200 --sort rate --download-timeout 2 -f 100 --verbose
reflector -p rsync --country USA --latest 200 --sort rate --download-timeout 2 -f 100 --verbose
pacstrap -K /mnt efibootmgr base linux-zen linux-zen-headers linux-firmware dkms flatpak wget sed bash curl os-prober nano fish git base-devel amd-ucode sof-firmware firefox networkmanager fastfetch grub sudo vim xorg git ntfs-3g btrfs-progs plasma-meta kde-applications-meta qt5-wayland
genfstab -U /mnt >> /mnt/etc/fstab
arch-chroot /mnt
