#!/bin/bash

# Stage 2
ln -sf /usr/share/zoneinfo/America/New_York /etc/localtime
hwclock --systohc
timedatectl set-local-rtc 1
sed 's/# en_US.UTF-8 UTF-8/en_US.UTF-8 UTF-8/' /etc/locale.gen
locale-gen
echo "LANG=en_US.UTF-8" > /etc/locale.conf
echo "linspc" > /etc/hostname
mkinitcpio -P
passwd
systemctl enable sddm
systemctl enable NetworkManager
sed 's/#GRUB_DISABLE_OS_PROBER=false/GRUB_DISABLE_OS_PROBER=false/' /etc/default/grub 
grub-install --target=x86_64-efi --efi-directory=/boot --bootloader-id=GRUB
grub-mkconfig -o /boot/grub/grub.cfg
useradd -m -G wheel -s /usr/bin/fish lin
passwd lin
echo "%wheel    ALL=(ALL) ALL" >> /etc/sudoers
#NVIDIA Specific shenanigans
pacman -S nvidia-open-dkms nvidia-utils
mkdir /etc/pacman.d/
mkdir /etc/pacman.d/hooks
echo "" > /etc/pacman.d/hooks/nvidia.hook
echo "[Trigger]" >> /etc/pacman.d/hooks/nvidia.hook
echo "Operation=Install" >> /etc/pacman.d/hooks/nvidia.hook
echo "Operation=Upgrade" >> /etc/pacman.d/hooks/nvidia.hook
echo "Operation=Remove" >> /etc/pacman.d/hooks/nvidia.hook
echo "Type=Package" >> /etc/pacman.d/hooks/nvidia.hook
echo "Target=nvidia-open-dkms" >> /etc/pacman.d/hooks/nvidia.hook
echo "Target=linux-zen" >> /etc/pacman.d/hooks/nvidia.hook
echo "Target=linux" >> /etc/pacman.d/hooks/nvidia.hook
echo "Target=nvidia-open" >> /etc/pacman.d/hooks/nvidia.hook
echo "Target=nvidia" >> /etc/pacman.d/hooks/nvidia.hook
echo "" >> /etc/pacman.d/hooks/nvidia.hook
echo "[Action]" >> /etc/pacman.d/hooks/nvidia.hook
echo "Description=Updating NVIDIA module in initcpio" >> /etc/pacman.d/hooks/nvidia.hook
echo "Depends=mkinitcpio" >> /etc/pacman.d/hooks/nvidia.hook
echo "When=PostTransaction" >> /etc/pacman.d/hooks/nvidia.hook
echo "NeedsTargets" >> /etc/pacman.d/hooks/nvidia.hook
echo "Exec=/bin/sh -c 'while read -r trg; do case $trg in linux*) exit 0; esac; done; /usr/bin/mkinitcpio -P'" >> /etc/pacman.d/hooks/nvidia.hook
echo "Remove kms from the HOOKS array in /etc/mkinitcpio.conf and regenerate the initramfs. This will prevent the initramfs from containing the nouveau module making sure the kernel cannot load it during early boot. The nvidia-utils package contains a file which blacklists the nouveau module once you reboot."
echo "You can add nvidia, nvidia_modeset, nvidia_uvm and nvidia_drm to the initramfs."
echo "After all of that, run \"mkinitcpio -P\""
echo "Then \"exit\""
echo "and \"reboot\" (don't forget to unplug this usb once you do and select Arch as your first boot option)"

