#import "conf.typ": conf, amazed, plot_with_error
#show: conf.with(
  title: [
    $"DL"_n \(0\)$ de quelques fonctions
  ], authors: (
    (
      name: "Louis Dalibard", affiliation: "Lycée Louis-Le-Grand", email: "ontake@ontake.dev",
    ),
  ), columns: 2, lang: "en", docversion: "v0.0.1",
)

#let graph_size = (7, 5)

= Exponentielle et fonctions trigo
#list(
  [
    $e^x=sum_(k=0)^n frac(x^k, k!)+cal(o)(x^n)$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-4, +4), x-tick-step: 1, x-ticks-are-multiple-of-pi: false, y-tick-step: 2, y-min: -1, y-max: 10, f1: (($ e^x $), (x => calc.exp(x))), fn: (
          ($ 1+x $, x => 1 + x), (
            $ 1+x +frac(x^2, 2!)+ frac(x^3, 3!) $, x => 1 + x + calc.pow(x, 2) / 2 + calc.pow(x, 3) / 6,
          ), (
            $ 1+x +frac(x^2, 2!)+ frac(x^3, 3!)+ frac(x^4, 4!)+ frac(x^5, 5!) $, x => 1 + x + calc.pow(x, 2) / 2 + calc.pow(x, 3) / 6 + calc.pow(x, 4) / 24 + calc.pow(x, 5) / 120,
          ),
        ),
      )
    ]
  ], [
    $e^(-x)=sum_(k=0)^n (-1)^k frac(x^k, k!)+cal(o)(x^n)$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-4, +4), x-tick-step: 1, x-ticks-are-multiple-of-pi: false, y-tick-step: 2, y-min: -1, y-max: 10, f1: (($ e^(-x) $), (x => calc.exp(-x))), fn: (
          ($ 1-x $, x => 1 - x), (
            $ 1-x +frac(x^2, 2!)- frac(x^3, 3!) $, x => 1 - x + calc.pow(x, 2) / 2 - calc.pow(x, 3) / 6,
          ), (
            $ 1-x +frac(x^2, 2!)- frac(x^3, 3!)+ frac(x^4, 4!)- frac(x^5, 5!) $, x => 1 - x + calc.pow(x, 2) / 2 - calc.pow(x, 3) / 6 + calc.pow(x, 4) / 24 - calc.pow(x, 5) / 120,
          ),
        ),
      )
    ]
  ], [
    $cos(x)=sum_(k=0)^n (-1)^k frac(x^(2k), (2k)!)+cal(o)(x^(2n+1))$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-calc.pi, +calc.pi), x-tick-step: calc.pi / 2, x-ticks-are-multiple-of-pi: true, y-tick-step: 0.5, y-min: -1.5, y-max: 1.5, f1: (($ cos(x) $), (x => calc.cos(x))), fn: (
          ($ 1 $, x => 1), ($ 1-frac(x^2, 2!) $, x => 1 - calc.pow(x, 2) / 2), (
            $ 1-frac(x^2, 2!)+ frac(x^4, 4!) $, x => 1 - calc.pow(x, 2) / 2 + calc.pow(x, 4) / 24,
          ),
        ),
      )
    ]
  ],
)
#colbreak()
#list(
  [
    $sin(x)=sum_(k=0)^n (-1)^k frac(x^(2k+1), (2k+1)!)+cal(o)(x^(2n+2))$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-calc.pi, +calc.pi), x-tick-step: calc.pi / 2, x-ticks-are-multiple-of-pi: true, y-tick-step: 0.5, y-min: -1.5, y-max: 1.5, f1: (($ sin(x) $), (x => calc.sin(x))), fn: (
          ($ x $, x => x), ($ x-frac(x^3, 3!) $, x => x - calc.pow(x, 3) / 6), (
            $ x-frac(x^3, 3!)+ frac(x^5, 5!) $, x => x - calc.pow(x, 3) / 6 + calc.pow(x, 5) / 120,
          ),
        ),
      )
    ]
  ], [
    $cosh(x)=sum_(k=0)^n frac(x^(2k), (2k)!)+cal(o)(x^(2n+1))$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-calc.pi, +calc.pi), x-tick-step: calc.pi / 2, x-ticks-are-multiple-of-pi: true, y-tick-step: 1, y-min: 0.5, y-max: 8.5, f1: (($ cosh(x) $), (x => calc.cosh(x))), fn: (
          ($ 1 $, x => 1), ($ 1+frac(x^2, 2!) $, x => 1 + calc.pow(x, 2) / 2), (
            $ 1+frac(x^2, 2!)+ frac(x^4, 4!) $, x => 1 + calc.pow(x, 2) / 2 + calc.pow(x, 4) / 24,
          ),
        ),
      )
    ]
  ], [
    $sinh(x)=sum_(k=0)^n frac(x^(2k+1), (2k+1)!)+cal(o)(x^(2n+2))$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-calc.pi, +calc.pi), x-tick-step: calc.pi / 2, x-ticks-are-multiple-of-pi: true, y-tick-step: 4, y-min: -15, y-max: 15, f1: (($ sinh(x) $), (x => calc.sinh(x))), fn: (
          ($ x $, x => x), ($ x+frac(x^3, 3!) $, x => x + calc.pow(x, 3) / 6), (
            $ x+frac(x^3, 3!)+ frac(x^5, 5!) $, x => x + calc.pow(x, 3) / 6 + calc.pow(x, 5) / 120,
          ),
        ),
      )
    ]
  ],
)
#colbreak()
#list(
  [
    $tan(x)=x+frac(x^3, 3)+frac(2x^5, 15)+frac(17x^7, 315)+cal(o)(x^(8))$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-19 * calc.pi / 40, +19 * calc.pi / 40), x-tick-step: calc.pi / 4, x-ticks-are-multiple-of-pi: true, y-tick-step: 4, y-min: -10, y-max: 10, f1: (($ tan(x) $), (x => calc.tan(x))), fn: (
          ($ x $, x => x), ($ x+frac(x^3, 3) $, x => x + calc.pow(x, 3) / 3), (
            $ x+frac(x^3, 3)+frac(2x^5, 15)+frac(17x^7, 315) $, x => x + calc.pow(x, 3) / 3 + 2 * calc.pow(x, 5) / 15 + 17 * calc.pow(x, 7) / 315,
          ),
        ),
      )
    ]
  ],
)

= Fonctions trigo reciproques
#list(
  [
    $arctan(x)=sum_(k=0)^n (-1)^k frac(x^(2k+1), 2k+1)+cal(o)(x^(2n+2))$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-2, +2), x-tick-step: 1, x-ticks-are-multiple-of-pi: false, y-tick-step: 1, y-min: -2, y-max: 2, f1: (($ arctan(x) $), (x => calc.atan(x).rad())), fn: (
          ($ x $, x => x), ($ x-frac(x^3, 3) $, x => x - calc.pow(x, 3) / 3), (
            $ x-frac(x^3, 3)+ frac(x^5, 5) $, x => x - calc.pow(x, 3) / 3 + calc.pow(x, 5) / 5,
          ),
        ),
      )
    ]
  ], [
    $frac(1, sqrt(1-x^2))=sum_(k=0)^n binom(2k, k)frac(x^(2k), 2^(2k))+cal(o)(x^(2n+1))$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-0.9, +0.9), x-tick-step: 0.5, x-ticks-are-multiple-of-pi: false, y-tick-step: 0.5, y-min: 1, y-max: 2.5, f1: (($ 1/sqrt(1-x^2) $), (x => 1 / calc.sqrt(1 - calc.pow(x, 2)))), fn: (
          ($ 1 $, x => 1), ($ 1 + frac(1, 2)x^2 $, x => 1 + 0.5 * calc.pow(x, 2)), (
            $ 1 + frac(1, 2)x^2 + frac(3, 8)x^4 $, x => 1 + 0.5 * calc.pow(x, 2) + 0.375 * calc.pow(x, 4),
          ),
        ),
      )
    ]
  ],
)
#colbreak()
#list(
  [
    $arcsin(x)=sum_(k=0)^n binom(2k, k)frac(x^(2k+1), 2^(2k)(2k+1))+cal(o)(x^(2n+2))$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-1, +1), x-tick-step: 0.5, x-ticks-are-multiple-of-pi: false, y-tick-step: 0.5, y-min: -2, y-max: 2, f1: (($ arcsin(x) $), (x => calc.asin(x).rad())), fn: (
          ($ x $, x => x), ($ x + frac(1, 6)x^3 $, x => x + (1 / 6) * calc.pow(x, 3)), (
            $ x + frac(1, 6)x^3 + frac(3, 40)x^5 $, x => x + (1 / 6) * calc.pow(x, 3) + (3 / 40) * calc.pow(x, 5),
          ),
        ),
      )
    ]
  ], [
    $arccos(x)=frac(π, 2) - arcsin(x)$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-1, +1), x-tick-step: 0.5, x-ticks-are-multiple-of-pi: false, y-tick-step: 0.5, y-min: 0, y-max: 3.5, f1: (($ arccos(x) $), (x => calc.acos(x).rad())), fn: (
          ($ frac(π, 2) - x $, x => calc.pi / 2 - x), (
            $ frac(π, 2) - x - frac(1, 6)x^3 $, x => calc.pi / 2 - x - (1 / 6) * calc.pow(x, 3),
          ), (
            $ frac(π, 2) - x - frac(1, 6)x^3 - frac(3, 40)x^5 $, x => calc.pi / 2 - x - (1 / 6) * calc.pow(x, 3) - (3 / 40) * calc.pow(x, 5),
          ),
        ),
      )
    ]
  ],
)

= Fonctions usuelles
#list(
  [
    $ln(1+x) = sum_(k=0)^n (-1)^(k) frac(x^(k+1), k+1) + cal(o)(x^(n+1))$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-0.9, +2.5), x-tick-step: 0.5, x-ticks-are-multiple-of-pi: false, y-tick-step: 0.5, y-min: -1, y-max: 1.5, f1: (($ ln(1+x) $), (x => calc.ln(1 + x))), fn: (
          ($ x $, x => x), ($ x - frac(x^2, 2) $, x => x - calc.pow(x, 2) / 2), (
            $ x - frac(x^2, 2) + frac(x^3, 3) $, x => x - calc.pow(x, 2) / 2 + calc.pow(x, 3) / 3,
          ),
        ),
      )
    ]
  ],
)
#colbreak()
#list(
  [
    $(1+x)^α = sum_(k=0)^n α(α-1)...(α-k+1)frac(x^k, k!) + cal(o)(x^(n))$

    Pour $α=frac(1, 2)$:
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-1, +5), x-tick-step: 1, x-ticks-are-multiple-of-pi: false, y-tick-step: 1, y-min: 0, y-max: 4, f1: (($ (1+x)^(frac(1, 2)) $), (x => calc.pow(1 + x, 0.5))), fn: (
          ($ 1+α x $, x => 1 + 0.5 * x), (
            $ 1+α x+frac(α(α-1), 2!)x^2 $, x => 1 + 0.5 * x + (0.5 * -0.5) / 2 * calc.pow(x, 2),
          ),
        ),
      )
    ]
  ], [
    $frac(1, 1+x) = sum_(k=0)^n (-1)^k x^k + cal(o)(x^n)$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-0.9, +0.9), x-tick-step: 0.5, x-ticks-are-multiple-of-pi: false, y-tick-step: 0.5, y-min: 0.1, y-max: 2.1, f1: (($ 1/(1+x) $), (x => 1 / (1 + x))), fn: (
          ($ 1 - x $, x => 1 - x), ($ 1 - x + x^2 $, x => 1 - x + calc.pow(x, 2)), ($ 1 - x + x^2 - x^3 $, x => 1 - x + calc.pow(x, 2) - calc.pow(x, 3)),
        ),
      )
    ]
  ], [
    $frac(1, 1-x) = sum_(k=0)^n x^k + cal(o)(x^n)$
    #align(
      right,
    )[
      #plot_with_error(
        size: graph_size, legend: "inner-north-east", domain: (-0.9, +0.9), x-tick-step: 0.5, x-ticks-are-multiple-of-pi: false, y-tick-step: 0.5, y-min: 0.1, y-max: 4.1, f1: (($ 1/(1-x) $), (x => 1 / (1 - x))), fn: (
          ($ 1 + x $, x => 1 + x), ($ 1 + x + x^2 $, x => 1 + x + calc.pow(x, 2)), ($ 1 + x + x^2 + x^3 $, x => 1 + x + calc.pow(x, 2) + calc.pow(x, 3)),
        ),
      )
    ]
  ],
)
