#import "@preview/cetz:0.3.2": canvas, draw
#import "@preview/cetz-plot:0.1.1": plot, chart

#let conf(
  title: none, authors: (
    (
      name: "Louis Dalibard", affiliation: "Lycée Louis-Le-Grand", email: "ontake@ontake.dev",
    ),
  ), columns: 1, lang: "en", docversion: "v0.0.1", doc,
) = {
  set text(font: "New Computer Modern", size: 10pt)
  set page(
    paper: "a4", margin: (x: 1.8cm, y: 1.5cm), header: align(
      right + horizon,
    )[
      #rect(
        width: 100%, height: 100%, inset: 4pt, stroke: (
          bottom: (
            paint: gradient.linear(..color.map.turbo), thickness: 1pt, dash: "dashed",
          ),
        ),
      )[
        *#title*
      ]
    ], numbering: "— 1 —", footer: context[#rect(
        width: 100%, height: 100%, inset: 4pt, stroke: (
          top: (
            paint: gradient.linear(..color.map.turbo), thickness: 1pt, dash: "dashed",
          ),
        ),
      )[
        #authors.at(0).name #h(1fr)
        #docversion
        #h(1fr)
        #counter(page).display("— 1 —")
      ]], columns: columns,
  )
  set par(justify: true, leading: 0.52em)

  set heading(numbering: "I.1")
  show heading: it => [
    #set text(font: "libertinus serif")
    #counter(heading).display(it.numbering) - #emph(it.body)

  ]

  /* Replace some occurences */
  show "OnTake": name => box[
    #box(image("OnTake.dev-Scaled-Offset.png", height: 0.7em))
    #name
  ]
  let LaTeX = {
    let A = (offset: (x: -0.33em, y: -0.3em), size: 0.7em)
    let T = (x_offset: -0.12em)
    let E = (x_offset: -0.2em, y_offset: 0.23em, size: 1em)
    let X = (x_offset: -0.1em)
    [L#h(A.offset.x)#text(size: A.size, baseline: A.offset.y)[A]#h(T.x_offset)T#h(E.x_offset)#text(size: E.size, baseline: E.y_offset)[E]#h(X.x_offset)X]
  }
  show "LaTeX": name => LaTeX

  align(center, text(17pt)[
    *#title*
  ])
  let count = authors.len()
  let ncols = calc.min(count, 3)
  align(
    center, grid(columns: (1fr,) * ncols, row-gutter: 24pt, ..authors.map(author => [
      #author.name \
      #author.affiliation \
      #link("mailto:" + author.email)
    ])),
  )

  let to-string(it) = {
    if type(it) == str {
      it
    } else if type(it) != content {
      str(it)
    } else if it.has("text") {
      it.text
    } else if it.has("children") {
      it.children.map(to-string).join()
    } else if it.has("body") {
      to-string(it.body)
    } else if it == [ ] {
      " "
    }
  }

  let author_list = authors.map(author => [
    #author.name
  ]).join("-")

  set text(lang: lang)

  set document(title: [#title], author: to-string(author_list))

  doc
}

#let amazed(term, color: purple) = {
  text(color, box[✨ #term ✨])
}

#let plot_with_error(
  size: (16, 12), legend: "inner-north-east", domain: (-1.1 * calc.pi, +1.1 * calc.pi), x-tick-step: calc.pi / 2, x-ticks-are-multiple-of-pi: true, y-tick-step: 2, y-min: -2.5, y-max: 2.5, f1: (($ sin x $), (x => calc.sin(x))), fn: (
    ($ x - frac(x^3, 3!) $, x => x - calc.pow(x, 3) / 6), (
      $ x - frac(x^3, 3!) - frac(x^5, 5!) $, x => x - calc.pow(x, 3) / 6 + calc.pow(x, 5) / 120,
    ), (
      $ x - frac(x^3, 3!) - frac(x^5, 5!) - frac(x^7, 7!) $, x => x - calc.pow(x, 3) / 6 + calc.pow(x, 5) / 120 - calc.pow(x, 7) / 5040,
    ),
  ),
) = {
  canvas(
    {
      import draw: *

      // Set-up a thin axis style
      set-style(
        axes: (stroke: .5pt, tick: (stroke: .5pt)), legend: (stroke: none, orientation: ttb, item: (spacing: .3), scale: 80%),
      )

      plot.plot(
        size: size, x-tick-step: x-tick-step, x-format: if x-ticks-are-multiple-of-pi { plot.formats.multiple-of } else { auto }, y-tick-step: y-tick-step, y-min: y-min, y-max: y-max, legend: legend, {
          let domain = domain

          for ((title, f)) in fn {
            plot.add-fill-between(f, f1.at(1), domain: domain, style: (stroke: none), label: title)
          }
          plot.add(f1.at(1), domain: domain, label: f1.at(0), style: (stroke: black))
        },
      )
    },
  )
}
