package html

import (
	"fmt"
	"generate/config"
	"generate/piece"
	"time"
)

func Wrapper(CSS string, innerHTML string) string {
	return fmt.Sprintf(`
	<!DOCTYPE html>
<html lang="en">
<!-- Autogenerated on %s-->
  <head>
    <!-- Stylesheet-->
    <style>
    @import url('https://fonts.googleapis.com/css2?family=Yeseva+One&display=swap');
    @font-face {
      font-family: 'Begika';
      src: url('assets/fonts/begika.ttf')  format('truetype');
  }
    body{
      margin:0;
      overflow-y: hidden;
    }
    #background{
      position:fixed;
      height:100vh;
      width:100vw;
      background: rgb(210,210,210);
      background: linear-gradient(0deg, rgba(210,210,210,1) 0%%, rgba(247,247,247,1) 19%%, rgba(247,247,247,1) 100%%);
    }

    #shadows{
      position:absolute;
      height:100vh;
      pointer-events: none;
      background-image: url(assets/images/gallery-wall.png);
      background-size: cover;
      mix-blend-mode: multiply;
    }

    .piece-container {
      padding:%dpx;
    }

    .piece-container,.info-card{
      position:absolute;
      background:white;
      box-shadow: #d6dbe1 -%dpx %dpx 4px;
    }

    .info-card{
      width:%dpx;
      height:%dpx;
      padding:%dpx;
      font-family: "Begika", serif;
    }

    .info-card-title{
      font-size:24px;
    }

    .info-card-date{
      font-size:12px;
    }

    #gallery-container{
      margin: 0;
      position: absolute;
      top: 50%%;
      -ms-transform: translateY(-50%%);
      transform: translateY(-50%%);
      height:%dpx;
    }

    #gallery-title{
      position:absolute;
      top:420px;
      left:200px;
      font-family: "Begika", serif;
      font-size:128px;
    }
	%s
	</style>
    <!-- Title Element-->
    <title>gallery.visit | ontake.dev</title>
    <!-- Icon-->
    <link rel="icon" type="image/webp" href="/assets/images/icon.png" />
    <!-- Metadata-->
    <meta property="og:type" content="website" />
    <meta property="og:url" content="https://ontake.dev/gallery/visit" />
    <meta property="og:title" content="gallery.visit | ontake.dev" />
    <meta name="viewport" content="width=device-width, initial-scale=0.1" />
  </head>

  <body>
  <div id="background"></div>
  <div id="gallery-title">OnTake's<br>Gallery</div>
    <div id="content">
	%s
    </div>
  </body>
</html>
`, time.Now().Format("02-Jan-2006"), config.PiecePadding, config.ShadowOffset, config.ShadowOffset, config.InfoCardWidth-config.InfoCardPadding*2, config.InfoCardHeight-config.InfoCardPadding*2, config.InfoCardPadding, config.GalleryHeight, CSS, innerHTML)
}

func GeneratePiecesHTML(pieces []piece.Piece) string {
	maxX := 0.0
	innerHTML := ""
	for _, currpiece := range pieces {
		pieceHTML, curMaxX := piece.GeneratePieceHTML(currpiece, pieces)
		maxX = max(maxX, curMaxX)
		innerHTML += pieceHTML
	}
	return fmt.Sprintf(`<div id="gallery-container" style="width:%fpx">%s</div><div id="shadows" style="width:%fpx"></div>`, maxX+config.GalleryPadding, innerHTML, maxX+config.GalleryPadding)
}

func GeneratePage() string {
	return Wrapper("", GeneratePiecesHTML(piece.GalleryPieces))
}
