const axios = require('axios');
const fs = require('fs');
const urlOfLemmas='https://ontake.dev/daily-kanji/assets/datasets/listoflemmas.txt';
let currentLemmaIndex = 0;
let listOfLemmas = []
let starttime;



axios.get(urlOfLemmas)
  .then(res => {
    const headerDate = res.headers && res.headers.date ? res.headers.date : 'no response date';
    console.log('Status Code:', res.status);
    console.log('Date in Response header:', headerDate);
    listOfLemmas = res.data.split("\r\n");
    console.log(listOfLemmas)
    starttime=new Date();
    constructDatabase();
  })
  .catch(err => {
    console.log('Error: ', err.message);
  });

function constructDatabase(){
  currentLemma = listOfLemmas[currentLemmaIndex]
  axios.get('https://jisho.org/api/v1/search/words?keyword='+encodeURI(currentLemma))
  .then(res => {
    const headerDate = res.headers && res.headers.date ? res.headers.date : 'no response date';
    fs.writeFile("./jisho-dataset/"+currentLemma, JSON.stringify(res.data), function(err) {
      if(err) {
          return console.log(err);
      }
      console.log(currentLemmaIndex+"/"+"20000");
      console.log(((new Date()-starttime)/1000)/(currentLemmaIndex+1)*(20000-currentLemmaIndex)/60+"min")
  }); 
    currentLemmaIndex++;
    if (currentLemmaIndex != listOfLemmas.length){
    constructDatabase()
    }
  })
  .catch(err => {
    console.log('Error: ', err.message);
    constructDatabase();
  });
  }

