String.prototype.toHHMMSS = function () {
  var sec_num = parseInt(this, 10); // don't forget the second param
  var hours = Math.floor(sec_num / 3600);
  var minutes = Math.floor((sec_num - hours * 3600) / 60);
  var seconds = sec_num - hours * 3600 - minutes * 60;

  if (hours < 10) {
    hours = "0" + hours;
  }
  if (minutes < 10) {
    minutes = "0" + minutes;
  }
  if (seconds < 10) {
    seconds = "0" + seconds;
  }
  return hours + ":" + minutes + ":" + seconds;
};

function formatBytes(bytes, decimals = 2) {
  if (!+bytes) return "0 Bytes";

  const k = 1024;
  const dm = decimals < 0 ? 0 : decimals;
  const sizes = ["Bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"];

  const i = Math.floor(Math.log(bytes) / Math.log(k));

  return `${parseFloat((bytes / Math.pow(k, i)).toFixed(dm))} ${sizes[i]}`;
}

$.ajax({
  url: "https://yukihyou.ontake.dev/banner",
  type: "GET",
  dataType: "text", // added data type
  success: function (res) {
    console.log(res);
    document.getElementById("ascii-banner-text").innerHTML = res
      .replaceAll(" ", "&nbsp;")
      .replaceAll("<", "&lt;")
      .replaceAll(">", "&gt;")
      .replaceAll("\n", "<br>");
  },
});
$.ajax({
  url: "https://yukihyou.ontake.dev/status",
  type: "GET",
  dataType: "json", // added data type
  success: function (res) {
    console.log(res);
    document.getElementById("server-system-info-text").innerHTML =
      "Hostname: " + res.Hostname + "<br>";
    document.getElementById("server-system-info-text").innerHTML +=
      "Server time: " + res.CurrentTime + "<br>";
    document.getElementById("server-system-info-text").innerHTML +=
      "Uptime: " + String(res.UpTime).toHHMMSS() + "<br>";
    document.getElementById("server-system-info-text").innerHTML +=
      "Used memory: " + formatBytes(res.SystemMemory - res.FreeMemory) + "<br>";
    document.getElementById("server-system-info-text").innerHTML +=
      "System memory: " + formatBytes(res.SystemMemory);
  },
});
