let lineHeight = 28; //px

let dnaData = "acggattagaagccgccgagcgggtgacagccctccgaaggaagactctcctccgtgcgtcctcgtcttcaccggtcgcgttcctgaaacgcagatgtgcctcgcgccgcactgctccgaacaataaagattctacaatactagcttttatggttatgaagaggaaaaattggcagtaacctggccccacaaaccttcaaatgaacgaatcaaattaacaaccataggatgataatgcgattagttttttagccttatttctggggtaattaatcagcgaagcgatgatttttgatctattaacagatatataaatgcaaaaactgcataaccactttaactaatactttcaacattttcggtttgtattacttcttattcaaatgtaataaaagtatcaacaaaaaattgttaatatacctctatactttaacgtcaaggagaaaaaaccccggatcggactactagcagccatggaaaaaaatgtctaatttgttgactgttcatcaaaatttgccagctttgccagttgatgcaacgtctgatgaggtaagaaagaatttgatggatatgtttagagatagacaagcattctctgaacatacttggaaaatgttgttgtctgtttgtagatcttgggctgcttggtgtaaattaaataatagaaaatggtttccagctgaaccagaagatgttagagattatttgttgtatttgcaagctagaggtttggctgttaaaactatacaacaacatttgggtcaattaaatatgttgcataggagatctggtttgcctagaccatctgattctaatgctgtatctttggttatgagaaggattagaaaagaaaatgttgatgcaggtgaaagagctaaacaagcattggcgtttgaaagaactgattttgatcaagttagatctttgatggaaaattctgatagatgtcaagatataagaaacttggctttcttgggaattgcttataatacattgttgagaattgctgaaattgctagaattagagttaaagacatttctagaactgatggtggtagaatgttgattcatattggtagaactaaaacattggtttcaactgctggcgttgagaaagcattgtctttgggtgttactaaattggttgaaagatggatttctgtatctggtgtggctgatgacccaaataattatttattttgtagagttagaaagaatggtgttgcggctccatctgctacatctcagctctctacccgtgccttggaaggaatttttgaagcaactcatagattgatttatggtgctaaagatgattctggtcaaagatatttagcatggtctggtcattctgctagagttggtgccgctagagatatggctagagctggggtatctattcctgaaattatgcaagctggtggttggactaatgttaacatcgtcatgaactatattagaaatttggattctgaaactggtgcaatggttagactcttggaagatggtgatcccgggaagcttggtacctatcacataggaagcaacaggcgcgttggacttttaattttcgaggaccgcgaatccttacatcacacccaatcccccacaagtgatcccccacacaccatagcttcaaaatgtttctactccttttttactcttccagattttctcggactccgcgcatcgccgtaccacttcaaaacacccaagcacagcatactaaatttcccctctttcttcctctagggtgtcgttaattacccgtactaaaggtttggaaaagaaaaaagagaccgcctcgtttctttttcttcgtcgaaaaaggcaataaaaatttttatcacgtttctttttcttgaaaatttttttttttgatttttttctctttcgatgacctcccattgatatttaagttaataaacggtcttcaatttctcaagtttcagtttcatttttcttgttctattacaactttttttacttcttgctcattagaaagaaagcatagcaatctaatctaagttttaattacaaaggatccacgattaaaagaATGtttgtttttcttgttttattgccactagtctctagtcagtgtgttaatcttacaaccagaactcaattaccccctgcatacactaattctttcacacgtggtgtttattaccctgacaaagttttcagatcctcagttttacattcaactcaggacttgttcttacctttcttttccaatgttacttggttccatgctatacatgtctctgggaccaatggtactaagaggtttgataaccctgtcctaccatttaatgatggtgtttattttgcttccactgagaagtctaacataataagaggctggatttttggtactactttagattcgaagacccagtccctacttattgttaataacgctactaatgttgttattaaagtctgtgaatttcaattttgtaatgatccatttttgggtgtttattaccacaaaaacaacaaaagttggatggaaagtgagttcagagtttattctagtgcgaataattgcacttttgaatatgtctctcagccttttcttatggaccttgaaggaaaacagggtaatttcaaaaatcttagggaatttgtgtttaagaatattgatggttattttaaaatatattctaagcacacgcctattaatttagtgcgtgatctccctcagggtttttcggctttagaaccattggtagatttgccaataggtattaacatcactaggtttcaaactttacttgctttacatagaagttatttgactcctggtgattcttcttcaggttggacagctggtgctgcagcttattatgtgggttatcttcaacctaggacttttctattaaaatataatgaaaatggaaccattacagatgctgtagactgtgcacttgaccctctctcagaaacaaagtgtacgttgaaatccttcactgtagaaaaaggaatctatcaaacttctaactttagagtccaaccaacagaatctattgttagatttcctaatattacaaacttgtgcccttttggtgaagtttttaacgccaccagatttgcatctgtttatgcttggaacaggaagagaatcagcaactgtgttgctgattattctgtcctatataattccgcatcattttccacttttaagtgttatggagtgtctcctactaaattaaatgatctctgctttactaatgtctatgcagattcatttgtaattagaggtgatgaagtcagacaaatcgctccagggcaaactggaaagattgctgattataattataaattaccagatgattttacaggctgcgttatagcttggaattctaacaatcttgattctaaggttggtggtaattataattacctgtatagattgtttaggaagtctaatctcaaaccttttgagagagatatttcaactgaaatctatcaggccggtagcacaccttgtaatggtgttgaaggttttaattgttactttcctttacaatcatatggtttccaacccactaatggtgttggttaccaaccatacagagtagtagtactttcttttgaacttctacatgcaccagcaactgtttgtggacctaaaaagtctactaatttggttaaaaacaaatgtgtcaatttcaacttcaatggtttaacaggcacaggtgttcttactgagtctaacaaaaagtttctgcctttccaacaatttggcagagacattgctgacactactgatgctgtccgtgatccacagacacttgagattcttgacattacaccatgttcttttggtggtgtcagtgttataacaccaggaacaaatacttctaaccaggttgctgttctttatcaggatgttaactgcacagaagtccctgttgctattcatgcagatcaacttactcctacttggcgtgtttattctacaggttctaatgtttttcaaacacgtgcaggctgtttaataggggctgaacatgtcaacaactcatatgagtgtgacatacccattggtgcaggtatatgcgctagttatcagactcagactaattctcctcggcgggcacgtagtgtagctagtcaatccatcattgcctacactatgtcacttggtgcagaaaattcagttgcttactctaataactctattgccatacccacaaattttactattagtgttaccacagaaattctaccagtgtctatgaccaagacatcagtagattgtacaatgtacatttgtggtgattcaactgaatgcagcaatcttttgttgcaatatggcagtttttgtacacaattaaaccgtgctttaactggaatagctgttgaacaagacaaaaacacccaagaagtttttgcacaagtcaaacaaatttacaaaacaccaccaattaaagattttggtggttttaatttttcacaaatattaccagatccatcaaaaccaagcaagaggtcatttattgaagatctacttttcaacaaagtgacacttgcagatgctggcttcatcaaacaatatggtgattgccttggtgatattgctgctagagacctcatttgtgcacaaaagtttaacggccttactgttttgccacctttgctcacagatgaaatgattgctcaatacacttctgcactgttagcgggtacaatcacttctggttggacctttggtgcaggtgctgcattacaaataccatttgctatgcaaatggcttataggtttaatggtattggagttacacagaatgttctctatgagaaccaaaaattgattgccaaccaatttaatagtgctattggcaaaattcaagactcactttcttccacagcaagtgcacttggaaaacttcaagatgtggtcaaccaaaatgcacaagctttaaacacgcttgttaaacaacttagctccaattttggtgcaatttcaagtgttttaaatgatatcctttcacgtcttgacaaagttgaggctgaagtgcaaattgataggttgatcacaggcagacttcaaagtttgcagacatatgtgactcaacaattaattagagctgcagaaatcagagcttctgctaatcttgctgctactaaaatgtcagagtgtgtacttggacaatcaaaaagagttgatttttgtggaaagggctatcatcttatgtccttccctcagtcagcacctcatggtgtagtcttcttgcatgtgacttatgtccctgcacaagaaaagaacttcacaactgctcctgccatttgtcatgatggaaaagcacactttcctcgtgaaggtgtctttgtttcaaatggcacacactggtttgtaacacaaaggaatttttatgaaccacaaatcattactacagacaacacatttgtgtctggtaactgtgatgttgtaataggaattgtcaacaacacagtttatgatcctttgcaacctgaattagactcattcaaggaggagttagataaatattttaagaatcatacatcaccagatgttgatttaggtgacatctctggcattaatgcttcagttgtaaacattcaaaaagaaattgaccgcctcaatgaggttgccaagaatttaaatgaatctctcatcgatctccaagaacttggaaagtatgagcagtatataaaatggccatggtacatttggctaggttttatagctggcttgattgccatagtaatggtgacaattatgctttgctgtatgaccagttgctgtagttgtctcaagggctgttgttcttgtggatcctgctgcaaatttgatgaagacgactctgagccagtgctcaaaggagtcaaattacattacacataatgatcatgtaattagttatgtcacgcttacattcacgccctccccccacatccgctctaaccgaaaaggaaggagttagacaacctgaagtctaggtccctatttatttttttatagttatgttagtattaagaacgttatttatatttcaaatttttcttttttttctgtacagacgcgtgtacgcatgtaacattatactgaaaaccttgcttgagaaggttttgggacgctcgaaggctttaatttgcggatccactagtaacggccgccagtgtgctggaattctgcagatatccatcacactggcggccgctcgagcatgcatctagagggccgcatcatgtaattagttatgtcacgcttacattcacgccctccccccacatccgctctaaccgaaaaggaaggagttagacaacctgaagtctaggtccctatttatttttttatagttatgttagtattaagaacgttatttatatttcaaatttttcttttttttctgtacagacgcgtgtacgcatgtaacattatactgaaaaccttgcttgagaaggttttgggacgctcgaaggctttaatttgcggccctgcattaatgaatcggccaacgcgcggggagaggcggtttgcgtattgggcgctcttccgcttcctcgctcactgactcgctgcgctcggtcgttcggctgcggcgagcggtatcagctcactcaaaggcggtaatacggttatccacagaatcaggggataacgcaggaaagaacatgtgagcaaaaggccagcaaaagcccaggaaccgtaaaaaggccgcgttgctggcgtttttccataggctccgcccccctgacgagcatcacaaaaatcgacgctcaagtcagaggtggcgaaacccgacaggactataaagataccaggcgtttccccctggaagctccctcgtgcgctctcctgttccgaccctgccgcttaccggatacctgtccgcctttctcccttcgggaagcgtggcgctttctcatagctcacgctgtaggtatctcagttcggtgtaggtcgttcgctccaagctgggctgtgtgcacgaaccccccgttcagcccgaccgctgcgccttatccggtaactatcgtcttgagtccaacccggtaagacacgacttatcgccactggcagcagccactggtaacaggattagcagagcgaggtatgtaggcggtgctacagagttcttgaagtggtggcctaactacggctacactagaaggacagtatttggtatctgcgctctgctgaagccagttaccttcggaaaaagagttggtagctcttgatccggcaaacaaaccaccgctggtagcggtggtttttttgtttgcaagcagcagattacgcgcagaaaaaaaggatctcaagaagatcctttgatcttttctacggggtctgacgctcagtggaacgaaaactcacgttaagggattttggtcatgagattatcaaaaaggatcttcacctagatccttttaaattaaaaatgaagttttaaatcaatctaaagtatatatgagtaaacttggtctgacagttaccaatgcttaatcagtgaggcacctatctcagcgatctgtctatttcgttcatccatagttgcctgactccccgtcgtgtagataactacgatacgggagcgcttaccatctggccccagtgctgcaatgataccgcgagacccacgctcaccggctccagatttatcagcaataaaccagccagccggaagggccgagcgcagaagtggtcctgcaactttatccgcctccattcagtctattaattgttgccgggaagctagagtaagtagttcgccagttaatagtttgcgcaacgttgttggcattgctacaggcatcgtggtgtcactctcgtcgtttggtatggcttcattcagctccggttcccaacgatcaaggcgagttacatgatcccccatgttgtgcaaaaaagcggttagctccttcggtcctccgatcgttgtcagaagtaagttggccgcagtgttatcactcatggttatggcagcactgcataattctcttactgtcatgccatccgtaagatgcttttctgtgactggtgagtactcaaccaagtcattctgagaatagtgtatgcggcgaccgagttgctcttgcccggcgtcaatacgggataatagtgtatcacatagcagaactttaaaagtgctcatcattggaaaacgttcttcggggcgaaaactctcaaggatcttaccgctgttgagatccagttcgatgtaacccactcgtgcacccaactgatcttcagcatcttttactttcaccagcgtttctgggtgagcaaaaacaggaaggcaaaatgccgcaaaaaagggaataagggcgacacggaaatgttgaatactcatactcttcctttttcaatgggtaataactgatataattaaattgaagctctaatttgtgagtttagtatacatgcatttacttataatacagttttttagttttgctggccgcatcttctcaaatatgcttcccagcctgcttttctgtaacgttcaccctctaccttagcatcccttccctttgcaaatagtcctcttccaacaataataatgtcagatcctgtagagaccacatcatccacggttctatactgttgacccaatgcgtctcccttgtcatctaaacccacaccgggtgtcataatcaaccaatcgtaaccttcatctcttccacccatgtctctttgagcaataaagccgataacaaaatctttgtcgctcttcgcaatgtcaacagtacccttagtatattctccagtagatagggagcccttgcatgacaattctgctaacatcaaaaggcctctaggttcctttgttacttcttctgccgcctgcttcaaaccgctaacaatacctgggcccaccacaccgtgtgcattcgtaatgtctgcccattctgctattctgtatacacccgcagagtactgcaatttgactgtattaccaatgtcagcaaattttctgtcttcgaagagtaaaaaattgtacttggcggataatgcctttagcggcttaactgtgccctccatggaaaaatcagtcaagatatccacatgtgtttttagtaaacaaattttgggacctaatgcttcaactaactccagtaattccttggtggtacgaacatccaatgaagcacacaagtttgtttgcttttcgtgcatgatattaaatagcttggcagcaacaggactaggatgagtagcagcacgttccttatatgtagctttcgacatgatttatcttcgtttcctgcaggtttttgttctgtgcagttgggttaagaatactgggcaatttcatgtttcttcaacactacatatgcgtatatataccaatctaagtctgtgctccttccttcgttcttccttctgttcggagattaccgaatcaaaaaaatttcaaagaaaccgaaatcaaaaaaaagaataaaaaaaaaatgatgaattgaattgaaaagctagcttatcgatgataagctgtcaaagatgagaattaattccacggactatagactatactagatactccgtctactgtacgatacacttccgctcaggtccttgtcctttaacgaggccttaccactcttttgttactctattgatccagctcagcaaaggcagtgtgatctaagattctatcttcgcgatgtagtaaaactagctagaccgagaaagagactagaaatgcaaaaggcacttctacaatggctgccatcattattatccgatgtgacgctgcagcttctcaatgatattcgaatacgctttgaggagatacagcctaatatccgacaaactgttttacagatttacgatcgtagataagctgtcaaagatgagaattaattccacggactatagactatactagatactccgtctactgtacgatacacttccgctcaggtccttgtcctttaacgaggccttaccactcttttgttactctattgatccagctcagcaaaggcagtgtgatctaagattctatcttcgcgatgtagtaaaactagctagaccgagaaagagactagaaatgcaaaaggcacttctacaatggctgccatcattattatccgatgtgacgctgcagcttctcaatgatattcgaatacgctttgaggagatacagcctaatatccgacaaactgttttacagatttacgatcgtacttgttacccatcattgaattttgaacatccgaacctgggagttttccctgaaacagatagtatatttgaacctgtataataatatatagtctagcgctttacggaagacaatgtatgtatttcggttcctggagaaactattgcatctattgcataggtaatcttgcacgtcgcatccccggttcattttctgcgtttccatcttgcacttcaatagcatatctttgttaacgaagcatctgtgcttcattttgtagaacaaaaatgcaacgcgagagcgctaatttttcaaacaaagaatctgagctgcatttttacagaacagaaatgcaacgcgaaagcgctattttaccaacgaagaatctgtgcttcatttttgtaaaacaaaaatgcaacgcgacgagagcgctaatttttcaaacaaagaatctgagctgcatttttacagaacagaaatgcaacgcgagagcgctattttaccaacaaagaatctatacttcttttttgttctacaaaaatgcatcccgagagcgctatttttctaacaaagcatcttagattactttttttctcctttgtgcgctctataatgcagtctcttgataactttttgcactgtaggtccgttaaggttagaagaaggctactttggtgtctattttctcttccataaaaaaagcctgactccacttcccgcgtttactgattactagcgaagctgcgggtgcattttttcaagataaaggcatccccgattatattctataccgatgtggattgcgcatactttgtgaacagaaagtgatagcgttgatgattcttcattggtcagaaaattatgaacggtttcttctattttgtctctatatactacgtataggaaatgtttacattttcgtattgttttcgattcactctatgaatagttcttactacaatttttttgtctaaagagtaatactagagataaacataaaaaatgtagaggtcgagtttagatgcaagttcaaggagcgaaaggtggatgggtaggttatatagggatatagcacagagatatatagcaaagagatacttttgagcaatgtttgtggaagcggtattcgcaatgggaagctccaccccggttgataatcagaaaagccccaaaaacaggaagattgtataagcaaatatttaaattgtaaacgttaatattttgttaaaattcgcgttaaatttttgttaaatcagctcattttttaacgaatagcccgaaatcggcaaaatcccttataaatcaaaagaatagaccgagatagggttgagtgttgttccagtttccaacaagagtccactattaaagaacgtggactccaacgtcaaagggcgaaaaagggtctatcagggcgatggcccactacgtgaaccatcaccctaatcaagttttttggggtcgaggtgccgtaaagcagtaaatcggaagggtaaacggatgcccccatttagagcttgacggggaaagccggcgaacgtggcgagaaaggaagggaagaaagcgaaaggagcgggggctagggcggtgggaagtgtaggggtcacgctgggcgtaaccaccacacccgccgcgcttaatggggcgctacagggcgcgtggggatgatccactagt";

let annotationData = [{ title: "source", start: 0, end: 11821, color: "#4C3B4D", pdbe: false }, { title: "UAS", start: 1, end: 118, color: "#624B58", pdbe: false }, { title: "GAL1 promoter", start: 1, end: 442, color: "#775A62", pdbe: false }, { title: "GAL", start: 413, end: 436, color: "#A17A78", pdbe: false }, { title: "Tef1 promoter (SacI cut site used)", start: 1530, end: 2040, color: "#CC998D", pdbe: false }, { title: "Kozak sequence", start: 2041, end: 2061, color: "#8FB7A3", pdbe: false }, { title: "SARS-CoV-2 Spike Protein (surface glycoprotein)", start: 2062, end: 5880, color: "#53D6BA", pdbe: true, pdbeID: "6vxx" }, { title: "TGA stop codon", start: 5881, end: 5883, color: "#2CC9BB", pdbe: false }, { title: "CYC1 terminator", start: 5884, end: 6131, color: "#429EA6", pdbe: false }, { title: "CYC1", start: 5900, end: 5918, color: "#153B50", pdbe: false }, { title: "CYC1 terminator", start: 6222, end: 6469, color: "#4C3B4D", pdbe: false }, { title: "CYC1", start: 6238, end: 6256, color: "#624B58", pdbe: false }, { title: "L4440", start: 6539, end: 6556, color: "#775A62", pdbe: false }, { title: "ori", start: 6710, end: 7298, color: "#A17A78", pdbe: false }, { title: "pBR322ori-F", start: 6790, end: 6809, color: "#CC998D", pdbe: false }, { title: "AmpR", start: 7469, end: 8329, color: "#8FB7A3", pdbe: false }, { title: "URA3", start: 8425, end: 9228, color: "#53D6BA", pdbe: false }, { title: "URA3 promoter", start: 9229, end: 9444, color: "#2CC9BB", pdbe: false }, { title: "2u ori", start: 10400, end: 11280, color: "#429EA6", pdbe: false }, { title: "f1 ori", start: 11349, end: 11804, color: "#153B50", pdbe: false }, { title: "F1ori-R", start: 11698, end: 11717, color: "#4C3B4D", pdbe: false }]

function displayPDBE(pdbeID) {
    document.getElementById("molstar-viewer-window").innerHTML = `<pdbe-molstar molecule-id="${pdbeID}" alphafold-view="true" hide-controls="false"><pdbe-molstar>`
}

function loadDNA() {
    for (let i in dnaData) {
        let bpDiv = document.createElement("div");
        bpDiv.id = "base-pair-" + i
        bpDiv.className = "base-pair"
        bpDiv.innerHTML = dnaData[i]
        // add the text node to the newly created div
        document.getElementById("base-pair-container").appendChild(bpDiv);
    }
    let maxAnnotationCount = 0
    for (let i in annotationData) {
        let currentAnnotationData = annotationData[i]
        let currentAnnotationDataTitle = " " + currentAnnotationData.title + " •"
        for (let j = 0; j < currentAnnotationData.end - currentAnnotationData.start + 1; j++) {
            let anDiv = document.createElement("div");
            anDiv.className = "annotation"
            anDiv.innerHTML = currentAnnotationDataTitle[j % currentAnnotationDataTitle.length].replace(" ", "&nbsp;")
            let parentElement = document.getElementById("base-pair-" + (currentAnnotationData.start + j))
            let borderRadius = "0px";
            if (j == 0) {
                borderRadius = "8px 0px 0px 8px"
            }
            if (j == currentAnnotationData.end - currentAnnotationData.start) {
                borderRadius = "0px 8px 8px 0px"
                anDiv.innerHTML = "&nbsp;"
            }
            if (currentAnnotationData.pdbe) {
                anDiv.setAttribute('onclick', `displayPDBE("${currentAnnotationData.pdbeID}");`)
            }
            anDiv.style = `top: ${lineHeight + parentElement.children.length * lineHeight}px;` + `height: ${lineHeight}px;` + `background: ${currentAnnotationData.color};` + `border-radius: ${borderRadius};`
            // add the text node to the newly created div
            parentElement.appendChild(anDiv);
            if (parentElement.children.length > maxAnnotationCount) {
                maxAnnotationCount = parentElement.children.length
            }
        }
    }
    let styleSheet = document.createElement("style");
    styleSheet.innerHTML = `.base-pair {height: ${3 * lineHeight + maxAnnotationCount * lineHeight}px;}`
    document.head.appendChild(styleSheet)
}

loadDNA()