var timestep = 1 / 10000;
var canvasScale = 20;
var inputScale = 1 / 2;
var numberOfVectors = 7; // Must be odd
var historicalPointsLimit = 1200; // usually framerate

// Program variables
// Canvas
var canvas = document.getElementsByTagName("canvas")[0];
var width = canvas.width;
var height = canvas.height;
var oldWidth = width;
var oldHeight = height;
var ctx = canvas.getContext("2d");

// Fourier series
fourierSeriesConstants = [];
// Historical points
var historicalPoints = [];
// Input points (https://shinao.github.io/PathToPoints/)

var inputPoints = [
  [
      -44.05,
      -48
  ],
  [
      -44.05,
      -47.6
  ],
  [
      -44.05,
      -46.7
  ],
  [
      -44.05,
      -45
  ],
  [
      -44.05,
      -42.6
  ],
  [
      -44.45,
      -39.4
  ],
  [
      -44.85,
      -36
  ],
  [
      -45.25,
      -31.8
  ],
  [
      -45.45,
      -27.6
  ],
  [
      -45.85,
      -23.4
  ],
  [
      -46.15,
      -19
  ],
  [
      -46.45,
      -15.5
  ],
  [
      -46.85,
      -10
  ],
  [
      -46.95,
      -6.8
  ],
  [
      -47.05,
      -4
  ],
  [
      -47.05,
      -2
  ],
  [
      -47.05,
      0.1
  ],
  [
      -47.05,
      1.8
  ],
  [
      -47.05,
      3.3
  ],
  [
      -47.05,
      4.4
  ],
  [
      -47.05,
      5
  ],
  [
      -47.05,
      5.6
  ],
  [
      -47.05,
      5.7
  ],
  [
      -47.05,
      5.8
  ],
  [
      -46.95,
      5.7
  ],
  [
      -46.65,
      5.2
  ],
  [
      -46.05,
      4.2
  ],
  [
      -44.45,
      2.6
  ],
  [
      -41.85,
      0.5
  ],
  [
      -37.65,
      -3
  ],
  [
      -32.55,
      -6.7
  ],
  [
      -26.85,
      -11.2
  ],
  [
      -20.65,
      -15.9
  ],
  [
      -14.85,
      -20.2
  ],
  [
      -7.35,
      -25.5
  ],
  [
      -2.55,
      -29
  ],
  [
      0.95,
      -31.5
  ],
  [
      4.55,
      -34.2
  ],
  [
      7.55,
      -36.4
  ],
  [
      9.45,
      -37.9
  ],
  [
      11.45,
      -39.4
  ],
  [
      12.75,
      -40.3
  ],
  [
      13.75,
      -41
  ],
  [
      14.25,
      -41.5
  ],
  [
      14.15,
      -41.5
  ],
  [
      13.95,
      -41.4
  ],
  [
      13.55,
      -41.2
  ],
  [
      13.05,
      -41
  ],
  [
      12.35,
      -40.7
  ],
  [
      11.55,
      -40.3
  ],
  [
      10.25,
      -39.5
  ],
  [
      8.65,
      -38.6
  ],
  [
      6.55,
      -37.5
  ],
  [
      2.35,
      -35.5
  ],
  [
      -1.65,
      -33.8
  ],
  [
      -4.55,
      -32.4
  ],
  [
      -8.05,
      -30.8
  ],
  [
      -11.25,
      -29.4
  ],
  [
      -14.25,
      -27.9
  ],
  [
      -16.85,
      -26.6
  ],
  [
      -18.55,
      -25.8
  ],
  [
      -20.45,
      -24.8
  ],
  [
      -22.05,
      -24
  ],
  [
      -23.45,
      -23.4
  ],
  [
      -24.95,
      -22.6
  ],
  [
      -26.85,
      -21.5
  ],
  [
      -27.75,
      -21
  ],
  [
      -28.55,
      -20.4
  ],
  [
      -29.05,
      -20
  ],
  [
      -29.65,
      -19.8
  ],
  [
      -29.75,
      -19.6
  ],
  [
      -30.05,
      -19.5
  ],
  [
      -30.15,
      -19.5
  ],
  [
      -30.05,
      -19.5
  ],
  [
      -29.75,
      -19.5
  ],
  [
      -29.35,
      -19.5
  ],
  [
      -28.65,
      -19.5
  ],
  [
      -27.85,
      -19.5
  ],
  [
      -26.65,
      -19.8
  ],
  [
      -25.05,
      -20
  ],
  [
      -22.05,
      -20.6
  ],
  [
      -18.05,
      -21.4
  ],
  [
      -9.25,
      -23.2
  ],
  [
      -2.85,
      -25
  ],
  [
      3.75,
      -26.8
  ],
  [
      9.05,
      -28.2
  ],
  [
      14.95,
      -29.6
  ],
  [
      19.05,
      -30.4
  ],
  [
      23.55,
      -31.4
  ],
  [
      27.15,
      -31.9
  ],
  [
      30.25,
      -32.4
  ],
  [
      32.15,
      -32.7
  ],
  [
      33.85,
      -32.8
  ],
  [
      35.35,
      -33
  ],
  [
      35.85,
      -33
  ],
  [
      36.15,
      -33
  ],
  [
      35.95,
      -33
  ],
  [
      35.75,
      -32.6
  ],
  [
      35.15,
      -32.2
  ],
  [
      33.85,
      -30.8
  ],
  [
      32.55,
      -29.6
  ],
  [
      30.25,
      -27.6
  ],
  [
      27.05,
      -25
  ],
  [
      21.95,
      -21.2
  ],
  [
      16.35,
      -17
  ],
  [
      9.75,
      -12.2
  ],
  [
      2.55,
      -7
  ],
  [
      -4.65,
      -1.5
  ],
  [
      -12.05,
      4
  ],
  [
      -18.85,
      9.6
  ],
  [
      -24.05,
      13.8
  ],
  [
      -29.45,
      18.4
  ],
  [
      -34.95,
      22.9
  ]
]
/*[
  [-2.2025083573478526, 1.0051891800658268],
  [-1.7874783258251057, -0.9291597085828585],
  [-0.7944158564618817, -2.673629264795295],
  [0.6417226675935979, -4.056001343094806],
  [2.38260363862301, -5.016999876015859],
  [4.319074114937422, -5.523062140309321],
  [6.317142913121813, -5.555618759536287],
  [8.24499662138902, -5.122076760196194],
  [10.037014313716526, -4.215563916289341],
  [11.523568221110935, -2.8873837762708376],
  [12.577346817035306, -1.2046858745450777],
  [13.084197830338127, 0.7245332944755773],
  [12.970333306033268, 2.7167375785475087],
  [12.255504042644162, 4.566049756443988],
  [11.017721584219515, 6.14833158675475],
  [9.410584046024894, 7.322738863862071],
  [7.55992728330574, 8.055665387547549],
  [5.587554257292339, 8.319744150078805],
  [3.592206927318159, 8.11491270104699],
  [1.7187215483971556, 7.441385351142856],
  [0.08055005170780305, 6.320185348904658],
  [-1.2091294565014152, 4.794034985936207],
  [-2.002946366291468, 2.9587237066393186],
  [-2.2025083573478526, 1.0051891800658268],
  [-1.7874783258251057, -0.9291597085828585],
  [-0.7944158564618817, -2.673629264795295],
  [0.6417226675935979, -4.056001343094806],
  [2.38260363862301, -5.016999876015859],
  [4.319074114937422, -5.523062140309321],
  [6.317142913121813, -5.555618759536287],
  [8.24499662138902, -5.122076760196194],
  [10.037014313716526, -4.215563916289341],
  [11.523568221110935, -2.8873837762708376],
  [12.577346817035306, -1.2046858745450777],
  [13.084197830338127, 0.7245332944755773],
  [12.970333306033268, 2.7167375785475087],
  [12.255504042644162, 4.566049756443988],
  [11.017721584219515, 6.14833158675475],
  [9.410584046024894, 7.322738863862071],
  [7.55992728330574, 8.055665387547549],
  [5.587554257292339, 8.319744150078805],
  [3.592206927318159, 8.11491270104699],
  [1.7187215483971556, 7.441385351142856],
  [0.08055005170780305, 6.320185348904658],
  [-1.2091294565014152, 4.794034985936207],
  [-2.002946366291468, 2.9587237066393186],
  [-14.202658698599691, 5.019429517424612],
  [-13.936847531776806, 6.998038863575971],
  [-13.396467554073695, 8.920274252331808],
  [-12.623233276348458, 10.750229305661207],
  [-11.634671155910866, 12.490588449872064],
  [-10.454204268794427, 14.107875064647715],
  [-9.100595818500864, 15.592814478314438],
  [-7.6171813258937675, 16.91101116660883],
  [-5.992164994221099, 18.07785456601431],
  [-4.261641884785064, 19.072328857815762],
  [-2.433220272999165, 19.89532435838038],
  [-0.5418022928050732, 20.533733205235535],
  [1.408325022716184, 20.990479969418573],
  [3.391351656872871, 21.261909111401962],
  [5.389055394079634, 21.350712178652145],
  [7.3864394488521725, 21.2567688467866],
  [9.369071056205883, 20.978356685838605],
  [11.302159804362901, 20.51754521695426],
  [13.193577784556993, 19.870013689435098],
  [15.021999396342864, 19.038826803601353],
  [16.7525225057789, 18.039768628514366],
  [18.377538837451567, 16.869159246719448],
  [19.86095333005872, 15.546316532528976],
  [21.207915700186135, 14.063225516936711],
  [22.384360845346094, 12.450254606044837],
  [23.37481792714081, 10.70739505413826],
  [24.15302451829993, 8.864045825413484],
  [24.71082171537367, 6.940154904759481],
  [25.03384346868475, 4.972423457539662],
  [25.112598982829667, 2.978390747345088],
  [24.952176619548396, 0.994905346668304],
  [24.55505326749764, -0.9673068719738467],
  [23.92746188547099, -2.8649758112067616],
  [23.07797452451669, -4.674997058474446],
  [22.020244378108572, -6.387205501162498],
  [20.79664474393806, -7.945355692469434],
  [19.38930583726247, -9.375972319432492],
  [17.851852633554557, -10.649937349402308],
  [16.26315147348876, -11.870634285949961],
  [14.67722833206139, -13.089196699702143],
  [13.102069147426704, -14.299488502585234],
  [11.50778920159874, -15.524471963786482],
  [9.920115514781429, -16.74437942936362],
  [8.340733914572837, -17.95791557415663],
  [6.751907279302458, -19.178708921031046],
  [5.170983987052097, -20.393429642760168],
  [3.5775378885977887, -21.61777240767418],
  [1.9985901910179393, -22.830975158357035],
  [0.400845481891281, -24.059016712748416],
  [-1.4473847292474318, -24.696677481495726],
  [-3.406038100581526, -24.349980045163022],
  [-4.845280030231805, -23.020097046458147],
  [-4.660298417072596, -21.11962970217411],
  [-3.1822517961373933, -19.81436874037331],
  [-1.6305758278182054, -18.552450936638763],
  [-0.07594178601337376, -17.288127446618887],
  [1.474718508113284, -16.027035651260064],
  [3.0287113924213998, -14.763233589732124],
  [1.2727669413649778, -14.676289900966992],
  [-0.7347091360500997, -14.674148593151017],
  [-2.7343634047795717, -14.672015628597762],
  [-4.736229374866809, -14.669880304896253],
  [-6.7356488926819225, -14.667747590743943],
  [-8.74275448997679, -14.665606678106826],
  [-10.732082322101917, -14.663484728419292],
  [-12.737773850422258, -14.661345324122351],
  [-14.732088244382197, -14.659218055435474],
  [-16.741750322144327, -14.657074415885859],
  [-18.741559095542726, -14.65494128652756],
  [-20.71644851491962, -14.451406181895209],
  [-22.438648145656913, -13.468801354014317],
  [-23.419744389515273, -11.774325700365978],
  [-22.89961297939331, -9.917791831457066],
  [-21.146973707657168, -9.046758455001793],
  [-19.15052366804693, -8.99999403731249],
  [-17.154887059595268, -9.003845265855148],
  [-15.160283344130846, -9.0076945010955],
  [-13.146988030414889, -9.011579807841258],
  [-11.145549698810868, -9.015442232691669],
  [-9.174607010822598, -9.007967577540342],
  [-10.760575028400751, -7.795168505274717],
  [-12.347321244221035, -6.581774340235654],
  [-13.929836486823717, -5.371615625304173],
  [-15.516636137276748, -4.158180598487149],
  [-17.105407687168423, -2.9432376485700047],
  [-18.702803971510235, -1.7216993134850895],
  [-20.28505643446357, -0.5117415476972269],
  [-21.876524808894686, 0.7052636798088656],
  [-23.466781124364445, 1.92134203869756],
  [-25.057700276266672, 3.1379272725051237],
  [-26.63699862573654, 4.345626010335025],
  [-28.23703861821801, 5.569186004585561],
  [-29.813996476154614, 6.779351575291685],
  [-31.077298817258196, 8.313163278616003],
  [-31.58853560171633, 10.242009411371328],
  [-30.974890149231868, 12.089691822222449],
  [-29.31611574731383, 13.158054611421164],
  [-27.342687272053098, 13.168220258152985],
  [-25.52354557409498, 12.359460436566735],
  [-23.957516180496526, 11.099097184098298],
  [-22.415455616038173, 9.834885369992776],
  [-20.864487444382036, 8.563370922959393],
  [-19.329027509648256, 7.3045704359253705],
  [-17.78396052024874, 6.037893895066304],
  [-16.22801289461168, 4.76229719296748],
  [-14.684605454426134, 3.4969811834459392],
  [-14.21094622514758, 4.2306327261095475],
  [13.511307059083236, 9.934786927214816],
  [11.869471503276458, 11.079663152134913],
  [10.069000960368754, 11.938005628026076],
  [8.148105244789377, 12.501371592394037],
  [6.163081718463559, 12.761114420331069],
  [4.169299980033287, 12.723883906519973],
  [2.2044440088459396, 12.392122159398127],
  [0.2965579805561731, 11.753038937962572],
  [-1.4614390554240515, 10.82647829953487],
  [-3.0505056793204517, 9.614110222495128],
  [-4.406407364826521, 8.152439221776092],
  [-5.479166764240603, 6.470623425877648],
  [-6.212059147816035, 4.607584981358627],
  [-6.5568247837832985, 2.641496643460357],
  [-6.502787552814851, 0.64018610898313],
  [-6.0596649942210945, -1.3012079339856086],
  [-5.23538001630817, -3.130564098917773],
  [-4.08522254274402, -4.765030947291223],
  [-2.673931003551843, -6.1636043363445765],
  [-1.0356922706625369, -7.306038458832518],
  [0.7624378576465745, -8.168834086024162],
  [2.6860123874583053, -8.740884332098972],
  [4.66523229982343, -9.007448030077796],
  [6.668562621135351, -8.973386717402377],
  [8.633852106142854, -8.641303717390599],
  [10.532973832149139, -8.006089483343942],
  [12.297028856981655, -7.0813123981664035],
  [13.89420675184212, -5.87215216025055],
  [15.2476627125927, -4.420641391002562],
  [16.33054506208387, -2.728636560999803],
  [17.062227733690435, -0.8769353830451223],
  [17.410851420421267, 1.0791555685167964],
  [17.36959686710324, 3.0836797470217903],
  [16.930800093669546, 5.032930249608114],
  [16.12062432004896, 6.851208571827954],
  [14.977820983905502, 8.487027135527626],
];
*/

function getActualFourierTransformNumber(
  lengthOfSeries,
  fourierSeriesConstantsIndex
) {
  return -(lengthOfSeries - 1) / 2 + fourierSeriesConstantsIndex;
}

function calculateFourierSeriesConstants() {
  fourierSeriesConstants = [];
  for (var i = 0; i < numberOfVectors; i++) {
    var actualFourierTransformNumber = getActualFourierTransformNumber(
      numberOfVectors,
      i
    );
    sumX = 0;
    sumY = 0;
    for (inputPointIndex in inputPoints) {
      var calculatedComplex = math.multiply(
        math.complex(
          inputPoints[inputPointIndex][0] * inputScale,
          inputPoints[inputPointIndex][1] * inputScale
        ),
        math.pow(
          Math.E,
          math.multiply(
            2,
            math.complex(0, 1),
            -actualFourierTransformNumber,
            inputPointIndex / (inputPoints.length - 1),
            Math.PI
          )
        )
      );
      sumX += calculatedComplex.re;
      sumY += calculatedComplex.im;
    }
    fourierSeriesConstants.push(
      math.complex(sumX / inputPoints.length, sumY / inputPoints.length)
    );
  }
}

function startDrawing() {
  var t = new Date().getTime(); // Time variable
  (function animloop() {
    requestAnimationFrame(animloop);
    // Get mouse position
    if (mouseDown) {
      inputPoints.push([
        (mouseX - width / 2) / canvasScale / inputScale,
        (mouseY - height / 2) / canvasScale / inputScale,
      ]);
    }
    ctx.clearRect(0, 0, width, height);
    // Draw axes
    ctx.strokeStyle = "#ffffff";
    ctx.beginPath();
    ctx.moveTo(0, height / 2);
    ctx.lineTo(width, height / 2);
    ctx.stroke();
    ctx.beginPath();
    ctx.moveTo(width / 2, 0);
    ctx.lineTo(width / 2, height);
    ctx.stroke();
    // Draw fourier vectors
    var localT = (new Date().getTime() - t) * timestep;
    var fourierSeriesConstantsIndex = 0;
    var previousX = width / 2;
    var previousY = height / 2;
    for (i in fourierSeriesConstants) {
      ctx.strokeStyle = "#ff0000";
      var actualFourierTransformNumber = getActualFourierTransformNumber(
        numberOfVectors,
        fourierSeriesConstantsIndex
      );
      ctx.beginPath();
      ctx.moveTo(previousX, previousY);
      var fourierVector = math.multiply(
        fourierSeriesConstants[fourierSeriesConstantsIndex],
        math.pow(
          Math.E,
          math.multiply(
            2,
            math.complex(0, 1),
            actualFourierTransformNumber,
            localT,
            Math.PI
          )
        )
      );
      var previousX = previousX + fourierVector.re * canvasScale;
      var previousY = previousY + fourierVector.im * canvasScale;
      ctx.lineTo(previousX, previousY);
      if (vectorVisibility) {
        ctx.stroke(); // Render the path
      }
      if (circleVisibility) {
        ctx.strokeStyle = "#00ff00";
        ctx.beginPath();
        ctx.arc(
          previousX,
          previousY,
          math.abs(fourierVector) * canvasScale,
          0,
          2 * Math.PI
        );
        ctx.stroke();
      }
      fourierSeriesConstantsIndex++;
    }
    // Historical points
    historicalPoints.push([previousX, previousY]);
    while (historicalPoints.length > historicalPointsLimit) {
      historicalPoints.shift();
    }
    var oldPointX = historicalPoints[0][0];
    var oldPointY = historicalPoints[0][1];
    for (pointIndex in historicalPoints) {
      ctx.strokeStyle = `rgb(0,0,${Math.min(
        (pointIndex / historicalPointsLimit) * 2 * 255,
        255
      )})`;
      ctx.beginPath();
      ctx.moveTo(oldPointX, oldPointY);
      ctx.lineTo(
        historicalPoints[pointIndex][0],
        historicalPoints[pointIndex][1]
      );
      oldPointX = historicalPoints[pointIndex][0];
      oldPointY = historicalPoints[pointIndex][1];
      ctx.stroke();
    }
    // Input points
    if (drawingVisibility) {
      var oldPointX = width / 2 + inputPoints[0][0] * canvasScale * inputScale;
      var oldPointY = height / 2 + inputPoints[0][1] * canvasScale * inputScale;
      ctx.strokeStyle = "#ffffff";
      for (pointIndex in inputPoints) {
        ctx.beginPath();
        ctx.moveTo(oldPointX, oldPointY);
        ctx.lineTo(
          width / 2 + inputPoints[pointIndex][0] * canvasScale * inputScale,
          height / 2 + inputPoints[pointIndex][1] * canvasScale * inputScale
        );
        oldPointX =
          width / 2 + inputPoints[pointIndex][0] * canvasScale * inputScale;
        oldPointY =
          height / 2 + inputPoints[pointIndex][1] * canvasScale * inputScale;
        ctx.stroke();
      }
    }
  })();
}

function updateInfoDisplay() {
  document.getElementById(
    "info-display"
  ).innerHTML = `Point history length: ${historicalPointsLimit}; Drawing frequency: ${Math.round(
    1 / timestep / 1000
  )}s; Number of vectors: ${numberOfVectors}`;
}

canvas.width = window.innerWidth;
canvas.height = window.innerHeight;
width = canvas.width;
height = canvas.height;
oldWidth = window.innerWidth;
oldHeight = window.innerHeight;

var mouseDown = 0;
document.getElementsByTagName("canvas")[0].onmousedown = function () {
  ++mouseDown;
  inputPoints = [];
};
document.getElementsByTagName("canvas")[0].onmouseup = function () {
  --mouseDown;
  calculateFourierSeriesConstants();
};
var mouseX = 0;
var mouseY = 0;
document.body.onmousemove = function (e) {
  mouseX = e.clientX;
  mouseY = e.clientY;
};
document.getElementById("vector-count-slider").oninput = function () {
  numberOfVectors = this.value * 2 + 1;
  updateInfoDisplay();
  calculateFourierSeriesConstants();
};
document.getElementById("timestep-slider").oninput = function () {
  timestep = 1 / (this.value * 1000);
  updateInfoDisplay();
};
document.getElementById("historical-point-count-slider").oninput = function () {
  historicalPointsLimit = this.value * 30;
  updateInfoDisplay();
};
var vectorVisibility = true;
var circleVisibility = true;
var drawingVisibility = true;
document.getElementById("vector-visiblity-checkbox").oninput = function () {
  vectorVisibility = document.getElementById(
    "vector-visiblity-checkbox"
  ).checked;
};
document.getElementById("circle-visiblity-checkbox").oninput = function () {
  circleVisibility = document.getElementById(
    "circle-visiblity-checkbox"
  ).checked;
};
document.getElementById("drawing-visiblity-checkbox").oninput = function () {
  drawingVisibility = document.getElementById(
    "drawing-visiblity-checkbox"
  ).checked;
};
updateInfoDisplay();
calculateFourierSeriesConstants();
startDrawing();

/*setInterval(function () {
  if (oldWidth == window.innerWidth) {
  } else if (oldHeight == window.innerHeight) {
  } else {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
    width = canvas.width;
    height = canvas.height;
    oldWidth = window.innerWidth;
    oldHeight = window.innerHeight;
  }
}, 1000);
*/
