margin = 64;
elementScale = 60;
effectRange = 0.6;
maxEffect = 1.2;
selectThreshold = 1.12;
elementSpacing = 70;

visibleElements = []

elementTargetScales = {}
elementCurrentScales = {}
elementCoords = {}

elementSymbolList=[]
elementNameList=[]
elementAList=[]
elementECList=[]
elementBlockList=[]
elementGroupBlockList=[]
elementSSList=[]
elementIEList=[]

currentlySelectedElement = 1;

function drawElement(pTElementId, pTElementSymbol, pTElementName, pTElementZ, pTElementA, pTElementElectronicConfiguration, pTElementBlock, pTElementGroupBlock, pTElementStandardState, pTElementIonizationEnergy, pTElementX, pTElementY) {
    visibleElements.push(pTElementId)
    newpTElement = document.createElement("div");
    newpTElement.className = "ptelement";
    newpTElement.id = pTElementId;
    newpTElement.innerHTML = pTElementSymbol;
    newpTElement.innerHTML += `<div class=${"element-name"}>${pTElementName}</div>`;
    //newpTElement.innerHTML+=`<div class=${"element-a-number"}>${pTElementA}</div>`;
    newpTElement.innerHTML += `<div class=${"element-z-number"}>${pTElementZ}</div>`;
    newpTElement.style.left = margin + pTElementX * elementSpacing + "px"
    newpTElement.style.top = margin + pTElementY * elementSpacing + "px"
    elementCurrentScales[pTElementId] = 1;
    elementTargetScales[pTElementId] = 1;
    elementCoords[pTElementId] = [pTElementX, pTElementY];
    document.getElementById("container").appendChild(newpTElement)
    elementSymbolList.push(pTElementSymbol)
    elementNameList.push(pTElementName)
    elementAList.push(pTElementA)
    elementECList.push(pTElementElectronicConfiguration)
    elementBlockList.push(pTElementBlock)
    elementGroupBlockList.push(pTElementGroupBlock)
    elementSSList.push(pTElementStandardState)
    elementIEList.push(pTElementIonizationEnergy)
}

// Generated with python script @ ./generateData.py
drawElement("element-id-1", "H", "Hydrogen", 1, "1.00794(4)", "1s1", "s", "nonmetal", "gas", "1312", 0, 0);
drawElement("element-id-2", "He", "Helium", 2, "4.002602(2)", "1s2", "p", "noble gas", "gas", "2372", 17, 0);
drawElement("element-id-3", "Li", "Lithium", 3, "6.941(2)", "[He] 2s1", "s", "alkali metal", "solid", "520", 0, 1);
drawElement("element-id-4", "Be", "Beryllium", 4, "9.012182(3)", "[He] 2s2", "s", "alkaline earth metal", "solid", "900", 1, 1);
drawElement("element-id-5", "B", "Boron", 5, "10.811(7)", "[He] 2s2 2p1", "p", "metalloid", "solid", "801", 12, 1);
drawElement("element-id-6", "C", "Carbon", 6, "12.0107(8)", "[He] 2s2 2p2", "p", "nonmetal", "solid", "1087", 13, 1);
drawElement("element-id-7", "N", "Nitrogen", 7, "14.0067(2)", "[He] 2s2 2p3", "p", "nonmetal", "gas", "1402", 14, 1);
drawElement("element-id-8", "O", "Oxygen", 8, "15.9994(3)", "[He] 2s2 2p4", "p", "nonmetal", "gas", "1314", 15, 1);
drawElement("element-id-9", "F", "Fluorine", 9, "18.9984032(5)", "[He] 2s2 2p5", "p", "halogen", "gas", "1681", 16, 1);
drawElement("element-id-10", "Ne", "Neon", 10, "20.1797(6)", "[He] 2s2 2p6", "p", "noble gas", "gas", "2081", 17, 1);
drawElement("element-id-11", "Na", "Sodium", 11, "22.98976928(2)", "[Ne] 3s1", "s", "alkali metal", "solid", "496", 0, 2);
drawElement("element-id-12", "Mg", "Magnesium", 12, "24.3050(6)", "[Ne] 3s2", "s", "alkaline earth metal", "solid", "738", 1, 2);
drawElement("element-id-13", "Al", "Aluminum", 13, "26.9815386(8)", "[Ne] 3s2 3p1", "p", "metal", "solid", "578", 12, 2);
drawElement("element-id-14", "Si", "Silicon", 14, "28.0855(3)", "[Ne] 3s2 3p2", "p", "metalloid", "solid", "787", 13, 2);
drawElement("element-id-15", "P", "Phosphorus", 15, "30.973762(2)", "[Ne] 3s2 3p3", "p", "nonmetal", "solid", "1012", 14, 2);
drawElement("element-id-16", "S", "Sulfur", 16, "32.065(5)", "[Ne] 3s2 3p4", "p", "nonmetal", "solid", "1000", 15, 2);
drawElement("element-id-17", "Cl", "Chlorine", 17, "35.453(2)", "[Ne] 3s2 3p5", "p", "halogen", "gas", "1251", 16, 2);
drawElement("element-id-18", "Ar", "Argon", 18, "39.948(1)", "[Ne] 3s2 3p6", "p", "noble gas", "gas", "1521", 17, 2);
drawElement("element-id-19", "K", "Potassium", 19, "39.0983(1)", "[Ar] 4s1", "s", "alkali metal", "solid", "419", 0, 3);
drawElement("element-id-20", "Ca", "Calcium", 20, "40.078(4)", "[Ar] 4s2", "s", "alkaline earth metal", "solid", "590", 1, 3);
drawElement("element-id-21", "Sc", "Scandium", 21, "44.955912(6)", "[Ar] 3d1 4s2", "d", "transition metal", "solid", "633", 2, 3);
drawElement("element-id-22", "Ti", "Titanium", 22, "47.867(1)", "[Ar] 3d2 4s2", "d", "transition metal", "solid", "659", 3, 3);
drawElement("element-id-23", "V", "Vanadium", 23, "50.9415(1)", "[Ar] 3d3 4s2", "d", "transition metal", "solid", "651", 4, 3);
drawElement("element-id-24", "Cr", "Chromium", 24, "51.9961(6)", "[Ar] 3d5 4s1", "d", "transition metal", "solid", "653", 5, 3);
drawElement("element-id-25", "Mn", "Manganese", 25, "54.938045(5)", "[Ar] 3d5 4s2", "d", "transition metal", "solid", "717", 6, 3);
drawElement("element-id-26", "Fe", "Iron", 26, "55.845(2)", "[Ar] 3d6 4s2", "d", "transition metal", "solid", "763", 7, 3);
drawElement("element-id-27", "Co", "Cobalt", 27, "58.933195(5)", "[Ar] 3d7 4s2", "d", "transition metal", "solid", "760", 8, 3);
drawElement("element-id-28", "Ni", "Nickel", 28, "58.6934(4)", "[Ar] 3d8 4s2", "d", "transition metal", "solid", "737", 9, 3);
drawElement("element-id-29", "Cu", "Copper", 29, "63.546(3)", "[Ar] 3d10 4s1", "d", "transition metal", "solid", "746", 10, 3);
drawElement("element-id-30", "Zn", "Zinc", 30, "65.38(2)", "[Ar] 3d10 4s2", "d", "transition metal", "solid", "906", 11, 3);
drawElement("element-id-31", "Ga", "Gallium", 31, "69.723(1)", "[Ar] 3d10 4s2 4p1", "p", "metal", "solid", "579", 12, 3);
drawElement("element-id-32", "Ge", "Germanium", 32, "72.64(1)", "[Ar] 3d10 4s2 4p2", "p", "metalloid", "solid", "762", 13, 3);
drawElement("element-id-33", "As", "Arsenic", 33, "74.92160(2)", "[Ar] 3d10 4s2 4p3", "p", "metalloid", "solid", "947", 14, 3);
drawElement("element-id-34", "Se", "Selenium", 34, "78.96(3)", "[Ar] 3d10 4s2 4p4", "p", "nonmetal", "solid", "941", 15, 3);
drawElement("element-id-35", "Br", "Bromine", 35, "79.904(1)", "[Ar] 3d10 4s2 4p5", "p", "halogen", "liquid", "1140", 16, 3);
drawElement("element-id-36", "Kr", "Krypton", 36, "83.798(2)", "[Ar] 3d10 4s2 4p6", "p", "noble gas", "gas", "1351", 17, 3);
drawElement("element-id-37", "Rb", "Rubidium", 37, "85.4678(3)", "[Kr] 5s1", "s", "alkali metal", "solid", "403", 0, 4);
drawElement("element-id-38", "Sr", "Strontium", 38, "87.62(1)", "[Kr] 5s2", "s", "alkaline earth metal", "solid", "550", 1, 4);
drawElement("element-id-39", "Y", "Yttrium", 39, "88.90585(2)", "[Kr] 4d1 5s2", "d", "transition metal", "solid", "600", 2, 4);
drawElement("element-id-40", "Zr", "Zirconium", 40, "91.224(2)", "[Kr] 4d2 5s2", "d", "transition metal", "solid", "640", 3, 4);
drawElement("element-id-41", "Nb", "Niobium", 41, "92.90638(2)", "[Kr] 4d4 5s1", "d", "transition metal", "solid", "652", 4, 4);
drawElement("element-id-42", "Mo", "Molybdenum", 42, "95.96(2)", "[Kr] 4d5 5s1", "d", "transition metal", "solid", "684", 5, 4);
drawElement("element-id-43", "Tc", "Technetium", 43, "[98]", "[Kr] 4d5 5s2", "d", "transition metal", "solid", "702", 6, 4);
drawElement("element-id-44", "Ru", "Ruthenium", 44, "101.07(2)", "[Kr] 4d7 5s1", "d", "transition metal", "solid", "710", 7, 4);
drawElement("element-id-45", "Rh", "Rhodium", 45, "102.90550(2)", "[Kr] 4d8 5s1", "d", "transition metal", "solid", "720", 8, 4);
drawElement("element-id-46", "Pd", "Palladium", 46, "106.42(1)", "[Kr] 4d10", "d", "transition metal", "solid", "804", 9, 4);
drawElement("element-id-47", "Ag", "Silver", 47, "107.8682(2)", "[Kr] 4d10 5s1", "d", "transition metal", "solid", "731", 10, 4);
drawElement("element-id-48", "Cd", "Cadmium", 48, "112.411(8)", "[Kr] 4d10 5s2", "d", "transition metal", "solid", "868", 11, 4);
drawElement("element-id-49", "In", "Indium", 49, "114.818(3)", "[Kr] 4d10 5s2 5p1", "p", "metal", "solid", "558", 12, 4);
drawElement("element-id-50", "Sn", "Tin", 50, "118.710(7)", "[Kr] 4d10 5s2 5p2", "p", "metal", "solid", "709", 13, 4);
drawElement("element-id-51", "Sb", "Antimony", 51, "121.760(1)", "[Kr] 4d10 5s2 5p3", "p", "metalloid", "solid", "834", 14, 4);
drawElement("element-id-52", "Te", "Tellurium", 52, "127.60(3)", "[Kr] 4d10 5s2 5p4", "p", "metalloid", "solid", "869", 15, 4);
drawElement("element-id-53", "I", "Iodine", 53, "126.90447(3)", "[Kr] 4d10 5s2 5p5", "p", "halogen", "solid", "1008", 16, 4);
drawElement("element-id-54", "Xe", "Xenon", 54, "131.293(6)", "[Kr] 4d10 5s2 5p6", "p", "noble gas", "gas", "1170", 17, 4);
drawElement("element-id-55", "Cs", "Cesium", 55, "132.9054519(2)", "[Xe] 6s1", "s", "alkali metal", "solid", "376", 0, 5);
drawElement("element-id-56", "Ba", "Barium", 56, "137.327(7)", "[Xe] 6s2", "s", "alkaline earth metal", "solid", "503", 1, 5);
drawElement("element-id-57", "La", "Lanthanum", 57, "138.90547(7)", "[Xe] 5d1 6s2", "f", "lanthanoid", "solid", "538", 3, 8);
drawElement("element-id-58", "Ce", "Cerium", 58, "140.116(1)", "[Xe] 4f1 5d1 6s2", "f", "lanthanoid", "solid", "534", 4, 8);
drawElement("element-id-59", "Pr", "Praseodymium", 59, "140.90765(2)", "[Xe] 4f3 6s2", "f", "lanthanoid", "solid", "527", 5, 8);
drawElement("element-id-60", "Nd", "Neodymium", 60, "144.242(3)", "[Xe] 4f4 6s2", "f", "lanthanoid", "solid", "533", 6, 8);
drawElement("element-id-61", "Pm", "Promethium", 61, "[145]", "[Xe] 4f5 6s2", "f", "lanthanoid", "solid", "540", 7, 8);
drawElement("element-id-62", "Sm", "Samarium", 62, "150.36(2)", "[Xe] 4f6 6s2", "f", "lanthanoid", "solid", "545", 8, 8);
drawElement("element-id-63", "Eu", "Europium", 63, "151.964(1)", "[Xe] 4f7 6s2", "f", "lanthanoid", "solid", "547", 9, 8);
drawElement("element-id-64", "Gd", "Gadolinium", 64, "157.25(3)", "[Xe] 4f7 5d1 6s2", "f", "lanthanoid", "solid", "593", 10, 8);
drawElement("element-id-65", "Tb", "Terbium", 65, "158.92535(2)", "[Xe] 4f9 6s2", "f", "lanthanoid", "solid", "566", 11, 8);
drawElement("element-id-66", "Dy", "Dysprosium", 66, "162.500(1)", "[Xe] 4f10 6s2", "f", "lanthanoid", "solid", "573", 12, 8);
drawElement("element-id-67", "Ho", "Holmium", 67, "164.93032(2)", "[Xe] 4f11 6s2", "f", "lanthanoid", "solid", "581", 13, 8);
drawElement("element-id-68", "Er", "Erbium", 68, "167.259(3)", "[Xe] 4f12 6s2", "f", "lanthanoid", "solid", "589", 14, 8);
drawElement("element-id-69", "Tm", "Thulium", 69, "168.93421(2)", "[Xe] 4f13 6s2", "f", "lanthanoid", "solid", "597", 15, 8);
drawElement("element-id-70", "Yb", "Ytterbium", 70, "173.054(5)", "[Xe] 4f14 6s2", "f", "lanthanoid", "solid", "603", 16, 8);
drawElement("element-id-71", "Lu", "Lutetium", 71, "174.9668(1)", "[Xe] 4f14 5d1 6s2", "d", "lanthanoid", "solid", "524", 17, 8);
drawElement("element-id-72", "Hf", "Hafnium", 72, "178.49(2)", "[Xe] 4f14 5d2 6s2", "d", "transition metal", "solid", "659", 3, 5);
drawElement("element-id-73", "Ta", "Tantalum", 73, "180.94788(2)", "[Xe] 4f14 5d3 6s2", "d", "transition metal", "solid", "761", 4, 5);
drawElement("element-id-74", "W", "Tungsten", 74, "183.84(1)", "[Xe] 4f14 5d4 6s2", "d", "transition metal", "solid", "770", 5, 5);
drawElement("element-id-75", "Re", "Rhenium", 75, "186.207(1)", "[Xe] 4f14 5d5 6s2", "d", "transition metal", "solid", "760", 6, 5);
drawElement("element-id-76", "Os", "Osmium", 76, "190.23(3)", "[Xe] 4f14 5d6 6s2", "d", "transition metal", "solid", "840", 7, 5);
drawElement("element-id-77", "Ir", "Iridium", 77, "192.217(3)", "[Xe] 4f14 5d7 6s2", "d", "transition metal", "solid", "880", 8, 5);
drawElement("element-id-78", "Pt", "Platinum", 78, "195.084(9)", "[Xe] 4f14 5d9 6s1", "d", "transition metal", "solid", "870", 9, 5);
drawElement("element-id-79", "Au", "Gold", 79, "196.966569(4)", "[Xe] 4f14 5d10 6s1", "d", "transition metal", "solid", "890", 10, 5);
drawElement("element-id-80", "Hg", "Mercury", 80, "200.59(2)", "[Xe] 4f14 5d10 6s2", "d", "transition metal", "liquid", "1007", 11, 5);
drawElement("element-id-81", "Tl", "Thallium", 81, "204.3833(2)", "[Xe] 4f14 5d10 6s2 6p1", "p", "metal", "solid", "589", 12, 5);
drawElement("element-id-82", "Pb", "Lead", 82, "207.2(1)", "[Xe] 4f14 5d10 6s2 6p2", "p", "metal", "solid", "716", 13, 5);
drawElement("element-id-83", "Bi", "Bismuth", 83, "208.98040(1)", "[Xe] 4f14 5d10 6s2 6p3", "p", "metal", "solid", "703", 14, 5);
drawElement("element-id-84", "Po", "Polonium", 84, "[209]", "[Xe] 4f14 5d10 6s2 6p4", "p", "metalloid", "solid", "812", 15, 5);
drawElement("element-id-85", "At", "Astatine", 85, "[210]", "[Xe] 4f14 5d10 6s2 6p5", "p", "halogen", "solid", "920", 16, 5);
drawElement("element-id-86", "Rn", "Radon", 86, "[222]", "[Xe] 4f14 5d10 6s2 6p6", "p", "noble gas", "gas", "1037", 17, 5);
drawElement("element-id-87", "Fr", "Francium", 87, "[223]", "[Rn] 7s1", "s", "alkali metal", "solid", "380", 0, 6);
drawElement("element-id-88", "Ra", "Radium", 88, "[226]", "[Rn] 7s2", "s", "alkaline earth metal", "solid", "509", 1, 6);
drawElement("element-id-89", "Ac", "Actinium", 89, "[227]", "[Rn] 6d1 7s2", "f", "actinoid", "solid", "499", 3, 9);
drawElement("element-id-90", "Th", "Thorium", 90, "232.03806(2)", "[Rn] 6d2 7s2", "f", "actinoid", "solid", "587", 4, 9);
drawElement("element-id-91", "Pa", "Protactinium", 91, "231.03588(2)", "[Rn] 5f2 6d1 7s2", "f", "actinoid", "solid", "568", 5, 9);
drawElement("element-id-92", "U", "Uranium", 92, "238.02891(3)", "[Rn] 5f3 6d1 7s2", "f", "actinoid", "solid", "598", 6, 9);
drawElement("element-id-93", "Np", "Neptunium", 93, "[237]", "[Rn] 5f4 6d1 7s2", "f", "actinoid", "solid", "605", 7, 9);
drawElement("element-id-94", "Pu", "Plutonium", 94, "[244]", "[Rn] 5f6 7s2", "f", "actinoid", "solid", "585", 8, 9);
drawElement("element-id-95", "Am", "Americium", 95, "[243]", "[Rn] 5f7 7s2", "f", "actinoid", "solid", "578", 9, 9);
drawElement("element-id-96", "Cm", "Curium", 96, "[247]", "[Rn] 5f7 6d1 7s2", "f", "actinoid", "solid", "581", 10, 9);
drawElement("element-id-97", "Bk", "Berkelium", 97, "[247]", "[Rn] 5f9 7s2", "f", "actinoid", "solid", "601", 11, 9);
drawElement("element-id-98", "Cf", "Californium", 98, "[251]", "[Rn] 5f10 7s2", "f", "actinoid", "solid", "608", 12, 9);
drawElement("element-id-99", "Es", "Einsteinium", 99, "[252]", "[Rn] 5f11 7s2", "f", "actinoid", "solid", "619", 13, 9);
drawElement("element-id-100", "Fm", "Fermium", 100, "[257]", "[Rn] 5f12 7s2", "f", "actinoid", "unknown", "627", 14, 9);
drawElement("element-id-101", "Md", "Mendelevium", 101, "[258]", "[Rn] 5f13 7s2", "f", "actinoid", "unknown", "635", 15, 9);
drawElement("element-id-102", "No", "Nobelium", 102, "[259]", "[Rn] 5f14 7s2", "f", "actinoid", "unknown", "642", 16, 9);
drawElement("element-id-103", "Lr", "Lawrencium", 103, "[262]", "[Rn] 5f14 7s2 7p1", "d", "transition metal", "unknown", "unknown", 17, 9);
drawElement("element-id-104", "Rf", "Rutherfordium", 104, "[267]", "[Rn] 5f14 6d2 7s2", "d", "transition metal", "unknown", "unknown", 3, 6);
drawElement("element-id-105", "Db", "Dubnium", 105, "[268]", "[Rn] 5f14 6d3 7s2", "d", "transition metal", "unknown", "unknown", 4, 6);
drawElement("element-id-106", "Sg", "Seaborgium", 106, "[271]", "[Rn] 5f14 6d4 7s2", "d", "transition metal", "unknown", "unknown", 5, 6);
drawElement("element-id-107", "Bh", "Bohrium", 107, "[272]", "[Rn] 5f14 6d5 7s2", "d", "transition metal", "unknown", "unknown", 6, 6);
drawElement("element-id-108", "Hs", "Hassium", 108, "[270]", "[Rn] 5f14 6d6 7s2", "d", "transition metal", "unknown", "unknown", 7, 6);
drawElement("element-id-109", "Mt", "Meitnerium", 109, "[276]", "[Rn] 5f14 6d7 7s2", "d", "transition metal", "unknown", "unknown", 8, 6);
drawElement("element-id-110", "Ds", "Darmstadtium", 110, "[281]", "[Rn] 5f14 6d9 7s1", "d", "transition metal", "unknown", "unknown", 9, 6);
drawElement("element-id-111", "Rg", "Roentgenium", 111, "[280]", "[Rn] 5f14 6d10 7s1", "d", "transition metal", "unknown", "unknown", 10, 6);
drawElement("element-id-112", "Cn", "Copernicium", 112, "[285]", "[Rn] 5f14 6d10 7s2", "d", "transition metal", "unknown", "unknown", 11, 6);
drawElement("element-id-113", "Nh", "Nihonium", 113, "[284]", "[Rn] 5f14 6d10 7s2 7p1", "p", "post-transition metal", "unknown", "unknown", 12, 6);
drawElement("element-id-114", "Fl", "Flerovium", 114, "[289]", "[Rn] 5f14 6d10 7s2 7p2", "p", "post-transition metal", "unknown", "unknown", 13, 6);
drawElement("element-id-115", "Mc", "Moscovium", 115, "[288]", "[Rn] 5f14 6d10 7s2 7p3", "p", "post-transition metal", "unknown", "unknown", 14, 6);
drawElement("element-id-116", "Lv", "Livermorium", 116, "[293]", "[Rn] 5f14 6d10 7s2 7p4", "p", "post-transition metal", "unknown", "unknown", 15, 6);
drawElement("element-id-117", "Ts", "Tennessine", 117, "[294]", "[Rn] 5f14 6d10 7s2 7p5", "p", "post-transition metal", "unknown", "unknown", 16, 6);
drawElement("element-id-118", "Og", "Oganesson", 118, "[294]", "[Rn] 5f14 6d10 7s2 7p6", "p", "noble gas", "unknown", "unknown", 17, 6);
// End generation


function updateElementInfo(){
  document.getElementById("info-container").innerHTML="";
  document.getElementById("info-container").innerHTML+=
  `<div id="info-element-symbol" class="info-element">Symbol: ${elementSymbolList[currentlySelectedElement-1]}</div>
  <div id="info-element-name" class="info-element">Name: ${elementNameList[currentlySelectedElement-1]}</div>
  <div id="info-element-Z" class="info-element">Z: ${currentlySelectedElement}</div>
  <div id="info-element-A" class="info-element">A: ${elementAList[currentlySelectedElement-1]}</div>
  <div id="info-element-electronic-configuration" class="info-element">Electronic Configuration: ${elementECList[currentlySelectedElement-1]}</div>
  <div id="info-element-block" class="info-element">Block: ${elementBlockList[currentlySelectedElement-1]}</div>
  <div id="info-element-group-block" class="info-element">Group Block: ${elementGroupBlockList[currentlySelectedElement-1]}</div>
  <div id="info-element-standard-state" class="info-element">Standard State: ${elementSSList[currentlySelectedElement-1]}</div>
  <div id="info-element-ionization-energy" class="info-element">Ionization Energy: ${elementIEList[currentlySelectedElement-1]}kJ⋅mol−1</div>`
  ;
}

function updatePIDFrame() {
    biggestScale = 0;
    biggestElement = 1;
    for (pTElementVisible in visibleElements) {
        PTEVelementID = visibleElements[pTElementVisible];
        elementCurrentScales[PTEVelementID] -= (elementCurrentScales[PTEVelementID] - elementTargetScales[PTEVelementID]) / 10
        PTEVelementCoords = elementCoords[PTEVelementID]
        document.getElementById(PTEVelementID).style.left = margin + PTEVelementCoords[0] * elementSpacing + (elementScale - elementScale * elementCurrentScales[PTEVelementID]) / 2 + "px";
        document.getElementById(PTEVelementID).style.top = margin + PTEVelementCoords[1] * elementSpacing + (elementScale - elementScale * elementCurrentScales[PTEVelementID]) / 2 + "px";
        document.getElementById(PTEVelementID).style.width = elementScale * elementCurrentScales[PTEVelementID] + "px"
        document.getElementById(PTEVelementID).style.height = elementScale * elementCurrentScales[PTEVelementID] + "px"
        if (biggestScale < elementCurrentScales[PTEVelementID]){
            biggestScale=elementCurrentScales[PTEVelementID];
            biggestElement = parseInt(PTEVelementID.replaceAll("element-id-",""));
        }
        /*if (elementCurrentScales[PTEVelementID]>selectThreshold){
          if (currentlySelectedElement != parseInt(PTEVelementID.replaceAll("element-id-",""))){
            currentlySelectedElement = parseInt(PTEVelementID.replaceAll("element-id-",""));
            console.log(currentlySelectedElement)
            updateElementInfo();
          }
          
        }
        */
    }
    if (currentlySelectedElement != biggestElement){
        document.getElementById("element-id-"+currentlySelectedElement).style.filter="invert(0)";
        document.getElementById("element-id-"+biggestElement).style.filter="invert(1)";
        currentlySelectedElement = biggestElement;
        console.log(currentlySelectedElement)
        updateElementInfo();
    }
    window.requestAnimationFrame(updatePIDFrame);

}

window.requestAnimationFrame(updatePIDFrame);

document.onmousemove = handleMouseMove;

function handleMouseMove(event) {
    var eventDoc, doc, body;

    event = event || window.event; // IE-ism

    // If pageX/Y aren't available and clientX/Y are,
    // calculate pageX/Y - logic taken from jQuery.
    // (This is to support old IE)
    if (event.pageX == null && event.clientX != null) {
        eventDoc = (event.target && event.target.ownerDocument) || document;
        doc = eventDoc.documentElement;
        body = eventDoc.body;

        event.pageX = event.clientX +
            (doc && doc.scrollLeft || body && body.scrollLeft || 0) -
            (doc && doc.clientLeft || body && body.clientLeft || 0);
        event.pageY = event.clientY +
            (doc && doc.scrollTop || body && body.scrollTop || 0) -
            (doc && doc.clientTop || body && body.clientTop || 0);
    }

    // Use event.pageX / event.pageY here
    for (pTElementVisible in visibleElements) {
        PTEVelementID = visibleElements[pTElementVisible];
        refX = parseInt(document.getElementById(PTEVelementID).style.left.replace("px", "")) + elementScale / 2;
        refY = parseInt(document.getElementById(PTEVelementID).style.top.replace("px", "")) + elementScale / 2;
        mouseDistancetoElement = Math.sqrt((refX - event.pageX) ** 2 + (refY - event.pageY) ** 2)
        finalScale = Math.min(1 + 1 / (mouseDistancetoElement ** effectRange), maxEffect);
        elementTargetScales[PTEVelementID] = finalScale;
    }
}