const noiseScale = 4137;
const scale = 160; // 160
var oldWidth = 0;
var oldHeight = 0;
var wiggleScale = 40;
//var timeBeforeRefresh = 1*240;
var thetaSpeed = 0.1;
var zoomSpeed = 1.005;

canvas = document.getElementsByTagName("canvas")[0];
var width = canvas.width;
var height = canvas.height;
var ctx = canvas.getContext("2d");
noise.seed(Math.random());

function startDrawing() {
  (function animloop() {
    requestAnimationFrame(animloop);
    ctx.fillStyle = "hsl(" + Math.random() * 360 + ", 85%, 50%)";
    ctx.font = Math.random() * scale + "px Yusei Magic";
    ctx.fillText(
      listOfLemmas[Math.floor(Math.random() * listOfLemmas.length)],
      Math.random() * width,
      Math.random() * height
    );
    ctx.translate(width / 2, height / 2);
    ctx.rotate((thetaSpeed * Math.PI) / 180);
    ctx.scale(zoomSpeed, zoomSpeed);
    //ctx.transform(noise.simplex2((new Date()-0)/noiseScale,10010), noise.simplex2((new Date()-0)/noiseScale,1010), noise.simplex2((new Date()-0)/noiseScale,10), noise.simplex2((new Date()-0)/noiseScale,100010), noise.simplex2((new Date()-0)/noiseScale,20010), noise.simplex2((new Date()-0)/noiseScale,30010));
    //ctx.transform(noise.simplex2((new Date()-0)/noiseScale,180010), noise.simplex2((new Date()-0)/noiseScale,10810), noise.simplex2((new Date()-0)/noiseScale,810), noise.simplex2((new Date()-0)/noiseScale,1008010), noise.simplex2((new Date()-0)/noiseScale,208010), noise.simplex2((new Date()-0)/noiseScale,380010));
    ctx.translate(-width / 2, -height / 2);
    ctx.drawImage(
      canvas,
      noise.simplex2((new Date() - 0) / noiseScale, 10010) * wiggleScale,
      noise.simplex2((new Date() - 0) / noiseScale, 1080) * wiggleScale
    );
    ctx.resetTransform();
    //if (Math.random()<1/timeBeforeRefresh){
    //ctx.clearRect(0, 0, canvas.width, canvas.height);
    //}
  })();
}

// Get list of lemmas
const url =
  "https://ontake.dev/legacy/v5/daily-kanji/assets/datasets/listoflemmas.txt";
$.ajax({
  url: url,
  success: function (result) {
    listOfLemmas = result.split("\r\n");
    startDrawing();
  },
});

setInterval(function () {
  if (oldWidth == window.innerWidth) {
  } else if (oldHeight == window.innerHeight) {
  } else {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
    width = canvas.width;
    height = canvas.height;
    oldWidth = window.innerWidth;
    oldHeight = window.innerHeight;
  }
}, 1000);
