var speedOfSolve = 500;

var sudokuBoard = generateEmptyBoard();

function generateEmptyBoard() {
  return [
    [[], [], [], [], [], [], [], [], []],
    [[], [], [], [], [], [], [], [], []],
    [[], [], [], [], [], [], [], [], []],
    [[], [], [], [], [], [], [], [], []],
    [[], [], [], [], [], [], [], [], []],
    [[], [], [], [], [], [], [], [], []],
    [[], [], [], [], [], [], [], [], []],
    [[], [], [], [], [], [], [], [], []],
    [[], [], [], [], [], [], [], [], []],
  ];
}

function getCoordsOfBoxesInSameSubBox(x, y) {
  let subBoxX = Math.floor(x / 3);
  let subBoxY = Math.floor(y / 3);
  let coords = [];
  for (let subBoxBoxX = 0; subBoxBoxX < 3; subBoxBoxX++) {
    for (let subBoxBoxY = 0; subBoxBoxY < 3; subBoxBoxY++) {
      let globalX = subBoxBoxX + subBoxX * 3;
      let globalY = subBoxBoxY + subBoxY * 3;
      if (!(globalX === x && globalY === y)) {
        coords.push({ x: globalX, y: globalY });
      }
    }
  }
  return coords;
}

function getCoordsOfBoxesInSameXandY(x, y) {
  let coords = [];
  for (let boxX = 0; boxX < 9; boxX++) {
    if (!(boxX === x)) {
      coords.push({ x: boxX, y: y });
    }
  }
  for (let boxY = 0; boxY < 9; boxY++) {
    if (!(boxY === y)) {
      coords.push({ x: x, y: boxY });
    }
  }
  return coords;
}

function getPossibleNumbers(x, y, sudokuBoard) {
  let possibleNumbers = [1, 2, 3, 4, 5, 6, 7, 8, 9];
  let coordsToCheck = getCoordsOfBoxesInSameSubBox(x, y).concat(
    getCoordsOfBoxesInSameXandY(x, y)
  );
  for (let coordIndex in coordsToCheck) {
    let coord = coordsToCheck[coordIndex];
    let boxData = sudokuBoard[coord.x][coord.y];
    if (boxData.length === 1) {
      var index = possibleNumbers.indexOf(boxData[0]);
      if (index !== -1) {
        possibleNumbers.splice(index, 1);
      }
    }
  }
  return possibleNumbers;
}

function iterativelySolveSudokuBoard(sudokuBoard) {
  let newSudokuBoard = sudokuBoard;
  for (let x in sudokuBoard) {
    let sudokuBoardRow = sudokuBoard[x];
    for (let y in sudokuBoard) {
      let sudokuBox = sudokuBoardRow[y];
      if (!(sudokuBox.length === 1)) {
        newSudokuBoard[x][y] = getPossibleNumbers(x, y, sudokuBoard);
      }
    }
  }
  return newSudokuBoard;
}

function initDisplay() {
  let sudokuBoardElement = document.getElementById("sudoku-board");
  sudokuBoardElement.innerHTML = "";
  for (let boxX = 0; boxX < 9; boxX++) {
    let sudokuBoardRow = document.createElement("div");
    sudokuBoardRow.className = "sudoku-board-row";
    for (let boxY = 0; boxY < 9; boxY++) {
      let sudokuBoardBox = document.createElement("div");
      sudokuBoardBox.className = "sudoku-board-box";
      sudokuBoardBox.id = "sudoku-board-box-" + boxX + "-" + boxY;
      sudokuBoardBox.innerHTML = `<input type="text" class="sudoku-board-box-input" id="${
        "sudoku-board-box-input-" + boxX + "-" + boxY
      }">`;
      sudokuBoardRow.appendChild(sudokuBoardBox);
    }
    sudokuBoardElement.appendChild(sudokuBoardRow);
  }
}

function updateDisplay(sudokuBoard) {
  for (let boxX = 0; boxX < 9; boxX++) {
    for (let boxY = 0; boxY < 9; boxY++) {
      let currentSudokuBoardBox = document.getElementById(
        "sudoku-board-box-" + boxX + "-" + boxY
      );
      let currentBoxData = sudokuBoard[boxX][boxY];
      if (currentBoxData.length === 1) {
        currentSudokuBoardBox.className =
          "sudoku-board-box sudoku-board-box-solved";
        currentSudokuBoardBox.innerHTML = currentBoxData[0];
      } else if (currentBoxData.length === 0) {
        currentSudokuBoardBox.className =
          "sudoku-board-box sudoku-board-box-empty";
      } else {
        currentSudokuBoardBox.className =
          "sudoku-board-box sudoku-board-box-unsolved";
        currentSudokuBoardBox.innerHTML = currentBoxData[0];
        for (let boxDataIndex in currentBoxData.slice(1)) {
          currentSudokuBoardBox.innerHTML +=
            ", " + currentBoxData.slice(1)[boxDataIndex];
        }
      }
    }
  }
}

function runIteration() {
  if (shouldBeSolving) {
    sudokuBoard = iterativelySolveSudokuBoard(sudokuBoard);
    updateDisplay(sudokuBoard);
    let solved = true;
    for (let x in sudokuBoard) {
      let sudokuBoardRow = sudokuBoard[x];
      for (let y in sudokuBoard) {
        let sudokuBox = sudokuBoardRow[y];
        if (!(sudokuBox.length === 1)) {
          solved = false;
        }
      }
    }
    if (!solved) {
      setTimeout(runIteration, speedOfSolve);
    } else {
      shouldBeSolving = false;
    }
  }
}

function loadUserInput() {
  for (let boxX = 0; boxX < 9; boxX++) {
    for (let boxY = 0; boxY < 9; boxY++) {
      let currentSudokuBoardBoxInput = document.getElementById(
        "sudoku-board-box-input-" + boxX + "-" + boxY
      );
      if (currentSudokuBoardBoxInput.value == "") {
        sudokuBoard[boxX][boxY] = [];
      } else {
        sudokuBoard[boxX][boxY] = [parseInt(currentSudokuBoardBoxInput.value)];
      }
    }
  }
}

let shouldBeSolving = false;
function runSolver() {
  shouldBeSolving = true;
  loadUserInput();
  runIteration();
}

function haltSolverAndReset() {
  shouldBeSolving = false;
  sudokuBoard = generateEmptyBoard();
  console.log(sudokuBoard);
  updateDisplay(sudokuBoard);
  setTimeout(initDisplay, 500);
}

initDisplay();
