var sudokuBoard = [
  [[5], [3], [], [], [7], [], [], [], []],
  [[6], [], [], [1], [9], [5], [], [], []],
  [[], [9], [8], [], [], [], [], [6], []],
  [[8], [], [], [], [6], [], [], [], [3]],
  [[4], [], [], [8], [], [3], [], [], [1]],
  [[7], [], [], [], [2], [], [], [], [6]],
  [[], [6], [], [], [], [], [2], [8], []],
  [[], [], [], [4], [1], [9], [], [], [5]],
  [[], [], [], [], [8], [], [], [7], [9]],
];

function getCoordsOfBoxesInSameSubBox(x, y) {
  let subBoxX = Math.floor(x / 3);
  let subBoxY = Math.floor(y / 3);
  let coords = [];
  for (let subBoxBoxX = 0; subBoxBoxX < 3; subBoxBoxX++) {
    for (let subBoxBoxY = 0; subBoxBoxY < 3; subBoxBoxY++) {
      let globalX = subBoxBoxX + subBoxX * 3;
      let globalY = subBoxBoxY + subBoxY * 3;
      if (!(globalX === x && globalY === y)) {
        coords.push({ x: globalX, y: globalY });
      }
    }
  }
  return coords;
}

function getCoordsOfBoxesInSameXandY(x, y) {
  let coords = [];
  for (let boxX = 0; boxX < 9; boxX++) {
    if (!(boxX === x)) {
      coords.push({ x: boxX, y: y });
    }
  }
  for (let boxY = 0; boxY < 9; boxY++) {
    if (!(boxY === y)) {
      coords.push({ x: x, y: boxY });
    }
  }
  return coords;
}

function getPossibleNumbers(x, y, sudokuBoard) {
  let possibleNumbers = [1, 2, 3, 4, 5, 6, 7, 8, 9];
  let coordsToCheck = getCoordsOfBoxesInSameSubBox(x, y).concat(
    getCoordsOfBoxesInSameXandY(x, y)
  );
  for (let coordIndex in coordsToCheck) {
    let coord = coordsToCheck[coordIndex];
    let boxData = sudokuBoard[coord.x][coord.y];
    if (boxData.length === 1) {
      var index = possibleNumbers.indexOf(boxData[0]);
      if (index !== -1) {
        possibleNumbers.splice(index, 1);
      }
    }
  }
  return possibleNumbers;
}

function iterativelySolveSudokuBoard(sudokuBoard) {
  let newSudokuBoard = sudokuBoard;
  for (let x in sudokuBoard) {
    let sudokuBoardRow = sudokuBoard[x];
    for (let y in sudokuBoard) {
      let sudokuBox = sudokuBoardRow[y];
      if (!(sudokuBox.length === 1)) {
        newSudokuBoard[x][y] = getPossibleNumbers(x, y, sudokuBoard);
      }
    }
  }
  return newSudokuBoard;
}

let solved = false;
while (!solved) {
  sudokuBoard = iterativelySolveSudokuBoard(sudokuBoard);
  solved = true;
  for (let x in sudokuBoard) {
    let sudokuBoardRow = sudokuBoard[x];
    for (let y in sudokuBoard) {
      let sudokuBox = sudokuBoardRow[y];
      if (!(sudokuBox.length === 1)) {
        solved = false;
      }
    }
  }
}
console.log(sudokuBoard);
