playingFieldSize = [10, 24]
playingFieldScale = 30
sidebarPadding = 32;
speed = 200;


// System Variables
pieces = ["straight", "l1", "l2", "square", "s1", "s2", "t"]

piecesDefinition = {
    "straight": [
        [
            [-2, 0],
            [-1, 0],
            [0, 0],
            [1, 0]
        ],
        [
            [0, -2],
            [0, -1],
            [0, 0],
            [0, 1]
        ],
        [
            [-2, 1],
            [-1, 1],
            [0, 1],
            [1, 1]
        ],
        [
            [-1, -2],
            [-1, -1],
            [-1, 0],
            [-1, 1]
        ]
    ],
    "l1": [
        [
            [-1, -1],
            [-1, 0],
            [0, 0],
            [1, 0]
        ],
        [
            [1, -1],
            [0, -1],
            [0, 0],
            [0, 1]
        ],
        [
            [-1, 0],
            [0, 0],
            [1, 0],
            [1, 1]
        ],
        [
            [0, -1],
            [0, 0],
            [0, 1],
            [-1, 1]
        ]
    ],
    "l2": [
        [
            [1, -1],
            [-1, 0],
            [0, 0],
            [1, 0]
        ],
        [
            [1, 1],
            [0, -1],
            [0, 0],
            [0, 1]
        ],
        [
            [-1, 0],
            [0, 0],
            [1, 0],
            [-1, 1]
        ],
        [
            [0, -1],
            [0, 0],
            [0, 1],
            [-1, -1]
        ]
    ],
    "square": [
        [
            [-1, -1],
            [-1, 0],
            [0, 0],
            [0, -1]
        ],
        [
            [-1, -1],
            [-1, 0],
            [0, 0],
            [0, -1]
        ],
        [
            [-1, -1],
            [-1, 0],
            [0, 0],
            [0, -1]
        ],
        [
            [-1, -1],
            [-1, 0],
            [0, 0],
            [0, -1]
        ]
    ],
    "s1": [
        [
            [-1, 0],
            [0, 0],
            [0, -1],
            [1, -1]
        ],
        [
            [0, -1],
            [0, 0],
            [1, 0],
            [1, 1]
        ],
        [
            [-1, 1],
            [0, 1],
            [0, 0],
            [1, 0]
        ],
        [
            [-1, -1],
            [-1, 0],
            [0, 0],
            [0, 1]
        ]
    ],
    "s2": [
        [
            [-1, -1],
            [0, -1],
            [0, 0],
            [1, 0]
        ],
        [
            [1, -1],
            [1, 0],
            [0, 0],
            [0, 1]
        ],
        [
            [-1, 0],
            [0, 0],
            [0, 1],
            [1, 1]
        ],
        [
            [-1, 1],
            [-1, 0],
            [0, 0],
            [0, -1]
        ]
    ],
    "t": [
        [
            [-1, 0],
            [0, 0],
            [0, -1],
            [1, 0]
        ],
        [
            [0, -1],
            [0, 0],
            [1, 0],
            [0, 1]
        ],
        [
            [-1, 0],
            [0, 0],
            [0, 1],
            [1, 0]
        ],
        [
            [0, -1],
            [0, 0],
            [-1, 0],
            [0, 1]
        ]
    ]
}

var playingField = [];
var currentPiece;
var nextPiece;
var score = 0;
var lines = 0;
var gameOverState = false;
var pausedState = false;

// Function Definition
function generatePlayingField() {
    for (var i = 0; i < playingFieldSize[0]; i++) {
        currentRowInPlayingFieldGeneration = []
        for (var j = 0; j < playingFieldSize[1]; j++) {
            currentRowInPlayingFieldGeneration.push(0)
        }
        playingField.push(currentRowInPlayingFieldGeneration)
    }
}

function drawPixel(posX, posY) {
    currentPixel = document.createElement("div");
    currentPixel.className = "pixel"
    currentPixel.style.left = playingFieldScale * posX + "px"
    currentPixel.style.top = playingFieldScale * posY + "px"
    $("#playing-field")[0].append(currentPixel)
}

function drawPixelInPreview(posX, posY, bounds) {
    currentPixel = document.createElement("div");
    currentPixel.className = "pixel"
    currentPixel.style.left = playingFieldScale * posX + playingFieldScale * 1.5 + 32 + "px"
    currentPixel.style.top = playingFieldScale * posY + playingFieldScale * 1.5 + 32 + "px"
    $("#next-piece-preview")[0].append(currentPixel)
}

function drawPlayingField() {
    // Clear playing field for render
    $("#playing-field")[0].innerHTML = "";
    // Render currently placed pieces
    for (var i = 0; i < playingFieldSize[0]; i++) {
        for (var j = 0; j < playingFieldSize[1]; j++) {
            if (playingField[i][j] == 1) {
                drawPixel(i, j)
            }
        }
    }
    // Render current piece
    for (pixels in piecesDefinition[currentPiece.type][currentPiece.rotation]) {
        drawPixel(currentPiece.position[0] + piecesDefinition[currentPiece.type][currentPiece.rotation][pixels][0], currentPiece.position[1] + piecesDefinition[currentPiece.type][currentPiece.rotation][pixels][1])
    }
}

function updateNextPiecePreview() {
    $("#next-piece-preview")[0].innerHTML = "";
    for (pixels in piecesDefinition[nextPiece.type][nextPiece.rotation]) {
        drawPixelInPreview(piecesDefinition[nextPiece.type][nextPiece.rotation][pixels][0], piecesDefinition[nextPiece.type][nextPiece.rotation][pixels][1])
    }
}

function generateCurrentPiece() {
    var pieceType = pieces[Math.floor(Math.random() * pieces.length)];
    var piecePosition = [Math.floor(playingFieldSize[0] / 2), 2]
    var pieceRotation = 0;
    if (nextPiece == undefined) {
        currentPiece = {
            "type": pieceType,
            "position": piecePosition,
            "rotation": pieceRotation
        }
        var pieceType = pieces[Math.floor(Math.random() * pieces.length)];
        var piecePosition = [Math.floor(playingFieldSize[0] / 2), 2]
        var pieceRotation = 0;
        nextPiece = {
            "type": pieceType,
            "position": piecePosition,
            "rotation": pieceRotation
        }
    } else {
        currentPiece = nextPiece
        nextPiece = {
            "type": pieceType,
            "position": piecePosition,
            "rotation": pieceRotation
        }
    }
    updateNextPiecePreview();
}

function checkCollisions(directionX, directionY) {
    collisionState = false;
    for (pixels in piecesDefinition[currentPiece.type][currentPiece.rotation]) {
        calculatedX = currentPiece.position[0] + piecesDefinition[currentPiece.type][currentPiece.rotation][pixels][0] + directionX;
        calculatedY = currentPiece.position[1] + piecesDefinition[currentPiece.type][currentPiece.rotation][pixels][1] + directionY;
        // Max Border
        if (calculatedX > playingFieldSize[0] - 1) {
            collisionState = true
            return collisionState;
        }
        if (calculatedY > playingFieldSize[1] - 1) {
            collisionState = true
            return collisionState;
        }
        // Min Border
        if (calculatedX < 0) {
            collisionState = true
            return collisionState;
        }
        if (calculatedY < 0) {
            collisionState = true
            return collisionState;
        }

        if (playingField[calculatedX][calculatedY] == 1) {
            collisionState = true;
            return collisionState;
        }
    }
    return collisionState;
}

function checkCollisionsRotation(rotationDirection) {
    collisionState = false;
    for (pixels in piecesDefinition[currentPiece.type][currentPiece.rotation]) {
        calculatedRotation = currentPiece.rotation + rotationDirection;
        if (calculatedRotation > 3) {
            calculatedRotation = 0;
        }
        if (calculatedRotation < 0) {
            calculatedRotation = 3;
        }
        calculatedX = currentPiece.position[0] + piecesDefinition[currentPiece.type][calculatedRotation][pixels][0];
        calculatedY = currentPiece.position[1] + piecesDefinition[currentPiece.type][calculatedRotation][pixels][1];
        // Max Border
        if (calculatedX > playingFieldSize[0] - 1) {
            collisionState = true
            return collisionState;
        }
        if (calculatedY > playingFieldSize[1] - 1) {
            collisionState = true
            return collisionState;
        }
        // Min Border
        if (calculatedX < 0) {
            collisionState = true
            return collisionState;
        }
        if (calculatedY < 0) {
            collisionState = true
            return collisionState;
        }

        if (playingField[calculatedX][calculatedY] == 1) {
            collisionState = true;
            return collisionState;
        }
    }
    return collisionState;
}

function physicsTick() {
    if (!checkCollisions(0, 1)) {
        currentPiece.position[1]++;
    } else {
        for (pixels in piecesDefinition[currentPiece.type][currentPiece.rotation]) {
            calculatedX = currentPiece.position[0] + piecesDefinition[currentPiece.type][currentPiece.rotation][pixels][0];
            calculatedY = currentPiece.position[1] + piecesDefinition[currentPiece.type][currentPiece.rotation][pixels][1];
            playingField[calculatedX][calculatedY] = 1;
        }
        if (!gameOverState) {
            checkLines();
            generateCurrentPiece();
        }
        if (checkCollisions(0, 0)) {
            gameOver();
        }
    }

}

function checkLines() {
    linesWhereBreaksAre = []
    for (var j = 0; j < playingFieldSize[1]; j++) {
        uninterrupted = true;
        for (var i = 0; i < playingFieldSize[0]; i++) {
            if (playingField[i][j] == 0) {
                uninterrupted = false;
            }
        }
        if (uninterrupted) {
            linesWhereBreaksAre.push(j);
        }
    }
    for (var k = 0; k < linesWhereBreaksAre.length; k++) {
        lineBreak = linesWhereBreaksAre[k]
        for (var j = 0; j < lineBreak; j++) {
            for (var i = 0; i < playingFieldSize[0]; i++) {
                playingField[i][lineBreak - j] = playingField[i][lineBreak - 1 - j]
            }
        }
    }
    lines += linesWhereBreaksAre.length;
    switch (linesWhereBreaksAre.length) {
        case 1:
            score += 40
            break;
        case 2:
            score += 100
            break;
        case 3:
            score += 300
            break;
        case 4:
            score += 1200
            break;
    }
    updateScore()
}

function updateScore() {
    $("#score")[0].innerHTML = "Score: " + score + "<br>" + "Lines: " + lines;
}

function restart() {
    console.log("Restarting")
    score = 0
    lines = 0
    playingField = [];
    generatePlayingField();
    generateCurrentPiece();
    drawPlayingField();
    updateScore()
    $("#gameover-screen")[0].remove();
    gameOverState = false;
}

function gameOver() {
    if (!gameOverState) {
        gameOverScreen = document.createElement("div");
        gameOverScreen.id = "gameover-screen"
        gameOverScreen.innerHTML = "Game Over !<br>"
        gameOverScreen.innerHTML += "Score: " + score + "<br>"
        gameOverScreen.innerHTML += "Lines: " + lines + "<br>"
        restartButton = document.createElement("button");
        restartButton.onclick = restart;
        restartButton.id = "gameover-restart-button"
        restartButton.innerHTML = "Restart"
        gameOverScreen.append(restartButton)
        $("body")[0].append(gameOverScreen)
        gameOverState = true;
    }
}

// Define Controls
document.addEventListener('keydown', (event) => {
    if (!pausedState) {
        var name = event.key;
        var code = event.code;
        switch (String(code)) {
            case "ArrowLeft":
                if (!checkCollisions(-1, 0)) {
                    currentPiece.position[0]--;
                    drawPlayingField();
                }
                break;
            case "ArrowRight":
                if (!checkCollisions(1, 0)) {
                    currentPiece.position[0]++;
                    drawPlayingField();
                }
                break;
            case "ArrowDown":
                physicsTick();
                drawPlayingField();
                break;
            case "KeyZ":
                if (!checkCollisionsRotation(-1)) {
                    currentPiece.rotation--;
                    if (currentPiece.rotation < 0) {
                        currentPiece.rotation = 3;
                    }
                    drawPlayingField();
                }
                break;
            case "KeyX":
                if (!checkCollisionsRotation(1)) {
                    currentPiece.rotation++;
                    if (currentPiece.rotation > 3) {
                        currentPiece.rotation = 0;
                    }
                    drawPlayingField();
                }
                break;
        }
    }
}, false);

function gameLoop() {
    physicsTick();
    drawPlayingField();
}

function togglePause() {
    if (pausedState) {
        gameLoopInterval = setInterval(gameLoop, speed);
        pausedState = false;
    } else {
        clearInterval(gameLoopInterval);
        pausedState = true;
    }
}

// Code Start
$("#playing-field")[0].style.width = playingFieldScale * playingFieldSize[0] + "px";
$("#playing-field")[0].style.height = playingFieldScale * playingFieldSize[1] + "px";
$("#sidebar")[0].style.width = playingFieldScale * playingFieldSize[0] - sidebarPadding * 2 + "px";
$("#sidebar")[0].style.padding = sidebarPadding + "px";
$("#sidebar")[0].style.left = "calc(50% + " + $("#playing-field")[0].style.width + ")";
$("#sidebar")[0].style.height = playingFieldScale * playingFieldSize[1] - sidebarPadding * 2 + "px";

$("#next-piece-preview")[0].style.width = playingFieldScale * 4 + 32 + "px";
$("#next-piece-preview")[0].style.height = playingFieldScale * 4 + 32 + "px";

generatePlayingField();
generateCurrentPiece();
drawPlayingField();
updateScore()




var gameLoopInterval = setInterval(gameLoop, speed);