stopWatchSidebarStatus = false;
breakTime = 5*60*1000;
workTime = 25*60*1000;



breakTimeRound = Math.round(breakTime/1000);
workTimeRound = Math.round(workTime/1000);

startTime = new Date();
currentState = "Work";
startedState = false;
stopwatchPaused = false;
stopwatchPauseTime = new Date();



function toggleStopwatchSidebar(){
    if(stopWatchSidebarStatus){
        document.getElementById("stopwatch-sidebar").style = "";
        stopWatchSidebarStatus = false;
    } else {
        document.getElementById("stopwatch-sidebar").style.left = "-2px";
        document.getElementById("stopwatch-sidebar").style.border = "white 1px solid";
        stopWatchSidebarStatus = true;
    }
}

function startStopwatch(){
    if (!stopwatchPaused){
        startTime = new Date();
        startedState = true;
    } 
    else {
        startTime = new Date()-stopwatchPauseTime;
        startedState = true;
        stopwatchPaused=false;
    }
    
}

function resetStopwatch(){
    startTime = new Date();
    startedState = false;
    stopwatchPaused=false;
}

function pauseStopwatch(){
    startedState = false;
    stopwatchPaused = true;
    stopwatchPauseTime = (new Date() - startTime);
}

function updateStopwatch(){
    if(startedState){
        deltaTime = (new Date() - startTime)
        deltaTimeRound = Math.round(deltaTime/1000);
        if (currentState == "Work"){
        progress = deltaTime/workTime;
        stateTimeRound = workTimeRound
        } else{
            progress = deltaTime/breakTime;
            stateTimeRound = breakTimeRound
        }
        document.getElementById("stopwatch-progress-bar-infill").style.width = `${progress*320}px`;
        document.getElementById("stopwatch-progress-bar-text").innerHTML = `${String(Math.floor(deltaTimeRound/3600)).padStart(2, '0')}:${String(Math.floor(deltaTimeRound/60)%60).padStart(2, '0')}:${String(deltaTimeRound%60).padStart(2, '0')} / ${String(Math.floor(stateTimeRound/3600)).padStart(2, '0')}:${String(Math.floor(stateTimeRound/60)%60).padStart(2, '0')}:${String(stateTimeRound%60).padStart(2, '0')} (${currentState})`
        if (progress > 1){
            if (currentState == "Work"){
                currentState = "Break";
                } else{
                    currentState = "Work";
                }
            startTime = new Date();
        }
    }
    }

setInterval(updateStopwatch,100);