// User
let lineMaxCharacterLength = 40;
let lineCount = 4;

// System
let threeKListLength = top_threek_english_words.length;
let lineData = [];
let userCursorPosition = 0;
let isShiftPressed = false;
let runStartTime = new Date();
let runStarted = false;
let runErrors = [];
let writtenLetters = [];

function pickRandomWordFromList() {
  return top_threek_english_words[
    Math.round(Math.random() * (threeKListLength - 1))
  ];
}

function generateLines() {
  let generatedLineData = [];
  for (let lineIndex = 0; lineIndex < lineCount; lineIndex++) {
    let currentLineData = "";
    let maxCharacterLengthReached = false;
    while (!maxCharacterLengthReached) {
      let newCurrentLineData = currentLineData.concat(
        pickRandomWordFromList() + " "
      );
      if (newCurrentLineData.length > lineMaxCharacterLength) {
        maxCharacterLengthReached = true;
      } else {
        currentLineData = newCurrentLineData;
      }
    }
    generatedLineData.push(currentLineData);
  }
  return generatedLineData;
}

function getCharacterFromIndex(lineData, index) {
  lineData;
  let currentCharacterId = 0;
  for (let lineIndex in lineData) {
    let currentLineString = lineData[lineIndex];
    for (let currentCharacterIndex in currentLineString) {
      if (index == currentCharacterId) {
        return currentLineString[currentCharacterIndex];
      }
      currentCharacterId++;
    }
  }
  return "Not found.";
}

function getCharacterCount(lineData) {
  let currentCharacterId = 0;
  for (let lineIndex in lineData) {
    let currentLineString = lineData[lineIndex];
    for (let currentCharacterIndex in currentLineString) {
      currentCharacterId++;
    }
  }
  return currentCharacterId;
}

function getWordCount(lineData) {
  let wordCount = 0;
  for (let lineIndex in lineData) {
    let currentLineString = lineData[lineIndex];
    wordCount += currentLineString.split(" ").length;
  }
  return wordCount;
}

function formatForHTML(stringToFormat) {
  return stringToFormat.replaceAll(" ", "&nbsp;");
}

function renderLineDataToScreen() {
  let linesContainerDiv = document.getElementById("lines-container");
  linesContainerDiv.innerHTML = "";
  let currentCharacterId = 0;
  for (let lineIndex in lineData) {
    let lineDiv = document.createElement("div");
    lineDiv.className = "line-div";
    let currentLineString = lineData[lineIndex];
    for (let currentCharacterIndex in currentLineString) {
      let characterDiv = document.createElement("div");
      characterDiv.id = "character-div-" + currentCharacterId;
      characterDiv.className = "character-div";
      if (runErrors.includes(currentCharacterId)) {
        characterDiv.className += " character-div-error";
      }
      if (writtenLetters.includes(currentCharacterId)) {
        characterDiv.className += " character-div-written";
      }
      characterDiv.innerHTML = formatForHTML(
        currentLineString[currentCharacterIndex]
      );
      lineDiv.appendChild(characterDiv);
      currentCharacterId++;
    }
    linesContainerDiv.appendChild(lineDiv);
  }
}

function updateCursorPosition() {
  let cursorElement = document.getElementById("cursor-div");
  cursorElement.innerHTML = formatForHTML(
    getCharacterFromIndex(lineData, userCursorPosition)
  );
  let targetBoudingRect = {
    left: "-50",
    top: "50",
    right: "-50",
    bottom: "50",
  };
  try {
    targetBoudingRect = document
      .getElementById("character-div-" + userCursorPosition)
      .getBoundingClientRect();
  } catch {
    console.log("unsafe behavior but I don't care");
  }
  cursorElement.style.top = targetBoudingRect.top + "px";
  cursorElement.style.left = targetBoudingRect.left + "px";
  cursorElement.style.width =
    targetBoudingRect.right - targetBoudingRect.left + "px";
  cursorElement.style.height =
    targetBoudingRect.bottom - targetBoudingRect.top + "px";
}

function updateStats() {
  let statusContainer = document.getElementById("status-container");
  let characterCount = getCharacterCount(lineData);
  let wordCount = getWordCount(lineData);
  let avgTypedWords = wordCount * (userCursorPosition / characterCount);
  let timeSinceStart = new Date() - runStartTime;
  if (runStarted) {
    statusContainer.innerHTML = `
            <div id="status-wpm">WPM: ${Math.round(
              (avgTypedWords / (timeSinceStart / 1000)) * 60
            )}</div>
            <div id="status-errors">Errors: ${runErrors.length}</div>
            <div id="status-accuracy">Accuracy: ${Math.round(
              ((characterCount - runErrors.length) / characterCount) * 100
            )}%</div>
            <div id="status-time">Time: ${String(
              Math.floor(Math.floor(timeSinceStart / 1000) / 60)
            ).padStart(2, "0")}:${String(
      Math.floor(timeSinceStart / 1000) % 60
    ).padStart(2, "0")}.${Math.floor((timeSinceStart % 1000) / 100)}</div>
  `;
  }
}

function initialiseTest() {
  lineData = generateLines();
  renderLineDataToScreen();
}

document.addEventListener("keyup", function (event) {
  if (event.keyCode == 16) {
    isShiftPressed = false;
  }
});

function advanceCursor() {
  if (userCursorPosition == 0) {
    runStartTime = new Date();
    runStarted = true;
  }
  userCursorPosition++;
}

document.addEventListener("keydown", function (event) {
  let characterTyped = String.fromCharCode(event.keyCode);
  let isCapsLockOn = event.getModifierState("CapsLock");
  if (event.keyCode == 8) {
    if (userCursorPosition != 0) {
      userCursorPosition--;
      var index = runErrors.indexOf(userCursorPosition);
      if (index !== -1) {
        runErrors.splice(index, 1);
      }
      index = writtenLetters.indexOf(userCursorPosition);
      if (index !== -1) {
        writtenLetters.splice(index, 1);
      }
    }
  }
  if (event.keyCode == 27) {
    initialiseTest();
    runStartTime = new Date();
    runStarted = false;
    runErrors = [];
    writtenLetters = [];
    userCursorPosition = 0;
  }
  if (event.keyCode == 109 || event.keyCode == 54) {
    characterTyped = "-";
  }
  if (event.keyCode == 16) {
    isShiftPressed = true;
  }
  if (
    !((!isCapsLockOn && isShiftPressed) || (isCapsLockOn && !isShiftPressed))
  ) {
    characterTyped = characterTyped.toLowerCase();
  }
  let pendingCharacter = getCharacterFromIndex(lineData, userCursorPosition);
  if (pendingCharacter == characterTyped) {
    writtenLetters.push(userCursorPosition);
    advanceCursor();
  } else {
    if (![20, 16, 8, 27].includes(event.keyCode)) {
      runErrors.push(userCursorPosition);
      advanceCursor();
    }
  }
  if (userCursorPosition == getCharacterCount(lineData)) {
    runStarted = false;
  }
  updateCursorPosition();
  renderLineDataToScreen();
});

initialiseTest();
setTimeout(updateCursorPosition, 100);
setInterval(updateStats, 100);
