var scrollPos = 0;
var effectRecoverySpeed = 0.001;

var material = new Blotter.LiquidDistortMaterial();
material.uniforms.uSpeed.value = 1.0;
material.uniforms.uVolatility.value = 0.1;

function createBlotterText() {
  var textOpts = {
    family: "'Rubik'",
    size: 48,
    weight: 700,
    fill: "#000000",
    paddingLeft: 0,
    paddingRight: 0,
    paddingTop: 0,
    paddingBottom: 0,
  };
  // BLOTTER - Example 2
  var text1 = new Blotter.Text("Bio", textOpts);
  var text2 = new Blotter.Text("Software Development", textOpts);
  var text3 = new Blotter.Text("Education", textOpts);
  var text4 = new Blotter.Text("Hobbies", textOpts);
  var text5 = new Blotter.Text("Contact", textOpts);
  var texts = [text1, text2, text3, text4, text5];
  var blotter = new Blotter(material, {
    texts: texts,
  });
  texts.forEach(function (item, index) {
    document.getElementById("distortion-text-" + (index + 1)).innerHTML = "";    
    var elem = document.getElementById("distortion-text-" + (index + 1));
    var scope = blotter.forText(item);
    scope.appendTo(elem);
    //document.getElementById("distortion-text-" + (index + 1)).innerHTML = "";
  });
}

WebFont.load({
  google: {
    families: ["Rubik"],
  },
  active: () => createBlotterText(),
});

var previousTimeStamp = 0;

function frame(timestamp) {
  var timeElapsed = (timestamp - previousTimeStamp) / 8;
  //console.log(timestamp - previousTimeStamp);
  scrollPos +=
    (document.body.parentElement.scrollTop - scrollPos) /
    (1 / effectRecoverySpeed) ** (timeElapsed);
  material.uniforms.uVolatility.value =
    (document.body.parentElement.scrollTop - scrollPos)**2 / 1000000;
  material.uniforms.uSpeed.value =
    (document.body.parentElement.scrollTop - scrollPos)**2 / 1000000;
  previousTimeStamp = timestamp;
  window.requestAnimationFrame(frame);
}
window.requestAnimationFrame(frame);
