/* The definitive data-set for chemical elements */
/* Collator: Scott Weaver @sweaver2112 */
/* Data collated from many public sources, including those listed below */
/* https://github.com/Bowserinator/Periodic-Table-JSON */
/* wikipedia.com */
/* ptable.com */
/* periodictable.com */
pTableUnits =
{
    "abundance": {
        "universe": "%",
        "solar": "%",
        "meteor": "%",
        "crust": "%",
        "human": "%"
    },
    "atomic_mass": "amu",
    "boiling_point": {
        "celsius": "°",
        "fahrenheit": "°",
        "kelvin": "K"
    },
    "conductivity": {
        "thermal": "W/mK",
        "electric": "MS/m"
    },
    "curie_point": "K",
    "density": {
        "shear": "GPa",
        "young": "GPa",
        "stp": "kg/m³",
        "liquid": "kg/m³"
    },
    "discovered": "year",
    "electron_affinity": "kJ/mol",
    "electronegativity_pauling": "kJ/mol",
    "energy_levels": "e⁻️",
    "half_life": "year",
    "hardness": {
        "radius": "pm",
        "vickers": "MPa",
        "brinell": "MPa",
        "mohs": "MPa"
    },
    "heat": {
        "specific": "J/(kg K)",
        "fusion": "kJ/mol",
        "vaporization": "kJ/mol",
        "molar": "J/K.mol"
    },
    "ionization_energies": "kJ/mol",
    "lattice_constants": "pm",
    "lifetime": "year",
    "magnetic_susceptibility": {
        "mass": "m³/Kg",
        "molar": "m³/mol"
    },
    "melting_point": {
        "celsius": "°",
        "fahrenheit": "°",
        "kelvin": "K"
    },
    "modulus": {
        "bulk": "GPa"
    },
    "neel_point": "K",
    "radius": {
        "calculated": "pm",
        "empirical": "pm",
        "covalent": "pm",
        "vanderwaals": "pm"
    },
    "resistivity": "m Ω",
    "speed_of_sound": "m/s",
    "superconducting_point": "K",
    "thermal_expansion": "K⁻¹"
};

pTable = [
    {
        "name": "Hydrogen",
        "symbol": "H",
        "abundance": {
            "universe": 75,
            "solar": 75,
            "meteor": 2.4,
            "crust": 0.15,
            "ocean": 11,
            "human": 10
        },
        "adiabatic_index": "7/5",
        "allotropes": "Dihydrogen",
        "appearance": "colorless gas",
        "atomic_mass": 1.008,
        "atomic_number": 1,
        "block": "s-block",
        "boiling_point": 20.271,
        "classifications": {
            "cas_number": "CAS1333-74-0",
            "cid_number": "CID783",
            "rtecs_number": "RTECSMW8900000",
            "dot_numbers": 1966,
            "dot_hazard_class": 2.1
        },
        "conductivity": {
            "thermal": 0.1805
        },
        "cpk_hex": "ffffff",
        "critical_pressure": 1.293,
        "critical_temperature": 32.97,
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 0.0899
        },
        "discovered": {
            "year": 1766,
            "by": "Henry Cavendish",
            "location": "The United Kingdom"
        },
        "electron_affinity": 72.769,
        "electron_configuration": "1s¹",
        "electron_configuration_semantic": "1s¹",
        "electronegativity_pauling": 2.2,
        "electrons_per_shell": [
            1
        ],
        "energy_levels": "1",
        "gas_phase": "Diatomic",
        "group": 1,
        "half_life": "Stable",
        "heat": {
            "specific": 14300,
            "vaporization": 0.452,
            "fusion": 0.558,
            "molar": 28.836
        },
        "ionization_energies": [
            1312
        ],
        "isotopes_known": "¹H, ²H, ³H, ⁴H, ⁵H, ⁶H, ⁷H",
        "isotopes_stable": "¹H, ²H",
        "isotopic_abundances": "¹H: 99.9885%, ²H: 0.0115%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "470, 470, 340",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -2.48e-8,
            "molar": -4.999e-11,
            "volume": -2.23e-9
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 13.99,
        "molar_volume": 0.01121,
        "neutron_cross_section": 0.332,
        "neutron_mass_absorption": 0.011,
        "oxidation_states": "-1c,1c",
        "period": 1,
        "phase": "Gas",
        "quantum_numbers": "2S1/2",
        "radius": {
            "calculated": 53,
            "empirical": 25,
            "covalent": 37,
            "vanderwaals": 120
        },
        "refractive_index": 1.000132,
        "series": "diatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Hydrogen",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 1270,
        "summary": "<p>Hydrogen is the chemical element with the symbol H and atomic number 1. Hydrogen is the lightest element. At standard conditions hydrogen is a gas of diatomic molecules having the formula H2. It is colorless, odorless, non-toxic, and highly combustible. Hydrogen is the most abundant chemical substance in the universe, constituting roughly 75% of all normal matter. Stars such as the Sun are mainly composed of hydrogen in the plasma state. Most of the hydrogen on Earth exists in molecular forms such as water and organic compounds. For the most common isotope of hydrogen (symbol 1H) each atom has one proton, one electron, and no neutrons.</p><p>In the early universe, the formation of protons, the nuclei of hydrogen, occurred during the first second after the Big Bang. The emergence of neutral hydrogen atoms throughout the universe occurred about 370,000 years later during the recombination epoch, when the plasma had cooled enough for electrons to remain bound to protons.</p><p>Hydrogen is nonmetallic, except at extremely high pressures, and readily forms a single covalent bond with most nonmetallic elements, forming compounds such as water and nearly all organic compounds. Hydrogen plays a particularly important role in acid–base reactions because these reactions usually involve the exchange of protons between soluble molecules. In ionic compounds, hydrogen can take the form of a negative charge (i.e., anion) where it is known as a hydride, or as a positively charged (i.e., cation) species denoted by the symbol H+. The H+ cation is simply a proton (symbol p) but its behavior in aqueous solutions and in ionic compounds involves screening of its electric charge by nearby polar molecules or anions. Because hydrogen is the only neutral atom for which the Schrödinger equation can be solved analytically, the study of its energetics and chemical bonding has played a key role in the development of quantum mechanics.</p><p>Hydrogen gas was first artificially produced in the early 16th century by the reaction of acids on metals. In 1766–81, Henry Cavendish was the first to recognize that hydrogen gas was a discrete substance, and that it produces water when burned, the property for which it was later named: in Greek, hydrogen means \"water-former\".</p><p>Industrial production is mainly from steam reforming natural gas, and less often from more energy-intensive methods such as the electrolysis of water. Most hydrogen is used near the site of its production, the two largest uses being fossil fuel processing (e.g., hydrocracking) and ammonia production, mostly for the fertilizer market. Hydrogen is problematic in metallurgy because it can embrittle many metals, complicating the design of pipelines and storage tanks.</p>",
        "valence_electrons": 1
    },
    {
        "name": "Helium",
        "symbol": "He",
        "abundance": {
            "universe": 23,
            "solar": 23,
            "crust": 5.5e-7,
            "ocean": 7.2e-10
        },
        "adiabatic_index": "5/3",
        "appearance": "colorless gas, exhibiting a red-orange glow when placed in a high-voltage electric field",
        "atomic_mass": 4.0026022,
        "atomic_number": 2,
        "block": "s-block",
        "boiling_point": 4.222,
        "classifications": {
            "cas_number": "CAS7440-59-7",
            "cid_number": "CID23987",
            "rtecs_number": "RTECSMH6520000",
            "dot_numbers": 1963,
            "dot_hazard_class": 2.2
        },
        "conductivity": {
            "thermal": 0.1513
        },
        "cpk_hex": "d9ffff",
        "critical_pressure": 0.227,
        "critical_temperature": 5.19,
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 0.1785
        },
        "discovered": {
            "year": 1895,
            "by": "Pierre Janssen",
            "location": "Sweden and The United Kingdom"
        },
        "electron_affinity": -48,
        "electron_configuration": "1s²",
        "electron_configuration_semantic": "1s²",
        "electrons_per_shell": [
            2
        ],
        "energy_levels": "2",
        "gas_phase": "Monoatomic",
        "group": 18,
        "half_life": "Stable",
        "heat": {
            "specific": 5193.1,
            "vaporization": 0.083,
            "fusion": 0.02
        },
        "ionization_energies": [
            2372.3,
            5250.5
        ],
        "isotopes_known": "²He, ³He, ⁴He, ⁵He, ⁶He, ⁷He, ⁸He, ⁹He, ¹⁰He",
        "isotopes_stable": "³He, ⁴He",
        "isotopic_abundances": "³He: 0.000137%, ⁴He: 99.999863%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "424.2, 424.2, 424.2",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -5.9e-9,
            "molar": -2.36e-11,
            "volume": -1.05e-9
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 0.95,
        "molar_volume": 0.022424,
        "neutron_cross_section": 0.007,
        "neutron_mass_absorption": 0.00001,
        "period": 1,
        "phase": "Gas",
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 31,
            "covalent": 32,
            "vanderwaals": 140
        },
        "refractive_index": 1.000035,
        "series": "noble gas",
        "source": "https://en.wikipedia.org/wiki/Helium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 970,
        "summary": "<p>Helium (from Greek: ἥλιος, romanized: helios, lit. 'sun') is a chemical element with the symbol He and atomic number 2. It is a colorless, odorless, tasteless, non-toxic, inert, monatomic gas, the first in the noble gas group in the periodic table. Its boiling and melting point are the lowest among all the elements. Helium is the second lightest and second most abundant element in the observable universe (hydrogen is the lightest and most abundant). It is present at about 24% of the total elemental mass, which is more than 12 times the mass of all the heavier elements combined. Its abundance is similar to this in both the Sun and in Jupiter. This is due to the very high nuclear binding energy (per nucleon) of helium-4, with respect to the next three elements after helium. This helium-4 binding energy also accounts for why it is a product of both nuclear fusion and radioactive decay. Most helium in the universe is helium-4, the vast majority of which was formed during the Big Bang. Large amounts of new helium are being created by nuclear fusion of hydrogen in stars.</p><p>Helium was first detected as an unknown, yellow spectral line signature in sunlight, during a solar eclipse in 1868 by Georges Rayet, Captain C. T. Haig, Norman R. Pogson, and Lieutenant John Herschel, and was subsequently confirmed by French astronomer, Jules Janssen. Janssen is often jointly credited with detecting the element, along with Norman Lockyer. Janssen recorded the helium spectral line during the solar eclipse of 1868, while Lockyer observed it from Britain. Lockyer was the first to propose that the line was due to a new element, which he named. The formal discovery of the element was made in 1895 by chemists Sir William Ramsay, Per Teodor Cleve, and Nils Abraham Langlet, who found helium emanating from the uranium ore, cleveite, which is now not regarded as a separate mineral species, but as a variety of uraninite. In 1903, large reserves of helium were found in natural gas fields in parts of the United States, which is by far the largest supplier of the gas today.</p><p>Liquid helium is used in cryogenics (its largest single use, absorbing about a quarter of production), and in the cooling of superconducting magnets, with the main commercial application being in MRI scanners. Helium's other industrial uses—as a pressurizing and purge gas, as a protective atmosphere for arc welding, and in processes such as growing crystals to make silicon wafers—account for half of the gas produced. A well-known but minor use is as a lifting gas in balloons and airships. As with any gas whose density differs from that of air, inhaling a small volume of helium temporarily changes the timbre and quality of the human voice. In scientific research, the behavior of the two fluid phases of helium-4 (helium I and helium II) is important to researchers studying quantum mechanics (in particular the property of superfluidity) and to those looking at the phenomena, such as superconductivity, produced in matter near absolute zero.</p><p>On Earth, it is relatively rare—5.2 ppm by volume in the atmosphere. Most terrestrial helium present today is created by the natural radioactive decay of heavy radioactive elements (thorium and uranium, although there are other examples), as the alpha particles emitted by such decays consist of helium-4 nuclei. This radiogenic helium is trapped with natural gas in concentrations as great as 7% by volume, from which it is extracted commercially by a low-temperature separation process called fractional distillation. Previously, terrestrial helium—a non-renewable resource because once released into the atmosphere, it promptly escapes into space—was thought to be in increasingly short supply. However, recent studies suggest that helium produced deep in the earth by radioactive decay can collect in natural gas reserves in larger than expected quantities, in some cases, having been released by volcanic activity.</p>",
        "valence_electrons": 0
    },
    {
        "name": "Lithium",
        "symbol": "Li",
        "abundance": {
            "universe": 6e-7,
            "solar": 6e-9,
            "meteor": 0.00017,
            "crust": 0.0017,
            "ocean": 0.000018,
            "human": 0.000003
        },
        "appearance": "silvery-white",
        "atomic_mass": 6.94,
        "atomic_number": 3,
        "block": "s-block",
        "boiling_point": 1603,
        "classifications": {
            "cas_number": "CAS7439-93-2",
            "cid_number": "CID3028194",
            "rtecs_number": "RTECSOJ5540000",
            "dot_numbers": 1415,
            "dot_hazard_class": 4.3
        },
        "conductivity": {
            "thermal": 85,
            "electric": 11
        },
        "cpk_hex": "cc80ff",
        "critical_pressure": 67,
        "critical_temperature": 3223,
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 535,
            "liquid": 512
        },
        "discovered": {
            "year": 1817,
            "by": "Johan August Arfwedson",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 59.6326,
        "electron_configuration": "1s² 2s¹",
        "electron_configuration_semantic": "[He] 2s¹",
        "electronegativity_pauling": 0.98,
        "electrons_per_shell": [
            2,
            1
        ],
        "energy_levels": "2, 1",
        "group": 1,
        "half_life": "Stable",
        "hardness": {
            "mohs": 0.6
        },
        "heat": {
            "specific": 3570,
            "vaporization": 147,
            "fusion": 3,
            "molar": 24.86
        },
        "ionization_energies": [
            520.2,
            7298.1,
            11815
        ],
        "isotopes_known": "³Li, ⁴Li, ⁵Li, ⁶Li, ⁷Li, ⁸Li, ⁹Li, ¹⁰Li, ¹¹Li, ¹²Li",
        "isotopes_stable": "⁶Li, ⁷Li",
        "isotopic_abundances": "⁶Li: 7.59%, ⁷Li: 92.41%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "351, 351, 351",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 2.56e-8,
            "molar": 1.78e-10,
            "volume": 0.0000137
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 453.65,
        "modulus": {
            "bulk": 11,
            "shear": 4.2,
            "young": 4.9
        },
        "molar_volume": 0.00001297,
        "neutron_cross_section": 71,
        "oxidation_states": "1c",
        "period": 2,
        "phase": "Solid",
        "quantum_numbers": "2S1/2",
        "radius": {
            "calculated": 167,
            "empirical": 145,
            "covalent": 134,
            "vanderwaals": 182
        },
        "resistivity": 9.400000000002e-8,
        "series": "alkali metal",
        "source": "https://en.wikipedia.org/wiki/Lithium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 6000,
        "summary": "<p>Lithium (from Greek: λίθος, romanized: lithos, lit. 'stone') is a chemical element with the symbol Li and atomic number 3. It is a soft, silvery-white alkali metal. Under standard conditions, it is the lightest metal and the lightest solid element. Like all alkali metals, lithium is highly reactive and flammable, and must be stored in vacuum, inert atmosphere or inert liquid such as purified kerosene or mineral oil. When cut, it exhibits a metallic luster, but moist air corrodes it quickly to a dull silvery gray, then black tarnish. It never occurs freely in nature, but only in (usually ionic) compounds, such as pegmatitic minerals, which were once the main source of lithium. Due to its solubility as an ion, it is present in ocean water and is commonly obtained from brines. Lithium metal is isolated electrolytically from a mixture of lithium chloride and potassium chloride.</p><p>The nucleus of the lithium atom verges on instability, since the two stable lithium isotopes found in nature have among the lowest binding energies per nucleon of all stable nuclides. Because of its relative nuclear instability, lithium is less common in the solar system than 25 of the first 32 chemical elements even though its nuclei are very light: it is an exception to the trend that heavier nuclei are less common. For related reasons, lithium has important uses in nuclear physics. The transmutation of lithium atoms to helium in 1932 was the first fully man-made nuclear reaction, and lithium deuteride serves as a fusion fuel in staged thermonuclear weapons.</p><p>Lithium and its compounds have several industrial applications, including heat-resistant glass and ceramics, lithium grease lubricants, flux additives for iron, steel and aluminium production, lithium batteries, and lithium-ion batteries. These uses consume more than three-quarters of lithium production.</p><p>Lithium is present in biological systems in trace amounts; its functions are uncertain. Lithium salts have proven to be useful as a mood stabilizer and antidepressant in the treatment of mental illness such as bipolar disorder.</p>",
        "thermal_expansion": 0.000046,
        "valence_electrons": 1
    },
    {
        "name": "Beryllium",
        "symbol": "Be",
        "abundance": {
            "universe": 1e-7,
            "solar": 1e-8,
            "meteor": 0.0000029,
            "crust": 0.00019,
            "ocean": 6e-11,
            "human": 4e-8
        },
        "appearance": "white-gray metallic",
        "atomic_mass": 9.01218315,
        "atomic_number": 4,
        "block": "s-block",
        "boiling_point": 2742,
        "classifications": {
            "cas_number": "CAS7440-41-7",
            "cid_number": "CID5460467",
            "rtecs_number": "RTECSDS1750000",
            "dot_numbers": 1567,
            "dot_hazard_class": 6.1
        },
        "conductivity": {
            "thermal": 190,
            "electric": 25
        },
        "cpk_hex": "c2ff00",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 1848,
            "liquid": 1690
        },
        "discovered": {
            "year": 1797,
            "by": "Louis Nicolas Vauquelin",
            "location": "France"
        },
        "electrical_type": "Conductor",
        "electron_affinity": -48,
        "electron_configuration": "1s² 2s²",
        "electron_configuration_semantic": "[He] 2s²",
        "electronegativity_pauling": 1.57,
        "electrons_per_shell": [
            2,
            2
        ],
        "energy_levels": "2, 2",
        "group": 2,
        "half_life": "Stable",
        "hardness": {
            "vickers": 1670,
            "brinell": 600,
            "mohs": 5.5
        },
        "heat": {
            "specific": 1820,
            "vaporization": 297,
            "fusion": 7.95,
            "molar": 16.443
        },
        "ionization_energies": [
            899.5,
            1757.1,
            14848.7,
            21006.6
        ],
        "isotopes_known": "⁵Be, ⁶Be, ⁷Be, ⁸Be, ⁹Be, ¹⁰Be, ¹¹Be, ¹²Be, ¹³Be, ¹⁴Be, ¹⁵Be, ¹⁶Be",
        "isotopes_stable": "⁹Be",
        "isotopic_abundances": "⁹Be: 100%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "228.58, 228.58, 358.43",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -1.26e-8,
            "molar": -1.136e-10,
            "volume": -0.00002328
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 1560,
        "modulus": {
            "bulk": 130,
            "shear": 132,
            "young": 287
        },
        "molar_volume": 0.0000048767,
        "neutron_cross_section": 0.0092,
        "neutron_mass_absorption": 0.00003,
        "oxidation_states": "1,2c",
        "period": 2,
        "phase": "Solid",
        "poisson_ratio": 0.032,
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 112,
            "empirical": 105,
            "covalent": 90
        },
        "resistivity": 3.999999999998e-8,
        "series": "alkaline earth metal",
        "source": "https://en.wikipedia.org/wiki/Beryllium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 13000,
        "summary": "<p>Beryllium is a chemical element with the symbol Be and atomic number 4. It is a steel-gray, strong, lightweight and brittle alkaline earth metal. It is a divalent element that occurs naturally only in combination with other elements to form minerals. Notable gemstones high in beryllium include beryl (aquamarine, emerald) and chrysoberyl. It is a relatively rare element in the universe, usually occurring as a product of the spallation of larger atomic nuclei that have collided with cosmic rays. Within the cores of stars, beryllium is depleted as it is fused into heavier elements. Beryllium constitutes about 0.0004 percent by mass of Earth's crust. The world's annual beryllium production of 220 tons is usually manufactured by extraction from the mineral beryl, a difficult process because beryllium bonds strongly to oxygen.</p><p>In structural applications, the combination of high flexural rigidity, thermal stability, thermal conductivity and low density (1.85 times that of water) make beryllium metal a desirable aerospace material for aircraft components, missiles, spacecraft, and satellites. Because of its low density and atomic mass, beryllium is relatively transparent to X-rays and other forms of ionizing radiation; therefore, it is the most common window material for X-ray equipment and components of particle detectors. When added as an alloying element to aluminium, copper (notably the alloy beryllium copper), iron, or nickel, beryllium improves many physical properties. For example, tools and components made of beryllium copper alloys are strong and hard and do not create sparks when they strike a steel surface. In air, the surface of beryllium oxidizes readily at room temperature to form a passivation layer 1–10 nm thick that protects it from further oxidation and corrosion. The metal oxidizes in bulk (beyond the passivation layer) when heated above 500 °C, and burns brilliantly when heated to about 2500 °C.</p><p>The commercial use of beryllium requires the use of appropriate dust control equipment and industrial controls at all times because of the toxicity of inhaled beryllium-containing dusts that can cause a chronic life-threatening allergic disease in some people called berylliosis.</p>",
        "superconducting_point": 0.026,
        "thermal_expansion": 0.0000113,
        "valence_electrons": 2
    },
    {
        "name": "Boron",
        "symbol": "B",
        "abundance": {
            "universe": 1e-7,
            "solar": 2e-7,
            "meteor": 0.00016,
            "crust": 0.00086,
            "ocean": 0.00044,
            "human": 0.00007
        },
        "allotropes": "Alpha Rhombohedral Boron, Beta Rhombohedral Boron, Alpha Tetragonal Boron",
        "appearance": "black-brown",
        "atomic_mass": 10.81,
        "atomic_number": 5,
        "block": "p-block",
        "boiling_point": 4200,
        "classifications": {
            "cas_number": "CAS7440-42-8",
            "cid_number": "CID5462311",
            "rtecs_number": "RTECSED7350000"
        },
        "conductivity": {
            "thermal": 27,
            "electric": 1e-10
        },
        "cpk_hex": "ffb5b5",
        "crystal_structure": "Simple Trigonal",
        "density": {
            "stp": 2460,
            "liquid": 2080
        },
        "discovered": {
            "year": 1808,
            "by": "Joseph Louis Gay-Lussac",
            "location": "France and The United Kingdom"
        },
        "electrical_type": "Insulator",
        "electron_affinity": 26.989,
        "electron_configuration": "1s² 2s² 2p¹",
        "electron_configuration_semantic": "[He] 2s² 2p¹",
        "electronegativity_pauling": 2.04,
        "electrons_per_shell": [
            2,
            3
        ],
        "energy_levels": "2, 3",
        "group": 13,
        "half_life": "Stable",
        "hardness": {
            "vickers": 49000,
            "mohs": 9.3
        },
        "heat": {
            "specific": 1030,
            "vaporization": 507,
            "fusion": 50,
            "molar": 11.087
        },
        "ionization_energies": [
            800.6,
            2427.1,
            3659.7,
            25025.8,
            32826.7
        ],
        "isotopes_known": "⁶B, ⁷B, ⁸B, ⁹B, ¹⁰B, ¹¹B, ¹²B, ¹³B, ¹⁴B, ¹⁵B, ¹⁶B, ¹⁷B, ¹⁸B, ¹⁹B",
        "isotopes_stable": "¹⁰B, ¹¹B",
        "isotopic_abundances": "¹⁰B: 19.9%, ¹¹B: 80.1%",
        "lattice_angles": "1.01334, 1.01334, 1.01334",
        "lattice_constants": "506, 506, 506",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -8.7e-9,
            "molar": -9.41e-11,
            "volume": -0.0000214
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 2349,
        "modulus": {
            "bulk": 320
        },
        "molar_volume": 0.0000043943,
        "neutron_cross_section": 760,
        "neutron_mass_absorption": 2.4,
        "oxidation_states": "1,2,3c",
        "period": 2,
        "phase": "Solid",
        "quantum_numbers": "2P1/2",
        "radius": {
            "calculated": 87,
            "empirical": 85,
            "covalent": 82
        },
        "resistivity": 10000,
        "series": "metalloid",
        "source": "https://en.wikipedia.org/wiki/Boron",
        "space_group_name": "R_3m",
        "space_group_number": 166,
        "speed_of_sound": 16200,
        "summary": "<p>Boron is a chemical element with the symbol B and atomic number 5. In its crystalline form it is a brittle, dark, lustrous metalloid; in its amorphous form it is a brown powder. As the lightest element of the boron group it has three valence electrons for forming covalent bonds, resulting many compounds such as boric acid, the mineral borax, and the ultra-hard crystal boron carbide.</p><p>Boron is synthesized entirely by cosmic ray spallation and supernovae and not by stellar nucleosynthesis, so it is a low-abundance element in the Solar System and in the Earth's crust. It constitutes about 0.001 percent by weight of Earth's crust. Boron is concentrated on Earth by the water-solubility of its more common naturally occurring compounds, the borate minerals. These are mined industrially as evaporites, such as borax and kernite. The largest known boron deposits are in Turkey, the largest producer of boron minerals.</p><p>Elemental boron is a metalloid that is found in small amounts in meteoroids but chemically uncombined boron is not otherwise found naturally on Earth. Industrially, very pure boron is produced with difficulty because of contamination by carbon or other elements that resist removal. Several allotropes of boron exist: amorphous boron is a brown powder; crystalline boron is silvery to black, extremely hard (about 9.5 on the Mohs scale), and a poor electrical conductor at room temperature. The primary use of elemental boron is as boron filaments with applications similar to carbon fibers in some high-strength materials.</p><p>Boron is primarily used in chemical compounds. About half of all boron consumed globally is an additive in fiberglass for insulation and structural materials. The next leading use is in polymers and ceramics in high-strength, lightweight structural and heat-resistant materials. Borosilicate glass is desired for its greater strength and thermal shock resistance than ordinary soda lime glass. Boron as sodium perborate is used as a bleach. A small amount of boron is used as a dopant in semiconductors, and reagent intermediates in the synthesis of organic fine chemicals. A few boron-containing organic pharmaceuticals are used or are in study. Natural boron is composed of two stable isotopes, one of which (boron-10) has a number of uses as a neutron-capturing agent.</p><p>The intersection of boron with biology is very small. Consensus on boron as essential for mammalian life is lacking. Borates have low toxicity in mammals (similar to table salt) but are more toxic to arthropods and are occasionally used as insecticides. Boron-containing organic antibiotics are known. Although only traces are required, boron is an essential plant nutrient.</p>",
        "thermal_expansion": 0.000006,
        "valence_electrons": 3
    },
    {
        "name": "Carbon",
        "symbol": "C",
        "abundance": {
            "universe": 0.5,
            "solar": 0.3,
            "meteor": 1.5,
            "crust": 0.18,
            "ocean": 0.0028,
            "human": 23
        },
        "allotropes": "Graphite, Diamond, Amorphous Carbon, Lonsdaleite, Fullerene, Carbon Nanotube, Graphene",
        "atomic_mass": 12.011,
        "atomic_number": 6,
        "block": "p-block",
        "boiling_point": 4300,
        "classifications": {
            "cas_number": "CAS7440-44-0",
            "cid_number": "CID5462310",
            "rtecs_number": "RTECSHL4158550",
            "dot_numbers": 1361,
            "dot_hazard_class": 4.2
        },
        "conductivity": {
            "thermal": 140,
            "electric": 0.1
        },
        "cpk_hex": "909090",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 2260
        },
        "discovered": {
            "year": -3750,
            "by": "Ancient Egypt"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 121.7763,
        "electron_configuration": "1s² 2s² 2p²",
        "electron_configuration_semantic": "[He] 2s² 2p²",
        "electronegativity_pauling": 2.55,
        "electrons_per_shell": [
            2,
            4
        ],
        "energy_levels": "2, 4",
        "group": 14,
        "half_life": "Stable",
        "hardness": {
            "mohs": 0.5
        },
        "heat": {
            "specific": 710,
            "vaporization": 715,
            "fusion": 105,
            "molar": 8.517
        },
        "ionization_energies": [
            1086.5,
            2352.6,
            4620.5,
            6222.7,
            37831,
            47277
        ],
        "isotopes_known": "⁸C, ⁹C, ¹⁰C, ¹¹C, ¹²C, ¹³C, ¹⁴C, ¹⁵C, ¹⁶C, ¹⁷C, ¹⁸C, ¹⁹C, ²⁰C, ²¹C, ²²C",
        "isotopes_stable": "¹²C, ¹³C",
        "isotopic_abundances": "¹²C: 98.93%, ¹³C: 1.07%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "246.4, 246.4, 671.1",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -6.2e-9,
            "molar": -7.45e-11,
            "volume": -0.000014
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 3823,
        "modulus": {
            "bulk": 33
        },
        "molar_volume": 0.0000053146,
        "neutron_cross_section": 0.0035,
        "neutron_mass_absorption": 0.000015,
        "oxidation_states": "-4c,-3,-2,-1,1,2,3,4c",
        "period": 2,
        "phase": "Solid",
        "quantum_numbers": "3P0",
        "radius": {
            "calculated": 67,
            "empirical": 70,
            "covalent": 77,
            "vanderwaals": 170
        },
        "refractive_index": 2.417,
        "resistivity": 0.00001,
        "series": "polyatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Carbon",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 18350,
        "summary": "<p>Carbon (from Latin: carbo \"coal\") is a chemical element with the symbol C and atomic number 6. It is nonmetallic and tetravalent—making four electrons available to form covalent chemical bonds. It belongs to group 14 of the periodic table. Carbon makes up only about 0.025 percent of Earth's crust. Three isotopes occur naturally, 12C and 13C being stable, while 14C is a radionuclide, decaying with a half_life of about 5,730 years. Carbon is one of the few elements known since antiquity.</p><p>Carbon is the 15th most abundant element in the Earth's crust, and the fourth most abundant element in the universe by mass after hydrogen, helium, and oxygen. Carbon's abundance, its unique diversity of organic compounds, and its unusual ability to form polymers at the temperatures commonly encountered on Earth enables this element to serve as a common element of all known life. It is the second most abundant element in the human body by mass (about 18.5%) after oxygen.</p><p>The atoms of carbon can bond together in diverse ways, resulting in various allotropes of carbon. Well-known allotropes include graphite, diamond, amorphous carbon and fullerenes. The physical properties of carbon vary widely with the allotropic form. For example, graphite is opaque and black while diamond is highly transparent. Graphite is soft enough to form a streak on paper (hence its name, from the Greek verb \"γράφειν\" which means \"to write\"), while diamond is the hardest naturally occurring material known. Graphite is a good electrical conductor while diamond has a low electrical conductivity. Under normal conditions, diamond, carbon nanotubes, and graphene have the highest thermal conductivities of all known materials. All carbon allotropes are solids under normal conditions, with graphite being the most thermodynamically stable form at standard temperature and pressure. They are chemically resistant and require high temperature to react even with oxygen.</p><p>The most common oxidation state of carbon in inorganic compounds is +4, while +2 is found in carbon monoxide and transition metal carbonyl complexes. The largest sources of inorganic carbon are limestones, dolomites and carbon dioxide, but significant quantities occur in organic deposits of coal, peat, oil, and methane clathrates. Carbon forms a vast number of compounds, more than any other element, with almost ten million compounds described to date, and yet that number is but a fraction of the number of theoretically possible compounds under standard conditions. For this reason, carbon has often been referred to as the \"king of the elements\".</p>",
        "thermal_expansion": 0.0000071,
        "valence_electrons": 4
    },
    {
        "name": "Nitrogen",
        "symbol": "N",
        "abundance": {
            "universe": 0.1,
            "solar": 0.1,
            "meteor": 0.14,
            "crust": 0.002,
            "ocean": 0.00005,
            "human": 2.6
        },
        "adiabatic_index": "7/5",
        "allotropes": "Dinitrogen",
        "appearance": "colorless gas, liquid or solid",
        "atomic_mass": 14.007,
        "atomic_number": 7,
        "block": "p-block",
        "boiling_point": 77.355,
        "classifications": {
            "cas_number": "CAS7727-37-9",
            "cid_number": "CID947",
            "rtecs_number": "RTECSQW9700000",
            "dot_numbers": 1977,
            "dot_hazard_class": 2.2
        },
        "conductivity": {
            "thermal": 0.02583
        },
        "cpk_hex": "3050f8",
        "critical_pressure": 3.39,
        "critical_temperature": 126.21,
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 1.251
        },
        "discovered": {
            "year": 1772,
            "by": "Daniel Rutherford",
            "location": "The United Kingdom"
        },
        "electron_affinity": -6.8,
        "electron_configuration": "1s² 2s² 2p³",
        "electron_configuration_semantic": "[He] 2s² 2p³",
        "electronegativity_pauling": 3.04,
        "electrons_per_shell": [
            2,
            5
        ],
        "energy_levels": "2, 5",
        "gas_phase": "Diatomic",
        "group": 15,
        "half_life": "Stable",
        "heat": {
            "specific": 1040,
            "vaporization": 2.79,
            "fusion": 0.36
        },
        "ionization_energies": [
            1402.3,
            2856,
            4578.1,
            7475,
            9444.9,
            53266.6,
            64360
        ],
        "isotopes_known": "¹⁰N, ¹¹N, ¹²N, ¹³N, ¹⁴N, ¹⁵N, ¹⁶N, ¹⁷N, ¹⁸N, ¹⁹N, ²⁰N, ²¹N, ²²N, ²³N, ²⁴N, ²⁵N",
        "isotopes_stable": "¹⁴N, ¹⁵N",
        "isotopic_abundances": "¹⁴N: 99.632%, ¹⁵N: 0.368%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "386.1, 386.1, 626.5",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -5.4e-9,
            "molar": -1.5e-10,
            "volume": -6.8e-9
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 63.15,
        "molar_volume": 0.011197,
        "neutron_cross_section": 1.91,
        "neutron_mass_absorption": 0.0048,
        "oxidation_states": "-3c,-2,-1,1,2,3c,4,5c",
        "period": 2,
        "phase": "Gas",
        "quantum_numbers": "4S3/2",
        "radius": {
            "calculated": 56,
            "empirical": 65,
            "covalent": 75,
            "vanderwaals": 155
        },
        "refractive_index": 1.000298,
        "series": "diatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Nitrogen",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 333.6,
        "summary": "<p>Nitrogen is the chemical element with the symbol N and atomic number 7. It was first discovered and isolated by Scottish physician Daniel Rutherford in 1772. Although Carl Wilhelm Scheele and Henry Cavendish had independently done so at about the same time, Rutherford is generally accorded the credit because his work was published first. The name nitrogène was suggested by French chemist Jean-Antoine-Claude Chaptal in 1790 when it was found that nitrogen was present in nitric acid and nitrates. Antoine Lavoisier suggested instead the name azote, from the Ancient Greek: ἀζωτικός \"no life\", as it is an asphyxiant gas; this name is used instead in many languages, such as French, Italian, Russian, Romanian, Portuguese and Turkish, and appears in the English names of some nitrogen compounds such as hydrazine, azides and azo compounds.</p><p>Nitrogen is the lightest member of group 15 of the periodic table, often called the pnictogens. It is a common element in the universe, estimated at about seventh in total abundance in the Milky Way and the Solar System. At standard temperature and pressure, two atoms of the element bind to form dinitrogen, a colourless and odorless diatomic gas with the formula N2. Dinitrogen forms about 78% of Earth's atmosphere, making it the most abundant uncombined element. Nitrogen occurs in all organisms, primarily in amino acids (and thus proteins), in the nucleic acids (DNA and RNA) and in the energy transfer molecule adenosine triphosphate. The human body contains about 3% nitrogen by mass, the fourth most abundant element in the body after oxygen, carbon, and hydrogen. The nitrogen cycle describes movement of the element from the air, into the biosphere and organic compounds, then back into the atmosphere.</p><p>Many industrially important compounds, such as ammonia, nitric acid, organic nitrates (propellants and explosives), and cyanides, contain nitrogen. The extremely strong triple bond in elemental nitrogen (N≡N), the second strongest bond in any diatomic molecule after carbon monoxide (CO), dominates nitrogen chemistry. This causes difficulty for both organisms and industry in converting N2 into useful compounds, but at the same time means that burning, exploding, or decomposing nitrogen compounds to form nitrogen gas releases large amounts of often useful energy. Synthetically produced ammonia and nitrates are key industrial fertilisers, and fertiliser nitrates are key pollutants in the eutrophication of water systems.</p><p>Apart from its use in fertilisers and energy-stores, nitrogen is a constituent of organic compounds as diverse as Kevlar used in high-strength fabric and cyanoacrylate used in superglue. Nitrogen is a constituent of every major pharmacological drug class, including antibiotics. Many drugs are mimics or prodrugs of natural nitrogen-containing signal molecules: for example, the organic nitrates nitroglycerin and nitroprusside control blood pressure by metabolizing into nitric oxide. Many notable nitrogen-containing drugs, such as the natural caffeine and morphine or the synthetic amphetamines, act on receptors of animal neurotransmitters.</p>",
        "valence_electrons": 3
    },
    {
        "name": "Oxygen",
        "symbol": "O",
        "abundance": {
            "universe": 1,
            "solar": 0.9,
            "meteor": 40,
            "crust": 46,
            "ocean": 86,
            "human": 61
        },
        "adiabatic_index": "7/5",
        "allotropes": "Dioxygen, Ozone, Tetraoxygen",
        "atomic_mass": 15.999,
        "atomic_number": 8,
        "block": "p-block",
        "boiling_point": 90.188,
        "classifications": {
            "cas_number": "CAS7782-44-7",
            "cid_number": "CID977",
            "rtecs_number": "RTECSRS2060000",
            "dot_numbers": 1073,
            "dot_hazard_class": 2.2
        },
        "conductivity": {
            "thermal": 0.02658
        },
        "cpk_hex": "ff0d0d",
        "critical_pressure": 5.043,
        "critical_temperature": 154.59,
        "crystal_structure": "Base-centered Monoclinic",
        "density": {
            "stp": 1.429
        },
        "discovered": {
            "year": 1774,
            "by": "Carl Wilhelm Scheele",
            "location": "Sweden and The United Kingdom"
        },
        "electron_affinity": 140.976,
        "electron_configuration": "1s² 2s² 2p⁴",
        "electron_configuration_semantic": "[He] 2s² 2p⁴",
        "electronegativity_pauling": 3.44,
        "electrons_per_shell": [
            2,
            6
        ],
        "energy_levels": "2, 6",
        "gas_phase": "Diatomic",
        "group": 16,
        "half_life": "Stable",
        "heat": {
            "specific": 919,
            "vaporization": 3.41,
            "fusion": 0.222
        },
        "ionization_energies": [
            1313.9,
            3388.3,
            5300.5,
            7469.2,
            10989.5,
            13326.5,
            71330,
            84078
        ],
        "isotopes_known": "¹²O, ¹³O, ¹⁴O, ¹⁵O, ¹⁶O, ¹⁷O, ¹⁸O, ¹⁹O, ²⁰O, ²¹O, ²²O, ²³O, ²⁴O, ²⁵O, ²⁶O, ²⁷O, ²⁸O",
        "isotopes_stable": "¹⁶O, ¹⁷O, ¹⁸O",
        "isotopic_abundances": "¹⁶O: 99.757%, ¹⁷O: 0.038%, ¹⁸O: 0.205%",
        "lattice_angles": "π/2, 2.313085, π/2",
        "lattice_constants": "540.3, 342.9, 508.6",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 0.000001335,
            "molar": 4.27184e-8,
            "volume": 0.00000190772
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 54.36,
        "molar_volume": 0.011196,
        "neutron_cross_section": 0.00028,
        "neutron_mass_absorption": 0.000001,
        "oxidation_states": "-2c,-1,1,2",
        "period": 2,
        "phase": "Gas",
        "quantum_numbers": "3P2",
        "radius": {
            "calculated": 48,
            "empirical": 60,
            "covalent": 73,
            "vanderwaals": 152
        },
        "refractive_index": 1.000271,
        "series": "diatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Oxygen",
        "space_group_name": "C12/m1",
        "space_group_number": 12,
        "speed_of_sound": 317.5,
        "summary": "<p>Oxygen is the chemical element with the symbol O and atomic number 8. It is a member of the chalcogen group in the periodic table, a highly reactive nonmetal, and an oxidizing agent that readily forms oxides with most elements as well as with other compounds. Oxygen is Earth's most abundant element, and after hydrogen and helium, it is the third-most abundant element in the universe. At standard temperature and pressure, two atoms of the element bind to form dioxygen, a colorless and odorless diatomic gas with the formula O2. Diatomic oxygen gas currently constitutes 20.95% of the Earth's atmosphere, though this has changed considerably over long periods of time. Oxygen makes up almost half of the Earth's crust in the form of oxides.</p><p>Dioxygen provides the energy released in combustion and aerobic cellular respiration, and many major classes of organic molecules in living organisms contain oxygen atoms, such as proteins, nucleic acids, carbohydrates, and fats, as do the major constituent inorganic compounds of animal shells, teeth, and bone. Most of the mass of living organisms is oxygen as a component of water, the major constituent of lifeforms. Oxygen is continuously replenished in Earth's atmosphere by photosynthesis, which uses the energy of sunlight to produce oxygen from water and carbon dioxide. Oxygen is too chemically reactive to remain a free element in air without being continuously replenished by the photosynthetic action of living organisms. Another form (allotrope) of oxygen, ozone (O3), strongly absorbs ultraviolet UVB radiation and the high-altitude ozone layer helps protect the biosphere from ultraviolet radiation. However, ozone present at the surface is a byproduct of smog and thus a pollutant.</p><p>Oxygen was isolated by Michael Sendivogius before 1604, but it is commonly believed that the element was discovered independently by Carl Wilhelm Scheele, in Uppsala, in 1773 or earlier, and Joseph Priestley in Wiltshire, in 1774. Priority is often given for Priestley because his work was published first. Priestley, however, called oxygen \"dephlogisticated air\", and did not recognize it as a chemical element. The name oxygen was coined in 1777 by Antoine Lavoisier, who first recognized oxygen as a chemical element and correctly characterized the role it plays in combustion.</p><p>Common uses of oxygen include production of steel, plastics and textiles, brazing, welding and cutting of steels and other metals, rocket propellant, oxygen therapy, and life support systems in aircraft, submarines, spaceflight and diving.</p>",
        "valence_electrons": 2
    },
    {
        "name": "Fluorine",
        "symbol": "F",
        "abundance": {
            "universe": 0.00004,
            "solar": 0.00005,
            "meteor": 0.0087,
            "crust": 0.054,
            "ocean": 0.00013,
            "human": 0.0037
        },
        "adiabatic_index": "7/5",
        "allotropes": "Difluorine",
        "atomic_mass": 18.9984031636,
        "atomic_number": 9,
        "block": "p-block",
        "boiling_point": 85.03,
        "classifications": {
            "cas_number": "CAS7782-41-4",
            "cid_number": "CID24524",
            "rtecs_number": "RTECSLM6475000",
            "dot_numbers": 9192,
            "dot_hazard_class": 2.3
        },
        "conductivity": {
            "thermal": 0.0277
        },
        "cpk_hex": "90e050",
        "critical_pressure": 5.172,
        "critical_temperature": 144.13,
        "crystal_structure": "Base-centered Monoclinic",
        "density": {
            "stp": 1.696
        },
        "discovered": {
            "year": 1886,
            "by": "André-Marie Ampère",
            "location": "France"
        },
        "electron_affinity": 328.1649,
        "electron_configuration": "1s² 2s² 2p⁵",
        "electron_configuration_semantic": "[He] 2s² 2p⁵",
        "electronegativity_pauling": 3.98,
        "electrons_per_shell": [
            2,
            7
        ],
        "energy_levels": "2, 7",
        "gas_phase": "Diatomic",
        "group": 17,
        "half_life": "Stable",
        "heat": {
            "specific": 824,
            "vaporization": 3.27,
            "fusion": 0.26
        },
        "ionization_energies": [
            1681,
            3374.2,
            6050.4,
            8407.7,
            11022.7,
            15164.1,
            17868,
            92038.1,
            106434.3
        ],
        "isotopes_known": "¹⁴F, ¹⁵F, ¹⁶F, ¹⁷F, ¹⁸F, ¹⁹F, ²⁰F, ²¹F, ²²F, ²³F, ²⁴F, ²⁵F, ²⁶F, ²⁷F, ²⁸F, ²⁹F, ³⁰F, ³¹F",
        "isotopes_stable": "¹⁹F",
        "isotopic_abundances": "¹⁹F: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "550, 328, 728",
        "lifetime": "Stable",
        "melting_point": 53.48,
        "molar_volume": 0.011202,
        "neutron_cross_section": 0.0096,
        "neutron_mass_absorption": 0.00002,
        "oxidation_states": "-1c",
        "period": 2,
        "phase": "Gas",
        "quantum_numbers": "2P3/2",
        "radius": {
            "calculated": 42,
            "empirical": 50,
            "covalent": 71,
            "vanderwaals": 147
        },
        "refractive_index": 1.000195,
        "series": "diatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Fluorine",
        "space_group_name": "C12/c1",
        "space_group_number": 15,
        "summary": "<p>Fluorine is a chemical element with the symbol F and atomic number 9. It is the lightest halogen and exists at standard conditions as a highly toxic, pale yellow diatomic gas. As the most electronegative element, it is extremely reactive, as it reacts with all other elements, except for argon, neon, and helium.</p><p>Among the elements, fluorine ranks 24th in universal abundance and 13th in terrestrial abundance. Fluorite, the primary mineral source of fluorine which gave the element its name, was first described in 1529; as it was added to metal ores to lower their melting points for smelting, the Latin verb fluo meaning \"flow\" gave the mineral its name. Proposed as an element in 1810, fluorine proved difficult and dangerous to separate from its compounds, and several early experimenters died or sustained injuries from their attempts. Only in 1886 did French chemist Henri Moissan isolate elemental fluorine using low-temperature electrolysis, a process still employed for modern production. Industrial production of fluorine gas for uranium enrichment, its largest application, began during the Manhattan Project in World War II.</p><p>Owing to the expense of refining pure fluorine, most commercial applications use fluorine compounds, with about half of mined fluorite used in steelmaking. The rest of the fluorite is converted into corrosive hydrogen fluoride en route to various organic fluorides, or into cryolite, which plays a key role in aluminium refining. Molecules containing a carbon–fluorine bond often have very high chemical and thermal stability; their major uses are as refrigerants, electrical insulation and cookware, the last as PTFE (Teflon). Pharmaceuticals such as atorvastatin and fluoxetine contain C−F bonds. The fluoride ion from dissolved fluoride salts inhibits dental cavities, and so finds use in toothpaste and water fluoridation. Global fluorochemical sales amount to more than US$15 billion a year.</p><p>Fluorocarbon gases are generally greenhouse gases with global-warming potentials 100 to 23,500 times that of carbon dioxide, SF6 having the highest global warming potential of any known substance. Organofluorine compounds often persist in the environment due to the strength of the carbon–fluorine bond. Fluorine has no known metabolic role in mammals; a few plants and sea sponges synthesize organofluorine poisons (most often monofluoroacetates) that help deter predation.</p>",
        "valence_electrons": 1
    },
    {
        "name": "Neon",
        "symbol": "Ne",
        "abundance": {
            "universe": 0.13,
            "solar": 0.1,
            "crust": 3e-7,
            "ocean": 1.2e-8
        },
        "adiabatic_index": "5/3",
        "appearance": "colorless gas exhibiting an orange-red glow when placed in a high voltage electric field",
        "atomic_mass": 20.17976,
        "atomic_number": 10,
        "block": "p-block",
        "boiling_point": 27.104,
        "classifications": {
            "cas_number": "CAS7440-01-9",
            "cid_number": "CID23935",
            "rtecs_number": "RTECSQP4450000",
            "dot_numbers": 1913,
            "dot_hazard_class": 2.2
        },
        "conductivity": {
            "thermal": 0.0491
        },
        "cpk_hex": "b3e3f5",
        "critical_pressure": 2.76,
        "critical_temperature": 44.4,
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 0.9
        },
        "discovered": {
            "year": 1898,
            "by": "Morris Travers",
            "location": "The United Kingdom"
        },
        "electron_affinity": -116,
        "electron_configuration": "1s² 2s² 2p⁶",
        "electron_configuration_semantic": "[He] 2s² 2p⁶",
        "electrons_per_shell": [
            2,
            8
        ],
        "energy_levels": "2, 8",
        "gas_phase": "Monoatomic",
        "group": 18,
        "half_life": "Stable",
        "heat": {
            "specific": 1030,
            "vaporization": 1.75,
            "fusion": 0.34
        },
        "ionization_energies": [
            2080.7,
            3952.3,
            6122,
            9371,
            12177,
            15238,
            19999,
            23069.5,
            115379.5,
            131432
        ],
        "isotopes_known": "¹⁶Ne, ¹⁷Ne, ¹⁸Ne, ¹⁹Ne, ²⁰Ne, ²¹Ne, ²²Ne, ²³Ne, ²⁴Ne, ²⁵Ne, ²⁶Ne, ²⁷Ne, ²⁸Ne, ²⁹Ne, ³⁰Ne, ³¹Ne, ³²Ne, ³³Ne, ³⁴Ne",
        "isotopes_stable": "²⁰Ne, ²¹Ne, ²²Ne",
        "isotopic_abundances": "²⁰Ne: 90.48%, ²¹Ne: 0.27%, ²²Ne: 9.25%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "442.9, 442.9, 442.9",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -4.1e-9,
            "molar": -8.27e-11,
            "volume": -3.69e-9
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 24.56,
        "molar_volume": 0.02242,
        "neutron_cross_section": 0.04,
        "neutron_mass_absorption": 0.00059,
        "period": 2,
        "phase": "Gas",
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 38,
            "covalent": 69,
            "vanderwaals": 154
        },
        "refractive_index": 1.000067,
        "series": "noble gas",
        "source": "https://en.wikipedia.org/wiki/Neon",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 936,
        "summary": "<p>Neon is a chemical element with the symbol Ne and atomic number 10. It is a noble gas. Neon is a colorless, odorless, inert monatomic gas under standard conditions, with about two-thirds the density of air. It was discovered (along with krypton and xenon) in 1898 as one of the three residual rare inert elements remaining in dry air, after nitrogen, oxygen, argon and carbon dioxide were removed. Neon was the second of these three rare gases to be discovered and was immediately recognized as a new element from its bright red emission spectrum. The name neon is derived from the Greek word, νέον, neuter singular form of νέος (neos), meaning new. Neon is chemically inert, and no uncharged neon compounds are known. The compounds of neon currently known include ionic molecules, molecules held together by van der Waals forces and clathrates.</p><p>During cosmic nucleogenesis of the elements, large amounts of neon are built up from the alpha-capture fusion process in stars. Although neon is a very common element in the universe and solar system (it is fifth in cosmic abundance after hydrogen, helium, oxygen and carbon), it is rare on Earth. It composes about 18.2 ppm of air by volume (this is about the same as the molecular or mole fraction) and a smaller fraction in Earth's crust. The reason for neon's relative scarcity on Earth and the inner (terrestrial) planets is that neon is highly volatile and forms no compounds to fix it to solids. As a result, it escaped from the planetesimals under the warmth of the newly ignited Sun in the early Solar System. Even the outer atmosphere of Jupiter is somewhat depleted of neon, although for a different reason.</p><p>Neon gives a distinct reddish-orange glow when used in low-voltage neon glow lamps, high-voltage discharge tubes and neon advertising signs. The red emission line from neon also causes the well known red light of helium–neon lasers. Neon is used in some plasma tube and refrigerant applications but has few other commercial uses. It is commercially extracted by the fractional distillation of liquid air. Since air is the only source, it is considerably more expensive than helium.</p>",
        "valence_electrons": 0
    },
    {
        "name": "Sodium",
        "symbol": "Na",
        "abundance": {
            "universe": 0.002,
            "solar": 0.004,
            "meteor": 0.55,
            "crust": 2.3,
            "ocean": 1.1,
            "human": 0.14
        },
        "alternate_names": "Natrium",
        "appearance": "silvery white metallic",
        "atomic_mass": 22.989769282,
        "atomic_number": 11,
        "block": "s-block",
        "boiling_point": 1156.09,
        "classifications": {
            "cas_number": "CAS7440-23-5",
            "cid_number": "CID5360545",
            "rtecs_number": "RTECSVY0686000",
            "dot_numbers": 1428,
            "dot_hazard_class": 4.3
        },
        "conductivity": {
            "thermal": 140,
            "electric": 21
        },
        "cpk_hex": "ab5cf2",
        "critical_pressure": 35,
        "critical_temperature": 2573,
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 968,
            "liquid": 927
        },
        "discovered": {
            "year": 1807,
            "by": "Humphry Davy",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 52.867,
        "electron_configuration": "1s² 2s² 2p⁶ 3s¹",
        "electron_configuration_semantic": "[Ne] 3s¹",
        "electronegativity_pauling": 0.93,
        "electrons_per_shell": [
            2,
            8,
            1
        ],
        "energy_levels": "2, 8, 1",
        "group": 1,
        "half_life": "Stable",
        "hardness": {
            "brinell": 0.69,
            "mohs": 0.5
        },
        "heat": {
            "specific": 1230,
            "vaporization": 97.7,
            "fusion": 2.6,
            "molar": 28.23
        },
        "ionization_energies": [
            495.8,
            4562,
            6910.3,
            9543,
            13354,
            16613,
            20117,
            25496,
            28932,
            141362,
            159076
        ],
        "isotopes_known": "¹⁸Na, ¹⁹Na, ²⁰Na, ²¹Na, ²²Na, ²³Na, ²⁴Na, ²⁵Na, ²⁶Na, ²⁷Na, ²⁸Na, ²⁹Na, ³⁰Na, ³¹Na, ³²Na, ³³Na, ³⁴Na, ³⁵Na, ³⁶Na, ³⁷Na",
        "isotopes_stable": "²³Na",
        "isotopic_abundances": "²³Na: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "429.06, 429.06, 429.06",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 8.8e-9,
            "molar": 2e-10,
            "volume": 0.0000086
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 370.944,
        "modulus": {
            "bulk": 6.3,
            "shear": 3.3,
            "young": 10
        },
        "molar_volume": 0.00002375,
        "neutron_cross_section": 0.53,
        "neutron_mass_absorption": 0.0007,
        "oxidation_states": "-1,1c",
        "period": 3,
        "phase": "Solid",
        "quantum_numbers": "2S1/2",
        "radius": {
            "calculated": 190,
            "empirical": 180,
            "covalent": 154,
            "vanderwaals": 227
        },
        "resistivity": 4.699999999998e-8,
        "series": "alkali metal",
        "source": "https://en.wikipedia.org/wiki/Sodium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 3200,
        "summary": "<p>Sodium is a chemical element with the symbol Na (from Latin natrium) and atomic number 11. It is a soft, silvery-white, highly reactive metal. Sodium is an alkali metal, being in group 1 of the periodic table. Its only stable isotope is 23Na. The free metal does not occur in nature, and must be prepared from compounds. Sodium is the sixth most abundant element in the Earth's crust and exists in numerous minerals such as feldspars, sodalite, and rock salt (NaCl). Many salts of sodium are highly water-soluble: sodium ions have been leached by the action of water from the Earth's minerals over eons, and thus sodium and chlorine are the most common dissolved elements by weight in the oceans.</p><p>Sodium was first isolated by Humphry Davy in 1807 by the electrolysis of sodium hydroxide. Among many other useful sodium compounds, sodium hydroxide (lye) is used in soap manufacture, and sodium chloride (edible salt) is a de-icing agent and a nutrient for animals including humans.</p><p>Sodium is an essential element for all animals and some plants. Sodium ions are the major cation in the extracellular fluid (ECF) and as such are the major contributor to the ECF osmotic pressure and ECF compartment volume. Loss of water from the ECF compartment increases the sodium concentration, a condition called hypernatremia. Isotonic loss of water and sodium from the ECF compartment decreases the size of that compartment in a condition called ECF hypovolemia.</p><p>By means of the sodium-potassium pump, living human cells pump three sodium ions out of the cell in exchange for two potassium ions pumped in; comparing ion concentrations across the cell membrane, inside to outside, potassium measures about 40:1, and sodium, about 1:10. In nerve cells, the electrical charge across the cell membrane enables transmission of the nerve impulse—an action potential—when the charge is dissipated; sodium plays a key role in that activity.</p>",
        "thermal_expansion": 0.00007,
        "valence_electrons": 1
    },
    {
        "name": "Magnesium",
        "symbol": "Mg",
        "abundance": {
            "universe": 0.06,
            "solar": 0.07,
            "meteor": 12,
            "crust": 2.9,
            "ocean": 0.13,
            "human": 0.027
        },
        "appearance": "shiny grey solid",
        "atomic_mass": 24.305,
        "atomic_number": 12,
        "block": "s-block",
        "boiling_point": 1363,
        "classifications": {
            "cas_number": "CAS7439-95-4",
            "cid_number": "CID5462224",
            "dot_numbers": 2950,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 160,
            "electric": 23
        },
        "cpk_hex": "8aff00",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 1738,
            "liquid": 1584
        },
        "discovered": {
            "year": 1755,
            "by": "Joseph Black",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": -40,
        "electron_configuration": "1s² 2s² 2p⁶ 3s²",
        "electron_configuration_semantic": "[Ne] 3s²",
        "electronegativity_pauling": 1.31,
        "electrons_per_shell": [
            2,
            8,
            2
        ],
        "energy_levels": "2, 8, 2",
        "group": 2,
        "half_life": "Stable",
        "hardness": {
            "brinell": 260,
            "mohs": 2.5
        },
        "heat": {
            "specific": 1020,
            "vaporization": 128,
            "fusion": 8.7,
            "molar": 24.869
        },
        "ionization_energies": [
            737.7,
            1450.7,
            7732.7,
            10542.5,
            13630,
            18020,
            21711,
            25661,
            31653,
            35458,
            169988,
            189368
        ],
        "isotopes_known": "¹⁹Mg, ²⁰Mg, ²¹Mg, ²²Mg, ²³Mg, ²⁴Mg, ²⁵Mg, ²⁶Mg, ²⁷Mg, ²⁸Mg, ²⁹Mg, ³⁰Mg, ³¹Mg, ³²Mg, ³³Mg, ³⁴Mg, ³⁵Mg, ³⁶Mg, ³⁷Mg, ³⁸Mg, ³⁹Mg, ⁴⁰Mg",
        "isotopes_stable": "²⁴Mg, ²⁵Mg, ²⁶Mg",
        "isotopic_abundances": "²⁴Mg: 78.99%, ²⁵Mg: 10%, ²⁶Mg: 11.01%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "320.94, 320.94, 521.08",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 6.9e-9,
            "molar": 1.68e-10,
            "volume": 0.000012
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 923,
        "modulus": {
            "bulk": 45,
            "shear": 17,
            "young": 45
        },
        "molar_volume": 0.000013984,
        "neutron_cross_section": 0.063,
        "neutron_mass_absorption": 0.0001,
        "oxidation_states": "1,2c",
        "period": 3,
        "phase": "Solid",
        "poisson_ratio": 0.29,
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 145,
            "empirical": 150,
            "covalent": 130,
            "vanderwaals": 173
        },
        "resistivity": 4.399999999999e-8,
        "series": "alkaline earth metal",
        "source": "https://en.wikipedia.org/wiki/Magnesium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 4602,
        "summary": "<p>Magnesium is a chemical element with the symbol Mg and atomic number 12. It is a shiny gray solid which bears a close physical resemblance to the other five elements in the second column (group 2, or alkaline earth metals) of the periodic table: all group 2 elements have the same electron configuration in the outer electron shell and a similar crystal structure.</p><p>This element is produced in large, aging stars from the sequential addition of three helium nuclei to a carbon nucleus. When such stars explode as supernovas, much of the magnesium is expelled into the interstellar medium where it may recycle into new star systems. Magnesium is the eighth most abundant element in the Earth's crust and the fourth most common element in the Earth (after iron, oxygen and silicon), making up 13% of the planet's mass and a large fraction of the planet's mantle. It is the third most abundant element dissolved in seawater, after sodium and chlorine.</p><p>Magnesium occurs naturally only in combination with other elements, where it invariably has a +2 oxidation state. The free element (metal) can be produced artificially, and is highly reactive (though in the atmosphere it is soon coated in a thin layer of oxide that partly inhibits reactivity – see passivation). The free metal burns with a characteristic brilliant-white light. The metal is now obtained mainly by electrolysis of magnesium salts obtained from brine, and is used primarily as a component in aluminium-magnesium alloys, sometimes called magnalium or magnelium. Magnesium is less dense than aluminium, and the alloy is prized for its combination of lightness and strength.</p><p>This element is the eleventh most abundant element by mass in the human body and is essential to all cells and some 300 enzymes. Magnesium ions interact with polyphosphate compounds such as ATP, DNA, and RNA. Hundreds of enzymes require magnesium ions to function. Magnesium compounds are used medicinally as common laxatives, antacids (e.g., milk of magnesia), and to stabilize abnormal nerve excitation or blood vessel spasm in such conditions as eclampsia.</p>",
        "thermal_expansion": 0.0000248,
        "valence_electrons": 2
    },
    {
        "name": "Aluminium",
        "symbol": "Al",
        "abundance": {
            "universe": 0.005,
            "solar": 0.006,
            "meteor": 0.91,
            "crust": 8.1,
            "ocean": 5e-7,
            "human": 0.00009
        },
        "alternate_names": "Aluminium",
        "appearance": "silvery gray metallic",
        "atomic_mass": 26.98153857,
        "atomic_number": 13,
        "block": "p-block",
        "boiling_point": 2743,
        "classifications": {
            "cas_number": "CAS7429-90-5",
            "cid_number": "CID5359268",
            "rtecs_number": "RTECSBD0330000",
            "dot_numbers": 1396,
            "dot_hazard_class": 4.3
        },
        "conductivity": {
            "thermal": 235,
            "electric": 38
        },
        "cpk_hex": "bfa6a6",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 2700,
            "liquid": 2375
        },
        "discovered": {
            "year": 1825,
            "location": "Denmark"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 41.762,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p¹",
        "electron_configuration_semantic": "[Ne] 3s² 3p¹",
        "electronegativity_pauling": 1.61,
        "electrons_per_shell": [
            2,
            8,
            3
        ],
        "energy_levels": "2, 8, 3",
        "group": 13,
        "half_life": "Stable",
        "hardness": {
            "vickers": 167,
            "brinell": 245,
            "mohs": 2.75
        },
        "heat": {
            "specific": 904,
            "vaporization": 293,
            "fusion": 10.7,
            "molar": 24.2
        },
        "ionization_energies": [
            577.5,
            1816.7,
            2744.8,
            11577,
            14842,
            18379,
            23326,
            27465,
            31853,
            38473,
            42647,
            201266,
            222316
        ],
        "isotopes_known": "²¹Al, ²²Al, ²³Al, ²⁴Al, ²⁵Al, ²⁶Al, ²⁷Al, ²⁸Al, ²⁹Al, ³⁰Al, ³¹Al, ³²Al, ³³Al, ³⁴Al, ³⁵Al, ³⁶Al, ³⁷Al, ³⁸Al, ³⁹Al, ⁴⁰Al, ⁴¹Al, ⁴²Al",
        "isotopes_stable": "²⁷Al",
        "isotopic_abundances": "²⁷Al: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "404.95, 404.95, 404.95",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 7.8e-9,
            "molar": 2.1e-10,
            "volume": 0.0000211
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 933.47,
        "modulus": {
            "bulk": 76,
            "shear": 26,
            "young": 70
        },
        "molar_volume": 0.00000999,
        "neutron_cross_section": 0.233,
        "neutron_mass_absorption": 0.03,
        "oxidation_states": "1,2,3c",
        "period": 3,
        "phase": "Solid",
        "poisson_ratio": 0.35,
        "quantum_numbers": "2P1/2",
        "radius": {
            "calculated": 118,
            "empirical": 125,
            "covalent": 118
        },
        "resistivity": 2.6e-8,
        "series": "post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Aluminium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 5100,
        "summary": "<p>Aluminium (Aluminium in American and Canadian English) is a chemical element with the symbol Al and atomic number 13. Aluminium has a density lower than those of other common metals, at approximately one third that of steel. It has a great affinity towards oxygen, and forms a protective layer of oxide on the surface when exposed to air. Aluminium visually resembles silver, both in its color and in its great ability to reflect light. It is soft, non-magnetic and ductile. It has one stable isotope, 27Al; this isotope is very common, making aluminium the twelfth most common element in the Universe. The radioactivity of 26Al is used in radiodating.</p><p>Chemically, aluminium is a weak metal in the boron group; as is common for the group, aluminium forms compounds primarily in the +3 oxidation state. The aluminium cation Al3+ is small and highly charged; as such, it is polarizing, and bonds aluminium forms tend towards covalency. The strong affinity towards oxygen leads to aluminium's common association with oxygen in nature in the form of oxides; for this reason, aluminium is found on Earth primarily in rocks in the crust, where it is the third most abundant element after oxygen and silicon, rather than in the mantle, and virtually never as the free metal.</p><p>The discovery of aluminium was announced in 1825 by Danish physicist Hans Christian Ørsted. The first industrial production of aluminium was initiated by French chemist Henri Étienne Sainte-Claire Deville in 1856. Aluminium became much more available to the public with the Hall–Héroult process developed independently by French engineer Paul Héroult and American engineer Charles Martin Hall in 1886, and the mass production of aluminium led to its extensive use in industry and everyday life. In World Wars I and II, aluminium was a crucial strategic resource for aviation. In 1954, aluminium became the most produced non-ferrous metal, surpassing copper. In the 21st century, most aluminium was consumed in transportation, engineering, construction, and packaging in the United States, Western Europe, and Japan.</p><p>Despite its prevalence in the environment, no living organism is known to use aluminium salts metabolically, but aluminium is well tolerated by plants and animals. Because of the abundance of these salts, the potential for a biological role for them is of continuing interest, and studies continue.</p>",
        "superconducting_point": 1.175,
        "thermal_expansion": 0.0000231,
        "valence_electrons": 3
    },
    {
        "name": "Silicon",
        "symbol": "Si",
        "abundance": {
            "universe": 0.07,
            "solar": 0.09,
            "meteor": 14,
            "crust": 27,
            "ocean": 0.0001,
            "human": 0.026
        },
        "appearance": "crystalline, reflective with bluish-tinged faces",
        "atomic_mass": 28.085,
        "atomic_number": 14,
        "block": "p-block",
        "boiling_point": 3538,
        "classifications": {
            "cas_number": "CAS7440-21-3",
            "cid_number": "CID5461123",
            "rtecs_number": "RTECSVW0400000",
            "dot_numbers": 1346,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 150,
            "electric": 0.001
        },
        "cpk_hex": "f0c8a0",
        "crystal_structure": "Tetrahedral Packing",
        "density": {
            "stp": 2330,
            "liquid": 2570
        },
        "discovered": {
            "year": 1824,
            "by": "Jöns Jacob Berzelius",
            "location": "Sweden"
        },
        "electrical_type": "Semiconductor",
        "electron_affinity": 134.0684,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p²",
        "electron_configuration_semantic": "[Ne] 3s² 3p²",
        "electronegativity_pauling": 1.9,
        "electrons_per_shell": [
            2,
            8,
            4
        ],
        "energy_levels": "2, 8, 4",
        "group": 14,
        "half_life": "Stable",
        "hardness": {
            "mohs": 6.5
        },
        "heat": {
            "specific": 710,
            "vaporization": 359,
            "fusion": 50.2,
            "molar": 19.789
        },
        "ionization_energies": [
            786.5,
            1577.1,
            3231.6,
            4355.5,
            16091,
            19805,
            23780,
            29287,
            33878,
            38726,
            45962,
            50502,
            235196,
            257923
        ],
        "isotopes_known": "²²Si, ²³Si, ²⁴Si, ²⁵Si, ²⁶Si, ²⁷Si, ²⁸Si, ²⁹Si, ³⁰Si, ³¹Si, ³²Si, ³³Si, ³⁴Si, ³⁵Si, ³⁶Si, ³⁷Si, ³⁸Si, ³⁹Si, ⁴⁰Si, ⁴¹Si, ⁴²Si, ⁴³Si, ⁴⁴Si",
        "isotopes_stable": "²⁸Si, ²⁹Si, ³⁰Si",
        "isotopic_abundances": "²⁸Si: 92.2297%, ²⁹Si: 4.6832%, ³⁰Si: 3.0872%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "543.09, 543.09, 543.09",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -1.6e-9,
            "molar": -4.49e-11,
            "volume": -0.00000373
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 1687,
        "modulus": {
            "bulk": 100,
            "young": 47
        },
        "molar_volume": 0.000012054,
        "neutron_cross_section": 0.166,
        "neutron_mass_absorption": 0.0002,
        "oxidation_states": "-4c,-3,-2,-1,1,2,3,4c",
        "period": 3,
        "phase": "Solid",
        "quantum_numbers": "3P0",
        "radius": {
            "calculated": 111,
            "empirical": 110,
            "covalent": 111,
            "vanderwaals": 210
        },
        "resistivity": 0.001,
        "series": "metalloid",
        "source": "https://en.wikipedia.org/wiki/Silicon",
        "space_group_name": "Fd_3m",
        "space_group_number": 227,
        "speed_of_sound": 2200,
        "summary": "<p>Silicon is a chemical element with the symbol Si and atomic number 14. It is a hard, brittle crystalline solid with a blue-grey metallic lustre, and is a tetravalent metalloid and semiconductor. It is a member of group 14 in the periodic table: carbon is above it; and germanium, tin, lead, and flerovium are below it. It is relatively unreactive. Because of its high chemical affinity for oxygen, it was not until 1823 that Jöns Jakob Berzelius was first able to prepare it and characterize it in pure form. Its oxides form a family of anions known as silicates. Its melting and boiling points of 1414 °C and 3265 °C, respectively, are the second highest among all the metalloids and nonmetals, being surpassed only by boron. Silicon is the eighth most common element in the universe by mass, but very rarely occurs as the pure element in the Earth's crust. It is most widely distributed in space in cosmic dusts, planetoids, and planets as various forms of silicon dioxide (silica) or silicates. More than 90% of the Earth's crust is composed of silicate minerals, making silicon the second most abundant element in the Earth's crust (about 28% by mass), after oxygen. Silicon is a natural element, and when not previously present has a residence time of about 400 years in the world's oceans.</p><p>Most silicon is used commercially without being separated, and often with very little processing of the natural minerals. Such use includes industrial construction with clays, silica sand, and stone. Silicates are used in Portland cement for mortar and stucco, and mixed with silica sand and gravel to make concrete for walkways, foundations, and roads. They are also used in whiteware ceramics such as porcelain, and in traditional silicate-based soda-lime glass and many other specialty glasses. Silicon compounds such as silicon carbide are used as abrasives and components of high-strength ceramics. Silicon is the basis of the widely used synthetic polymers called silicones.</p><p>The late 20th century to early 21st century has been described as the Silicon Age (also known as the Digital Age or Information Age) due to elemental silicon having a large impact on the modern world economy. The relatively small portion of very highly purified elemental silicon used in semiconductor electronics (&lt; 10%) is essential to the metal–oxide–semiconductor (MOS) transistors and integrated circuit chips used in most modern technology (such as computers and cell phones, for example). The most widely used silicon device is the MOSFET (metal–oxide–semiconductor field-effect transistor), which has been manufactured in larger numbers than any other device in history. Free silicon is also used in the steel refining, aluminium-casting, and fine chemical industries (often to make fumed silica).</p><p>Silicon is an essential element in biology, although only traces are required by animals. However, various sea sponges and microorganisms, such as diatoms and radiolaria, secrete skeletal structures made of silica. Silica is deposited in many plant tissues.</p>",
        "thermal_expansion": 0.0000026,
        "valence_electrons": 4
    },
    {
        "name": "Phosphorus",
        "symbol": "P",
        "abundance": {
            "universe": 0.0007,
            "solar": 0.0007,
            "meteor": 0.11,
            "crust": 0.099,
            "ocean": 0.000007,
            "human": 1.1
        },
        "allotropes": "White Phosphorus, Red Phosphorus, Black Phosphorus",
        "appearance": "colourless, waxy white, yellow, scarlet, red, violet, black",
        "atomic_mass": 30.9737619985,
        "atomic_number": 15,
        "block": "p-block",
        "boiling_point": 553.6,
        "classifications": {
            "cas_number": "CAS7723-14-0",
            "cid_number": "CID5462309",
            "rtecs_number": "RTECSTH3495000",
            "dot_numbers": "1338, 1381, 2447",
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 0.236,
            "electric": 10
        },
        "cpk_hex": "ff8000",
        "crystal_structure": "Simple Triclinic",
        "density": {
            "stp": 1823
        },
        "discovered": {
            "year": 1669,
            "by": "Hennig Brand",
            "location": "Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 72.037,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p³",
        "electron_configuration_semantic": "[Ne] 3s² 3p³",
        "electronegativity_pauling": 2.19,
        "electrons_per_shell": [
            2,
            8,
            5
        ],
        "energy_levels": "2, 8, 5",
        "group": 15,
        "half_life": "Stable",
        "heat": {
            "specific": 769.7,
            "vaporization": 12.4,
            "fusion": 0.64,
            "molar": 23.824
        },
        "ionization_energies": [
            1011.8,
            1907,
            2914.1,
            4963.6,
            6273.9,
            21267,
            25431,
            29872,
            35905,
            40950,
            46261,
            54110,
            59024,
            271791,
            296195
        ],
        "isotopes_known": "²⁴P, ²⁵P, ²⁶P, ²⁷P, ²⁸P, ²⁹P, ³⁰P, ³¹P, ³²P, ³³P, ³⁴P, ³⁵P, ³⁶P, ³⁷P, ³⁸P, ³⁹P, ⁴⁰P, ⁴¹P, ⁴²P, ⁴³P, ⁴⁴P, ⁴⁵P, ⁴⁶P",
        "isotopes_stable": "³¹P",
        "isotopic_abundances": "³¹P: 100%",
        "lattice_angles": "1.25384, 1.57725, 1.24896",
        "lattice_constants": "1145, 550.3, 1126.1",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -1.13e-8,
            "molar": -3.5e-10,
            "volume": -0.0000206
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 317.3,
        "modulus": {
            "bulk": 11
        },
        "molar_volume": 0.000016991,
        "neutron_cross_section": 0.18,
        "neutron_mass_absorption": 0.0002,
        "oxidation_states": "-3c,-2,-1,1,2,3c,4,5c",
        "period": 3,
        "phase": "Solid",
        "quantum_numbers": "4S3/2",
        "radius": {
            "calculated": 98,
            "empirical": 100,
            "covalent": 106,
            "vanderwaals": 180
        },
        "refractive_index": 1.001212,
        "resistivity": 1e-7,
        "series": "polyatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Phosphorus",
        "space_group_name": "P-1",
        "space_group_number": 2,
        "summary": "<p>Phosphorus is a chemical element with the symbol P and atomic number 15. Elemental phosphorus exists in two major forms, white phosphorus and red phosphorus, but because it is highly reactive, phosphorus is never found as a free element on Earth. It has a concentration in the Earth's crust of about one gram per kilogram (compare copper at about 0.06 grams). In minerals, phosphorus generally occurs as phosphate.</p><p>Elemental phosphorus was first isolated as white phosphorus in 1669. White phosphorus emits a faint glow when exposed to oxygen – hence the name, taken from Greek mythology, Φωσφόρος meaning \"light-bearer\" (Latin Lucifer), referring to the \"Morning Star\", the planet Venus. The term \"phosphorescence\", meaning glow after illumination, derives from this property of phosphorus, although the word has since been used for a different physical process that produces a glow. The glow of phosphorus is caused by oxidation of the white (but not red) phosphorus — a process now called chemiluminescence. Together with nitrogen, arsenic, antimony, and bismuth, phosphorus is classified as a pnictogen.</p><p>Phosphorus is an element essential to sustaining life largely through phosphates, compounds containing the phosphate ion, PO43−. Phosphates are a component of DNA, RNA, ATP, and phospholipids, complex compounds fundamental to cells. Elemental phosphorus was first isolated from human urine, and bone ash was an important early phosphate source. Phosphate mines contain fossils because phosphate is present in the fossilized deposits of animal remains and excreta. Low phosphate levels are an important limit to growth in some aquatic systems. The vast majority of phosphorus compounds mined are consumed as fertilisers. Phosphate is needed to replace the phosphorus that plants remove from the soil, and its annual demand is rising nearly twice as fast as the growth of the human population. Other applications include organophosphorus compounds in detergents, pesticides, and nerve agents.</p>",
        "valence_electrons": 5
    },
    {
        "name": "Sulfur",
        "symbol": "S",
        "abundance": {
            "universe": 0.05,
            "solar": 0.04,
            "meteor": 4,
            "crust": 0.042,
            "ocean": 0.093,
            "human": 0.2
        },
        "allotropes": "Rhombic Sulphur, Monoclinic Sulphur, Amorphous Sulphur",
        "alternate_names": "Sulphur",
        "appearance": "lemon yellow sintered microcrystals",
        "atomic_mass": 32.06,
        "atomic_number": 16,
        "block": "p-block",
        "boiling_point": 717.8,
        "classifications": {
            "cas_number": "CAS7704-34-9",
            "cid_number": "CID5362487",
            "rtecs_number": "RTECSWS4250000"
        },
        "conductivity": {
            "thermal": 0.205,
            "electric": 1e-21
        },
        "cpk_hex": "ffff30",
        "critical_pressure": 20.7,
        "critical_temperature": 1314,
        "crystal_structure": "Face-centered Orthorhombic",
        "density": {
            "stp": 1960,
            "liquid": 1819
        },
        "discovered": {
            "year": -500,
            "by": "Ancient china"
        },
        "electrical_type": "Insulator",
        "electron_affinity": 200.4101,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁴",
        "electron_configuration_semantic": "[Ne] 3s² 3p⁴",
        "electronegativity_pauling": 2.58,
        "electrons_per_shell": [
            2,
            8,
            6
        ],
        "energy_levels": "2, 8, 6",
        "group": 16,
        "half_life": "Stable",
        "hardness": {
            "mohs": 2
        },
        "heat": {
            "specific": 705,
            "vaporization": 9.8,
            "fusion": 1.73,
            "molar": 22.75
        },
        "ionization_energies": [
            999.6,
            2252,
            3357,
            4556,
            7004.3,
            8495.8,
            27107,
            31719,
            36621,
            43177,
            48710,
            54460,
            62930,
            68216,
            311048,
            337138
        ],
        "isotopes_known": "²⁶S, ²⁷S, ²⁸S, ²⁹S, ³⁰S, ³¹S, ³²S, ³³S, ³⁴S, ³⁵S, ³⁶S, ³⁷S, ³⁸S, ³⁹S, ⁴⁰S, ⁴¹S, ⁴²S, ⁴³S, ⁴⁴S, ⁴⁵S, ⁴⁶S, ⁴⁷S, ⁴⁸S, ⁴⁹S",
        "isotopes_stable": "³²S, ³³S, ³⁴S, ³⁶S",
        "isotopic_abundances": "³²S: 94.93%, ³³S: 0.76%, ³⁴S: 4.29%, ³⁶S: 0.02%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "1043.7, 1284.5, 2436.9",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -6.2e-9,
            "molar": -1.99e-10,
            "volume": -0.0000122
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 388.36,
        "modulus": {
            "bulk": 7.7
        },
        "molar_volume": 0.000016357,
        "neutron_cross_section": 0.52,
        "neutron_mass_absorption": 0.00055,
        "oxidation_states": "-2c,-1,1,2c,3,4c,5,6c",
        "period": 3,
        "phase": "Solid",
        "quantum_numbers": "3P2",
        "radius": {
            "calculated": 88,
            "empirical": 100,
            "covalent": 102,
            "vanderwaals": 180
        },
        "refractive_index": 1.001111,
        "resistivity": 1000000000000000,
        "series": "polyatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Sulfur",
        "space_group_name": "Fddd",
        "space_group_number": 70,
        "summary": "<p>Sulfur (in nontechnical British English: sulphur) is a chemical element with the symbol S and atomic number 16. It is abundant, multivalent and nonmetallic. Under normal conditions, sulfur atoms form cyclic octatomic molecules with a chemical formula S8. Elemental sulfur is a bright yellow, crystalline solid at room temperature.</p><p>Sulfur is the tenth most common element by mass in the universe, and the fifth most common on Earth. Though sometimes found in pure, native form, sulfur on Earth usually occurs as sulfide and sulfate minerals. Being abundant in native form, sulfur was known in ancient times, being mentioned for its uses in ancient India, ancient Greece, China, and Egypt. Historically and in literature sulfur is also called brimstone, which means \"burning stone\". Today, almost all elemental sulfur is produced as a byproduct of removing sulfur-containing contaminants from natural gas and petroleum. The greatest commercial use of the element is the production of sulfuric acid for sulfate and phosphate fertilizers, and other chemical processes. Sulfur is used in matches, insecticides, and fungicides. Many sulfur compounds are odoriferous, and the smells of odorized natural gas, skunk scent, grapefruit, and garlic are due to organosulfur compounds. Hydrogen sulfide gives the characteristic odor to rotting eggs and other biological processes.</p><p>Sulfur is an essential element for all life, but almost always in the form of organosulfur compounds or metal sulfides. Three amino acids (cysteine, cystine, and methionine) and two vitamins (biotin and thiamine) are organosulfur compounds. Many cofactors also contain sulfur, including glutathione, thioredoxin, and iron–sulfur proteins. Disulfides, S–S bonds, confer mechanical strength and insolubility of the protein keratin, found in outer skin, hair, and feathers. Sulfur is one of the core chemical elements needed for biochemical functioning and is an elemental macronutrient for all living organisms.</p>",
        "valence_electrons": 6
    },
    {
        "name": "Chlorine",
        "symbol": "Cl",
        "abundance": {
            "universe": 0.0001,
            "solar": 0.0008,
            "meteor": 0.037,
            "crust": 0.017,
            "ocean": 2,
            "human": 0.12
        },
        "adiabatic_index": "7/5",
        "allotropes": "Dichlorine",
        "appearance": "pale yellow-green gas",
        "atomic_mass": 35.45,
        "atomic_number": 17,
        "block": "p-block",
        "boiling_point": 239.11,
        "classifications": {
            "cas_number": "CAS7782-50-5",
            "cid_number": "CID24526",
            "rtecs_number": "RTECSFO2100000"
        },
        "conductivity": {
            "thermal": 0.0089,
            "electric": 1e-8
        },
        "cpk_hex": "1ff01f",
        "critical_pressure": 7.991,
        "critical_temperature": 416.9,
        "crystal_structure": "Base Orthorhombic",
        "density": {
            "stp": 3.214
        },
        "discovered": {
            "year": 1774,
            "by": "Carl Wilhelm Scheele",
            "location": "Sweden"
        },
        "electrical_type": "Insulator",
        "electron_affinity": 348.575,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁵",
        "electron_configuration_semantic": "[Ne] 3s² 3p⁵",
        "electronegativity_pauling": 3.16,
        "electrons_per_shell": [
            2,
            8,
            7
        ],
        "energy_levels": "2, 8, 7",
        "gas_phase": "Diatomic",
        "group": 17,
        "half_life": "Stable",
        "heat": {
            "specific": 478.2,
            "vaporization": 10.2,
            "fusion": 3.2
        },
        "ionization_energies": [
            1251.2,
            2298,
            3822,
            5158.6,
            6542,
            9362,
            11018,
            33604,
            38600,
            43961,
            51068,
            57119,
            63363,
            72341,
            78095,
            352994,
            380760
        ],
        "isotopes_known": "²⁸Cl, ²⁹Cl, ³⁰Cl, ³¹Cl, ³²Cl, ³³Cl, ³⁴Cl, ³⁵Cl, ³⁶Cl, ³⁷Cl, ³⁸Cl, ³⁹Cl, ⁴⁰Cl, ⁴¹Cl, ⁴²Cl, ⁴³Cl, ⁴⁴Cl, ⁴⁵Cl, ⁴⁶Cl, ⁴⁷Cl, ⁴⁸Cl, ⁴⁹Cl, ⁵⁰Cl, ⁵¹Cl",
        "isotopes_stable": "³⁵Cl, ³⁷Cl",
        "isotopic_abundances": "³⁵Cl: 75.78%, ³⁷Cl: 24.22%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "622.35, 445.61, 817.85",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -7.2e-9,
            "molar": -5.11e-10,
            "volume": -2.31e-8
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 171.6,
        "modulus": {
            "bulk": 1.1
        },
        "molar_volume": 0.01103,
        "neutron_cross_section": 35.3,
        "neutron_mass_absorption": 0.033,
        "oxidation_states": "-1c,1c,2,3c,4,5c,6,7c",
        "period": 3,
        "phase": "Gas",
        "quantum_numbers": "2P3/2",
        "radius": {
            "calculated": 79,
            "empirical": 100,
            "covalent": 99,
            "vanderwaals": 175
        },
        "refractive_index": 1.000773,
        "resistivity": 100,
        "series": "diatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Chlorine",
        "space_group_name": "Cmca",
        "space_group_number": 64,
        "speed_of_sound": 206,
        "summary": "<p>Chlorine is a chemical element with the symbol Cl and atomic number 17. The second-lightest of the halogens, it appears between fluorine and bromine in the periodic table and its properties are mostly intermediate between them. Chlorine is a yellow-green gas at room temperature. It is an extremely reactive element and a strong oxidising agent: among the elements, it has the highest electron affinity and the third-highest electronegativity on the revised Pauling scale, behind only oxygen and fluorine. On several scales other than the revised Pauling scale, nitrogen's electronegativity is also listed as greater than chlorine's, such as on the Allen, Allred-Rochow, Martynov-Batsanov, Mulliken-Jaffe, Nagle, and Noorizadeh-Shakerzadeh electronegativity scales.</p><p>Chlorine played an important role in the experiments conducted by medieval alchemists, which commonly involved the heating of chloride salts like ammonium chloride (sal ammoniac) and sodium chloride (common salt), producing various chemical substances containing chlorine such as hydrogen chloride, mercury(II) chloride (corrosive sublimate), and hydrochloric acid (in the form of aqua regia). However, the nature of free chlorine gas as a separate substance was only recognised around 1630 by Jan Baptist van Helmont. Carl Wilhelm Scheele wrote a description of chlorine gas in 1774, supposing it to be an oxide of a new element. In 1809, chemists suggested that the gas might be a pure element, and this was confirmed by Sir Humphry Davy in 1810, who named it after the Ancient Greek χλωρός (khlōrós, \"pale green\") because of its colour.</p><p>Because of its great reactivity, all chlorine in the Earth's crust is in the form of ionic chloride compounds, which includes table salt. It is the second-most abundant halogen (after fluorine) and twenty-first most abundant chemical element in Earth's crust. These crustal deposits are nevertheless dwarfed by the huge reserves of chloride in seawater.</p><p>Elemental chlorine is commercially produced from brine by electrolysis, predominantly in the chlor-alkali process. The high oxidising potential of elemental chlorine led to the development of commercial bleaches and disinfectants, and a reagent for many processes in the chemical industry. Chlorine is used in the manufacture of a wide range of consumer products, about two-thirds of them organic chemicals such as polyvinyl chloride (PVC), many intermediates for the production of plastics, and other end products which do not contain the element. As a common disinfectant, elemental chlorine and chlorine-generating compounds are used more directly in swimming pools to keep them sanitary. Elemental chlorine at high concentration is extremely dangerous, and poisonous to most living organisms. As a chemical warfare agent, chlorine was first used in World War I as a poison gas weapon.</p><p>In the form of chloride ions, chlorine is necessary to all known species of life. Other types of chlorine compounds are rare in living organisms, and artificially produced chlorinated organics range from inert to toxic. In the upper atmosphere, chlorine-containing organic molecules such as chlorofluorocarbons have been implicated in ozone depletion. Small quantities of elemental chlorine are generated by oxidation of chloride to hypochlorite in neutrophils as part of an immune system response against bacteria.</p>",
        "valence_electrons": 5
    },
    {
        "name": "Argon",
        "symbol": "Ar",
        "abundance": {
            "universe": 0.02,
            "solar": 0.007,
            "crust": 0.00015,
            "ocean": 0.000045
        },
        "adiabatic_index": "5/3",
        "appearance": "colorless gas exhibiting a lilac/violet glow when placed in a high voltage electric field",
        "atomic_mass": 39.9481,
        "atomic_number": 18,
        "block": "p-block",
        "boiling_point": 87.302,
        "classifications": {
            "cas_number": "CAS7440-37-1",
            "cid_number": "CID23968",
            "rtecs_number": "RTECSCF2300000",
            "dot_numbers": 1951,
            "dot_hazard_class": 2.2
        },
        "conductivity": {
            "thermal": 0.01772
        },
        "cpk_hex": "80d1e3",
        "critical_pressure": 4.898,
        "critical_temperature": 150.87,
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 1.784
        },
        "discovered": {
            "year": 1894,
            "by": "Lord Rayleigh",
            "location": "The United Kingdom"
        },
        "electron_affinity": -96,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶",
        "electron_configuration_semantic": "[Ne] 3s² 3p⁶",
        "electrons_per_shell": [
            2,
            8,
            8
        ],
        "energy_levels": "2, 8, 8",
        "gas_phase": "Monoatomic",
        "group": 18,
        "half_life": "Stable",
        "heat": {
            "specific": 520.33,
            "vaporization": 6.5,
            "fusion": 1.18
        },
        "ionization_energies": [
            1520.6,
            2665.8,
            3931,
            5771,
            7238,
            8781,
            11995,
            13842,
            40760,
            46186,
            52002,
            59653,
            66199,
            72918,
            82473,
            88576,
            397605,
            427066
        ],
        "isotopes_known": "³⁰Ar, ³¹Ar, ³²Ar, ³³Ar, ³⁴Ar, ³⁵Ar, ³⁶Ar, ³⁷Ar, ³⁸Ar, ³⁹Ar, ⁴⁰Ar, ⁴¹Ar, ⁴²Ar, ⁴³Ar, ⁴⁴Ar, ⁴⁵Ar, ⁴⁶Ar, ⁴⁷Ar, ⁴⁸Ar, ⁴⁹Ar, ⁵⁰Ar, ⁵¹Ar, ⁵²Ar, ⁵³Ar",
        "isotopes_stable": "³⁶Ar, ³⁸Ar, ⁴⁰Ar",
        "isotopic_abundances": "³⁶Ar: 0.3365%, ³⁸Ar: 0.0632%, ⁴⁰Ar: 99.6003%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "525.6, 525.6, 525.6",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -6e-9,
            "molar": -2.4e-10,
            "volume": -1.07e-8
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 83.81,
        "molar_volume": 0.022392,
        "neutron_cross_section": 0.66,
        "neutron_mass_absorption": 0.00059,
        "period": 3,
        "phase": "Gas",
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 71,
            "empirical": 71,
            "covalent": 97,
            "vanderwaals": 188
        },
        "refractive_index": 1.000281,
        "series": "noble gas",
        "source": "https://en.wikipedia.org/wiki/Argon",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 319,
        "summary": "<p>Argon is a chemical element with the symbol Ar and atomic number 18. It is in group 18 of the periodic table and is a noble gas. Argon is the third-most abundant gas in the Earth's atmosphere, at 0.934% (9340 ppmv). It is more than twice as abundant as water vapor (which averages about 4000 ppmv, but varies greatly), 23 times as abundant as carbon dioxide (400 ppmv), and more than 500 times as abundant as neon (18 ppmv). Argon is the most abundant noble gas in Earth's crust, comprising 0.00015% of the crust.</p><p>Nearly all of the argon in the Earth's atmosphere is radiogenic argon-40, derived from the decay of potassium-40 in the Earth's crust. In the universe, argon-36 is by far the most common argon isotope, as it is the most easily produced by stellar nucleosynthesis in supernovas.</p><p>The name \"argon\" is derived from the Greek word ἀργόν, neuter singular form of ἀργός meaning \"lazy\" or \"inactive\", as a reference to the fact that the element undergoes almost no chemical reactions. The complete octet (eight electrons) in the outer atomic shell makes argon stable and resistant to bonding with other elements. Its triple point temperature of 83.8058 K is a defining fixed point in the International Temperature Scale of 1990.</p><p>Argon is extracted industrially by the fractional distillation of liquid air. Argon is mostly used as an inert shielding gas in welding and other high-temperature industrial processes where ordinarily unreactive substances become reactive; for example, an argon atmosphere is used in graphite electric furnaces to prevent the graphite from burning. Argon is also used in incandescent, fluorescent lighting, and other gas-discharge tubes. Argon makes a distinctive blue-green gas laser. Argon is also used in fluorescent glow starters.</p>",
        "valence_electrons": 0
    },
    {
        "name": "Potassium",
        "symbol": "K",
        "abundance": {
            "universe": 0.0003,
            "solar": 0.0004,
            "meteor": 0.07,
            "crust": 1.5,
            "ocean": 0.042,
            "human": 0.2
        },
        "alternate_names": "Kalium",
        "appearance": "silvery gray",
        "atomic_mass": 39.09831,
        "atomic_number": 19,
        "block": "s-block",
        "boiling_point": 1032,
        "classifications": {
            "cas_number": "CAS7440-09-7",
            "cid_number": "CID5462222",
            "rtecs_number": "RTECSTS6460000",
            "dot_numbers": 2257,
            "dot_hazard_class": 4.3
        },
        "conductivity": {
            "thermal": 100,
            "electric": 14
        },
        "cpk_hex": "8f40d4",
        "critical_pressure": 16,
        "critical_temperature": 2223,
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 856,
            "liquid": 828
        },
        "discovered": {
            "year": 1807,
            "by": "Humphry Davy",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 48.383,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s¹",
        "electron_configuration_semantic": "[Ar] 4s¹",
        "electronegativity_pauling": 0.82,
        "electrons_per_shell": [
            2,
            8,
            8,
            1
        ],
        "energy_levels": "2, 8, 8, 1",
        "group": 1,
        "half_life": "Stable",
        "hardness": {
            "brinell": 0.363,
            "mohs": 0.4
        },
        "heat": {
            "specific": 757,
            "vaporization": 76.9,
            "fusion": 2.33,
            "molar": 29.6
        },
        "ionization_energies": [
            418.8,
            3052,
            4420,
            5877,
            7975,
            9590,
            11343,
            14944,
            16963.7,
            48610,
            54490,
            60730,
            68950,
            75900,
            83080,
            93400,
            99710,
            444880,
            476063
        ],
        "isotopes_known": "³²K, ³³K, ³⁴K, ³⁵K, ³⁶K, ³⁷K, ³⁸K, ³⁹K, ⁴⁰K, ⁴¹K, ⁴²K, ⁴³K, ⁴⁴K, ⁴⁵K, ⁴⁶K, ⁴⁷K, ⁴⁸K, ⁴⁹K, ⁵⁰K, ⁵¹K, ⁵²K, ⁵³K, ⁵⁴K, ⁵⁵K",
        "isotopes_stable": "³⁹K, ⁴¹K",
        "isotopic_abundances": "³⁹K: 93.2581%, ⁴⁰K: 0.0117%, ⁴¹K: 6.7302%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "532.8, 532.8, 532.8",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 6.7e-9,
            "molar": 2.62e-10,
            "volume": 0.00000574
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 336.7,
        "modulus": {
            "bulk": 3.1,
            "shear": 1.3
        },
        "molar_volume": 0.00004568,
        "neutron_cross_section": 2.1,
        "neutron_mass_absorption": 0.0018,
        "oxidation_states": "-1,1c",
        "period": 4,
        "phase": "Solid",
        "quantum_numbers": "2S1/2",
        "radius": {
            "calculated": 243,
            "empirical": 220,
            "covalent": 196,
            "vanderwaals": 275
        },
        "resistivity": 7.000000000002e-8,
        "series": "alkali metal",
        "source": "https://en.wikipedia.org/wiki/Potassium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 2000,
        "summary": "<p>Potassium is a chemical element with the symbol K (from Neo-Latin kalium) and atomic number 19. Potassium is a silvery-white metal that is soft enough to be cut with a knife with little force. Potassium metal reacts rapidly with atmospheric oxygen to form flaky white potassium peroxide in only seconds of exposure. It was first isolated from potash, the ashes of plants, from which its name derives. In the periodic table, potassium is one of the alkali metals, all of which have a single valence electron in the outer electron shell, that is easily removed to create an ion with a positive charge – a cation, that combines with anions to form salts. Potassium in nature occurs only in ionic salts. Elemental potassium reacts vigorously with water, generating sufficient heat to ignite hydrogen emitted in the reaction, and burning with a lilac-colored flame. It is found dissolved in sea water (which is 0.04% potassium by weight), and occurs in many minerals such as orthoclase, a common constituent of granites and other igneous rocks.</p><p>Potassium is chemically very similar to sodium, the previous element in group 1 of the periodic table. They have a similar first ionization energy, which allows for each atom to give up its sole outer electron. It was suspected in 1702 that they were distinct elements that combine with the same anions to make similar salts, and was proven in 1807 using electrolysis. Naturally occurring potassium is composed of three isotopes, of which 40K is radioactive. Traces of 40K are found in all potassium, and it is the most common radioisotope in the human body.</p><p>Potassium ions are vital for the functioning of all living cells. The transfer of potassium ions across nerve cell membranes is necessary for normal nerve transmission; potassium deficiency and excess can each result in numerous signs and symptoms, including an abnormal heart rhythm and various electrocardiographic abnormalities. Fresh fruits and vegetables are good dietary sources of potassium. The body responds to the influx of dietary potassium, which raises serum potassium levels, with a shift of potassium from outside to inside cells and an increase in potassium excretion by the kidneys.</p><p>Most industrial applications of potassium exploit the high solubility in water of potassium compounds, such as potassium soaps. Heavy crop production rapidly depletes the soil of potassium, and this can be remedied with agricultural fertilizers containing potassium, accounting for 95% of global potassium chemical production.</p>",
        "valence_electrons": 1
    },
    {
        "name": "Calcium",
        "symbol": "Ca",
        "abundance": {
            "universe": 0.007,
            "solar": 0.007,
            "meteor": 1.1,
            "crust": 5,
            "ocean": 0.00042,
            "human": 1.4
        },
        "atomic_mass": 40.0784,
        "atomic_number": 20,
        "block": "s-block",
        "boiling_point": 1757,
        "classifications": {
            "cas_number": "CAS7440-70-2",
            "cid_number": "CID5460341",
            "dot_numbers": 1855,
            "dot_hazard_class": 4.2
        },
        "conductivity": {
            "thermal": 200,
            "electric": 29
        },
        "cpk_hex": "3dff00",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 1550,
            "liquid": 1378
        },
        "discovered": {
            "year": 1808,
            "by": "Humphry Davy",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 2.37,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s²",
        "electron_configuration_semantic": "[Ar] 4s²",
        "electronegativity_pauling": 1,
        "electrons_per_shell": [
            2,
            8,
            8,
            2
        ],
        "energy_levels": "2, 8, 8, 2",
        "group": 2,
        "half_life": "Stable",
        "hardness": {
            "brinell": 167,
            "mohs": 1.75
        },
        "heat": {
            "specific": 631,
            "vaporization": 155,
            "fusion": 8.54,
            "molar": 25.929
        },
        "ionization_energies": [
            589.8,
            1145.4,
            4912.4,
            6491,
            8153,
            10496,
            12270,
            14206,
            18191,
            20385,
            57110,
            63410,
            70110,
            78890,
            86310,
            94000,
            104900,
            111711,
            494850,
            527762
        ],
        "isotopes_known": "³⁴Ca, ³⁵Ca, ³⁶Ca, ³⁷Ca, ³⁸Ca, ³⁹Ca, ⁴⁰Ca, ⁴¹Ca, ⁴²Ca, ⁴³Ca, ⁴⁴Ca, ⁴⁵Ca, ⁴⁶Ca, ⁴⁷Ca, ⁴⁸Ca, ⁴⁹Ca, ⁵⁰Ca, ⁵¹Ca, ⁵²Ca, ⁵³Ca, ⁵⁴Ca, ⁵⁵Ca, ⁵⁶Ca, ⁵⁷Ca",
        "isotopes_stable": "⁴⁰Ca, ⁴²Ca, ⁴³Ca, ⁴⁴Ca, ⁴⁶Ca",
        "isotopic_abundances": "⁴⁰Ca: 96.941%, ⁴²Ca: 0.647%, ⁴³Ca: 0.135%, ⁴⁴Ca: 2.086%, ⁴⁶Ca: 0.004%, ⁴⁸Ca: 0.187%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "558.84, 558.84, 558.84",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.38e-8,
            "molar": 5.531e-10,
            "volume": 0.00002139
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1115,
        "modulus": {
            "bulk": 17,
            "shear": 7.4,
            "young": 20
        },
        "molar_volume": 0.000025857,
        "neutron_cross_section": 0.43,
        "neutron_mass_absorption": 0.00037,
        "oxidation_states": "1,2c",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.31,
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 194,
            "empirical": 180,
            "covalent": 174
        },
        "resistivity": 3.399999999999e-8,
        "series": "alkaline earth metal",
        "source": "https://en.wikipedia.org/wiki/Calcium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 3810,
        "summary": "<p>Calcium is a chemical element with the symbol Ca and atomic number 20. As an alkaline earth metal, calcium is a reactive metal that forms a dark oxide-nitride layer when exposed to air. Its physical and chemical properties are most similar to its heavier homologues strontium and barium. It is the fifth most abundant element in Earth's crust, and the third most abundant metal, after iron and aluminium. The most common calcium compound on Earth is calcium carbonate, found in limestone and the fossilised remnants of early sea life; gypsum, anhydrite, fluorite, and apatite are also sources of calcium. The name derives from Latin calx \"lime\", which was obtained from heating limestone.</p><p>Some calcium compounds were known to the ancients, though their chemistry was unknown until the seventeenth century. Pure calcium was isolated in 1808 via electrolysis of its oxide by Humphry Davy, who named the element. Calcium compounds are widely used in many industries: in foods and pharmaceuticals for calcium supplementation, in the paper industry as bleaches, as components in cement and electrical insulators, and in the manufacture of soaps. On the other hand, the metal in pure form has few applications due to its high reactivity; still, in small quantities it is often used as an alloying component in steelmaking, and sometimes, as a calcium–lead alloy, in making automotive batteries.</p><p>Calcium is the most abundant metal and the fifth-most abundant element in the human body. As electrolytes, calcium ions play a vital role in the physiological and biochemical processes of organisms and cells: in signal transduction pathways where they act as a second messenger; in neurotransmitter release from neurons; in contraction of all muscle cell types; as cofactors in many enzymes; and in fertilization. Calcium ions outside cells are important for maintaining the potential difference across excitable cell membranes, protein synthesis, and bone formation.</p>",
        "thermal_expansion": 0.0000223,
        "valence_electrons": 2
    },
    {
        "name": "Scandium",
        "symbol": "Sc",
        "abundance": {
            "universe": 0.000003,
            "solar": 0.000004,
            "meteor": 0.00064,
            "crust": 0.0026,
            "ocean": 1.5e-10
        },
        "appearance": "silvery white",
        "atomic_mass": 44.9559085,
        "atomic_number": 21,
        "block": "d-block",
        "boiling_point": 3109,
        "classifications": {
            "cas_number": "CAS7440-20-2",
            "cid_number": "CID23952",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 16,
            "electric": 1.8
        },
        "cpk_hex": "e6e6e6",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 2985,
            "liquid": 2800
        },
        "discovered": {
            "year": 1879,
            "by": "Lars Fredrik Nilson",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 18,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹",
        "electron_configuration_semantic": "[Ar] 3d¹ 4s²",
        "electronegativity_pauling": 1.36,
        "electrons_per_shell": [
            2,
            8,
            9,
            2
        ],
        "energy_levels": "2, 8, 9, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "brinell": 750
        },
        "heat": {
            "specific": 567,
            "vaporization": 318,
            "fusion": 16,
            "molar": 25.52
        },
        "ionization_energies": [
            633.1,
            1235,
            2388.6,
            7090.6,
            8843,
            10679,
            13310,
            15250,
            17370,
            21726,
            24102,
            66320,
            73010,
            80160,
            89490,
            97400,
            105600,
            117000,
            124270,
            547530,
            582163
        ],
        "isotopes_known": "³⁶Sc, ³⁷Sc, ³⁸Sc, ³⁹Sc, ⁴⁰Sc, ⁴¹Sc, ⁴²Sc, ⁴³Sc, ⁴⁴Sc, ⁴⁵Sc, ⁴⁶Sc, ⁴⁷Sc, ⁴⁸Sc, ⁴⁹Sc, ⁵⁰Sc, ⁵¹Sc, ⁵²Sc, ⁵³Sc, ⁵⁴Sc, ⁵⁵Sc, ⁵⁶Sc, ⁵⁷Sc, ⁵⁸Sc, ⁵⁹Sc, ⁶⁰Sc",
        "isotopes_stable": "⁴⁵Sc",
        "isotopic_abundances": "⁴⁵Sc: 100%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "330.9, 330.9, 527.33",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 8.8e-8,
            "molar": 3.956e-9,
            "volume": 0.0002627
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1814,
        "modulus": {
            "bulk": 57,
            "shear": 29,
            "young": 74
        },
        "molar_volume": 0.000015061,
        "neutron_cross_section": 27.2,
        "neutron_mass_absorption": 0.025,
        "oxidation_states": "1,2,3c",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.28,
        "quantum_numbers": "2D3/2",
        "radius": {
            "calculated": 184,
            "empirical": 160,
            "covalent": 144
        },
        "resistivity": 5.5e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Scandium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "summary": "<p>Scandium is a chemical element with the symbol Sc and atomic number 21.</p><p>A silvery-white metallic d-block element, it has historically been classified as a rare-earth element, together with yttrium and the lanthanides. It was discovered in 1879 by spectral analysis of the minerals euxenite and gadolinite from Scandinavia.</p><p>Scandium is present in most of the deposits of rare-earth and uranium compounds, but it is extracted from these ores in only a few mines worldwide. Because of the low availability and the difficulties in the preparation of metallic scandium, which was first done in 1937, applications for scandium were not developed until the 1970s, when the positive effects of scandium on aluminium alloys were discovered, and its use in such alloys remains its only major application. The global trade of scandium oxide is 15–20 tonnes per year.</p><p>The properties of scandium compounds are intermediate between those of aluminium and yttrium. A diagonal relationship exists between the behavior of magnesium and scandium, just as there is between beryllium and aluminium. In the chemical compounds of the elements in group 3, the predominant oxidation state is +3.</p>",
        "superconducting_point": 0.05,
        "thermal_expansion": 0.0000102,
        "valence_electrons": 3
    },
    {
        "name": "Titanium",
        "symbol": "Ti",
        "abundance": {
            "universe": 0.0003,
            "solar": 0.0004,
            "meteor": 0.054,
            "crust": 0.66,
            "ocean": 1e-7
        },
        "appearance": "silvery grey-white metallic",
        "atomic_mass": 47.8671,
        "atomic_number": 22,
        "block": "d-block",
        "boiling_point": 3560,
        "classifications": {
            "cas_number": "CAS7440-32-6",
            "cid_number": "CID23963",
            "dot_numbers": 2546,
            "dot_hazard_class": 4.2
        },
        "conductivity": {
            "thermal": 22,
            "electric": 2.5
        },
        "cpk_hex": "bfc2c7",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 4507,
            "liquid": 4110
        },
        "discovered": {
            "year": 1791,
            "by": "William Gregor",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 7.289,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d²",
        "electron_configuration_semantic": "[Ar] 3d² 4s²",
        "electronegativity_pauling": 1.54,
        "electrons_per_shell": [
            2,
            8,
            10,
            2
        ],
        "energy_levels": "2, 8, 10, 2",
        "group": 4,
        "half_life": "Stable",
        "hardness": {
            "vickers": 970,
            "brinell": 716,
            "mohs": 6
        },
        "heat": {
            "specific": 520,
            "vaporization": 425,
            "fusion": 18.7,
            "molar": 25.06
        },
        "ionization_energies": [
            658.8,
            1309.8,
            2652.5,
            4174.6,
            9581,
            11533,
            13590,
            16440,
            18530,
            20833,
            25575,
            28125,
            76015,
            83280,
            90880,
            100700,
            109100,
            117800,
            129900,
            137530,
            602930,
            639294
        ],
        "isotopes_known": "³⁸Ti, ³⁹Ti, ⁴⁰Ti, ⁴¹Ti, ⁴²Ti, ⁴³Ti, ⁴⁴Ti, ⁴⁵Ti, ⁴⁶Ti, ⁴⁷Ti, ⁴⁸Ti, ⁴⁹Ti, ⁵⁰Ti, ⁵¹Ti, ⁵²Ti, ⁵³Ti, ⁵⁴Ti, ⁵⁵Ti, ⁵⁶Ti, ⁵⁷Ti, ⁵⁸Ti, ⁵⁹Ti, ⁶⁰Ti, ⁶¹Ti, ⁶²Ti, ⁶³Ti",
        "isotopes_stable": "⁴⁶Ti, ⁴⁷Ti, ⁴⁸Ti, ⁴⁹Ti, ⁵⁰Ti",
        "isotopic_abundances": "⁴⁶Ti: 8.25%, ⁴⁷Ti: 7.44%, ⁴⁸Ti: 73.72%, ⁴⁹Ti: 5.41%, ⁵⁰Ti: 5.18%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "295.08, 295.08, 468.55",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 4.01e-8,
            "molar": 1.919e-9,
            "volume": 0.0001807
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1941,
        "modulus": {
            "bulk": 110,
            "shear": 44,
            "young": 116
        },
        "molar_volume": 0.000010621,
        "neutron_cross_section": 6.1,
        "neutron_mass_absorption": 0.0044,
        "oxidation_states": "-1,2,3,4c",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.32,
        "quantum_numbers": "3F2",
        "radius": {
            "calculated": 176,
            "empirical": 140,
            "covalent": 136
        },
        "resistivity": 4e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Titanium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 4140,
        "summary": "<p>Titanium is a chemical element with the symbol Ti and atomic number 22. Its atomic weight is 47.867 measured in daltons. It is a lustrous transition metal with a silver color, low density, and high strength, resistant to corrosion in sea water, aqua regia, and chlorine.</p><p>Titanium was discovered in Cornwall, Great Britain, by William Gregor in 1791 and was named by Martin Heinrich Klaproth after the Titans of Greek mythology. The element occurs within a number of mineral deposits, principally rutile and ilmenite, which are widely distributed in the Earth's crust and lithosphere; it is found in almost all living things, as well as bodies of water, rocks, and soils. The metal is extracted from its principal mineral ores by the Kroll and Hunter processes. The most common compound, titanium dioxide, is a popular photocatalyst and is used in the manufacture of white pigments. Other compounds include titanium tetrachloride (TiCl4), a component of smoke screens and catalysts; and titanium trichloride (TiCl3), which is used as a catalyst in the production of polypropylene.</p><p>Titanium can be alloyed with iron, aluminium, vanadium, and molybdenum, among other elements, to produce strong, lightweight alloys for aerospace (jet engines, missiles, and spacecraft), military, industrial processes (chemicals and petrochemicals, desalination plants, pulp, and paper), automotive, agriculture (farming), medical prostheses, orthopedic implants, dental and endodontic instruments and files, dental implants, sporting goods, jewelry, mobile phones, and other applications.</p><p>The two most useful properties of the metal are corrosion resistance and strength-to-density ratio, the highest of any metallic element. In its unalloyed condition, titanium is as strong as some steels, but less dense. There are two allotropic forms and five naturally occurring isotopes of this element, 46Ti through 50Ti, with 48Ti being the most abundant (73.8%). Although titanium and zirconium have the same number of valence electrons and are in the same group in the periodic table, they differ in many chemical and physical properties.</p>",
        "superconducting_point": 0.4,
        "thermal_expansion": 0.0000086,
        "valence_electrons": 4
    },
    {
        "name": "Vanadium",
        "symbol": "V",
        "abundance": {
            "universe": 0.0001,
            "solar": 0.00004,
            "meteor": 0.0061,
            "crust": 0.019,
            "ocean": 1.5e-7,
            "human": 0.000003
        },
        "appearance": "blue-silver-grey metal",
        "atomic_mass": 50.94151,
        "atomic_number": 23,
        "block": "d-block",
        "boiling_point": 3680,
        "classifications": {
            "cas_number": "CAS7440-62-2",
            "cid_number": "CID23990",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 31,
            "electric": 5
        },
        "cpk_hex": "a6a6ab",
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 6110,
            "liquid": 5500
        },
        "discovered": {
            "year": 1801,
            "by": "Andrés Manuel del Río",
            "location": "Mexico and Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 50.911,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d³",
        "electron_configuration_semantic": "[Ar] 3d³ 4s²",
        "electronegativity_pauling": 1.63,
        "electrons_per_shell": [
            2,
            8,
            11,
            2
        ],
        "energy_levels": "2, 8, 11, 2",
        "group": 5,
        "half_life": "Stable",
        "hardness": {
            "vickers": 628,
            "brinell": 628,
            "mohs": 7
        },
        "heat": {
            "specific": 489,
            "vaporization": 453,
            "fusion": 22.8,
            "molar": 24.89
        },
        "ionization_energies": [
            650.9,
            1414,
            2830,
            4507,
            6298.7,
            12363,
            14530,
            16730,
            19860,
            22240,
            24670,
            29730,
            32446,
            86450,
            94170,
            102300,
            112700,
            121600,
            130700,
            143400,
            151440,
            661050,
            699144
        ],
        "isotopes_known": "⁴⁰V, ⁴¹V, ⁴²V, ⁴³V, ⁴⁴V, ⁴⁵V, ⁴⁶V, ⁴⁷V, ⁴⁸V, ⁴⁹V, ⁵⁰V, ⁵¹V, ⁵²V, ⁵³V, ⁵⁴V, ⁵⁵V, ⁵⁶V, ⁵⁷V, ⁵⁸V, ⁵⁹V, ⁶⁰V, ⁶¹V, ⁶²V, ⁶³V, ⁶⁴V, ⁶⁵V",
        "isotopes_stable": "⁵¹V",
        "isotopic_abundances": "⁵⁰V: 0.25%, ⁵¹V: 99.75%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "303, 303, 303",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 6.28e-8,
            "molar": 3.199e-9,
            "volume": 0.0003837
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2183,
        "modulus": {
            "bulk": 160,
            "shear": 47,
            "young": 128
        },
        "molar_volume": 0.0000083374,
        "neutron_cross_section": 5.06,
        "neutron_mass_absorption": 0.0033,
        "oxidation_states": "-1,1,2,3,4,5c",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.37,
        "quantum_numbers": "4F3/2",
        "radius": {
            "calculated": 171,
            "empirical": 135,
            "covalent": 125
        },
        "resistivity": 2e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Vanadium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 4560,
        "summary": "<p>Vanadium is a chemical element with the symbol V and atomic number 23. It is a hard, silvery-grey, malleable transition metal. The elemental metal is rarely found in nature, but once isolated artificially, the formation of an oxide layer (passivation) somewhat stabilizes the free metal against further oxidation.</p><p>Andrés Manuel del Río discovered compounds of vanadium in 1801 in Mexico by analyzing a new lead-bearing mineral he called \"brown lead\". Though he initially presumed its qualities were due to the presence of a new element, he was later erroneously convinced by French chemist Hippolyte Victor Collet-Descotils that the element was just chromium. Then in 1830, Nils Gabriel Sefström generated chlorides of vanadium, thus proving there was a new element, and named it \"vanadium\" after the Scandinavian goddess of beauty and fertility, Vanadís (Freyja). The name was based on the wide range of colors found in vanadium compounds. Del Rio's lead mineral was ultimately named vanadinite for its vanadium content. In 1867 Henry Enfield Roscoe obtained the pure element.</p><p>Vanadium occurs naturally in about 65 minerals and in fossil fuel deposits. It is produced in China and Russia from steel smelter slag. Other countries produce it either from magnetite directly, flue dust of heavy oil, or as a byproduct of uranium mining. It is mainly used to produce specialty steel alloys such as high-speed tool steels, and some aluminium alloys. The most important industrial vanadium compound, vanadium pentoxide, is used as a catalyst for the production of sulfuric acid. The vanadium redox battery for energy storage may be an important application in the future.</p><p>Large amounts of vanadium ions are found in a few organisms, possibly as a toxin. The oxide and some other salts of vanadium have moderate toxicity. Particularly in the ocean, vanadium is used by some life forms as an active center of enzymes, such as the vanadium bromoperoxidase of some ocean algae.</p>",
        "superconducting_point": 5.4,
        "thermal_expansion": 0.0000084,
        "valence_electrons": 5
    },
    {
        "name": "Chromium",
        "symbol": "Cr",
        "abundance": {
            "universe": 0.0015,
            "solar": 0.002,
            "meteor": 0.3,
            "crust": 0.014,
            "ocean": 6e-8,
            "human": 0.000003
        },
        "appearance": "silvery metallic",
        "atomic_mass": 51.99616,
        "atomic_number": 24,
        "block": "d-block",
        "boiling_point": 2944,
        "classifications": {
            "cas_number": "CAS7440-47-3",
            "cid_number": "CID23976",
            "rtecs_number": "RTECSGB4200000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 94,
            "electric": 7.9
        },
        "cpk_hex": "8a99c7",
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 7190,
            "liquid": 6300
        },
        "discovered": {
            "year": 1797,
            "by": "Louis Nicolas Vauquelin",
            "location": "France"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 65.21,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s¹ 3d⁵",
        "electron_configuration_semantic": "[Ar] 3d⁵ 4s¹",
        "electronegativity_pauling": 1.66,
        "electrons_per_shell": [
            2,
            8,
            13,
            1
        ],
        "energy_levels": "2, 8, 13, 1",
        "group": 6,
        "half_life": "Stable",
        "hardness": {
            "vickers": 1060,
            "brinell": 1120,
            "mohs": 8.5
        },
        "heat": {
            "specific": 448,
            "vaporization": 339,
            "fusion": 20.5,
            "molar": 23.35
        },
        "ionization_energies": [
            652.9,
            1590.6,
            2987,
            4743,
            6702,
            8744.9,
            15455,
            17820,
            20190,
            23580,
            26130,
            28750,
            34230,
            37066,
            97510,
            105800,
            114300,
            125300,
            134700,
            144300,
            157700,
            166090,
            721870,
            761733
        ],
        "isotopes_known": "⁴²Cr, ⁴³Cr, ⁴⁴Cr, ⁴⁵Cr, ⁴⁶Cr, ⁴⁷Cr, ⁴⁸Cr, ⁴⁹Cr, ⁵⁰Cr, ⁵¹Cr, ⁵²Cr, ⁵³Cr, ⁵⁴Cr, ⁵⁵Cr, ⁵⁶Cr, ⁵⁷Cr, ⁵⁸Cr, ⁵⁹Cr, ⁶⁰Cr, ⁶¹Cr, ⁶²Cr, ⁶³Cr, ⁶⁴Cr, ⁶⁵Cr, ⁶⁶Cr, ⁶⁷Cr",
        "isotopes_stable": "⁵⁰Cr, ⁵²Cr, ⁵³Cr, ⁵⁴Cr",
        "isotopic_abundances": "⁵⁰Cr: 4.345%, ⁵²Cr: 83.789%, ⁵³Cr: 9.501%, ⁵⁴Cr: 2.365%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "291, 291, 291",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 4.45e-8,
            "molar": 2.314e-9,
            "volume": 0.0003177
        },
        "magnetic_type": "antiferromagnetic",
        "melting_point": 2180,
        "modulus": {
            "bulk": 160,
            "shear": 115,
            "young": 279
        },
        "molar_volume": 0.0000072317,
        "neel_point": 393,
        "neutron_cross_section": 3.1,
        "neutron_mass_absorption": 0.0021,
        "oxidation_states": "-2,-1,1,2,3c,4,5,6c",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.21,
        "quantum_numbers": "7S3",
        "radius": {
            "calculated": 166,
            "empirical": 140,
            "covalent": 127
        },
        "resistivity": 1.3e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Chromium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 5940,
        "summary": "<p>Chromium is a chemical element with the symbol Cr and atomic number 24. It is the first element in group 6. It is a steely-grey, lustrous, hard, and brittle transition metal. Chromium is the main additive in stainless steel, to which it adds anti-corrosive properties. Chromium is also highly valued as a metal that is able to be highly polished while resisting tarnishing. Polished chromium reflects almost 70% of the visible spectrum, and almost 90% of infrared light. The name of the element is derived from the Greek word χρῶμα, chrōma, meaning color, because many chromium compounds are intensely colored.</p><p>Ferrochromium alloy is commercially produced from chromite by silicothermic or aluminothermic reactions and chromium metal by roasting and leaching processes followed by reduction with carbon and then aluminium. Chromium metal is of high value for its high corrosion resistance and hardness. A major development in steel production was the discovery that steel could be made highly resistant to corrosion and discoloration by adding metallic chromium to form stainless steel. Stainless steel and chrome plating (electroplating with chromium) together comprise 85% of the commercial use.</p><p>In the United States, trivalent chromium (Cr(III)) ion is considered an essential nutrient in humans for insulin, sugar, and lipid metabolism. However, in 2014, the European Food Safety Authority, acting for the European Union, concluded that there was insufficient evidence for chromium to be recognized as essential.</p><p>While chromium metal and Cr(III) ions are considered non-toxic, hexavalent chromium, Cr(VI), is toxic and carcinogenic. Abandoned chromium production sites often require environmental cleanup.</p>",
        "thermal_expansion": 0.0000049,
        "valence_electrons": 6
    },
    {
        "name": "Manganese",
        "symbol": "Mn",
        "abundance": {
            "universe": 0.0008,
            "solar": 0.001,
            "meteor": 0.27,
            "crust": 0.11,
            "ocean": 2e-7,
            "human": 0.00002
        },
        "appearance": "silvery metallic",
        "atomic_mass": 54.9380443,
        "atomic_number": 25,
        "block": "d-block",
        "boiling_point": 2334,
        "classifications": {
            "cas_number": "CAS7439-96-5",
            "cid_number": "CID23930",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 7.8,
            "electric": 0.62
        },
        "cpk_hex": "9c7ac7",
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 7470,
            "liquid": 5950
        },
        "discovered": {
            "year": 1774,
            "by": "Torbern Olof Bergman",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": -50,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d⁵",
        "electron_configuration_semantic": "[Ar] 3d⁵ 4s²",
        "electronegativity_pauling": 1.55,
        "electrons_per_shell": [
            2,
            8,
            13,
            2
        ],
        "energy_levels": "2, 8, 13, 2",
        "group": 7,
        "half_life": "Stable",
        "hardness": {
            "brinell": 196,
            "mohs": 6
        },
        "heat": {
            "specific": 479,
            "vaporization": 220,
            "fusion": 13.2,
            "molar": 26.32
        },
        "ionization_energies": [
            717.3,
            1509,
            3248,
            4940,
            6990,
            9220,
            11500,
            18770,
            21400,
            23960,
            27590,
            30330,
            33150,
            38880,
            41987,
            109480,
            118100,
            127100,
            138600,
            148500,
            158600,
            172500,
            181380,
            785450,
            827067
        ],
        "isotopes_known": "⁴⁴Mn, ⁴⁵Mn, ⁴⁶Mn, ⁴⁷Mn, ⁴⁸Mn, ⁴⁹Mn, ⁵⁰Mn, ⁵¹Mn, ⁵²Mn, ⁵³Mn, ⁵⁴Mn, ⁵⁵Mn, ⁵⁶Mn, ⁵⁷Mn, ⁵⁸Mn, ⁵⁹Mn, ⁶⁰Mn, ⁶¹Mn, ⁶²Mn, ⁶³Mn, ⁶⁴Mn, ⁶⁵Mn, ⁶⁶Mn, ⁶⁷Mn, ⁶⁸Mn, ⁶⁹Mn",
        "isotopes_stable": "⁵⁵Mn",
        "isotopic_abundances": "⁵⁵Mn: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "891.25, 891.25, 891.25",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.21e-7,
            "molar": 6.6475e-9,
            "volume": 0.00090387
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1519,
        "modulus": {
            "bulk": 120,
            "young": 198
        },
        "molar_volume": 0.0000073545,
        "neel_point": 100,
        "neutron_cross_section": 13.3,
        "neutron_mass_absorption": 0.0083,
        "oxidation_states": "-3,-2,-1,1,2c,3,4c,5,6,7c",
        "period": 4,
        "phase": "Solid",
        "quantum_numbers": "6S5/2",
        "radius": {
            "calculated": 161,
            "empirical": 140,
            "covalent": 139
        },
        "resistivity": 0.0000016,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Manganese",
        "space_group_name": "I_43m",
        "space_group_number": 217,
        "speed_of_sound": 5150,
        "summary": "<p>Manganese is a chemical element with the symbol Mn and atomic number 25. It is a hard brittle silvery metal, often found in minerals in combination with iron. Manganese is a transition metal with a multifaceted array of industrial alloy uses, particularly in stainless steels. It improves strength, workability, and resistance to wear. Manganese oxide is used as an oxidising agent, as a rubber additive, in glass making, fertilisers, and ceramics. Manganese sulfate can be used as a fungicide.</p><p>Manganese is also an essential human dietary element, important in macronutrient metabolism, bone formation, and free radical defense systems. It is a critical component in dozens of proteins and enzymes. It is found mostly in the bones, but also the liver, kidneys, and brain. In the human brain, the manganese is bound to manganese metalloproteins, most notably glutamine synthetase in astrocytes.</p><p>Manganese was first isolated in 1774. It is familiar in the laboratory in the form of the deep violet salt potassium permanganate. It occurs at the active sites in some enzymes. Of particular interest is the use of a Mn-O cluster, the oxygen-evolving complex, in the production of oxygen by plants.</p>",
        "thermal_expansion": 0.0000217,
        "valence_electrons": 4
    },
    {
        "name": "Iron",
        "symbol": "Fe",
        "abundance": {
            "universe": 0.11,
            "solar": 0.1,
            "meteor": 22,
            "crust": 6.3,
            "ocean": 3e-7,
            "human": 0.006
        },
        "alternate_names": "Ferrum",
        "appearance": "lustrous metallic with a grayish tinge",
        "atomic_mass": 55.8452,
        "atomic_number": 26,
        "block": "d-block",
        "boiling_point": 3134,
        "classifications": {
            "cas_number": "CAS7439-89-6",
            "cid_number": "CID23925",
            "rtecs_number": "RTECSNO4565500",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 80,
            "electric": 10
        },
        "cpk_hex": "e06633",
        "crystal_structure": "Body-centered Cubic",
        "curie_point": 1043,
        "density": {
            "stp": 7874,
            "liquid": 6980
        },
        "discovered": {
            "year": -2000,
            "location": "Egypt and Mesopotamia"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 14.785,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d⁶",
        "electron_configuration_semantic": "[Ar] 3d⁶ 4s²",
        "electronegativity_pauling": 1.83,
        "electrons_per_shell": [
            2,
            8,
            14,
            2
        ],
        "energy_levels": "2, 8, 14, 2",
        "group": 8,
        "half_life": "Stable",
        "hardness": {
            "vickers": 608,
            "brinell": 490,
            "mohs": 4
        },
        "heat": {
            "specific": 449,
            "vaporization": 347,
            "fusion": 13.8,
            "molar": 25.1
        },
        "ionization_energies": [
            762.5,
            1561.9,
            2957,
            5290,
            7240,
            9560,
            12060,
            14580,
            22540,
            25290,
            28000,
            31920,
            34830,
            37840,
            44100,
            47206,
            122200,
            131000,
            140500,
            152600,
            163000,
            173600,
            188100,
            195200,
            851800,
            895161
        ],
        "isotopes_known": "⁴⁵Fe, ⁴⁶Fe, ⁴⁷Fe, ⁴⁸Fe, ⁴⁹Fe, ⁵⁰Fe, ⁵¹Fe, ⁵²Fe, ⁵³Fe, ⁵⁴Fe, ⁵⁵Fe, ⁵⁶Fe, ⁵⁷Fe, ⁵⁸Fe, ⁵⁹Fe, ⁶⁰Fe, ⁶¹Fe, ⁶²Fe, ⁶³Fe, ⁶⁴Fe, ⁶⁵Fe, ⁶⁶Fe, ⁶⁷Fe, ⁶⁸Fe, ⁶⁹Fe, ⁷⁰Fe, ⁷¹Fe, ⁷²Fe",
        "isotopes_stable": "⁵⁴Fe, ⁵⁶Fe, ⁵⁷Fe, ⁵⁸Fe",
        "isotopic_abundances": "⁵⁴Fe: 5.845%, ⁵⁶Fe: 91.754%, ⁵⁷Fe: 2.119%, ⁵⁸Fe: 0.282%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "286.65, 286.65, 286.65",
        "lifetime": "Stable",
        "magnetic_type": "ferromagnetic",
        "melting_point": 1811,
        "modulus": {
            "bulk": 170,
            "shear": 82,
            "young": 211
        },
        "molar_volume": 0.0000070923,
        "neutron_cross_section": 2.56,
        "neutron_mass_absorption": 0.0015,
        "oxidation_states": "-2,-1,1,2c,3c,4,5,6",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.29,
        "quantum_numbers": "5D4",
        "radius": {
            "calculated": 156,
            "empirical": 140,
            "covalent": 125
        },
        "resistivity": 9.700000000001e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Iron",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 4910,
        "summary": "<p>Iron (/ˈaɪərn/) is a chemical element with symbol Fe (from Latin: ferrum) and atomic number 26. It is a metal that belongs to the first transition series and group 8 of the periodic table. It is, by mass, the most common element on Earth, right in front of oxygen (32.1% and 30.1%, respectively), forming much of Earth's outer and inner core. It is the fourth most common element in the Earth's crust.</p><p>In its metallic state, iron is rare in the Earth's crust, limited mainly to deposition by meteorites. Iron ores, by contrast, are among the most abundant in the Earth's crust, although extracting usable metal from them requires kilns or furnaces capable of reaching 1,500 °C (2,730 °F) or higher, about 500 °C (900 °F) higher than that required to smelt copper. Humans started to master that process in Eurasia by about 2000 BCE, and the use of iron tools and weapons began to displace copper alloys, in some regions, only around 1200 BCE. That event is considered the transition from the Bronze Age to the Iron Age. In the modern world, iron alloys, such as steel, stainless steel, cast iron and special steels are by far the most common industrial metals, because of their mechanical properties and low cost.</p><p>Pristine and smooth pure iron surfaces are mirror-like silvery-gray. However, iron reacts readily with oxygen and water to give brown to black hydrated iron oxides, commonly known as rust. Unlike the oxides of some other metals, that form passivating layers, rust occupies more volume than the metal and thus flakes off, exposing fresh surfaces for corrosion. Although iron readily reacts, high purity iron, called electrolytic iron, has better corrosion resistance.</p><p>The body of an adult human contains about 4 grams (0.005% body weight) of iron, mostly in hemoglobin and myoglobin. These two proteins play essential roles in vertebrate metabolism, respectively oxygen transport by blood and oxygen storage in muscles. To maintain the necessary levels, human iron metabolism requires a minimum of iron in the diet. Iron is also the metal at the active site of many important redox enzymes dealing with cellular respiration and oxidation and reduction in plants and animals.</p><p>Chemically, the most common oxidation states of iron are iron(II) and iron(III). Iron shares many properties of other transition metals, including the other group 8 elements, ruthenium and osmium. Iron forms compounds in a wide range of oxidation states, −2 to +7. Iron also forms many coordination compounds; some of them, such as ferrocene, ferrioxalate, and Prussian blue, have substantial industrial, medical, or research applications.</p>",
        "thermal_expansion": 0.0000118,
        "valence_electrons": 3
    },
    {
        "name": "Cobalt",
        "symbol": "Co",
        "abundance": {
            "universe": 0.0003,
            "solar": 0.0004,
            "meteor": 0.059,
            "crust": 0.003,
            "ocean": 8e-9,
            "human": 0.000002
        },
        "appearance": "hard lustrous gray metal",
        "atomic_mass": 58.9331944,
        "atomic_number": 27,
        "block": "d-block",
        "boiling_point": 3200,
        "classifications": {
            "cas_number": "CAS7440-48-4",
            "cid_number": "CID104730",
            "rtecs_number": "RTECSGF8750000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 100,
            "electric": 17
        },
        "cpk_hex": "f090a0",
        "crystal_structure": "Simple Hexagonal",
        "curie_point": 1394,
        "density": {
            "stp": 8900,
            "liquid": 7750
        },
        "discovered": {
            "year": 1735,
            "by": "Georg Brandt",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 63.898,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d⁷",
        "electron_configuration_semantic": "[Ar] 3d⁷ 4s²",
        "electronegativity_pauling": 1.88,
        "electrons_per_shell": [
            2,
            8,
            15,
            2
        ],
        "energy_levels": "2, 8, 15, 2",
        "group": 9,
        "half_life": "Stable",
        "hardness": {
            "vickers": 1043,
            "brinell": 700,
            "mohs": 5
        },
        "heat": {
            "specific": 421,
            "vaporization": 375,
            "fusion": 16.2,
            "molar": 24.81
        },
        "ionization_energies": [
            760.4,
            1648,
            3232,
            4950,
            7670,
            9840,
            12440,
            15230,
            17959,
            26570,
            29400,
            32400,
            36600,
            39700,
            42800,
            49396,
            52737,
            134810,
            145170,
            154700,
            167400,
            178100,
            189300,
            204500,
            214100,
            920870,
            966023
        ],
        "isotopes_known": "⁴⁷Co, ⁴⁸Co, ⁴⁹Co, ⁵⁰Co, ⁵¹Co, ⁵²Co, ⁵³Co, ⁵⁴Co, ⁵⁵Co, ⁵⁶Co, ⁵⁷Co, ⁵⁸Co, ⁵⁹Co, ⁶⁰Co, ⁶¹Co, ⁶²Co, ⁶³Co, ⁶⁴Co, ⁶⁵Co, ⁶⁶Co, ⁶⁷Co, ⁶⁸Co, ⁶⁹Co, ⁷⁰Co, ⁷¹Co, ⁷²Co, ⁷³Co, ⁷⁴Co, ⁷⁵Co",
        "isotopes_stable": "⁵⁹Co",
        "isotopic_abundances": "⁵⁹Co: 100%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "250.71, 250.71, 406.95",
        "lifetime": "Stable",
        "magnetic_type": "ferromagnetic",
        "melting_point": 1768,
        "modulus": {
            "bulk": 180,
            "shear": 75,
            "young": 209
        },
        "molar_volume": 0.00000662,
        "neutron_cross_section": 37.2,
        "neutron_mass_absorption": 0.021,
        "oxidation_states": "-1,1,2c,3c,4,5",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.31,
        "quantum_numbers": "4F9/2",
        "radius": {
            "calculated": 152,
            "empirical": 135,
            "covalent": 126
        },
        "resistivity": 6.000000000002e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Cobalt",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 4720,
        "summary": "<p>Cobalt is a chemical element with the symbol Co and atomic number 27. Like nickel, cobalt is found in the Earth's crust only in a chemically combined form, save for small deposits found in alloys of natural meteoric iron. The free element, produced by reductive smelting, is a hard, lustrous, silver-gray metal.</p><p>Cobalt-based blue pigments (cobalt blue) have been used since ancient times for jewelry and paints, and to impart a distinctive blue tint to glass, but the color was later thought to be due to the known metal bismuth. Miners had long used the name kobold ore (German for goblin ore) for some of the blue-pigment-producing minerals; they were so named because they were poor in known metals, and gave poisonous arsenic-containing fumes when smelted. In 1735, such ores were found to be reducible to a new metal (the first discovered since ancient times), and this was ultimately named for the kobold.</p><p>Today, some cobalt is produced specifically from one of a number of metallic-lustered ores, such as cobaltite (CoAsS). The element is, however, more usually produced as a by-product of copper and nickel mining. The Copperbelt in the Democratic Republic of the Congo (DRC) and Zambia yields most of the global cobalt production. World production in 2016 was 116,000 tonnes (114,000 long tons; 128,000 short tons) (according to Natural Resources Canada), and the DRC alone accounted for more than 50%.</p><p>Cobalt is primarily used in lithium-ion batteries, and in the manufacture of magnetic, wear-resistant and high-strength alloys. The compounds cobalt silicate and cobalt(II) aluminate (CoAl2O4, cobalt blue) give a distinctive deep blue color to glass, ceramics, inks, paints and varnishes. Cobalt occurs naturally as only one stable isotope, cobalt-59. Cobalt-60 is a commercially important radioisotope, used as a radioactive tracer and for the production of high-energy gamma rays.</p><p>Cobalt is the active center of a group of coenzymes called cobalamins. Vitamin B12, the best-known example of the type, is an essential vitamin for all animals. Cobalt in inorganic form is also a micronutrient for bacteria, algae, and fungi.</p>",
        "thermal_expansion": 0.000013,
        "valence_electrons": 4
    },
    {
        "name": "Nickel",
        "symbol": "Ni",
        "abundance": {
            "universe": 0.006,
            "solar": 0.008,
            "meteor": 1.3,
            "crust": 0.0089,
            "ocean": 2e-7,
            "human": 0.00001
        },
        "appearance": "lustrous, metallic, and silver with a gold tinge",
        "atomic_mass": 58.69344,
        "atomic_number": 28,
        "block": "d-block",
        "boiling_point": 3003,
        "classifications": {
            "cas_number": "CAS7440-02-0",
            "cid_number": "CID935",
            "rtecs_number": "RTECSQR5950000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 91,
            "electric": 14
        },
        "cpk_hex": "50d050",
        "crystal_structure": "Face-centered Cubic",
        "curie_point": 631,
        "density": {
            "stp": 8908,
            "liquid": 7810
        },
        "discovered": {
            "year": 1751,
            "by": "Axel Fredrik Cronstedt",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 111.65,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d⁸",
        "electron_configuration_semantic": "[Ar] 3d⁸ 4s²",
        "electronegativity_pauling": 1.91,
        "electrons_per_shell": [
            2,
            8,
            16,
            2
        ],
        "energy_levels": "2, 8, 16, 2",
        "group": 10,
        "half_life": "Stable",
        "hardness": {
            "vickers": 638,
            "brinell": 700,
            "mohs": 4
        },
        "heat": {
            "specific": 445,
            "vaporization": 378,
            "fusion": 17.2,
            "molar": 26.07
        },
        "ionization_energies": [
            737.1,
            1753,
            3395,
            5300,
            7339,
            10400,
            12800,
            15600,
            18600,
            21670,
            30970,
            34000,
            37100,
            41500,
            44800,
            48100,
            55101,
            58570,
            148700,
            159000,
            169400,
            182700,
            194000,
            205600,
            221400,
            231490,
            992718,
            1039668
        ],
        "isotopes_known": "⁴⁸Ni, ⁴⁹Ni, ⁵⁰Ni, ⁵¹Ni, ⁵²Ni, ⁵³Ni, ⁵⁴Ni, ⁵⁵Ni, ⁵⁶Ni, ⁵⁷Ni, ⁵⁸Ni, ⁵⁹Ni, ⁶⁰Ni, ⁶¹Ni, ⁶²Ni, ⁶³Ni, ⁶⁴Ni, ⁶⁵Ni, ⁶⁶Ni, ⁶⁷Ni, ⁶⁸Ni, ⁶⁹Ni, ⁷⁰Ni, ⁷¹Ni, ⁷²Ni, ⁷³Ni, ⁷⁴Ni, ⁷⁵Ni, ⁷⁶Ni, ⁷⁷Ni, ⁷⁸Ni",
        "isotopes_stable": "⁵⁸Ni, ⁶⁰Ni, ⁶¹Ni, ⁶²Ni, ⁶⁴Ni",
        "isotopic_abundances": "⁵⁸Ni: 68.0769%, ⁶⁰Ni: 26.2231%, ⁶¹Ni: 1.1399%, ⁶²Ni: 3.6345%, ⁶⁴Ni: 0.9256%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "352.4, 352.4, 352.4",
        "lifetime": "Stable",
        "magnetic_type": "ferromagnetic",
        "melting_point": 1728,
        "modulus": {
            "bulk": 180,
            "shear": 76,
            "young": 200
        },
        "molar_volume": 0.0000065888,
        "neutron_cross_section": 4.5,
        "neutron_mass_absorption": 0.0026,
        "oxidation_states": "-1,1,2c,3,4",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.31,
        "quantum_numbers": "3F4",
        "radius": {
            "calculated": 149,
            "empirical": 135,
            "covalent": 121,
            "vanderwaals": 163
        },
        "resistivity": 7.000000000002e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Nickel",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 4970,
        "summary": "<p>Nickel is a chemical element with the symbol Ni and atomic number 28. It is a silvery-white lustrous metal with a slight golden tinge. Nickel belongs to the transition metals and is hard and ductile. Pure nickel, powdered to maximize the reactive surface area, shows a significant chemical activity, but larger pieces are slow to react with air under standard conditions because an oxide layer forms on the surface and prevents further corrosion (passivation). Even so, pure native nickel is found in Earth's crust only in tiny amounts, usually in ultramafic rocks, and in the interiors of larger nickel–iron meteorites that were not exposed to oxygen when outside Earth's atmosphere.</p><p>Meteoric nickel is found in combination with iron, a reflection of the origin of those elements as major end products of supernova nucleosynthesis. An iron–nickel mixture is thought to compose Earth's outer and inner cores.</p><p>Use of nickel (as a natural meteoric nickel–iron alloy) has been traced as far back as 3500 BCE. Nickel was first isolated and classified as a chemical element in 1751 by Axel Fredrik Cronstedt, who initially mistook the ore for a copper mineral, in the cobalt mines of Los, Hälsingland, Sweden. The element's name comes from a mischievous sprite of German miner mythology, Nickel (similar to Old Nick), who personified the fact that copper-nickel ores resisted refinement into copper. An economically important source of nickel is the iron ore limonite, which often contains 1–2% nickel. Nickel's other important ore minerals include pentlandite and a mixture of Ni-rich natural silicates known as garnierite. Major production sites include the Sudbury region in Canada (which is thought to be of meteoric origin), New Caledonia in the Pacific, and Norilsk in Russia.</p><p>Nickel is slowly oxidized by air at room temperature and is considered corrosion-resistant. Historically, it has been used for plating iron and brass, coating chemistry equipment, and manufacturing certain alloys that retain a high silvery polish, such as German silver. About 9% of world nickel production is still used for corrosion-resistant nickel plating. Nickel-plated objects sometimes provoke nickel allergy. Nickel has been widely used in coins, though its rising price has led to some replacement with cheaper metals in recent years.</p><p>Nickel is one of four elements (the others are iron, cobalt, and gadolinium) that are ferromagnetic at approximately room temperature. Alnico permanent magnets based partly on nickel are of intermediate strength between iron-based permanent magnets and rare-earth magnets. The metal is valuable in modern times chiefly in alloys; about 68% of world production is used in stainless steel. A further 10% is used for nickel-based and copper-based alloys, 7% for alloy steels, 3% in foundries, 9% in plating and 4% in other applications, including the fast-growing battery sector, including those in electric vehicles (EVs). As a compound, nickel has a number of niche chemical manufacturing uses, such as a catalyst for hydrogenation, cathodes for batteries, pigments and metal surface treatments. Nickel is an essential nutrient for some microorganisms and plants that have enzymes with nickel as an active site.</p>",
        "thermal_expansion": 0.0000134,
        "valence_electrons": 2
    },
    {
        "name": "Copper",
        "symbol": "Cu",
        "abundance": {
            "universe": 0.000006,
            "solar": 0.00007,
            "meteor": 0.011,
            "crust": 0.0068,
            "ocean": 3e-7,
            "human": 0.0001
        },
        "alternate_names": "Cuprum",
        "appearance": "red-orange metallic luster",
        "atomic_mass": 63.5463,
        "atomic_number": 29,
        "block": "d-block",
        "boiling_point": 2835,
        "classifications": {
            "cas_number": "CAS7440-50-8",
            "cid_number": "CID23978",
            "rtecs_number": "RTECSGL5325000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 400,
            "electric": 59
        },
        "cpk_hex": "c88033",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 8960,
            "liquid": 8020
        },
        "discovered": {
            "year": -8000,
            "by": "Middle East"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 119.235,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s¹ 3d¹⁰",
        "electron_configuration_semantic": "[Ar] 3d¹⁰ 4s¹",
        "electronegativity_pauling": 1.9,
        "electrons_per_shell": [
            2,
            8,
            18,
            1
        ],
        "energy_levels": "2, 8, 18, 1",
        "group": 11,
        "half_life": "Stable",
        "hardness": {
            "vickers": 369,
            "brinell": 874,
            "mohs": 3
        },
        "heat": {
            "specific": 384.4,
            "vaporization": 300,
            "fusion": 13.1,
            "molar": 24.44
        },
        "ionization_energies": [
            745.5,
            1957.9,
            3555,
            5536,
            7700,
            9900,
            13400,
            16000,
            19200,
            22400,
            25600,
            35600,
            38700,
            42000,
            46700,
            50200,
            53700,
            61100,
            64702,
            163700,
            174100,
            184900,
            198800,
            210500,
            222700,
            239100,
            249660,
            1067358,
            1116105
        ],
        "isotopes_known": "⁵²Cu, ⁵³Cu, ⁵⁴Cu, ⁵⁵Cu, ⁵⁶Cu, ⁵⁷Cu, ⁵⁸Cu, ⁵⁹Cu, ⁶⁰Cu, ⁶¹Cu, ⁶²Cu, ⁶³Cu, ⁶⁴Cu, ⁶⁵Cu, ⁶⁶Cu, ⁶⁷Cu, ⁶⁸Cu, ⁶⁹Cu, ⁷⁰Cu, ⁷¹Cu, ⁷²Cu, ⁷³Cu, ⁷⁴Cu, ⁷⁵Cu, ⁷⁶Cu, ⁷⁷Cu, ⁷⁸Cu, ⁷⁹Cu, ⁸⁰Cu",
        "isotopes_stable": "⁶³Cu, ⁶⁵Cu",
        "isotopic_abundances": "⁶³Cu: 69.17%, ⁶⁵Cu: 30.83%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "361.49, 361.49, 361.49",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -1.08e-9,
            "molar": -6.86e-11,
            "volume": -0.00000963
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 1357.77,
        "modulus": {
            "bulk": 140,
            "shear": 48,
            "young": 130
        },
        "molar_volume": 0.0000070922,
        "neutron_cross_section": 3.78,
        "neutron_mass_absorption": 0.0021,
        "oxidation_states": "1,2c,3,4",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.34,
        "quantum_numbers": "2S1/2",
        "radius": {
            "calculated": 145,
            "empirical": 135,
            "covalent": 138,
            "vanderwaals": 140
        },
        "resistivity": 1.7e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Copper",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 3570,
        "summary": "<p>Copper is a chemical element with the symbol Cu (from Latin: cuprum) and atomic number 29. It is a soft, malleable, and ductile metal with very high thermal and electrical conductivity. A freshly exposed surface of pure copper has a pinkish-orange color. Copper is used as a conductor of heat and electricity, as a building material, and as a constituent of various metal alloys, such as sterling silver used in jewelry, cupronickel used to make marine hardware and coins, and constantan used in strain gauges and thermocouples for temperature measurement.</p><p>Copper is one of the few metals that can occur in nature in a directly usable metallic form (native metals). This led to very early human use in several regions, from c. 8000 BC. Thousands of years later, it was the first metal to be smelted from sulfide ores, c. 5000 BC; the first metal to be cast into a shape in a mold, c. 4000 BC; and the first metal to be purposely alloyed with another metal, tin, to create bronze, c. 3500 BC.</p><p>In the Roman era, copper was mined principally on Cyprus, the origin of the name of the metal, from aes сyprium (metal of Cyprus), later corrupted to сuprum (Latin). Coper (Old English) and copper were derived from this, the later spelling first used around 1530.</p><p>Commonly encountered compounds are copper(II) salts, which often impart blue or green colors to such minerals as azurite, malachite, and turquoise, and have been used widely and historically as pigments.</p><p>Copper used in buildings, usually for roofing, oxidizes to form a green verdigris (or patina). Copper is sometimes used in decorative art, both in its elemental metal form and in compounds as pigments. Copper compounds are used as bacteriostatic agents, fungicides, and wood preservatives.</p><p>Copper is essential to all living organisms as a trace dietary mineral because it is a key constituent of the respiratory enzyme complex cytochrome c oxidase. In molluscs and crustaceans, copper is a constituent of the blood pigment hemocyanin, replaced by the iron-complexed hemoglobin in fish and other vertebrates. In humans, copper is found mainly in the liver, muscle, and bone. The adult body contains between 1.4 and 2.1 mg of copper per kilogram of body weight.</p>",
        "thermal_expansion": 0.0000165,
        "valence_electrons": 2
    },
    {
        "name": "Zinc",
        "symbol": "Zn",
        "abundance": {
            "universe": 0.00003,
            "solar": 0.0002,
            "meteor": 0.018,
            "crust": 0.0078,
            "ocean": 5e-7,
            "human": 0.0033
        },
        "appearance": "silver-gray",
        "atomic_mass": 65.382,
        "atomic_number": 30,
        "block": "d-block",
        "boiling_point": 1180,
        "classifications": {
            "cas_number": "CAS7440-66-6",
            "cid_number": "CID23994",
            "rtecs_number": "RTECSZG8600000",
            "dot_numbers": 1436,
            "dot_hazard_class": 4.3
        },
        "conductivity": {
            "thermal": 120,
            "electric": 17
        },
        "cpk_hex": "7d80b0",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 7140,
            "liquid": 6570
        },
        "discovered": {
            "year": 1500,
            "by": "India",
            "location": "Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": -58,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰",
        "electron_configuration_semantic": "[Ar] 3d¹⁰ 4s²",
        "electronegativity_pauling": 1.65,
        "electrons_per_shell": [
            2,
            8,
            18,
            2
        ],
        "energy_levels": "2, 8, 18, 2",
        "group": 12,
        "half_life": "Stable",
        "hardness": {
            "brinell": 412,
            "mohs": 2.5
        },
        "heat": {
            "specific": 388,
            "vaporization": 119,
            "fusion": 7.35,
            "molar": 25.47
        },
        "ionization_energies": [
            906.4,
            1733.3,
            3833,
            5731,
            7970,
            10400,
            12900,
            16800,
            19600,
            23000,
            26400,
            29990,
            40490,
            43800,
            47300,
            52300,
            55900,
            59700,
            67300,
            71200,
            179100
        ],
        "isotopes_known": "⁵⁴Zn, ⁵⁵Zn, ⁵⁶Zn, ⁵⁷Zn, ⁵⁸Zn, ⁵⁹Zn, ⁶⁰Zn, ⁶¹Zn, ⁶²Zn, ⁶³Zn, ⁶⁴Zn, ⁶⁵Zn, ⁶⁶Zn, ⁶⁷Zn, ⁶⁸Zn, ⁶⁹Zn, ⁷⁰Zn, ⁷¹Zn, ⁷²Zn, ⁷³Zn, ⁷⁴Zn, ⁷⁵Zn, ⁷⁶Zn, ⁷⁷Zn, ⁷⁸Zn, ⁷⁹Zn, ⁸⁰Zn, ⁸¹Zn, ⁸²Zn, ⁸³Zn",
        "isotopes_stable": "⁶⁴Zn, ⁶⁶Zn, ⁶⁷Zn, ⁶⁸Zn, ⁷⁰Zn",
        "isotopic_abundances": "⁶⁴Zn: 48.63%, ⁶⁶Zn: 27.9%, ⁶⁷Zn: 4.1%, ⁶⁸Zn: 18.75%, ⁷⁰Zn: 0.62%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "266.49, 266.49, 494.68",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -2.21e-9,
            "molar": -1.45e-10,
            "volume": -0.0000158
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 692.68,
        "modulus": {
            "bulk": 70,
            "shear": 43,
            "young": 108
        },
        "molar_volume": 0.000009157,
        "neutron_cross_section": 1.1,
        "neutron_mass_absorption": 0.00055,
        "oxidation_states": "1,2c",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.25,
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 142,
            "empirical": 135,
            "covalent": 131,
            "vanderwaals": 139
        },
        "refractive_index": 1.00205,
        "resistivity": 5.900000000001e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Zinc",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 3700,
        "summary": "<p>Zinc is a chemical element with the symbol Zn and atomic number 30. Zinc is a slightly brittle metal at room temperature and has a silvery-greyish appearance when oxidation is removed. It is the first element in group 12 (IIB) of the periodic table. In some respects, zinc is chemically similar to magnesium: both elements exhibit only one normal oxidation state (+2), and the Zn2+ and Mg2+ ions are of similar size. Zinc is the 24th most abundant element in Earth's crust and has five stable isotopes. The most common zinc ore is sphalerite (zinc blende), a zinc sulfide mineral. The largest workable lodes are in Australia, Asia, and the United States. Zinc is refined by froth flotation of the ore, roasting, and final extraction using electricity (electrowinning).</p><p>Brass, an alloy of copper and zinc in various proportions, was used as early as the third millennium BC in the Aegean area and the region which currently includes Iraq, the United Arab Emirates, Kalmykia, Turkmenistan and Georgia. In the second millennium BC it was used in the regions currently including West India, Uzbekistan, Iran, Syria, Iraq, and Israel. Zinc metal was not produced on a large scale until the 12th century in India, though it was known to the ancient Romans and Greeks. The mines of Rajasthan have given definite evidence of zinc production going back to the 6th century BC. To date, the oldest evidence of pure zinc comes from Zawar, in Rajasthan, as early as the 9th century AD when a distillation process was employed to make pure zinc. Alchemists burned zinc in air to form what they called \"philosopher's wool\" or \"white snow\".</p><p>The element was probably named by the alchemist Paracelsus after the German word Zinke (prong, tooth). German chemist Andreas Sigismund Marggraf is credited with discovering pure metallic zinc in 1746. Work by Luigi Galvani and Alessandro Volta uncovered the electrochemical properties of zinc by 1800. Corrosion-resistant zinc plating of iron (hot-dip galvanizing) is the major application for zinc. Other applications are in electrical batteries, small non-structural castings, and alloys such as brass. A variety of zinc compounds are commonly used, such as zinc carbonate and zinc gluconate (as dietary supplements), zinc chloride (in deodorants), zinc pyrithione (anti-dandruff shampoos), zinc sulfide (in luminescent paints), and dimethylzinc or diethylzinc in the organic laboratory.</p><p>Zinc is an essential mineral, including to prenatal and postnatal development. Zinc deficiency affects about two billion people in the developing world and is associated with many diseases. In children, deficiency causes growth retardation, delayed sexual maturation, infection susceptibility, and diarrhea. Enzymes with a zinc atom in the reactive center are widespread in biochemistry, such as alcohol dehydrogenase in humans. Consumption of excess zinc may cause ataxia, lethargy, and copper deficiency.</p>",
        "superconducting_point": 0.85,
        "thermal_expansion": 0.0000302,
        "valence_electrons": 2
    },
    {
        "name": "Gallium",
        "symbol": "Ga",
        "abundance": {
            "universe": 0.000001,
            "solar": 0.000004,
            "meteor": 0.00076,
            "crust": 0.0019,
            "ocean": 3e-9
        },
        "appearance": "silver-white",
        "atomic_mass": 69.7231,
        "atomic_number": 31,
        "block": "p-block",
        "boiling_point": 2673,
        "classifications": {
            "cas_number": "CAS7440-55-3",
            "cid_number": "CID5360835",
            "rtecs_number": "RTECSLW8600000",
            "dot_numbers": 2803,
            "dot_hazard_class": 8
        },
        "conductivity": {
            "thermal": 29,
            "electric": 7.1
        },
        "cpk_hex": "c28f8f",
        "crystal_structure": "Base Orthorhombic",
        "density": {
            "stp": 5904,
            "liquid": 6095
        },
        "discovered": {
            "year": 1875,
            "by": "Lecoq de Boisbaudran",
            "location": "France"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 41,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p¹",
        "electron_configuration_semantic": "[Ar] 3d¹⁰ 4s² 4p¹",
        "electronegativity_pauling": 1.81,
        "electrons_per_shell": [
            2,
            8,
            18,
            3
        ],
        "energy_levels": "2, 8, 18, 3",
        "group": 13,
        "half_life": "Stable",
        "hardness": {
            "brinell": 60,
            "mohs": 1.5
        },
        "heat": {
            "specific": 371,
            "vaporization": 256,
            "fusion": 5.59,
            "molar": 25.86
        },
        "ionization_energies": [
            578.8,
            1979.3,
            2963,
            6180
        ],
        "isotopes_known": "⁵⁶Ga, ⁵⁷Ga, ⁵⁸Ga, ⁵⁹Ga, ⁶⁰Ga, ⁶¹Ga, ⁶²Ga, ⁶³Ga, ⁶⁴Ga, ⁶⁵Ga, ⁶⁶Ga, ⁶⁷Ga, ⁶⁸Ga, ⁶⁹Ga, ⁷⁰Ga, ⁷¹Ga, ⁷²Ga, ⁷³Ga, ⁷⁴Ga, ⁷⁵Ga, ⁷⁶Ga, ⁷⁷Ga, ⁷⁸Ga, ⁷⁹Ga, ⁸⁰Ga, ⁸¹Ga, ⁸²Ga, ⁸³Ga, ⁸⁴Ga, ⁸⁵Ga, ⁸⁶Ga",
        "isotopes_stable": "⁶⁹Ga, ⁷¹Ga",
        "isotopic_abundances": "⁶⁹Ga: 60.108%, ⁷¹Ga: 39.892%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "451.97, 766.33, 452.6",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -3e-9,
            "molar": -2.09e-10,
            "volume": -0.0000177
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 302.9146,
        "molar_volume": 0.000011809,
        "neutron_cross_section": 2.9,
        "neutron_mass_absorption": 0.0015,
        "oxidation_states": "1,2,3c",
        "period": 4,
        "phase": "Solid",
        "quantum_numbers": "2P1/2",
        "radius": {
            "calculated": 136,
            "empirical": 130,
            "covalent": 126,
            "vanderwaals": 187
        },
        "resistivity": 1.4e-7,
        "series": "post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Gallium",
        "space_group_name": "Cmca",
        "space_group_number": 64,
        "speed_of_sound": 2740,
        "summary": "<p>Gallium is a chemical element with the symbol Ga and atomic number 31. Discovered by French chemist Paul-Èmile Lecoq De Boisbaudran in 1875, Gallium is in group 13 of the periodic table, and has similarities to the other metals of the group (aluminium, indium, and thallium).</p><p>Elemental gallium is a soft, silvery metal at standard temperature and pressure. In its liquid state, it becomes silvery white. If too much force is applied, the gallium may fracture conchoidally. Since its discovery in 1875, gallium has widely been used to make alloys with low melting points. It is also used in semiconductors, as a dopant in semiconductor substrates.</p><p>The melting point of gallium is used as a temperature reference point. Gallium alloys are used in thermometers as a non-toxic and environmentally friendly alternative to mercury, and can withstand higher temperatures than mercury. An even lower melting point of −19 °C (−2 °F), well below the freezing point of water, is claimed for the alloy galinstan (62–⁠95% gallium, 5–⁠22% indium, and 0–⁠16% tin by weight), but that may be the freezing point with the effect of supercooling.</p><p>Gallium does not occur as a free element in nature, but as gallium (III) compounds in trace amounts in zinc ores (such as sphalerite) and in bauxite. Elemental gallium is a liquid at temperatures greater than 29.76 °C (85.57 °F), and will melt in a person's hands at normal human body temperature of 37.0 °C (98.6 °F).</p><p>Gallium is predominantly used in electronics. Gallium arsenide, the primary chemical compound of gallium in electronics, is used in microwave circuits, high-speed switching circuits, and infrared circuits. Semiconducting gallium nitride and indium gallium nitride produce blue and violet light-emitting diodes (LEDs) and diode lasers. Gallium is also used in the production of artificial gadolinium gallium garnet for jewelry. Gallium is considered a technology-critical element by the United States National Library of Medicine and Frontiers Media.</p><p>Gallium has no known natural role in biology. Gallium(III) behaves in a similar manner to ferric salts in biological systems and has been used in some medical applications, including pharmaceuticals and radiopharmaceuticals.</p>",
        "superconducting_point": 1.083,
        "thermal_expansion": 0.00012,
        "valence_electrons": 3
    },
    {
        "name": "Germanium",
        "symbol": "Ge",
        "abundance": {
            "universe": 0.00002,
            "solar": 0.00002,
            "meteor": 0.0021,
            "crust": 0.00014,
            "ocean": 6e-9
        },
        "appearance": "grayish-white",
        "atomic_mass": 72.6308,
        "atomic_number": 32,
        "block": "p-block",
        "boiling_point": 3106,
        "classifications": {
            "cas_number": "CAS7440-56-4",
            "cid_number": "CID6326954",
            "rtecs_number": "RTECSLY5200000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 60,
            "electric": 0.002
        },
        "cpk_hex": "668f8f",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 5323,
            "liquid": 5600
        },
        "discovered": {
            "year": 1886,
            "by": "Clemens Winkler",
            "location": "Germany"
        },
        "electrical_type": "Semiconductor",
        "electron_affinity": 118.9352,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p²",
        "electron_configuration_semantic": "[Ar] 3d¹⁰ 4s² 4p²",
        "electronegativity_pauling": 2.01,
        "electrons_per_shell": [
            2,
            8,
            18,
            4
        ],
        "energy_levels": "2, 8, 18, 4",
        "group": 14,
        "half_life": "Stable",
        "hardness": {
            "mohs": 6
        },
        "heat": {
            "specific": 321.4,
            "vaporization": 334,
            "fusion": 31.8,
            "molar": 23.222
        },
        "ionization_energies": [
            762,
            1537.5,
            3302.1,
            4411,
            9020
        ],
        "isotopes_known": "⁵⁸Ge, ⁵⁹Ge, ⁶⁰Ge, ⁶¹Ge, ⁶²Ge, ⁶³Ge, ⁶⁴Ge, ⁶⁵Ge, ⁶⁶Ge, ⁶⁷Ge, ⁶⁸Ge, ⁶⁹Ge, ⁷⁰Ge, ⁷¹Ge, ⁷²Ge, ⁷³Ge, ⁷⁴Ge, ⁷⁵Ge, ⁷⁶Ge, ⁷⁷Ge, ⁷⁸Ge, ⁷⁹Ge, ⁸⁰Ge, ⁸¹Ge, ⁸²Ge, ⁸³Ge, ⁸⁴Ge, ⁸⁵Ge, ⁸⁶Ge, ⁸⁷Ge, ⁸⁸Ge, ⁸⁹Ge",
        "isotopes_stable": "⁷⁰Ge, ⁷²Ge, ⁷³Ge, ⁷⁴Ge",
        "isotopic_abundances": "⁷⁰Ge: 20.84%, ⁷²Ge: 27.54%, ⁷³Ge: 7.73%, ⁷⁴Ge: 36.28%, ⁷⁶Ge: 7.61%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "565.75, 565.75, 565.75",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -1.5e-9,
            "molar": -1.09e-10,
            "volume": -0.00000798
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 1211.4,
        "molar_volume": 0.000013645,
        "neutron_cross_section": 2.2,
        "neutron_mass_absorption": 0.0011,
        "oxidation_states": "-4c,1,2c,3,4c",
        "period": 4,
        "phase": "Solid",
        "quantum_numbers": "3P0",
        "radius": {
            "calculated": 125,
            "empirical": 125,
            "covalent": 122
        },
        "resistivity": 0.0005,
        "series": "metalloid",
        "source": "https://en.wikipedia.org/wiki/Germanium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 5400,
        "summary": "<p>Germanium is a chemical element with the symbol Ge and atomic number 32. It is a lustrous, hard-brittle, grayish-white metalloid in the carbon group, chemically similar to its group neighbors silicon and tin. Pure germanium is a semiconductor with an appearance similar to elemental silicon. Like silicon, germanium naturally reacts and forms complexes with oxygen in nature.</p><p>Because it seldom appears in high concentration, germanium was discovered comparatively late in the history of chemistry. Germanium ranks near fiftieth in relative abundance of the elements in the Earth's crust. In 1869, Dmitri Mendeleev predicted its existence and some of its properties from its position on his periodic table, and called the element ekasilicon. Nearly two decades later, in 1886, Clemens Winkler found the new element along with silver and sulfur, in an uncommon mineral called argyrodite. Although the new element somewhat resembled arsenic and antimony in appearance, the combining ratios in compounds agreed with Mendeleev's predictions for a relative of silicon. Winkler named the element after his country, Germany. Today, germanium is mined primarily from sphalerite (the primary ore of zinc), though germanium is also recovered commercially from silver, lead, and copper ores.</p><p>Elemental germanium is used as a semiconductor in transistors and various other electronic devices. Historically, the first decade of semiconductor electronics was based entirely on germanium. Presently, the major end uses are fibre-optic systems, infrared optics, solar cell applications, and light-emitting diodes (LEDs). Germanium compounds are also used for polymerization catalysts and have most recently found use in the production of nanowires. This element forms a large number of organogermanium compounds, such as tetraethylgermanium, useful in organometallic chemistry. Germanium is considered a technology-critical element.</p><p>Germanium is not thought to be an essential element for any living organism. Some complex organic germanium compounds are being investigated as possible pharmaceuticals, though none have yet proven successful. Similar to silicon and aluminium, naturally-occurring germanium compounds tend to be insoluble in water and thus have little oral toxicity. However, synthetic soluble germanium salts are nephrotoxic, and synthetic chemically reactive germanium compounds with halogens and hydrogen are irritants and toxins.</p>",
        "thermal_expansion": 0.000006,
        "valence_electrons": 4
    },
    {
        "name": "Arsenic",
        "symbol": "As",
        "abundance": {
            "universe": 8e-7,
            "meteor": 0.00018,
            "crust": 0.00021,
            "ocean": 2.3e-7,
            "human": 0.000005
        },
        "allotropes": "Yellow Arsenic, Black Arsenic, Gray Arsenic",
        "appearance": "metallic grey",
        "atomic_mass": 74.9215956,
        "atomic_number": 33,
        "block": "p-block",
        "boiling_point": 887,
        "classifications": {
            "cas_number": "CAS7440-38-2",
            "cid_number": "CID5359596",
            "rtecs_number": "RTECSCG0525000",
            "dot_numbers": 1558,
            "dot_hazard_class": 6.1
        },
        "conductivity": {
            "thermal": 50,
            "electric": 3.3
        },
        "cpk_hex": "bd80e3",
        "crystal_structure": "Simple Trigonal",
        "density": {
            "stp": 5727,
            "liquid": 5220
        },
        "discovered": {
            "year": 1250,
            "by": "Bronze Age"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 77.65,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p³",
        "electron_configuration_semantic": "[Ar] 3d¹⁰ 4s² 4p³",
        "electronegativity_pauling": 2.18,
        "electrons_per_shell": [
            2,
            8,
            18,
            5
        ],
        "energy_levels": "2, 8, 18, 5",
        "group": 15,
        "half_life": "Stable",
        "hardness": {
            "brinell": 1440,
            "mohs": 3.5
        },
        "heat": {
            "specific": 328,
            "vaporization": 32.4,
            "fusion": 27.7,
            "molar": 24.64
        },
        "ionization_energies": [
            947,
            1798,
            2735,
            4837,
            6043,
            12310
        ],
        "isotopes_known": "⁶⁰As, ⁶¹As, ⁶²As, ⁶³As, ⁶⁴As, ⁶⁵As, ⁶⁶As, ⁶⁷As, ⁶⁸As, ⁶⁹As, ⁷⁰As, ⁷¹As, ⁷²As, ⁷³As, ⁷⁴As, ⁷⁵As, ⁷⁶As, ⁷⁷As, ⁷⁸As, ⁷⁹As, ⁸⁰As, ⁸¹As, ⁸²As, ⁸³As, ⁸⁴As, ⁸⁵As, ⁸⁶As, ⁸⁷As, ⁸⁸As, ⁸⁹As, ⁹⁰As, ⁹¹As, ⁹²As",
        "isotopes_stable": "⁷⁵As",
        "isotopic_abundances": "⁷⁵As: 100%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "375.98, 375.98, 1054.75",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -3.9e-9,
            "molar": -2.92e-10,
            "volume": -0.0000223
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 1090,
        "modulus": {
            "bulk": 22,
            "young": 8
        },
        "molar_volume": 0.000013082,
        "neutron_cross_section": 4.2,
        "neutron_mass_absorption": 0.002,
        "oxidation_states": "-3c,2,3c,5c",
        "period": 4,
        "phase": "Solid",
        "quantum_numbers": "4S3/2",
        "radius": {
            "calculated": 114,
            "empirical": 115,
            "covalent": 119,
            "vanderwaals": 185
        },
        "refractive_index": 1.001552,
        "resistivity": 3e-7,
        "series": "metalloid",
        "source": "https://en.wikipedia.org/wiki/Arsenic",
        "space_group_name": "R_3m",
        "space_group_number": 166,
        "summary": "<p class=\"mw-empty-elt\"></p><p>Arsenic is a chemical element with the symbol As and atomic number 33. Arsenic occurs in many minerals, usually in combination with sulfur and metals, but also as a pure elemental crystal. Arsenic is a metalloid. It has various allotropes, but only the gray form, which has a metallic appearance, is important to industry.</p><p>The primary use of arsenic is in alloys of lead (for example, in car batteries and ammunition). Arsenic is a common n-type dopant in semiconductor electronic devices. It is also a component of the III-V compound semiconductor gallium arsenide. Arsenic and its compounds, especially the trioxide, are used in the production of pesticides, treated wood products, herbicides, and insecticides. These applications are declining with the increasing recognition of the toxicity of arsenic and its compounds.</p><p>A few species of bacteria are able to use arsenic compounds as respiratory metabolites. Trace quantities of arsenic are an essential dietary element in rats, hamsters, goats, chickens, and presumably other species. A role in human metabolism is not known. However, arsenic poisoning occurs in multicellular life if quantities are larger than needed. Arsenic contamination of groundwater is a problem that affects millions of people across the world.</p><p>The United States' Environmental Protection Agency states that all forms of arsenic are a serious risk to human health. The United States' Agency for Toxic Substances and Disease Registry ranked arsenic as number 1 in its 2001 Priority List of Hazardous Substances at Superfund sites. Arsenic is classified as a Group-A carcinogen.</p>",
        "valence_electrons": 5
    },
    {
        "name": "Selenium",
        "symbol": "Se",
        "abundance": {
            "universe": 0.000003,
            "meteor": 0.0013,
            "crust": 0.000005,
            "ocean": 4.5e-8,
            "human": 0.000005
        },
        "allotropes": "Amorphous Red Selenium, Amorphous Black Selenium, Monoclinic Selenium, Hexagonal Selenium",
        "appearance": "black, red, and gray (not pictured) allotropes",
        "atomic_mass": 78.9718,
        "atomic_number": 34,
        "block": "p-block",
        "boiling_point": 958,
        "classifications": {
            "cas_number": "CAS7782-49-2",
            "cid_number": "CID6326970",
            "rtecs_number": "RTECSVS7700000",
            "dot_numbers": 2658,
            "dot_hazard_class": 6.1
        },
        "conductivity": {
            "thermal": 0.52
        },
        "cpk_hex": "ffa100",
        "critical_pressure": 27.2,
        "critical_temperature": 1766,
        "crystal_structure": "Simple Monoclinic",
        "density": {
            "stp": 4819,
            "liquid": 3990
        },
        "discovered": {
            "year": 1817,
            "by": "Jöns Jakob Berzelius",
            "location": "Sweden"
        },
        "electron_affinity": 194.9587,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁴",
        "electron_configuration_semantic": "[Ar] 3d¹⁰ 4s² 4p⁴",
        "electronegativity_pauling": 2.55,
        "electrons_per_shell": [
            2,
            8,
            18,
            6
        ],
        "energy_levels": "2, 8, 18, 6",
        "group": 16,
        "half_life": "Stable",
        "hardness": {
            "brinell": 736,
            "mohs": 2
        },
        "heat": {
            "specific": 321.2,
            "vaporization": 26,
            "fusion": 5.4,
            "molar": 25.363
        },
        "ionization_energies": [
            941,
            2045,
            2973.7,
            4144,
            6590,
            7880,
            14990
        ],
        "isotopes_known": "⁶⁵Se, ⁶⁶Se, ⁶⁷Se, ⁶⁸Se, ⁶⁹Se, ⁷⁰Se, ⁷¹Se, ⁷²Se, ⁷³Se, ⁷⁴Se, ⁷⁵Se, ⁷⁶Se, ⁷⁷Se, ⁷⁸Se, ⁷⁹Se, ⁸⁰Se, ⁸¹Se, ⁸²Se, ⁸³Se, ⁸⁴Se, ⁸⁵Se, ⁸⁶Se, ⁸⁷Se, ⁸⁸Se, ⁸⁹Se, ⁹⁰Se, ⁹¹Se, ⁹²Se, ⁹³Se, ⁹⁴Se",
        "isotopes_stable": "⁷⁴Se, ⁷⁶Se, ⁷⁷Se, ⁷⁸Se, ⁸⁰Se",
        "isotopic_abundances": "⁷⁴Se: 0.89%, ⁷⁶Se: 9.37%, ⁷⁷Se: 7.63%, ⁷⁸Se: 23.77%, ⁸⁰Se: 49.61%, ⁸²Se: 8.73%",
        "lattice_angles": "π/2, 1.58493, π/2",
        "lattice_constants": "905.4, 908.3, 1160.1",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -4e-9,
            "molar": -3.16e-10,
            "volume": -0.0000193
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 494,
        "modulus": {
            "bulk": 8.3,
            "shear": 3.7,
            "young": 10
        },
        "molar_volume": 0.000016387,
        "neutron_cross_section": 11.7,
        "neutron_mass_absorption": 0.0056,
        "oxidation_states": "-2c,1,2c,4c,6c",
        "period": 4,
        "phase": "Solid",
        "poisson_ratio": 0.33,
        "quantum_numbers": "3P2",
        "radius": {
            "calculated": 103,
            "empirical": 115,
            "covalent": 116,
            "vanderwaals": 190
        },
        "refractive_index": 1.000895,
        "series": "polyatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Selenium",
        "space_group_name": "P121/c1",
        "space_group_number": 14,
        "speed_of_sound": 3350,
        "summary": "<p>Selenium is a chemical element with the symbol Se and atomic number 34. It is a nonmetal (more rarely considered a metalloid) with properties that are intermediate between the elements above and below in the periodic table, sulfur and tellurium, and also has similarities to arsenic. It rarely occurs in its elemental state or as pure ore compounds in the Earth's crust. Selenium—from Greek selḗnē (σελήνη 'Moon')—was discovered in 1817 by Jöns Jacob Berzelius, who noted the similarity of the new element to the previously discovered tellurium (named for the Earth).</p><p>Selenium is found in metal sulfide ores, where it partially replaces the sulfur. Commercially, selenium is produced as a byproduct in the refining of these ores, most often during production. Minerals that are pure selenide or selenate compounds are known but rare. The chief commercial uses for selenium today are glassmaking and pigments. Selenium is a semiconductor and is used in photocells. Applications in electronics, once important, have been mostly replaced with silicon semiconductor devices. Selenium is still used in a few types of DC power surge protectors and one type of fluorescent quantum dot.</p><p>Although trace amounts of selenium are necessary for cellular function in many animals, including humans, both elemental selenium and (especially) selenium salts are toxic in even small doses, causing selenosis. Selenium is listed as an ingredient in many multivitamins and other dietary supplements, as well as in infant formula, and is a component of the antioxidant enzymes glutathione peroxidase and thioredoxin reductase (which indirectly reduce certain oxidized molecules in animals and some plants) as well as in three deiodinase enzymes. Selenium requirements in plants differ by species, with some plants requiring relatively large amounts and others apparently requiring none.</p>",
        "valence_electrons": 6
    },
    {
        "name": "Bromine",
        "symbol": "Br",
        "abundance": {
            "universe": 7e-7,
            "meteor": 0.00012,
            "crust": 0.0003,
            "ocean": 0.0067,
            "human": 0.00029
        },
        "allotropes": "Dibromine",
        "atomic_mass": 79.904,
        "atomic_number": 35,
        "block": "p-block",
        "boiling_point": 332,
        "classifications": {
            "cas_number": "CAS7726-95-6",
            "cid_number": "CID24408",
            "rtecs_number": "RTECSEF9100000",
            "dot_numbers": 1744,
            "dot_hazard_class": 8
        },
        "conductivity": {
            "thermal": 0.12,
            "electric": 1e-16
        },
        "cpk_hex": "a62929",
        "critical_pressure": 10.34,
        "critical_temperature": 588,
        "crystal_structure": "Base Orthorhombic",
        "density": {
            "stp": 3120,
            "liquid": 3120
        },
        "discovered": {
            "year": 1826,
            "by": "Antoine Jérôme Balard",
            "location": "France"
        },
        "electrical_type": "Insulator",
        "electron_affinity": 324.537,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁵",
        "electron_configuration_semantic": "[Ar] 3d¹⁰ 4s² 4p⁵",
        "electronegativity_pauling": 2.96,
        "electrons_per_shell": [
            2,
            8,
            18,
            7
        ],
        "energy_levels": "2, 8, 18, 7",
        "group": 17,
        "half_life": "Stable",
        "heat": {
            "specific": 947.3,
            "vaporization": 14.8,
            "fusion": 5.8
        },
        "ionization_energies": [
            1139.9,
            2103,
            3470,
            4560,
            5760,
            8550,
            9940,
            18600
        ],
        "isotopes_known": "⁶⁷Br, ⁶⁸Br, ⁶⁹Br, ⁷⁰Br, ⁷¹Br, ⁷²Br, ⁷³Br, ⁷⁴Br, ⁷⁵Br, ⁷⁶Br, ⁷⁷Br, ⁷⁸Br, ⁷⁹Br, ⁸⁰Br, ⁸¹Br, ⁸²Br, ⁸³Br, ⁸⁴Br, ⁸⁵Br, ⁸⁶Br, ⁸⁷Br, ⁸⁸Br, ⁸⁹Br, ⁹⁰Br, ⁹¹Br, ⁹²Br, ⁹³Br, ⁹⁴Br, ⁹⁵Br, ⁹⁶Br, ⁹⁷Br",
        "isotopes_stable": "⁷⁹Br, ⁸¹Br",
        "isotopic_abundances": "⁷⁹Br: 50.69%, ⁸¹Br: 49.31%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "672.65, 464.51, 870.23",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -4.9e-9,
            "molar": -7.83e-10,
            "volume": -0.0000153
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 265.8,
        "modulus": {
            "bulk": 1.9
        },
        "molar_volume": 0.00002561,
        "neutron_cross_section": 6.8,
        "neutron_mass_absorption": 0.002,
        "oxidation_states": "-1c,1c,3c,4,5c,7",
        "period": 4,
        "phase": "Liquid",
        "quantum_numbers": "2P3/2",
        "radius": {
            "calculated": 94,
            "empirical": 115,
            "covalent": 114,
            "vanderwaals": 185
        },
        "refractive_index": 1.001132,
        "resistivity": 10000000000,
        "series": "diatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Bromine",
        "space_group_name": "Cmca",
        "space_group_number": 64,
        "summary": "<p>Bromine is a chemical element with the symbol Br and atomic number 35. It is the third-lightest halogen, and is a fuming red-brown liquid at room temperature that evaporates readily to form a similarly coloured vapour. Its properties are intermediate between those of chlorine and iodine. Isolated independently by two chemists, Carl Jacob Löwig (in 1825) and Antoine Jérôme Balard (in 1826), its name was derived from the Ancient Greek βρῶμος (\"stench\"), referring to its sharp and disagreeable smell.</p><p>Elemental bromine is very reactive and thus does not occur free in nature, but in colourless soluble crystalline mineral halide salts, analogous to table salt. While it is rather rare in the Earth's crust, the high solubility of the bromide ion (Br−) has caused its accumulation in the oceans. Commercially the element is easily extracted from brine evaporation ponds, mostly in the United States, Israel, and China. The mass of bromine in the oceans is about one three-hundredth that of chlorine.</p><p>At standard conditions for temperature and pressure it is a liquid; the only other element that is liquid under these conditions is mercury. At high temperatures, organobromine compounds readily dissociate to yield free bromine atoms, a process that stops free radical chemical chain reactions. This effect makes organobromine compounds useful as fire retardants, and more than half the bromine produced worldwide each year is put to this purpose. The same property causes ultraviolet sunlight to dissociate volatile organobromine compounds in the atmosphere to yield free bromine atoms, causing ozone depletion. As a result, many organobromine compounds—such as the pesticide methyl bromide—are no longer used. Bromine compounds are still used in well drilling fluids, in photographic film, and as an intermediate in the manufacture of organic chemicals.</p><p>Large amounts of bromide salts are toxic from the action of soluble bromide ions, causing bromism. However, a clear biological role for bromide ion and hypobromous acid has recently been elucidated, and it now appears that bromine is an essential trace element in humans. The role of biological organobromine compounds in sea life such as algae has been known for much longer. As a pharmaceutical, the simple bromide ion (Br−) has inhibitory effects on the central nervous system, and bromide salts were once a major medical sedative, before replacement by shorter-acting drugs. They retain niche uses as antiepileptics.</p>",
        "valence_electrons": 5
    },
    {
        "name": "Krypton",
        "symbol": "Kr",
        "abundance": {
            "universe": 0.000004,
            "crust": 1.5e-8,
            "ocean": 2.1e-8
        },
        "adiabatic_index": "5/3",
        "appearance": "colorless gas, exhibiting a whitish glow in a high electric field",
        "atomic_mass": 83.7982,
        "atomic_number": 36,
        "block": "p-block",
        "boiling_point": 119.93,
        "classifications": {
            "cas_number": "CAS7439-90-9",
            "cid_number": "CID5416",
            "rtecs_number": "RTECSOC6772500",
            "dot_numbers": 1970,
            "dot_hazard_class": 2.2
        },
        "conductivity": {
            "thermal": 0.00943
        },
        "cpk_hex": "5cb8d1",
        "critical_pressure": 5.5,
        "critical_temperature": 209.41,
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 3.75
        },
        "discovered": {
            "year": 1898,
            "by": "William Ramsay",
            "location": "The United Kingdom"
        },
        "electron_affinity": -96,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶",
        "electron_configuration_semantic": "[Ar] 3d¹⁰ 4s² 4p⁶",
        "electronegativity_pauling": 3,
        "electrons_per_shell": [
            2,
            8,
            18,
            8
        ],
        "energy_levels": "2, 8, 18, 8",
        "gas_phase": "Monoatomic",
        "group": 18,
        "half_life": "Stable",
        "heat": {
            "specific": 248.05,
            "vaporization": 9.02,
            "fusion": 1.64
        },
        "ionization_energies": [
            1350.8,
            2350.4,
            3565,
            5070,
            6240,
            7570,
            10710,
            12138,
            22274,
            25880,
            29700,
            33800,
            37700,
            43100,
            47500,
            52200,
            57100,
            61800,
            75800,
            80400,
            85300,
            90400,
            96300,
            101400,
            111100,
            116290,
            282500,
            296200,
            311400,
            326200
        ],
        "isotopes_known": "⁶⁹Kr, ⁷⁰Kr, ⁷¹Kr, ⁷²Kr, ⁷³Kr, ⁷⁴Kr, ⁷⁵Kr, ⁷⁶Kr, ⁷⁷Kr, ⁷⁸Kr, ⁷⁹Kr, ⁸⁰Kr, ⁸¹Kr, ⁸²Kr, ⁸³Kr, ⁸⁴Kr, ⁸⁵Kr, ⁸⁶Kr, ⁸⁷Kr, ⁸⁸Kr, ⁸⁹Kr, ⁹⁰Kr, ⁹¹Kr, ⁹²Kr, ⁹³Kr, ⁹⁴Kr, ⁹⁵Kr, ⁹⁶Kr, ⁹⁷Kr, ⁹⁸Kr, ⁹⁹Kr, ¹⁰⁰Kr",
        "isotopes_stable": "⁷⁸Kr, ⁸⁰Kr, ⁸²Kr, ⁸³Kr, ⁸⁴Kr, ⁸⁶Kr",
        "isotopic_abundances": "⁷⁸Kr: 0.35%, ⁸⁰Kr: 2.28%, ⁸²Kr: 11.58%, ⁸³Kr: 11.49%, ⁸⁴Kr: 57%, ⁸⁶Kr: 17.3%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "570.6, 570.6, 570.6",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -4.4e-9,
            "molar": -3.69e-10,
            "volume": -1.65e-8
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 115.78,
        "molar_volume": 0.02235,
        "neutron_cross_section": 25,
        "neutron_mass_absorption": 0.013,
        "oxidation_states": "2c",
        "period": 4,
        "phase": "Gas",
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 88,
            "covalent": 110,
            "vanderwaals": 202
        },
        "refractive_index": 1.000427,
        "series": "noble gas",
        "source": "https://en.wikipedia.org/wiki/Krypton",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 1120,
        "summary": "<p>Krypton (from Ancient Greek: κρυπτός, romanized: kryptos 'the hidden one') is a chemical element with the symbol Kr and atomic number 36. It is a colorless, odorless, tasteless noble gas that occurs in trace amounts in the atmosphere and is often used with other rare gases in fluorescent lamps. With rare exceptions, krypton is chemically inert.</p><p>Krypton, like the other noble gases, is used in lighting and photography. Krypton light has many spectral lines, and krypton plasma is useful in bright, high-powered gas lasers (krypton ion and excimer lasers), each of which resonates and amplifies a single spectral line. Krypton fluoride also makes a useful laser medium. From 1960 to 1983, the official length of a meter was defined by the 606-nanometer wavelength of the orange spectral line of krypton-86, because of the high power and relative ease of operation of krypton discharge tubes.</p>",
        "valence_electrons": 2
    },
    {
        "name": "Rubidium",
        "symbol": "Rb",
        "abundance": {
            "universe": 0.000001,
            "solar": 0.000003,
            "meteor": 0.00032,
            "crust": 0.006,
            "ocean": 0.000012,
            "human": 0.00046
        },
        "appearance": "grey white",
        "atomic_mass": 85.46783,
        "atomic_number": 37,
        "block": "s-block",
        "boiling_point": 961,
        "classifications": {
            "cas_number": "CAS7440-17-7",
            "cid_number": "CID5357696",
            "rtecs_number": "RTECSVL8500000",
            "dot_numbers": 1423,
            "dot_hazard_class": 4.3
        },
        "conductivity": {
            "thermal": 58,
            "electric": 8.3
        },
        "cpk_hex": "702eb0",
        "critical_pressure": 16,
        "critical_temperature": 2093,
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 1532,
            "liquid": 1460
        },
        "discovered": {
            "year": 1861,
            "by": "Robert Bunsen",
            "location": "Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 46.884,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹",
        "electron_configuration_semantic": "[Kr] 5s¹",
        "electronegativity_pauling": 0.82,
        "electrons_per_shell": [
            2,
            8,
            18,
            8,
            1
        ],
        "energy_levels": "2, 8, 18, 8, 1",
        "group": 1,
        "half_life": "Stable",
        "hardness": {
            "brinell": 0.216,
            "mohs": 0.3
        },
        "heat": {
            "specific": 364,
            "vaporization": 72,
            "fusion": 2.19,
            "molar": 31.06
        },
        "ionization_energies": [
            403,
            2633,
            3860,
            5080,
            6850,
            8140,
            9570,
            13120,
            14500,
            26740
        ],
        "isotopes_known": "⁷¹Rb, ⁷²Rb, ⁷³Rb, ⁷⁴Rb, ⁷⁵Rb, ⁷⁶Rb, ⁷⁷Rb, ⁷⁸Rb, ⁷⁹Rb, ⁸⁰Rb, ⁸¹Rb, ⁸²Rb, ⁸³Rb, ⁸⁴Rb, ⁸⁵Rb, ⁸⁶Rb, ⁸⁷Rb, ⁸⁸Rb, ⁸⁹Rb, ⁹⁰Rb, ⁹¹Rb, ⁹²Rb, ⁹³Rb, ⁹⁴Rb, ⁹⁵Rb, ⁹⁶Rb, ⁹⁷Rb, ⁹⁸Rb, ⁹⁹Rb, ¹⁰⁰Rb, ¹⁰¹Rb, ¹⁰²Rb",
        "isotopes_stable": "⁸⁵Rb",
        "isotopic_abundances": "⁸⁵Rb: 72.17%, ⁸⁷Rb: 27.83%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "558.5, 558.5, 558.5",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 2.6e-9,
            "molar": 2.22e-10,
            "volume": 0.00000398
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 312.45,
        "modulus": {
            "bulk": 2.5,
            "young": 2.4
        },
        "molar_volume": 0.000055788,
        "neutron_cross_section": 0.38,
        "neutron_mass_absorption": 0.0003,
        "oxidation_states": "-1,1c",
        "period": 5,
        "phase": "Solid",
        "quantum_numbers": "2S1/2",
        "radius": {
            "calculated": 265,
            "empirical": 235,
            "covalent": 211
        },
        "resistivity": 1.2e-7,
        "series": "alkali metal",
        "source": "https://en.wikipedia.org/wiki/Rubidium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 1300,
        "summary": "<p>Rubidium is the chemical element with the symbol Rb and atomic number 37. Rubidium is a very soft, silvery-white metal in the alkali metal group. Rubidium metal shares similarities to potassium metal and caesium metal in physical appearance, softness and conductivity. Rubidium cannot be stored under atmospheric oxygen, as a highly exothermic reaction will ensue, sometimes even resulting in the metal catching fire.</p><p>Rubidium is the first alkali metal in the group to have a density higher than water, so it sinks, unlike the metals above it in the group. Rubidium has a standard atomic weight of 85.4678. On Earth, natural rubidium comprises two isotopes: 72% is a stable isotope 85Rb, and 28% is slightly radioactive 87Rb, with a half_life of 48.8 billion years—more than three times as long as the estimated age of the universe.</p><p>German chemists Robert Bunsen and Gustav Kirchhoff discovered rubidium in 1861 by the newly developed technique, flame spectroscopy. The name comes from the Latin word rubidus, meaning deep red, the color of its emission spectrum. Rubidium's compounds have various chemical and electronic applications. Rubidium metal is easily vaporized and has a convenient spectral absorption range, making it a frequent target for laser manipulation of atoms. Rubidium is not a known nutrient for any living organisms. However, rubidium ions have similar properties and the same charge as potassium ions, and are actively taken up and treated by animal cells in similar ways.</p>",
        "valence_electrons": 1
    },
    {
        "name": "Strontium",
        "symbol": "Sr",
        "abundance": {
            "universe": 0.000004,
            "solar": 0.000005,
            "meteor": 0.00087,
            "crust": 0.036,
            "ocean": 0.00081,
            "human": 0.00046
        },
        "atomic_mass": 87.621,
        "atomic_number": 38,
        "block": "s-block",
        "boiling_point": 1650,
        "classifications": {
            "cas_number": "CAS7440-24-6",
            "cid_number": "CID5359327",
            "dot_numbers": 1383,
            "dot_hazard_class": 4.2
        },
        "conductivity": {
            "thermal": 35,
            "electric": 7.7
        },
        "cpk_hex": "00ff00",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 2630,
            "liquid": 2375
        },
        "discovered": {
            "year": 1790,
            "by": "William Cruickshank (chemist)",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 5.023,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s²",
        "electron_configuration_semantic": "[Kr] 5s²",
        "electronegativity_pauling": 0.95,
        "electrons_per_shell": [
            2,
            8,
            18,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 8, 2",
        "group": 2,
        "half_life": "Stable",
        "hardness": {
            "mohs": 1.5
        },
        "heat": {
            "specific": 300,
            "vaporization": 137,
            "fusion": 8,
            "molar": 26.4
        },
        "ionization_energies": [
            549.5,
            1064.2,
            4138,
            5500,
            6910,
            8760,
            10230,
            11800,
            15600,
            17100,
            31270
        ],
        "isotopes_known": "⁷³Sr, ⁷⁴Sr, ⁷⁵Sr, ⁷⁶Sr, ⁷⁷Sr, ⁷⁸Sr, ⁷⁹Sr, ⁸⁰Sr, ⁸¹Sr, ⁸²Sr, ⁸³Sr, ⁸⁴Sr, ⁸⁵Sr, ⁸⁶Sr, ⁸⁷Sr, ⁸⁸Sr, ⁸⁹Sr, ⁹⁰Sr, ⁹¹Sr, ⁹²Sr, ⁹³Sr, ⁹⁴Sr, ⁹⁵Sr, ⁹⁶Sr, ⁹⁷Sr, ⁹⁸Sr, ⁹⁹Sr, ¹⁰⁰Sr, ¹⁰¹Sr, ¹⁰²Sr, ¹⁰³Sr, ¹⁰⁴Sr, ¹⁰⁵Sr",
        "isotopes_stable": "⁸⁴Sr, ⁸⁶Sr, ⁸⁷Sr, ⁸⁸Sr",
        "isotopic_abundances": "⁸⁴Sr: 0.56%, ⁸⁶Sr: 9.86%, ⁸⁷Sr: 7%, ⁸⁸Sr: 82.58%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "608.49, 608.49, 608.49",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.32e-9,
            "molar": 1.16e-10,
            "volume": 0.00000347
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1050,
        "modulus": {
            "shear": 6.1
        },
        "molar_volume": 0.000033316,
        "neutron_cross_section": 1.2,
        "neutron_mass_absorption": 0.0005,
        "oxidation_states": "1,2c",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.28,
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 219,
            "empirical": 200,
            "covalent": 192
        },
        "resistivity": 1.3e-7,
        "series": "alkaline earth metal",
        "source": "https://en.wikipedia.org/wiki/Strontium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "summary": "<p>Strontium is the chemical element with the symbol Sr and atomic number 38. An alkaline earth metal, strontium is a soft silver-white yellowish metallic element that is highly chemically reactive. The metal forms a dark oxide layer when it is exposed to air. Strontium has physical and chemical properties similar to those of its two vertical neighbors in the periodic table, calcium and barium. It occurs naturally mainly in the minerals celestine and strontianite, and is mostly mined from these.</p><p>Both strontium and strontianite are named after Strontian, a village in Scotland near which the mineral was discovered in 1790 by Adair Crawford and William Cruickshank; it was identified as a new element the next year from its crimson-red flame test color. Strontium was first isolated as a metal in 1808 by Humphry Davy using the then newly discovered process of electrolysis. During the 19th century, strontium was mostly used in the production of sugar from sugar beets (see strontian process). At the peak of production of television cathode ray tubes, as much as 75% of strontium consumption in the United States was used for the faceplate glass. With the replacement of cathode ray tubes with other display methods, consumption of strontium has dramatically declined.</p><p>While natural strontium (which is mostly the isotope strontium-88) is stable, the synthetic strontium-90 is radioactive and is one of the most dangerous components of nuclear fallout, as strontium is absorbed by the body in a similar manner to calcium. Natural stable strontium, on the other hand, is not hazardous to health.</p>",
        "thermal_expansion": 0.0000225,
        "valence_electrons": 2
    },
    {
        "name": "Yttrium",
        "symbol": "Y",
        "abundance": {
            "universe": 7e-7,
            "solar": 0.000001,
            "meteor": 0.00019,
            "crust": 0.0029,
            "ocean": 1.3e-9
        },
        "appearance": "silvery white",
        "atomic_mass": 88.905842,
        "atomic_number": 39,
        "block": "d-block",
        "boiling_point": 3203,
        "classifications": {
            "cas_number": "CAS7440-65-5",
            "cid_number": "CID23993",
            "rtecs_number": "RTECSZG2980000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 17,
            "electric": 1.8
        },
        "cpk_hex": "94ffff",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 4472,
            "liquid": 4240
        },
        "discovered": {
            "year": 1794,
            "by": "Johan Gadolin",
            "location": "Finland"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 29.6,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹",
        "electron_configuration_semantic": "[Kr] 4d¹ 5s²",
        "electronegativity_pauling": 1.22,
        "electrons_per_shell": [
            2,
            8,
            18,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 9, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "brinell": 589
        },
        "heat": {
            "specific": 298,
            "vaporization": 380,
            "fusion": 11.4,
            "molar": 26.53
        },
        "ionization_energies": [
            600,
            1180,
            1980,
            5847,
            7430,
            8970,
            11190,
            12450,
            14110,
            18400,
            19900,
            36090
        ],
        "isotopes_known": "⁷⁶Y, ⁷⁷Y, ⁷⁸Y, ⁷⁹Y, ⁸⁰Y, ⁸¹Y, ⁸²Y, ⁸³Y, ⁸⁴Y, ⁸⁵Y, ⁸⁶Y, ⁸⁷Y, ⁸⁸Y, ⁸⁹Y, ⁹⁰Y, ⁹¹Y, ⁹²Y, ⁹³Y, ⁹⁴Y, ⁹⁵Y, ⁹⁶Y, ⁹⁷Y, ⁹⁸Y, ⁹⁹Y, ¹⁰⁰Y, ¹⁰¹Y, ¹⁰²Y, ¹⁰³Y, ¹⁰⁴Y, ¹⁰⁵Y, ¹⁰⁶Y, ¹⁰⁷Y, ¹⁰⁸Y",
        "isotopes_stable": "⁸⁹Y",
        "isotopic_abundances": "⁸⁹Y: 100%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "364.74, 364.74, 573.06",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 6.66e-8,
            "molar": 5.921e-9,
            "volume": 0.0002978
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1799,
        "modulus": {
            "bulk": 41,
            "shear": 26,
            "young": 64
        },
        "molar_volume": 0.000019881,
        "neutron_cross_section": 1.28,
        "neutron_mass_absorption": 0.00059,
        "oxidation_states": "1,2,3c",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.24,
        "quantum_numbers": "2D3/2",
        "radius": {
            "calculated": 212,
            "empirical": 180,
            "covalent": 162
        },
        "resistivity": 5.7e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Yttrium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 3300,
        "summary": "<p>Yttrium is a chemical element with the symbol Y and atomic number 39. It is a silvery-metallic transition metal chemically similar to the lanthanides and has often been classified as a \"rare-earth element\". Yttrium is almost always found in combination with lanthanide elements in rare-earth minerals, and is never found in nature as a free element. 89Y is the only stable isotope, and the only isotope found in the Earth's crust.</p><p>The most important uses of yttrium are LEDs and phosphors, particularly the red phosphors in television set cathode ray tube displays. Yttrium is also used in the production of electrodes, electrolytes, electronic filters, lasers, superconductors, various medical applications, and tracing various materials to enhance their properties.</p><p>Yttrium has no known biological role. Exposure to yttrium compounds can cause lung disease in humans.</p><p>The element is named after ytterbite, a mineral first identified in 1787 by the chemist Arrhenius. He named the mineral after the village of Ytterby, in Sweden, where it had been discovered. When one of the chemicals in ytterbite was later found to be the previously unidentified element, yttrium, the element was then named after the mineral.</p>",
        "superconducting_point": 1.3,
        "thermal_expansion": 0.0000106,
        "valence_electrons": 3
    },
    {
        "name": "Zirconium",
        "symbol": "Zr",
        "abundance": {
            "universe": 0.000005,
            "solar": 0.000004,
            "meteor": 0.00066,
            "crust": 0.013,
            "ocean": 2.6e-9,
            "human": 0.000005
        },
        "appearance": "silvery white",
        "atomic_mass": 91.2242,
        "atomic_number": 40,
        "block": "d-block",
        "boiling_point": 4650,
        "classifications": {
            "cas_number": "CAS7440-67-7",
            "cid_number": "CID23995",
            "dot_numbers": 2008,
            "dot_hazard_class": 4.2
        },
        "conductivity": {
            "thermal": 23,
            "electric": 2.4
        },
        "cpk_hex": "94e0e0",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 6511,
            "liquid": 5800
        },
        "discovered": {
            "year": 1789,
            "by": "Martin Heinrich Klaproth",
            "location": "Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 41.806,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d²",
        "electron_configuration_semantic": "[Kr] 4d² 5s²",
        "electronegativity_pauling": 1.33,
        "electrons_per_shell": [
            2,
            8,
            18,
            10,
            2
        ],
        "energy_levels": "2, 8, 18, 10, 2",
        "group": 4,
        "half_life": "Stable",
        "hardness": {
            "vickers": 903,
            "brinell": 650,
            "mohs": 5
        },
        "heat": {
            "specific": 278,
            "vaporization": 580,
            "fusion": 21,
            "molar": 25.36
        },
        "ionization_energies": [
            640.1,
            1270,
            2218,
            3313,
            7752,
            9500
        ],
        "isotopes_known": "⁷⁸Zr, ⁷⁹Zr, ⁸⁰Zr, ⁸¹Zr, ⁸²Zr, ⁸³Zr, ⁸⁴Zr, ⁸⁵Zr, ⁸⁶Zr, ⁸⁷Zr, ⁸⁸Zr, ⁸⁹Zr, ⁹⁰Zr, ⁹¹Zr, ⁹²Zr, ⁹³Zr, ⁹⁴Zr, ⁹⁵Zr, ⁹⁶Zr, ⁹⁷Zr, ⁹⁸Zr, ⁹⁹Zr, ¹⁰⁰Zr, ¹⁰¹Zr, ¹⁰²Zr, ¹⁰³Zr, ¹⁰⁴Zr, ¹⁰⁵Zr, ¹⁰⁶Zr, ¹⁰⁷Zr, ¹⁰⁸Zr, ¹⁰⁹Zr, ¹¹⁰Zr",
        "isotopes_stable": "⁹⁰Zr, ⁹¹Zr, ⁹²Zr, ⁹⁴Zr",
        "isotopic_abundances": "⁹⁰Zr: 51.45%, ⁹¹Zr: 11.22%, ⁹²Zr: 17.15%, ⁹⁴Zr: 17.38%, ⁹⁶Zr: 2.8%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "323.2, 323.2, 514.7",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.68e-8,
            "molar": 1.53e-9,
            "volume": 0.000109
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2128,
        "modulus": {
            "shear": 33,
            "young": 68
        },
        "molar_volume": 0.000014011,
        "neutron_cross_section": 0.184,
        "neutron_mass_absorption": 0.00066,
        "oxidation_states": "1,2,3,4c",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.34,
        "quantum_numbers": "3F2",
        "radius": {
            "calculated": 206,
            "empirical": 155,
            "covalent": 148
        },
        "resistivity": 4.2e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Zirconium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 3800,
        "summary": "<p>Zirconium is a chemical element with the symbol Zr and atomic number 40. The name zirconium is taken from the name of the mineral zircon (the word is related to Persian zargun (zircon; zar-gun, \"gold-like\" or \"as gold\")), the most important source of zirconium. It is a lustrous, grey-white, strong transition metal that closely resembles hafnium and, to a lesser extent, titanium. Zirconium is mainly used as a refractory and opacifier, although small amounts are used as an alloying agent for its strong resistance to corrosion. Zirconium forms a variety of inorganic and organometallic compounds such as zirconium dioxide and zirconocene dichloride, respectively. Five isotopes occur naturally, four of which are stable. Zirconium compounds have no known biological role.</p>",
        "superconducting_point": 0.61,
        "thermal_expansion": 0.0000057,
        "valence_electrons": 4
    },
    {
        "name": "Niobium",
        "symbol": "Nb",
        "abundance": {
            "universe": 2e-7,
            "solar": 4e-7,
            "meteor": 0.000019,
            "crust": 0.0017,
            "ocean": 1e-10
        },
        "alternate_names": "Columbium",
        "appearance": "gray metallic, bluish when oxidized",
        "atomic_mass": 92.906372,
        "atomic_number": 41,
        "block": "d-block",
        "boiling_point": 5017,
        "classifications": {
            "cas_number": "CAS7440-03-1",
            "cid_number": "CID23936",
            "rtecs_number": "RTECSQT9900000"
        },
        "conductivity": {
            "thermal": 54,
            "electric": 6.7
        },
        "cpk_hex": "73c2c9",
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 8570
        },
        "discovered": {
            "year": 1801,
            "by": "Charles Hatchett",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 88.516,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d⁴",
        "electron_configuration_semantic": "[Kr] 4d⁴ 5s¹",
        "electronegativity_pauling": 1.6,
        "electrons_per_shell": [
            2,
            8,
            18,
            12,
            1
        ],
        "energy_levels": "2, 8, 18, 12, 1",
        "group": 5,
        "half_life": "Stable",
        "hardness": {
            "vickers": 1320,
            "brinell": 736,
            "mohs": 6
        },
        "heat": {
            "specific": 265,
            "vaporization": 690,
            "fusion": 26.8,
            "molar": 24.6
        },
        "ionization_energies": [
            652.1,
            1380,
            2416,
            3700,
            4877,
            9847,
            12100
        ],
        "isotopes_known": "⁸¹Nb, ⁸²Nb, ⁸³Nb, ⁸⁴Nb, ⁸⁵Nb, ⁸⁶Nb, ⁸⁷Nb, ⁸⁸Nb, ⁸⁹Nb, ⁹⁰Nb, ⁹¹Nb, ⁹²Nb, ⁹³Nb, ⁹⁴Nb, ⁹⁵Nb, ⁹⁶Nb, ⁹⁷Nb, ⁹⁸Nb, ⁹⁹Nb, ¹⁰⁰Nb, ¹⁰¹Nb, ¹⁰²Nb, ¹⁰³Nb, ¹⁰⁴Nb, ¹⁰⁵Nb, ¹⁰⁶Nb, ¹⁰⁷Nb, ¹⁰⁸Nb, ¹⁰⁹Nb, ¹¹⁰Nb, ¹¹¹Nb, ¹¹²Nb, ¹¹³Nb",
        "isotopes_stable": "⁹³Nb",
        "isotopic_abundances": "⁹³Nb: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "330.04, 330.04, 330.04",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 2.76e-8,
            "molar": 2.56e-9,
            "volume": 0.000237
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2750,
        "modulus": {
            "bulk": 170,
            "shear": 38,
            "young": 105
        },
        "molar_volume": 0.000010841,
        "neutron_cross_section": 1.15,
        "neutron_mass_absorption": 0.0004,
        "oxidation_states": "-1,2,3,4,5c",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.4,
        "quantum_numbers": "6D1/2",
        "radius": {
            "calculated": 198,
            "empirical": 145,
            "covalent": 137
        },
        "resistivity": 1.5e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Niobium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 3480,
        "summary": "<p>Niobium, also known as columbium, is a chemical element with the symbol Nb (formerly Cb) and atomic number 41. Niobium is a light grey, crystalline, and ductile transition metal. Pure niobium has a Mohs hardness rating similar to that of pure titanium, and it has similar ductility to iron. Niobium oxidizes in the earth's atmosphere very slowly, hence its application in jewelry as a hypoallergenic alternative to nickel. Niobium is often found in the minerals pyrochlore and columbite, hence the former name \"columbium\". Its name comes from Greek mythology, specifically Niobe, who was the daughter of Tantalus, the namesake of tantalum. The name reflects the great similarity between the two elements in their physical and chemical properties, making them difficult to distinguish.</p><p>The English chemist Charles Hatchett reported a new element similar to tantalum in 1801 and named it columbium. In 1809, the English chemist William Hyde Wollaston wrongly concluded that tantalum and columbium were identical. The German chemist Heinrich Rose determined in 1846 that tantalum ores contain a second element, which he named niobium. In 1864 and 1865, a series of scientific findings clarified that niobium and columbium were the same element (as distinguished from tantalum), and for a century both names were used interchangeably. Niobium was officially adopted as the name of the element in 1949, but the name columbium remains in current use in metallurgy in the United States.</p><p>It was not until the early 20th century that niobium was first used commercially. Brazil is the leading producer of niobium and ferroniobium, an alloy of 60–70% niobium with iron. Niobium is used mostly in alloys, the largest part in special steel such as that used in gas pipelines. Although these alloys contain a maximum of 0.1%, the small percentage of niobium enhances the strength of the steel. The temperature stability of niobium-containing superalloys is important for its use in jet and rocket engines.</p><p>Niobium is used in various superconducting materials. These superconducting alloys, also containing titanium and tin, are widely used in the superconducting magnets of MRI scanners. Other applications of niobium include welding, nuclear industries, electronics, optics, numismatics, and jewelry. In the last two applications, the low toxicity and iridescence produced by anodization are highly desired properties. Niobium is considered a technology-critical element.</p>",
        "superconducting_point": 9.25,
        "thermal_expansion": 0.0000073,
        "valence_electrons": 5
    },
    {
        "name": "Molybdenum",
        "symbol": "Mo",
        "abundance": {
            "universe": 5e-7,
            "solar": 9e-7,
            "meteor": 0.00012,
            "crust": 0.00011,
            "ocean": 0.000001,
            "human": 0.00001
        },
        "appearance": "gray metallic",
        "atomic_mass": 95.951,
        "atomic_number": 42,
        "block": "d-block",
        "boiling_point": 4912,
        "classifications": {
            "cas_number": "CAS7439-98-7",
            "cid_number": "CID23932",
            "rtecs_number": "RTECSQA4680000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 139,
            "electric": 20
        },
        "cpk_hex": "54b5b5",
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 10280,
            "liquid": 9330
        },
        "discovered": {
            "year": 1781,
            "by": "Carl Wilhelm Scheele",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 72.1,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d⁵",
        "electron_configuration_semantic": "[Kr] 4d⁵ 5s¹",
        "electronegativity_pauling": 2.16,
        "electrons_per_shell": [
            2,
            8,
            18,
            13,
            1
        ],
        "energy_levels": "2, 8, 18, 13, 1",
        "group": 6,
        "half_life": "Stable",
        "hardness": {
            "vickers": 1530,
            "brinell": 1500,
            "mohs": 5.5
        },
        "heat": {
            "specific": 251,
            "vaporization": 600,
            "fusion": 36,
            "molar": 24.06
        },
        "ionization_energies": [
            684.3,
            1560,
            2618,
            4480,
            5257,
            6640.8,
            12125,
            13860,
            15835,
            17980,
            20190,
            22219,
            26930,
            29196,
            52490,
            55000,
            61400,
            67700,
            74000,
            80400,
            87000,
            93400,
            98420,
            104400,
            121900,
            127700,
            133800,
            139800,
            148100,
            154500
        ],
        "isotopes_known": "⁸³Mo, ⁸⁴Mo, ⁸⁵Mo, ⁸⁶Mo, ⁸⁷Mo, ⁸⁸Mo, ⁸⁹Mo, ⁹⁰Mo, ⁹¹Mo, ⁹²Mo, ⁹³Mo, ⁹⁴Mo, ⁹⁵Mo, ⁹⁶Mo, ⁹⁷Mo, ⁹⁸Mo, ⁹⁹Mo, ¹⁰⁰Mo, ¹⁰¹Mo, ¹⁰²Mo, ¹⁰³Mo, ¹⁰⁴Mo, ¹⁰⁵Mo, ¹⁰⁶Mo, ¹⁰⁷Mo, ¹⁰⁸Mo, ¹⁰⁹Mo, ¹¹⁰Mo, ¹¹¹Mo, ¹¹²Mo, ¹¹³Mo, ¹¹⁴Mo, ¹¹⁵Mo",
        "isotopes_stable": "⁹²Mo, ⁹⁴Mo, ⁹⁵Mo, ⁹⁶Mo, ⁹⁷Mo, ⁹⁸Mo",
        "isotopic_abundances": "¹⁰⁰Mo: 9.63%, ⁹²Mo: 14.84%, ⁹⁴Mo: 9.25%, ⁹⁵Mo: 15.92%, ⁹⁶Mo: 16.68%, ⁹⁷Mo: 9.55%, ⁹⁸Mo: 24.13%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "314.7, 314.7, 314.7",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.17e-8,
            "molar": 1.122e-9,
            "volume": 0.0001203
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2896,
        "modulus": {
            "bulk": 230,
            "shear": 120,
            "young": 329
        },
        "molar_volume": 0.000009334,
        "neutron_cross_section": 2.6,
        "neutron_mass_absorption": 0.0009,
        "oxidation_states": "-2,-1,1,2,3,4c,5,6c",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.31,
        "quantum_numbers": "7S3",
        "radius": {
            "calculated": 190,
            "empirical": 145,
            "covalent": 145
        },
        "resistivity": 4.999999999997e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Molybdenum",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 6190,
        "summary": "<p>Molybdenum is a chemical element with the symbol Mo and atomic number 42. The name is from Neo-Latin molybdaenum, which is based on Ancient Greek Μόλυβδος molybdos, meaning lead, since its ores were confused with lead ores. Molybdenum minerals have been known throughout history, but the element was discovered (in the sense of differentiating it as a new entity from the mineral salts of other metals) in 1778 by Carl Wilhelm Scheele. The metal was first isolated in 1781 by Peter Jacob Hjelm.</p><p>Molybdenum does not occur naturally as a free metal on Earth; it is found only in various oxidation states in minerals. The free element, a silvery metal with a gray cast, has the sixth-highest melting point of any element. It readily forms hard, stable carbides in alloys, and for this reason most of the world production of the element (about 80%) is used in steel alloys, including high-strength alloys and superalloys.</p><p>Most molybdenum compounds have low solubility in water, but when molybdenum-bearing minerals contact oxygen and water, the resulting molybdate ion MoO2−4 is quite soluble. Industrially, molybdenum compounds (about 14% of world production of the element) are used in high-pressure and high-temperature applications as pigments and catalysts.</p><p>Molybdenum-bearing enzymes are by far the most common bacterial catalysts for breaking the chemical bond in atmospheric molecular nitrogen in the process of biological nitrogen fixation. At least 50 molybdenum enzymes are now known in bacteria, plants, and animals, although only bacterial and cyanobacterial enzymes are involved in nitrogen fixation. These nitrogenases contain an iron-molybdenum cofactor FeMoco, which is believed to contain either Mo(III) or Mo(IV). This is distinct from the fully oxidized Mo(VI) found complexed with molybdopterin in all other molybdenum-bearing enzymes, which perform a variety of crucial functions. The variety of crucial reactions catalyzed by these latter enzymes means that molybdenum is an essential element for all higher eukaryote organisms, including humans.</p>",
        "superconducting_point": 0.915,
        "thermal_expansion": 0.0000048,
        "valence_electrons": 6
    },
    {
        "name": "Technetium",
        "symbol": "Tc",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "shiny gray metal",
        "atomic_mass": 98,
        "atomic_number": 43,
        "block": "d-block",
        "boiling_point": 4538,
        "classifications": {
            "cas_number": "CAS7440-26-8"
        },
        "conductivity": {
            "thermal": 51,
            "electric": 5
        },
        "cpk_hex": "3b9e9e",
        "crystal_structure": "Simple Hexagonal",
        "decay_mode": "BetaDecay",
        "density": {
            "stp": 11500
        },
        "discovered": {
            "year": 1937,
            "by": "Emilio Segrè",
            "location": "Italy"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 53,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d⁵",
        "electron_configuration_semantic": "[Kr] 4d⁵ 5s²",
        "electronegativity_pauling": 1.9,
        "electrons_per_shell": [
            2,
            8,
            18,
            13,
            2
        ],
        "energy_levels": "2, 8, 18, 13, 2",
        "group": 7,
        "half_life": 211098.4271943,
        "heat": {
            "specific": 63,
            "vaporization": 550,
            "fusion": 23,
            "molar": 24.27
        },
        "ionization_energies": [
            702,
            1470,
            2850
        ],
        "isotopes_known": "⁸⁵Tc, ⁸⁶Tc, ⁸⁷Tc, ⁸⁸Tc, ⁸⁹Tc, ⁹⁰Tc, ⁹¹Tc, ⁹²Tc, ⁹³Tc, ⁹⁴Tc, ⁹⁵Tc, ⁹⁶Tc, ⁹⁷Tc, ⁹⁸Tc, ⁹⁹Tc, ¹⁰⁰Tc, ¹⁰¹Tc, ¹⁰²Tc, ¹⁰³Tc, ¹⁰⁴Tc, ¹⁰⁵Tc, ¹⁰⁶Tc, ¹⁰⁷Tc, ¹⁰⁸Tc, ¹⁰⁹Tc, ¹¹⁰Tc, ¹¹¹Tc, ¹¹²Tc, ¹¹³Tc, ¹¹⁴Tc, ¹¹⁵Tc, ¹¹⁶Tc, ¹¹⁷Tc, ¹¹⁸Tc",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "273.5, 273.5, 438.8",
        "lifetime": 6024860.476915,
        "magnetic_susceptibility": {
            "mass": 3.42e-8,
            "molar": 3.352e-9,
            "volume": 0.0003933
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2430,
        "molar_volume": 0.000008434782608696,
        "neutron_cross_section": 22,
        "oxidation_states": "-3,-1,1,2,3,4c,5,6,7c",
        "period": 5,
        "phase": "Solid",
        "quantum_numbers": "6S5/2",
        "radius": {
            "calculated": 183,
            "empirical": 135,
            "covalent": 156
        },
        "resistivity": 2e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Technetium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "summary": "<p>Technetium is a chemical element with the symbol Tc and atomic number 43. It is the lightest element whose isotopes are all radioactive, none of which is stable other than the fully ionized state of 97Tc. Nearly all available technetium is produced as a synthetic element. Naturally occurring technetium is a spontaneous fission product in uranium ore and thorium ore, the most common source, or the product of neutron capture in molybdenum ores. The silvery gray, crystalline transition metal lies between manganese and rhenium in group 7 of the periodic table, and its chemical properties are intermediate between those of both adjacent elements. The most common naturally occurring isotope is 99Tc, in traces only.</p><p>Many of technetium's properties had been predicted by Dmitri Mendeleev before it was discovered. Mendeleev noted a gap in his periodic table and gave the undiscovered element the provisional name ekamanganese (Em). In 1937, technetium (specifically the technetium-97 isotope) became the first predominantly artificial element to be produced, hence its name (from the Greek τεχνητός, meaning \"Craft, Art or Artificial\", + -ium).</p><p>One short-lived gamma ray-emitting nuclear isomer, technetium-99m, is used in nuclear medicine for a wide variety of tests, such as bone cancer diagnoses. The ground state of the nuclide technetium-99 is used as a gamma-ray-free source of beta particles. Long-lived technetium isotopes produced commercially are byproducts of the fission of uranium-235 in nuclear reactors and are extracted from nuclear fuel rods. Because even the longest-lived isotope of technetium has a relatively short half_life (4.21 million years), the 1952 detection of technetium in red giants helped to prove that stars can produce heavier elements.</p>",
        "superconducting_point": 7.7,
        "valence_electrons": 6
    },
    {
        "name": "Ruthenium",
        "symbol": "Ru",
        "abundance": {
            "universe": 4e-7,
            "solar": 5e-7,
            "meteor": 0.000081,
            "crust": 9.9e-8,
            "ocean": 7e-11
        },
        "appearance": "silvery white metallic",
        "atomic_mass": 101.072,
        "atomic_number": 44,
        "block": "d-block",
        "boiling_point": 4423,
        "classifications": {
            "cas_number": "CAS7440-18-8",
            "cid_number": "CID23950",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 120,
            "electric": 14
        },
        "cpk_hex": "248f8f",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 12370,
            "liquid": 10650
        },
        "discovered": {
            "year": 1844,
            "by": "Karl Ernst Claus",
            "location": "Russia"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 100.96,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d⁷",
        "electron_configuration_semantic": "[Kr] 4d⁷ 5s¹",
        "electronegativity_pauling": 2.2,
        "electrons_per_shell": [
            2,
            8,
            18,
            15,
            1
        ],
        "energy_levels": "2, 8, 18, 15, 1",
        "group": 8,
        "half_life": "Stable",
        "hardness": {
            "brinell": 2160,
            "mohs": 6.5
        },
        "heat": {
            "specific": 238,
            "vaporization": 580,
            "fusion": 25.7,
            "molar": 24.06
        },
        "ionization_energies": [
            710.2,
            1620,
            2747
        ],
        "isotopes_known": "⁸⁷Ru, ⁸⁸Ru, ⁸⁹Ru, ⁹⁰Ru, ⁹¹Ru, ⁹²Ru, ⁹³Ru, ⁹⁴Ru, ⁹⁵Ru, ⁹⁶Ru, ⁹⁷Ru, ⁹⁸Ru, ⁹⁹Ru, ¹⁰⁰Ru, ¹⁰¹Ru, ¹⁰²Ru, ¹⁰³Ru, ¹⁰⁴Ru, ¹⁰⁵Ru, ¹⁰⁶Ru, ¹⁰⁷Ru, ¹⁰⁸Ru, ¹⁰⁹Ru, ¹¹⁰Ru, ¹¹¹Ru, ¹¹²Ru, ¹¹³Ru, ¹¹⁴Ru, ¹¹⁵Ru, ¹¹⁶Ru, ¹¹⁷Ru, ¹¹⁸Ru, ¹¹⁹Ru, ¹²⁰Ru",
        "isotopes_stable": "¹⁰⁰Ru, ¹⁰¹Ru, ¹⁰²Ru, ¹⁰⁴Ru, ⁹⁶Ru, ⁹⁸Ru, ⁹⁹Ru",
        "isotopic_abundances": "¹⁰⁰Ru: 12.6%, ¹⁰¹Ru: 17.06%, ¹⁰²Ru: 31.55%, ¹⁰⁴Ru: 18.62%, ⁹⁶Ru: 5.54%, ⁹⁸Ru: 1.87%, ⁹⁹Ru: 12.76%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "270.59, 270.59, 428.15",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 5.42e-9,
            "molar": 5.48e-10,
            "volume": 0.000067
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2607,
        "modulus": {
            "bulk": 220,
            "shear": 173,
            "young": 447
        },
        "molar_volume": 0.0000081706,
        "neutron_cross_section": 2.6,
        "neutron_mass_absorption": 0.0009,
        "oxidation_states": "-2,1,2,3c,4c,5,6,7,8",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.3,
        "quantum_numbers": "5F5",
        "radius": {
            "calculated": 178,
            "empirical": 130,
            "covalent": 126
        },
        "resistivity": 7.000000000002e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Ruthenium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 5970,
        "summary": "<p>Ruthenium is a chemical element with the symbol Ru and atomic number 44. It is a rare transition metal belonging to the platinum group of the periodic table. Like the other metals of the platinum group, ruthenium is inert to most other chemicals. Russian-born scientist of Baltic-German ancestry Karl Ernst Claus discovered the element in 1844 at Kazan State University and named ruthenium in honor of Russia. Ruthenium is usually found as a minor component of platinum ores; the annual production has risen from about 19 tonnes in 2009 to some 35.5 tonnes in 2017. Most ruthenium produced is used in wear-resistant electrical contacts and thick-film resistors. A minor application for ruthenium is in platinum alloys and as a chemistry catalyst. A new application of ruthenium is as the capping layer for extreme ultraviolet photomasks. Ruthenium is generally found in ores with the other platinum group metals in the Ural Mountains and in North and South America. Small but commercially important quantities are also found in pentlandite extracted from Sudbury, Ontario and in pyroxenite deposits in South Africa.</p>",
        "superconducting_point": 0.49,
        "thermal_expansion": 0.0000064,
        "valence_electrons": 6
    },
    {
        "name": "Rhodium",
        "symbol": "Rh",
        "abundance": {
            "universe": 6e-8,
            "solar": 2e-7,
            "meteor": 0.000018,
            "crust": 7e-8
        },
        "appearance": "silvery white metallic",
        "atomic_mass": 102.905502,
        "atomic_number": 45,
        "block": "d-block",
        "boiling_point": 3968,
        "classifications": {
            "cas_number": "CAS7440-16-6",
            "cid_number": "CID23948",
            "rtecs_number": "RTECSVI9069000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 150,
            "electric": 23
        },
        "cpk_hex": "0a7d8c",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 12450,
            "liquid": 10700
        },
        "discovered": {
            "year": 1803,
            "by": "William Hyde Wollaston",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 110.27,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d⁸",
        "electron_configuration_semantic": "[Kr] 4d⁸ 5s¹",
        "electronegativity_pauling": 2.28,
        "electrons_per_shell": [
            2,
            8,
            18,
            16,
            1
        ],
        "energy_levels": "2, 8, 18, 16, 1",
        "group": 9,
        "half_life": "Stable",
        "hardness": {
            "vickers": 1246,
            "brinell": 1100,
            "mohs": 6
        },
        "heat": {
            "specific": 240,
            "vaporization": 495,
            "fusion": 21.7,
            "molar": 24.98
        },
        "ionization_energies": [
            719.7,
            1740,
            2997
        ],
        "isotopes_known": "⁸⁹Rh, ⁹⁰Rh, ⁹¹Rh, ⁹²Rh, ⁹³Rh, ⁹⁴Rh, ⁹⁵Rh, ⁹⁶Rh, ⁹⁷Rh, ⁹⁸Rh, ⁹⁹Rh, ¹⁰⁰Rh, ¹⁰¹Rh, ¹⁰²Rh, ¹⁰³Rh, ¹⁰⁴Rh, ¹⁰⁵Rh, ¹⁰⁶Rh, ¹⁰⁷Rh, ¹⁰⁸Rh, ¹⁰⁹Rh, ¹¹⁰Rh, ¹¹¹Rh, ¹¹²Rh, ¹¹³Rh, ¹¹⁴Rh, ¹¹⁵Rh, ¹¹⁶Rh, ¹¹⁷Rh, ¹¹⁸Rh, ¹¹⁹Rh, ¹²⁰Rh, ¹²¹Rh, ¹²²Rh",
        "isotopes_stable": "¹⁰³Rh",
        "isotopic_abundances": "¹⁰³Rh: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "380.34, 380.34, 380.34",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.36e-8,
            "molar": 1.4e-9,
            "volume": 0.0001693
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2237,
        "modulus": {
            "bulk": 380,
            "shear": 150,
            "young": 275
        },
        "molar_volume": 0.0000082655,
        "neutron_cross_section": 145,
        "neutron_mass_absorption": 0.063,
        "oxidation_states": "-1,1,2,3c,4,5,6",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.26,
        "quantum_numbers": "4F9/2",
        "radius": {
            "calculated": 173,
            "empirical": 135,
            "covalent": 135
        },
        "resistivity": 4.300000000003e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Rhodium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 4700,
        "summary": "<p>Rhodium is a chemical element with the symbol Rh and atomic number 45. It is an extraordinarily rare, silvery-white, hard, corrosion-resistant, and chemically inert transition metal. It is a noble metal and a member of the platinum group. It has only one naturally occurring isotope, 103Rh. Naturally occurring rhodium is usually found as a free metal, as an alloy with similar metals, and rarely as a chemical compound in minerals such as bowieite and rhodplumsite. It is one of the rarest and most valuable precious metals.</p><p>Rhodium is found in platinum or nickel ores together with the other members of the platinum group metals. It was discovered in 1803 by William Hyde Wollaston in one such ore, and named for the rose color of one of its chlorine compounds.</p><p>The element's major use (approximately 80% of world rhodium production) is as one of the catalysts in the three-way catalytic converters in automobiles. Because rhodium metal is inert against corrosion and most aggressive chemicals, and because of its rarity, rhodium is usually alloyed with platinum or palladium and applied in high-temperature and corrosion-resistive coatings. White gold is often plated with a thin rhodium layer to improve its appearance while sterling silver is often rhodium-plated for tarnish resistance. Rhodium is sometimes used to cure silicones; a two-part silicone in which one part containing a silicon hydride and the other containing a vinyl-terminated silicone are mixed. One of these liquids contains a rhodium complex.</p><p>Rhodium detectors are used in nuclear reactors to measure the neutron flux level. Other uses of rhodium include asymmetric hydrogenation used to form drug precursors and the processes for the production of acetic acid.</p>",
        "thermal_expansion": 0.000008,
        "valence_electrons": 6
    },
    {
        "name": "Palladium",
        "symbol": "Pd",
        "abundance": {
            "universe": 2e-7,
            "solar": 3e-7,
            "meteor": 0.000066,
            "crust": 6.3e-7
        },
        "appearance": "silvery white",
        "atomic_mass": 106.421,
        "atomic_number": 46,
        "block": "d-block",
        "boiling_point": 3236,
        "classifications": {
            "cas_number": "CAS7440-05-3",
            "cid_number": "CID23938",
            "rtecs_number": "RTECSRT3480500",
            "dot_numbers": 3200,
            "dot_hazard_class": 4.2
        },
        "conductivity": {
            "thermal": 72,
            "electric": 10
        },
        "cpk_hex": "006985",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 12023,
            "liquid": 10380
        },
        "discovered": {
            "year": 1803,
            "by": "William Hyde Wollaston",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 54.24,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 4d¹⁰",
        "electron_configuration_semantic": "[Kr] 4d¹⁰",
        "electronegativity_pauling": 2.2,
        "electrons_per_shell": [
            2,
            8,
            18,
            18
        ],
        "energy_levels": "2, 8, 18, 18",
        "group": 10,
        "half_life": "Stable",
        "hardness": {
            "vickers": 461,
            "brinell": 37.3,
            "mohs": 4.75
        },
        "heat": {
            "specific": 240,
            "vaporization": 380,
            "fusion": 16.7,
            "molar": 25.98
        },
        "ionization_energies": [
            804.4,
            1870,
            3177
        ],
        "isotopes_known": "⁹¹Pd, ⁹²Pd, ⁹³Pd, ⁹⁴Pd, ⁹⁵Pd, ⁹⁶Pd, ⁹⁷Pd, ⁹⁸Pd, ⁹⁹Pd, ¹⁰⁰Pd, ¹⁰¹Pd, ¹⁰²Pd, ¹⁰³Pd, ¹⁰⁴Pd, ¹⁰⁵Pd, ¹⁰⁶Pd, ¹⁰⁷Pd, ¹⁰⁸Pd, ¹⁰⁹Pd, ¹¹⁰Pd, ¹¹¹Pd, ¹¹²Pd, ¹¹³Pd, ¹¹⁴Pd, ¹¹⁵Pd, ¹¹⁶Pd, ¹¹⁷Pd, ¹¹⁸Pd, ¹¹⁹Pd, ¹²⁰Pd, ¹²¹Pd, ¹²²Pd, ¹²³Pd, ¹²⁴Pd",
        "isotopes_stable": "¹⁰²Pd, ¹⁰⁴Pd, ¹⁰⁵Pd, ¹⁰⁶Pd, ¹⁰⁸Pd, ¹¹⁰Pd",
        "isotopic_abundances": "¹⁰²Pd: 1.02%, ¹⁰⁴Pd: 11.14%, ¹⁰⁵Pd: 22.33%, ¹⁰⁶Pd: 27.33%, ¹⁰⁸Pd: 26.46%, ¹¹⁰Pd: 11.72%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "389.07, 389.07, 389.07",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 6.57e-8,
            "molar": 6.992e-9,
            "volume": 0.0007899
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1828.05,
        "modulus": {
            "bulk": 180,
            "shear": 44,
            "young": 121
        },
        "molar_volume": 0.0000088514,
        "neutron_cross_section": 6.9,
        "neutron_mass_absorption": 0.0023,
        "oxidation_states": "2c,4c",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.39,
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 169,
            "empirical": 140,
            "covalent": 131,
            "vanderwaals": 163
        },
        "resistivity": 1e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Palladium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 3070,
        "summary": "<p>Palladium is a chemical element with the symbol Pd and atomic number 46. It is a rare and lustrous silvery-white metal discovered in 1803 by the English chemist William Hyde Wollaston. He named it after the asteroid Pallas, which was itself named after the epithet of the Greek goddess Athena, acquired by her when she slew Pallas. Palladium, platinum, rhodium, ruthenium, iridium and osmium form a group of elements referred to as the platinum group metals (PGMs). They have similar chemical properties, but palladium has the lowest melting point and is the least dense of them.</p><p>More than half the supply of palladium and its congener platinum is used in catalytic converters, which convert as much as 90% of the harmful gases in automobile exhaust (hydrocarbons, carbon monoxide, and nitrogen dioxide) into less noxious substances (nitrogen, carbon dioxide and water vapor). Palladium is also used in electronics, dentistry, medicine, hydrogen purification, chemical applications, groundwater treatment, and jewelry. Palladium is a key component of fuel cells, which react hydrogen with oxygen to produce electricity, heat, and water.</p><p>Ore deposits of palladium and other PGMs are rare. The most extensive deposits have been found in the norite belt of the Bushveld Igneous Complex covering the Transvaal Basin in South Africa, the Stillwater Complex in Montana, United States; the Sudbury Basin and Thunder Bay District of Ontario, Canada, and the Norilsk Complex in Russia. Recycling is also a source, mostly from scrapped catalytic converters. The numerous applications and limited supply sources result in considerable investment interest.</p>",
        "thermal_expansion": 0.0000118,
        "valence_electrons": 4
    },
    {
        "name": "Silver",
        "symbol": "Ag",
        "abundance": {
            "universe": 6e-8,
            "solar": 1e-7,
            "meteor": 0.000014,
            "crust": 0.0000079,
            "ocean": 1e-8
        },
        "alternate_names": "Argentum",
        "appearance": "lustrous white metal",
        "atomic_mass": 107.86822,
        "atomic_number": 47,
        "block": "d-block",
        "boiling_point": 2435,
        "classifications": {
            "cas_number": "CAS7440-22-4",
            "cid_number": "CID23954",
            "rtecs_number": "RTECSVW3500000"
        },
        "conductivity": {
            "thermal": 430,
            "electric": 62
        },
        "cpk_hex": "c0c0c0",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 10490,
            "liquid": 9320
        },
        "discovered": {
            "year": -5000
        },
        "electrical_type": "Conductor",
        "electron_affinity": 125.862,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s¹ 4d¹⁰",
        "electron_configuration_semantic": "[Kr] 4d¹⁰ 5s¹",
        "electronegativity_pauling": 1.93,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            1
        ],
        "energy_levels": "2, 8, 18, 18, 1",
        "group": 11,
        "half_life": "Stable",
        "hardness": {
            "vickers": 251,
            "brinell": 24.5,
            "mohs": 2.5
        },
        "heat": {
            "specific": 235,
            "vaporization": 255,
            "fusion": 11.3,
            "molar": 25.35
        },
        "ionization_energies": [
            731,
            2070,
            3361
        ],
        "isotopes_known": "⁹³Ag, ⁹⁴Ag, ⁹⁵Ag, ⁹⁶Ag, ⁹⁷Ag, ⁹⁸Ag, ⁹⁹Ag, ¹⁰⁰Ag, ¹⁰¹Ag, ¹⁰²Ag, ¹⁰³Ag, ¹⁰⁴Ag, ¹⁰⁵Ag, ¹⁰⁶Ag, ¹⁰⁷Ag, ¹⁰⁸Ag, ¹⁰⁹Ag, ¹¹⁰Ag, ¹¹¹Ag, ¹¹²Ag, ¹¹³Ag, ¹¹⁴Ag, ¹¹⁵Ag, ¹¹⁶Ag, ¹¹⁷Ag, ¹¹⁸Ag, ¹¹⁹Ag, ¹²⁰Ag, ¹²¹Ag, ¹²²Ag, ¹²³Ag, ¹²⁴Ag, ¹²⁵Ag, ¹²⁶Ag, ¹²⁷Ag, ¹²⁸Ag, ¹²⁹Ag, ¹³⁰Ag",
        "isotopes_stable": "¹⁰⁷Ag, ¹⁰⁹Ag",
        "isotopic_abundances": "¹⁰⁷Ag: 51.839%, ¹⁰⁹Ag: 48.161%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "408.53, 408.53, 408.53",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -2.27e-9,
            "molar": -2.45e-10,
            "volume": -0.0000238
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 1234.93,
        "modulus": {
            "bulk": 100,
            "shear": 30,
            "young": 83
        },
        "molar_volume": 0.000010283,
        "neutron_cross_section": 63.6,
        "neutron_mass_absorption": 0.02,
        "oxidation_states": "1c,2,3,4",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.37,
        "quantum_numbers": "2S1/2",
        "radius": {
            "calculated": 165,
            "empirical": 160,
            "covalent": 153,
            "vanderwaals": 172
        },
        "resistivity": 1.6e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Silver",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 2600,
        "summary": "<p>Silver is a chemical element with the symbol Ag (from the Latin argentum, derived from the Proto-Indo-European h₂erǵ: \"shiny\" or \"white\") and atomic number 47. A soft, white, lustrous transition metal, it exhibits the highest electrical conductivity, thermal conductivity, and reflectivity of any metal. The metal is found in the Earth's crust in the pure, free elemental form (\"native silver\"), as an alloy with gold and other metals, and in minerals such as argentite and chlorargyrite. Most silver is produced as a byproduct of copper, gold, lead, and zinc refining.</p><p>Silver has long been valued as a precious metal. Silver metal is used in many bullion coins, sometimes alongside gold: while it is more abundant than gold, it is much less abundant as a native metal. Its purity is typically measured on a per-mille basis; a 94%-pure alloy is described as \"0.940 fine\". As one of the seven metals of antiquity, silver has had an enduring role in most human cultures.</p><p>Other than in currency and as an investment medium (coins and bullion), silver is used in solar panels, water filtration, jewellery, ornaments, high-value tableware and utensils (hence the term \"silverware\"), in electrical contacts and conductors, in specialized mirrors, window coatings, in catalysis of chemical reactions, as a colorant in stained glass, and in specialized confectionery. Its compounds are used in photographic and X-ray film. Dilute solutions of silver nitrate and other silver compounds are used as disinfectants and microbiocides (oligodynamic effect), added to bandages, wound-dressings, catheters, and other medical instruments.</p>",
        "thermal_expansion": 0.0000189,
        "valence_electrons": 1
    },
    {
        "name": "Cadmium",
        "symbol": "Cd",
        "abundance": {
            "universe": 2e-7,
            "solar": 6e-7,
            "meteor": 0.000044,
            "crust": 0.000015,
            "ocean": 5e-9,
            "human": 0.00007
        },
        "appearance": "silvery bluish-gray metallic",
        "atomic_mass": 112.4144,
        "atomic_number": 48,
        "block": "d-block",
        "boiling_point": 1040,
        "classifications": {
            "cas_number": "CAS7440-43-9",
            "cid_number": "CID23973",
            "rtecs_number": "RTECSEU9800000",
            "dot_numbers": 2570,
            "dot_hazard_class": 6.1
        },
        "conductivity": {
            "thermal": 97,
            "electric": 14
        },
        "cpk_hex": "ffd98f",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 8650,
            "liquid": 7996
        },
        "discovered": {
            "year": 1817,
            "by": "Karl Samuel Leberecht Hermann",
            "location": "Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": -68,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰",
        "electron_configuration_semantic": "[Kr] 4d¹⁰ 5s²",
        "electronegativity_pauling": 1.69,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            2
        ],
        "energy_levels": "2, 8, 18, 18, 2",
        "group": 12,
        "half_life": "Stable",
        "hardness": {
            "brinell": 203,
            "mohs": 2
        },
        "heat": {
            "specific": 230,
            "vaporization": 100,
            "fusion": 6.3,
            "molar": 26.02
        },
        "ionization_energies": [
            867.8,
            1631.4,
            3616
        ],
        "isotopes_known": "⁹⁵Cd, ⁹⁶Cd, ⁹⁷Cd, ⁹⁸Cd, ⁹⁹Cd, ¹⁰⁰Cd, ¹⁰¹Cd, ¹⁰²Cd, ¹⁰³Cd, ¹⁰⁴Cd, ¹⁰⁵Cd, ¹⁰⁶Cd, ¹⁰⁷Cd, ¹⁰⁸Cd, ¹⁰⁹Cd, ¹¹⁰Cd, ¹¹¹Cd, ¹¹²Cd, ¹¹³Cd, ¹¹⁴Cd, ¹¹⁵Cd, ¹¹⁶Cd, ¹¹⁷Cd, ¹¹⁸Cd, ¹¹⁹Cd, ¹²⁰Cd, ¹²¹Cd, ¹²²Cd, ¹²³Cd, ¹²⁴Cd, ¹²⁵Cd, ¹²⁶Cd, ¹²⁷Cd, ¹²⁸Cd, ¹²⁹Cd, ¹³⁰Cd, ¹³¹Cd, ¹³²Cd",
        "isotopes_stable": "¹⁰⁶Cd, ¹⁰⁸Cd, ¹¹⁰Cd, ¹¹¹Cd, ¹¹²Cd, ¹¹⁴Cd",
        "isotopic_abundances": "¹⁰⁶Cd: 1.25%, ¹⁰⁸Cd: 0.89%, ¹¹⁰Cd: 12.49%, ¹¹¹Cd: 12.8%, ¹¹²Cd: 24.13%, ¹¹³Cd: 12.22%, ¹¹⁴Cd: 28.73%, ¹¹⁶Cd: 7.49%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "297.94, 297.94, 561.86",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -2.3e-9,
            "molar": -2.59e-10,
            "volume": -0.0000199
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 594.22,
        "modulus": {
            "bulk": 42,
            "shear": 19,
            "young": 50
        },
        "molar_volume": 0.000012996,
        "neutron_cross_section": 2450,
        "neutron_mass_absorption": 1.4,
        "oxidation_states": "1,2c",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.3,
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 161,
            "empirical": 155,
            "covalent": 148,
            "vanderwaals": 158
        },
        "resistivity": 7.000000000002e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Cadmium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2310,
        "summary": "<p>Cadmium is a chemical element with the symbol Cd and atomic number 48. This soft, silvery-white metal is chemically similar to the two other stable metals in group 12, zinc and mercury. Like zinc, it demonstrates oxidation state +2 in most of its compounds, and like mercury, it has a lower melting point than the transition metals in groups 3 through 11. Cadmium and its congeners in group 12 are often not considered transition metals, in that they do not have partly filled d or f electron shells in the elemental or common oxidation states. The average concentration of cadmium in Earth's crust is between 0.1 and 0.5 parts per million (ppm). It was discovered in 1817 simultaneously by Stromeyer and Hermann, both in Germany, as an impurity in zinc carbonate.</p><p>Cadmium occurs as a minor component in most zinc ores and is a byproduct of zinc production. Cadmium was used for a long time as a corrosion-resistant plating on steel, and cadmium compounds are used as red, orange and yellow pigments, to color glass, and to stabilize plastic. Cadmium use is generally decreasing because it is toxic (it is specifically listed in the European Restriction of Hazardous Substances Directive) and nickel-cadmium batteries have been replaced with nickel-metal hydride and lithium-ion batteries. One of its few new uses is in cadmium telluride solar panels.</p><p>Although cadmium has no known biological function in higher organisms, a cadmium-dependent carbonic anhydrase has been found in marine diatoms.</p>",
        "superconducting_point": 0.517,
        "thermal_expansion": 0.0000308,
        "valence_electrons": 2
    },
    {
        "name": "Indium",
        "symbol": "In",
        "abundance": {
            "universe": 3e-8,
            "solar": 4e-7,
            "meteor": 0.0000044,
            "crust": 0.000016,
            "ocean": 1e-11
        },
        "appearance": "silvery lustrous gray",
        "atomic_mass": 114.8181,
        "atomic_number": 49,
        "block": "p-block",
        "boiling_point": 2345,
        "classifications": {
            "cas_number": "CAS7440-74-6",
            "cid_number": "CID5359967",
            "rtecs_number": "RTECSNL1050000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 82,
            "electric": 12
        },
        "cpk_hex": "a67573",
        "crystal_structure": "Centered Tetragonal",
        "density": {
            "stp": 7310,
            "liquid": 7020
        },
        "discovered": {
            "year": 1863,
            "by": "Ferdinand Reich",
            "location": "Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 37.043,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p¹",
        "electron_configuration_semantic": "[Kr] 4d¹⁰ 5s² 5p¹",
        "electronegativity_pauling": 1.78,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            3
        ],
        "energy_levels": "2, 8, 18, 18, 3",
        "group": 13,
        "half_life": "Stable",
        "hardness": {
            "brinell": 8.83,
            "mohs": 1.2
        },
        "heat": {
            "specific": 233,
            "vaporization": 230,
            "fusion": 3.26,
            "molar": 26.74
        },
        "ionization_energies": [
            558.3,
            1820.7,
            2704,
            5210
        ],
        "isotopes_known": "⁹⁷In, ⁹⁸In, ⁹⁹In, ¹⁰⁰In, ¹⁰¹In, ¹⁰²In, ¹⁰³In, ¹⁰⁴In, ¹⁰⁵In, ¹⁰⁶In, ¹⁰⁷In, ¹⁰⁸In, ¹⁰⁹In, ¹¹⁰In, ¹¹¹In, ¹¹²In, ¹¹³In, ¹¹⁴In, ¹¹⁵In, ¹¹⁶In, ¹¹⁷In, ¹¹⁸In, ¹¹⁹In, ¹²⁰In, ¹²¹In, ¹²²In, ¹²³In, ¹²⁴In, ¹²⁵In, ¹²⁶In, ¹²⁷In, ¹²⁸In, ¹²⁹In, ¹³⁰In, ¹³¹In, ¹³²In, ¹³³In, ¹³⁴In, ¹³⁵In",
        "isotopes_stable": "¹¹³In",
        "isotopic_abundances": "¹¹³In: 4.29%, ¹¹⁵In: 95.71%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "325.23, 325.23, 494.61",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -1.4e-9,
            "molar": -1.61e-10,
            "volume": -0.0000102
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 429.7485,
        "modulus": {
            "young": 11
        },
        "molar_volume": 0.000015707,
        "neutron_cross_section": 194,
        "neutron_mass_absorption": 0.06,
        "oxidation_states": "1,2,3c",
        "period": 5,
        "phase": "Solid",
        "quantum_numbers": "2P1/2",
        "radius": {
            "calculated": 156,
            "empirical": 155,
            "covalent": 144,
            "vanderwaals": 193
        },
        "resistivity": 8.000000000001e-8,
        "series": "post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Indium",
        "space_group_name": "I4/mmm",
        "space_group_number": 139,
        "speed_of_sound": 1215,
        "summary": "<p>Indium is a chemical element with the symbol In and atomic number 49. Indium is the softest metal that is not an alkali metal. It is a silvery-white metal that resembles tin in appearance. It is a post-transition metal that makes up 0.21 parts per million of the Earth's crust. Indium has a melting point higher than sodium and gallium, but lower than lithium and tin. Chemically, indium is similar to gallium and thallium, and it is largely intermediate between the two in terms of its properties. Indium was discovered in 1863 by Ferdinand Reich and Hieronymous Theodor Richter by spectroscopic methods. They named it for the indigo blue line in its spectrum. Indium was isolated the next year.</p><p>Indium is a minor component in zinc sulfide ores and is produced as a byproduct of zinc refinement. It is most notably used in the semiconductor industry, in low-melting-point metal alloys such as solders, in soft-metal high-vacuum seals, and in the production of transparent conductive coatings of indium tin oxide (ITO) on glass. Indium is considered a technology-critical element.</p><p>Indium has no biological role. Its compounds are toxic when injected into the bloodstream. Most occupational exposure is through ingestion, from which indium compounds are not absorbed well, and inhalation, from which they are moderately absorbed.</p>",
        "superconducting_point": 3.41,
        "thermal_expansion": 0.0000321,
        "valence_electrons": 3
    },
    {
        "name": "Tin",
        "symbol": "Sn",
        "abundance": {
            "universe": 4e-7,
            "solar": 9e-7,
            "meteor": 0.00012,
            "crust": 0.00022,
            "ocean": 1e-9,
            "human": 0.00002
        },
        "allotropes": "White Tin, Gray Tin",
        "alternate_names": "Stannum",
        "appearance": "silvery-white (beta, β) or gray (alpha, α)",
        "atomic_mass": 118.7107,
        "atomic_number": 50,
        "block": "p-block",
        "boiling_point": 2875,
        "classifications": {
            "cas_number": "CAS7440-31-5",
            "cid_number": "CID5352426",
            "rtecs_number": "RTECSXP7320000"
        },
        "conductivity": {
            "thermal": 67,
            "electric": 9.1
        },
        "cpk_hex": "668080",
        "crystal_structure": "Centered Tetragonal",
        "density": {
            "stp": 7310,
            "liquid": 6990
        },
        "discovered": {
            "year": -3000,
            "by": "unknown, before 3500 BC"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 107.2984,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p²",
        "electron_configuration_semantic": "[Kr] 4d¹⁰ 5s² 5p²",
        "electronegativity_pauling": 1.96,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            4
        ],
        "energy_levels": "2, 8, 18, 18, 4",
        "group": 14,
        "half_life": "Stable",
        "hardness": {
            "brinell": 51,
            "mohs": 1.5
        },
        "heat": {
            "specific": 217,
            "vaporization": 290,
            "fusion": 7,
            "molar": 27.112
        },
        "ionization_energies": [
            708.6,
            1411.8,
            2943,
            3930.3,
            7456
        ],
        "isotopes_known": "⁹⁹Sn, ¹⁰⁰Sn, ¹⁰¹Sn, ¹⁰²Sn, ¹⁰³Sn, ¹⁰⁴Sn, ¹⁰⁵Sn, ¹⁰⁶Sn, ¹⁰⁷Sn, ¹⁰⁸Sn, ¹⁰⁹Sn, ¹¹⁰Sn, ¹¹¹Sn, ¹¹²Sn, ¹¹³Sn, ¹¹⁴Sn, ¹¹⁵Sn, ¹¹⁶Sn, ¹¹⁷Sn, ¹¹⁸Sn, ¹¹⁹Sn, ¹²⁰Sn, ¹²¹Sn, ¹²²Sn, ¹²³Sn, ¹²⁴Sn, ¹²⁵Sn, ¹²⁶Sn, ¹²⁷Sn, ¹²⁸Sn, ¹²⁹Sn, ¹³⁰Sn, ¹³¹Sn, ¹³²Sn, ¹³³Sn, ¹³⁴Sn, ¹³⁵Sn, ¹³⁶Sn, ¹³⁷Sn",
        "isotopes_stable": "¹¹²Sn, ¹¹⁴Sn, ¹¹⁵Sn, ¹¹⁶Sn, ¹¹⁷Sn, ¹¹⁸Sn, ¹¹⁹Sn, ¹²⁰Sn, ¹²²Sn, ¹²⁴Sn",
        "isotopic_abundances": "¹¹²Sn: 0.97%, ¹¹⁴Sn: 0.66%, ¹¹⁵Sn: 0.34%, ¹¹⁶Sn: 14.54%, ¹¹⁷Sn: 7.68%, ¹¹⁸Sn: 24.22%, ¹¹⁹Sn: 8.59%, ¹²⁰Sn: 32.58%, ¹²²Sn: 4.63%, ¹²⁴Sn: 5.79%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "583.18, 583.18, 318.19",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -3.1e-9,
            "molar": -3.68e-10,
            "volume": -0.0000227
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 505.08,
        "modulus": {
            "bulk": 58,
            "shear": 18,
            "young": 50
        },
        "molar_volume": 0.000016239,
        "neutron_cross_section": 0.62,
        "neutron_mass_absorption": 0.0002,
        "oxidation_states": "-4c,2c,4c",
        "period": 5,
        "phase": "Solid",
        "poisson_ratio": 0.36,
        "quantum_numbers": "3P0",
        "radius": {
            "calculated": 145,
            "empirical": 145,
            "covalent": 141,
            "vanderwaals": 217
        },
        "resistivity": 1.1e-7,
        "series": "post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Tin",
        "space_group_name": "I41/amd",
        "space_group_number": 141,
        "speed_of_sound": 2500,
        "summary": "<p>Tin is a chemical element with the symbol Sn (from Latin: stannum) and atomic number 50. Tin is a silvery metal that characteristically has a faint yellow hue.</p><p>Tin is soft enough to be cut with little force. When a bar of tin is bent, the so-called “tin cry” can be heard as a result of twinning in tin crystals; this trait is shared by indium, cadmium, zinc, and frozen mercury.</p><p>Pure tin after solidifying presents a mirror-like appearance similar to most metals. In most tin alloys (such as pewter) the metal solidifies with a dull gray color.</p><p>Tin is a post-transition metal in group 14 of the periodic table of elements. It is obtained chiefly from the mineral cassiterite, which contains stannic oxide, SnO2. Tin shows a chemical similarity to both of its neighbors in group 14, germanium and lead, and has two main oxidation states, +2 and the slightly more stable +4. Tin is the 49th most abundant element on Earth and has, with 10 stable isotopes, the largest number of stable isotopes in the periodic table, thanks to its magic number of protons.</p><p>It has two main allotropes: at room temperature, the stable allotrope is β-tin, a silvery-white, malleable metal; at low temperatures it is less dense grey α-tin, which has the diamond cubic structure. Metallic tin does not easily oxidize in air.</p><p>The first tin alloy used on a large scale was bronze, made of 1&#8260;8 tin and 7&#8260;8 copper, from as early as 3000 BC. After 600 BC, pure metallic tin was produced. Pewter, which is an alloy of 85–90% tin with the remainder commonly consisting of copper, antimony, and lead, was used for flatware from the Bronze Age until the 20th century. In modern times, tin is used in many alloys, most notably tin / lead soft solders, which are typically 60% or more tin, and in the manufacture of transparent, electrically conducting films of indium tin oxide in optoelectronic applications. Another large application is corrosion-resistant tin plating of steel. Because of the low toxicity of inorganic tin, tin-plated steel is widely used for food packaging as tin cans. Some organotin compounds can be extremely toxic.</p>",
        "superconducting_point": 3.72,
        "thermal_expansion": 0.000022,
        "valence_electrons": 4
    },
    {
        "name": "Antimony",
        "symbol": "Sb",
        "abundance": {
            "universe": 4e-8,
            "solar": 1e-7,
            "meteor": 0.000012,
            "crust": 0.00002,
            "ocean": 2e-8
        },
        "allotropes": "White Antimony, Yellow Antimony, Black Antimony",
        "alternate_names": "Stibium",
        "appearance": "silvery lustrous gray",
        "atomic_mass": 121.7601,
        "atomic_number": 51,
        "block": "p-block",
        "boiling_point": 1908,
        "classifications": {
            "cas_number": "CAS7440-36-0",
            "cid_number": "CID5354495",
            "rtecs_number": "RTECSCC4025000"
        },
        "conductivity": {
            "thermal": 24,
            "electric": 2.5
        },
        "cpk_hex": "9e63b5",
        "crystal_structure": "Simple Trigonal",
        "density": {
            "stp": 6697,
            "liquid": 6530
        },
        "discovered": {
            "year": -3000,
            "by": "unknown, before 3000 BC"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 101.059,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p³",
        "electron_configuration_semantic": "[Kr] 4d¹⁰ 5s² 5p³",
        "electronegativity_pauling": 2.05,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            5
        ],
        "energy_levels": "2, 8, 18, 18, 5",
        "group": 15,
        "half_life": "Stable",
        "hardness": {
            "brinell": 294,
            "mohs": 3
        },
        "heat": {
            "specific": 207,
            "vaporization": 68,
            "fusion": 19.7,
            "molar": 25.23
        },
        "ionization_energies": [
            834,
            1594.9,
            2440,
            4260,
            5400,
            10400
        ],
        "isotopes_known": "¹⁰³Sb, ¹⁰⁴Sb, ¹⁰⁵Sb, ¹⁰⁶Sb, ¹⁰⁷Sb, ¹⁰⁸Sb, ¹⁰⁹Sb, ¹¹⁰Sb, ¹¹¹Sb, ¹¹²Sb, ¹¹³Sb, ¹¹⁴Sb, ¹¹⁵Sb, ¹¹⁶Sb, ¹¹⁷Sb, ¹¹⁸Sb, ¹¹⁹Sb, ¹²⁰Sb, ¹²¹Sb, ¹²²Sb, ¹²³Sb, ¹²⁴Sb, ¹²⁵Sb, ¹²⁶Sb, ¹²⁷Sb, ¹²⁸Sb, ¹²⁹Sb, ¹³⁰Sb, ¹³¹Sb, ¹³²Sb, ¹³³Sb, ¹³⁴Sb, ¹³⁵Sb, ¹³⁶Sb, ¹³⁷Sb, ¹³⁸Sb, ¹³⁹Sb",
        "isotopes_stable": "¹²¹Sb, ¹²³Sb",
        "isotopic_abundances": "¹²¹Sb: 57.21%, ¹²³Sb: 42.79%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "430.7, 430.7, 1127.3",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -1.09e-8,
            "molar": -1.327e-9,
            "volume": -0.000073
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 903.78,
        "modulus": {
            "bulk": 42,
            "shear": 20,
            "young": 55
        },
        "molar_volume": 0.000018181,
        "neutron_cross_section": 5.4,
        "neutron_mass_absorption": 0.0016,
        "oxidation_states": "-3c,3c,5c",
        "period": 5,
        "phase": "Solid",
        "quantum_numbers": "4S3/2",
        "radius": {
            "calculated": 133,
            "empirical": 145,
            "covalent": 138
        },
        "resistivity": 4e-7,
        "series": "metalloid",
        "source": "https://en.wikipedia.org/wiki/Antimony",
        "space_group_name": "R_3m",
        "space_group_number": 166,
        "speed_of_sound": 3420,
        "summary": "<p>Antimony is a chemical element with the symbol Sb (from Latin: stibium) and atomic number 51. A lustrous gray metalloid, it is found in nature mainly as the sulfide mineral stibnite (Sb2S3). Antimony compounds have been known since ancient times and were powdered for use as medicine and cosmetics, often known by the Arabic name kohl. Metallic antimony was also known, but it was erroneously identified as lead upon its discovery. The earliest known description of the metal in the West was written in 1540 by Vannoccio Biringuccio.</p><p>China is the largest producer of antimony and its compounds, with most production coming from the Xikuangshan Mine in Hunan. The industrial methods for refining antimony are roasting and reduction with carbon or direct reduction of stibnite with iron.</p><p>The largest applications for metallic antimony are an alloy with lead and tin and the lead antimony plates in lead–acid batteries. Alloys of lead and tin with antimony have improved properties for solders, bullets, and plain bearings. Antimony compounds are prominent additives for chlorine and bromine-containing fire retardants found in many commercial and domestic products. An emerging application is the use of antimony in microelectronics.</p>",
        "thermal_expansion": 0.000011,
        "valence_electrons": 5
    },
    {
        "name": "Tellurium",
        "symbol": "Te",
        "abundance": {
            "universe": 9e-7,
            "meteor": 0.00021,
            "crust": 9.9e-8
        },
        "atomic_mass": 127.603,
        "atomic_number": 52,
        "block": "p-block",
        "boiling_point": 1261,
        "classifications": {
            "cas_number": "CAS13494-80-9",
            "cid_number": "CID6327182",
            "rtecs_number": "RTECSWY2625000",
            "dot_numbers": 2811,
            "dot_hazard_class": 6.1
        },
        "conductivity": {
            "thermal": 3,
            "electric": 0.01
        },
        "cpk_hex": "d47a00",
        "crystal_structure": "Simple Trigonal",
        "density": {
            "stp": 6240,
            "liquid": 5700
        },
        "discovered": {
            "year": 1783,
            "by": "Franz-Joseph Müller von Reichenstein",
            "location": "Romania"
        },
        "electrical_type": "Semiconductor",
        "electron_affinity": 190.161,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁴",
        "electron_configuration_semantic": "[Kr] 4d¹⁰ 5s² 5p⁴",
        "electronegativity_pauling": 2.1,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            6
        ],
        "energy_levels": "2, 8, 18, 18, 6",
        "group": 16,
        "half_life": "Stable",
        "hardness": {
            "brinell": 180,
            "mohs": 2.25
        },
        "heat": {
            "specific": 201,
            "vaporization": 48,
            "fusion": 17.5,
            "molar": 25.73
        },
        "ionization_energies": [
            869.3,
            1790,
            2698,
            3610,
            5668,
            6820,
            13200
        ],
        "isotopes_known": "¹⁰⁵Te, ¹⁰⁶Te, ¹⁰⁷Te, ¹⁰⁸Te, ¹⁰⁹Te, ¹¹⁰Te, ¹¹¹Te, ¹¹²Te, ¹¹³Te, ¹¹⁴Te, ¹¹⁵Te, ¹¹⁶Te, ¹¹⁷Te, ¹¹⁸Te, ¹¹⁹Te, ¹²⁰Te, ¹²¹Te, ¹²²Te, ¹²³Te, ¹²⁴Te, ¹²⁵Te, ¹²⁶Te, ¹²⁷Te, ¹²⁸Te, ¹²⁹Te, ¹³⁰Te, ¹³¹Te, ¹³²Te, ¹³³Te, ¹³⁴Te, ¹³⁵Te, ¹³⁶Te, ¹³⁷Te, ¹³⁸Te, ¹³⁹Te, ¹⁴⁰Te, ¹⁴¹Te, ¹⁴²Te",
        "isotopes_stable": "¹²⁰Te, ¹²²Te, ¹²⁴Te, ¹²⁵Te, ¹²⁶Te",
        "isotopic_abundances": "¹²⁰Te: 0.09%, ¹²²Te: 2.55%, ¹²³Te: 0.89%, ¹²⁴Te: 4.74%, ¹²⁵Te: 7.07%, ¹²⁶Te: 18.84%, ¹²⁸Te: 31.74%, ¹³⁰Te: 34.08%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "445.72, 445.72, 592.9",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -3.9e-9,
            "molar": -4.98e-10,
            "volume": -0.0000243
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 722.66,
        "modulus": {
            "bulk": 65,
            "shear": 16,
            "young": 43
        },
        "molar_volume": 0.000020449,
        "neutron_cross_section": 5.4,
        "neutron_mass_absorption": 0.0013,
        "oxidation_states": "-2c,2c,4c,5,6c",
        "period": 5,
        "phase": "Solid",
        "quantum_numbers": "3P2",
        "radius": {
            "calculated": 123,
            "empirical": 140,
            "covalent": 135,
            "vanderwaals": 206
        },
        "refractive_index": 1.000991,
        "resistivity": 0.0001,
        "series": "metalloid",
        "source": "https://en.wikipedia.org/wiki/Tellurium",
        "space_group_name": "P3121",
        "space_group_number": 152,
        "speed_of_sound": 2610,
        "summary": "<p>Tellurium is a chemical element with the symbol Te and atomic number 52. It is a brittle, mildly toxic, rare, silver-white metalloid. Tellurium is chemically related to selenium and sulfur, all three of which are chalcogens. It is occasionally found in native form as elemental crystals. Tellurium is far more common in the Universe as a whole than on Earth. Its extreme rarity in the Earth's crust, comparable to that of platinum, is due partly to its formation of a volatile hydride that caused tellurium to be lost to space as a gas during the hot nebular formation of Earth.</p><p>Tellurium-bearing compounds were first discovered in 1782 in a gold mine in Kleinschlatten, Transylvania (now Zlatna, Romania) by Austrian mineralogist Franz-Joseph Müller von Reichenstein, although it was Martin Heinrich Klaproth who named the new element in 1798 after the Latin word for \"earth\", tellus. Gold telluride minerals are the most notable natural gold compounds. However, they are not a commercially significant source of tellurium itself, which is normally extracted as a by-product of copper and lead production.</p><p>Commercially, the primary use of tellurium is copper (tellurium copper) and steel alloys, where it improves machinability. Applications in CdTe solar panels and cadmium telluride semiconductors also consume a considerable portion of tellurium production. Tellurium is considered a technology-critical element.</p><p>Tellurium has no biological function, although fungi can use it in place of sulfur and selenium in amino acids such as tellurocysteine and telluromethionine. In humans, tellurium is partly metabolized into dimethyl telluride, (CH3)2Te, a gas with a garlic-like odor exhaled in the breath of victims of tellurium exposure or poisoning.</p>",
        "valence_electrons": 6
    },
    {
        "name": "Iodine",
        "symbol": "I",
        "abundance": {
            "universe": 1e-7,
            "meteor": 0.000025,
            "crust": 0.000049,
            "ocean": 0.000006,
            "human": 0.00002
        },
        "allotropes": "Diiodine",
        "appearance": "lustrous metallic gray, violet as a gas",
        "atomic_mass": 126.904473,
        "atomic_number": 53,
        "block": "p-block",
        "boiling_point": 457.4,
        "classifications": {
            "cas_number": "CAS7553-56-2",
            "cid_number": "CID807",
            "rtecs_number": "RTECSNN1575000",
            "dot_numbers": 1759,
            "dot_hazard_class": 8
        },
        "conductivity": {
            "thermal": 0.449,
            "electric": 1e-13
        },
        "cpk_hex": "940094",
        "critical_pressure": 11.7,
        "critical_temperature": 819,
        "crystal_structure": "Base Orthorhombic",
        "density": {
            "stp": 4940
        },
        "discovered": {
            "year": 1811,
            "by": "Bernard Courtois",
            "location": "France"
        },
        "electrical_type": "Insulator",
        "electron_affinity": 295.1531,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁵",
        "electron_configuration_semantic": "[Kr] 4d¹⁰ 5s² 5p⁵",
        "electronegativity_pauling": 2.66,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            7
        ],
        "energy_levels": "2, 8, 18, 18, 7",
        "group": 17,
        "half_life": "Stable",
        "heat": {
            "specific": 429,
            "vaporization": 20.9,
            "fusion": 7.76
        },
        "ionization_energies": [
            1008.4,
            1845.9,
            3180
        ],
        "isotopes_known": "¹⁰⁸I, ¹⁰⁹I, ¹¹⁰I, ¹¹¹I, ¹¹²I, ¹¹³I, ¹¹⁴I, ¹¹⁵I, ¹¹⁶I, ¹¹⁷I, ¹¹⁸I, ¹¹⁹I, ¹²⁰I, ¹²¹I, ¹²²I, ¹²³I, ¹²⁴I, ¹²⁵I, ¹²⁶I, ¹²⁷I, ¹²⁸I, ¹²⁹I, ¹³⁰I, ¹³¹I, ¹³²I, ¹³³I, ¹³⁴I, ¹³⁵I, ¹³⁶I, ¹³⁷I, ¹³⁸I, ¹³⁹I, ¹⁴⁰I, ¹⁴¹I, ¹⁴²I, ¹⁴³I, ¹⁴⁴I",
        "isotopes_stable": "¹²⁷I",
        "isotopic_abundances": "¹²⁷I: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "718.02, 471.02, 981.03",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -4.5e-9,
            "molar": -1.14e-9,
            "volume": -0.0000222
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 386.85,
        "modulus": {
            "bulk": 7.7
        },
        "molar_volume": 0.000025689,
        "neutron_cross_section": 6.3,
        "neutron_mass_absorption": 0.0018,
        "oxidation_states": "-1c,1c,3c,4,5c,7c",
        "period": 5,
        "phase": "Solid",
        "quantum_numbers": "2P3/2",
        "radius": {
            "calculated": 115,
            "empirical": 140,
            "covalent": 133,
            "vanderwaals": 198
        },
        "resistivity": 10000000,
        "series": "diatomic nonmetal",
        "source": "https://en.wikipedia.org/wiki/Iodine",
        "space_group_name": "Cmca",
        "space_group_number": 64,
        "summary": "<p>Iodine is a chemical element with the symbol I and atomic number 53. The heaviest of the stable halogens, it exists as a semi-lustrous, non-metallic solid at standard conditions that melts to form a deep violet liquid at 114 degrees Celsius, and boils to a violet gas at 184 degrees Celsius. The element was discovered by the French chemist Bernard Courtois in 1811, and was named two years later by Joseph Louis Gay-Lussac, after the Greek Ιώδης \"violet-coloured\".</p><p>Iodine occurs in many oxidation states, including iodide (I−), iodate (IO−3), and the various periodate anions. It is the least abundant of the stable halogens, being the sixty-first most abundant element. It is the heaviest essential mineral nutrient. Iodine is essential in the synthesis of thyroid hormones. Iodine deficiency affects about two billion people and is the leading preventable cause of intellectual disabilities.</p><p>The dominant producers of iodine today are Chile and Japan. Iodine and its compounds are primarily used in nutrition. Due to its high atomic number and ease of attachment to organic compounds, it has also found favour as a non-toxic radiocontrast material. Because of the specificity of its uptake by the human body, radioactive isotopes of iodine can also be used to treat thyroid cancer. Iodine is also used as a catalyst in the industrial production of acetic acid and some polymers.</p><p>It is on the World Health Organization's List of Essential Medicines.</p>",
        "valence_electrons": 7
    },
    {
        "name": "Xenon",
        "symbol": "Xe",
        "abundance": {
            "universe": 0.000001,
            "crust": 2e-9,
            "ocean": 5e-10
        },
        "adiabatic_index": "5/3",
        "appearance": "colorless gas, exhibiting a blue glow when placed in a high voltage electric field",
        "atomic_mass": 131.2936,
        "atomic_number": 54,
        "block": "p-block",
        "boiling_point": 165.051,
        "classifications": {
            "cas_number": "CAS7440-63-3",
            "cid_number": "CID23991",
            "rtecs_number": "RTECSZE1280000",
            "dot_numbers": 2591,
            "dot_hazard_class": 2.2
        },
        "conductivity": {
            "thermal": 0.00565
        },
        "cpk_hex": "429eb0",
        "critical_pressure": 5.841,
        "critical_temperature": 289.77,
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 5.9
        },
        "discovered": {
            "year": 1898,
            "by": "William Ramsay",
            "location": "The United Kingdom"
        },
        "electron_affinity": -77,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶",
        "electron_configuration_semantic": "[Kr] 4d¹⁰ 5s² 5p⁶",
        "electronegativity_pauling": 2.6,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            8
        ],
        "energy_levels": "2, 8, 18, 18, 8",
        "gas_phase": "Monoatomic",
        "group": 18,
        "half_life": "Stable",
        "heat": {
            "specific": 158.32,
            "vaporization": 12.64,
            "fusion": 2.3
        },
        "ionization_energies": [
            1170.4,
            2046.4,
            3099.4
        ],
        "isotopes_known": "¹¹⁰Xe, ¹¹¹Xe, ¹¹²Xe, ¹¹³Xe, ¹¹⁴Xe, ¹¹⁵Xe, ¹¹⁶Xe, ¹¹⁷Xe, ¹¹⁸Xe, ¹¹⁹Xe, ¹²⁰Xe, ¹²¹Xe, ¹²²Xe, ¹²³Xe, ¹²⁴Xe, ¹²⁵Xe, ¹²⁶Xe, ¹²⁷Xe, ¹²⁸Xe, ¹²⁹Xe, ¹³⁰Xe, ¹³¹Xe, ¹³²Xe, ¹³³Xe, ¹³⁴Xe, ¹³⁵Xe, ¹³⁶Xe, ¹³⁷Xe, ¹³⁸Xe, ¹³⁹Xe, ¹⁴⁰Xe, ¹⁴¹Xe, ¹⁴²Xe, ¹⁴³Xe, ¹⁴⁴Xe, ¹⁴⁵Xe, ¹⁴⁶Xe, ¹⁴⁷Xe",
        "isotopes_stable": "¹²⁴Xe, ¹²⁶Xe, ¹²⁸Xe, ¹²⁹Xe, ¹³⁰Xe, ¹³¹Xe, ¹³²Xe, ¹³⁴Xe, ¹³⁶Xe",
        "isotopic_abundances": "¹²⁴Xe: 0.09%, ¹²⁶Xe: 0.09%, ¹²⁸Xe: 1.92%, ¹²⁹Xe: 26.44%, ¹³⁰Xe: 4.08%, ¹³¹Xe: 21.18%, ¹³²Xe: 26.89%, ¹³⁴Xe: 10.44%, ¹³⁶Xe: 8.87%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "620.23, 620.23, 620.23",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -4.3e-9,
            "molar": -5.65e-10,
            "volume": -2.54e-8
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 161.4,
        "molar_volume": 0.0223,
        "neutron_cross_section": 25,
        "neutron_mass_absorption": 0.0083,
        "oxidation_states": "2c,4c,6c,8",
        "period": 5,
        "phase": "Gas",
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 108,
            "covalent": 130,
            "vanderwaals": 216
        },
        "refractive_index": 1.000702,
        "series": "noble gas",
        "source": "https://en.wikipedia.org/wiki/Xenon",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 1090,
        "summary": "<p>Xenon is a chemical element with the symbol Xe and atomic number 54. It is a colorless, dense, odorless noble gas found in Earth's atmosphere in trace amounts. Although generally unreactive, xenon can undergo a few chemical reactions such as the formation of xenon hexafluoroplatinate, the first noble gas compound to be synthesized.</p><p>Xenon is used in flash lamps and arc lamps, and as a general anesthetic. The first excimer laser design used a xenon dimer molecule (Xe2) as the lasing medium, and the earliest laser designs used xenon flash lamps as pumps. Xenon is used to search for hypothetical weakly interacting massive particles and as the propellant for ion thrusters in spacecraft.</p><p>Naturally occurring xenon consists of seven stable isotopes and two long-lived radioactive isotopes. More than 40 unstable xenon isotopes undergo radioactive decay, and the isotope ratios of xenon are an important tool for studying the early history of the Solar System. Radioactive xenon-135 is produced by beta decay from iodine-135 (a product of nuclear fission), and is the most significant (and unwanted) neutron absorber in nuclear reactors.</p>",
        "valence_electrons": 6
    },
    {
        "name": "Cesium",
        "symbol": "Cs",
        "abundance": {
            "universe": 8e-8,
            "solar": 8e-7,
            "meteor": 0.000014,
            "crust": 0.00019,
            "ocean": 5e-8,
            "human": 0.000002
        },
        "alternate_names": "Caesium",
        "appearance": "silvery gold",
        "atomic_mass": 132.905451966,
        "atomic_number": 55,
        "block": "s-block",
        "boiling_point": 944,
        "classifications": {
            "cas_number": "CAS7440-46-2",
            "cid_number": "CID5354618",
            "rtecs_number": "RTECSFK9225000",
            "dot_numbers": 1407,
            "dot_hazard_class": 4.3
        },
        "conductivity": {
            "thermal": 36,
            "electric": 5
        },
        "cpk_hex": "57178f",
        "critical_pressure": 9.4,
        "critical_temperature": 1938,
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 1879,
            "liquid": 1843
        },
        "discovered": {
            "year": 1860,
            "by": "Robert Bunsen",
            "location": "Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 45.505,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s¹",
        "electron_configuration_semantic": "[Xe] 6s¹",
        "electronegativity_pauling": 0.79,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            8,
            1
        ],
        "energy_levels": "2, 8, 18, 18, 8, 1",
        "group": 1,
        "half_life": "Stable",
        "hardness": {
            "brinell": 0.14,
            "mohs": 0.2
        },
        "heat": {
            "specific": 242,
            "vaporization": 65,
            "fusion": 2.09,
            "molar": 32.21
        },
        "ionization_energies": [
            375.7,
            2234.3,
            3400
        ],
        "isotopes_known": "¹¹²Cs, ¹¹³Cs, ¹¹⁴Cs, ¹¹⁵Cs, ¹¹⁶Cs, ¹¹⁷Cs, ¹¹⁸Cs, ¹¹⁹Cs, ¹²⁰Cs, ¹²¹Cs, ¹²²Cs, ¹²³Cs, ¹²⁴Cs, ¹²⁵Cs, ¹²⁶Cs, ¹²⁷Cs, ¹²⁸Cs, ¹²⁹Cs, ¹³⁰Cs, ¹³¹Cs, ¹³²Cs, ¹³³Cs, ¹³⁴Cs, ¹³⁵Cs, ¹³⁶Cs, ¹³⁷Cs, ¹³⁸Cs, ¹³⁹Cs, ¹⁴⁰Cs, ¹⁴¹Cs, ¹⁴²Cs, ¹⁴³Cs, ¹⁴⁴Cs, ¹⁴⁵Cs, ¹⁴⁶Cs, ¹⁴⁷Cs, ¹⁴⁸Cs, ¹⁴⁹Cs, ¹⁵⁰Cs, ¹⁵¹Cs",
        "isotopes_stable": "¹³³Cs",
        "isotopic_abundances": "¹³³Cs: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "614.1, 614.1, 614.1",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 2.8e-9,
            "molar": 3.72e-10,
            "volume": 0.00000526
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 301.7,
        "modulus": {
            "bulk": 1.6,
            "young": 1.7
        },
        "molar_volume": 0.000070732,
        "neutron_cross_section": 29,
        "neutron_mass_absorption": 0.0077,
        "oxidation_states": "-1,1c",
        "period": 6,
        "phase": "Solid",
        "quantum_numbers": "2S1/2",
        "radius": {
            "calculated": 298,
            "empirical": 260,
            "covalent": 225
        },
        "resistivity": 2e-7,
        "series": "alkali metal",
        "source": "https://en.wikipedia.org/wiki/Cesium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "summary": "<p>Caesium (IUPAC spelling) (also spelled cesium in American English) is a chemical element with the symbol Cs and atomic number 55. It is a soft, silvery-golden alkali metal with a melting point of 28.5 °C (83.3 °F), which makes it one of only five elemental metals that are liquid at or near room temperature. Caesium has physical and chemical properties similar to those of rubidium and potassium. The most reactive of all metals, it is pyrophoric and reacts with water even at −116 °C (−177 °F). It is the least electronegative element, with a value of 0.79 on the Pauling scale. It has only one stable isotope, caesium-133. Caesium is mined mostly from pollucite, while the radioisotopes, especially caesium-137, a fission product, are extracted from waste produced by nuclear reactors.</p><p>The German chemist Robert Bunsen and physicist Gustav Kirchhoff discovered caesium in 1860 by the newly developed method of flame spectroscopy. The first small-scale applications for caesium were as a \"getter\" in vacuum tubes and in photoelectric cells. In 1967, acting on Einstein's proof that the speed of light is the most constant dimension in the universe, the International System of Units used two specific wave counts from an emission spectrum of caesium-133 to co-define the second and the metre. Since then, caesium has been widely used in highly accurate atomic clocks.</p><p>Since the 1990s, the largest application of the element has been as caesium formate for drilling fluids, but it has a range of applications in the production of electricity, in electronics, and in chemistry. The radioactive isotope caesium-137 has a half_life of about 30 years and is used in medical applications, industrial gauges, and hydrology. Nonradioactive caesium compounds are only mildly toxic, but the pure metal's tendency to react explosively with water means that caesium is considered a hazardous material, and the radioisotopes present a significant health and ecological hazard in the environment.</p>",
        "valence_electrons": 1
    },
    {
        "name": "Barium",
        "symbol": "Ba",
        "abundance": {
            "universe": 0.000001,
            "solar": 0.000001,
            "meteor": 0.00027,
            "crust": 0.034,
            "ocean": 0.000003,
            "human": 0.00003
        },
        "atomic_mass": 137.3277,
        "atomic_number": 56,
        "block": "s-block",
        "boiling_point": 2118,
        "classifications": {
            "cas_number": "CAS7440-39-3",
            "cid_number": "CID5355457",
            "rtecs_number": "RTECSCQ8370000",
            "dot_numbers": 1400,
            "dot_hazard_class": 4.3
        },
        "conductivity": {
            "thermal": 18,
            "electric": 2.9
        },
        "cpk_hex": "00c900",
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 3510,
            "liquid": 3338
        },
        "discovered": {
            "year": 1808,
            "by": "Carl Wilhelm Scheele",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 13.954,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s²",
        "electron_configuration_semantic": "[Xe] 6s²",
        "electronegativity_pauling": 0.89,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 18, 8, 2",
        "group": 2,
        "half_life": "Stable",
        "hardness": {
            "mohs": 1.25
        },
        "heat": {
            "specific": 205,
            "vaporization": 140,
            "fusion": 8,
            "molar": 28.07
        },
        "ionization_energies": [
            502.9,
            965.2,
            3600
        ],
        "isotopes_known": "¹¹⁴Ba, ¹¹⁵Ba, ¹¹⁶Ba, ¹¹⁷Ba, ¹¹⁸Ba, ¹¹⁹Ba, ¹²⁰Ba, ¹²¹Ba, ¹²²Ba, ¹²³Ba, ¹²⁴Ba, ¹²⁵Ba, ¹²⁶Ba, ¹²⁷Ba, ¹²⁸Ba, ¹²⁹Ba, ¹³⁰Ba, ¹³¹Ba, ¹³²Ba, ¹³³Ba, ¹³⁴Ba, ¹³⁵Ba, ¹³⁶Ba, ¹³⁷Ba, ¹³⁸Ba, ¹³⁹Ba, ¹⁴⁰Ba, ¹⁴¹Ba, ¹⁴²Ba, ¹⁴³Ba, ¹⁴⁴Ba, ¹⁴⁵Ba, ¹⁴⁶Ba, ¹⁴⁷Ba, ¹⁴⁸Ba, ¹⁴⁹Ba, ¹⁵⁰Ba, ¹⁵¹Ba, ¹⁵²Ba, ¹⁵³Ba",
        "isotopes_stable": "¹³⁰Ba, ¹³²Ba, ¹³⁴Ba, ¹³⁵Ba, ¹³⁶Ba, ¹³⁷Ba, ¹³⁸Ba",
        "isotopic_abundances": "¹³⁰Ba: 0.106%, ¹³²Ba: 0.101%, ¹³⁴Ba: 2.417%, ¹³⁵Ba: 6.592%, ¹³⁶Ba: 7.854%, ¹³⁷Ba: 11.232%, ¹³⁸Ba: 71.698%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "502.8, 502.8, 502.8",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.13e-8,
            "molar": 1.552e-9,
            "volume": 0.00003966
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1000,
        "modulus": {
            "bulk": 9.6,
            "shear": 4.9,
            "young": 13
        },
        "molar_volume": 0.000039125,
        "neutron_cross_section": 1.3,
        "neutron_mass_absorption": 0.00027,
        "oxidation_states": "2c",
        "period": 6,
        "phase": "Solid",
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 253,
            "empirical": 215,
            "covalent": 198
        },
        "resistivity": 3.5e-7,
        "series": "alkaline earth metal",
        "source": "https://en.wikipedia.org/wiki/Barium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 1620,
        "summary": "<p>Barium is a chemical element with the symbol Ba and atomic number 56. It is the fifth element in group 2 and is a soft, silvery alkaline earth metal. Because of its high chemical reactivity, barium is never found in nature as a free element.</p><p>The most common minerals of barium are baryte (barium sulfate, BaSO4) and witherite (barium carbonate, BaCO3). The name barium originates from the alchemical derivative \"baryta\", from Greek βαρύς (barys), meaning \"heavy\". Baric is the adjectival form of barium. Barium was identified as a new element in 1774, but not reduced to a metal until 1808 with the advent of electrolysis.</p><p>Barium has few industrial applications. Historically, it was used as a getter for vacuum tubes and in oxide form as the emissive coating on indirectly heated cathodes. It is a component of YBCO (high-temperature superconductors) and electroceramics, and is added to steel and cast iron to reduce the size of carbon grains within the microstructure. Barium compounds are added to fireworks to impart a green color. Barium sulfate is used as an insoluble additive to oil well drilling fluid, as well as in a purer form, as X-ray radiocontrast agents for imaging the human gastrointestinal tract. Water-soluble barium compounds are poisonous and have been used as rodenticides.</p>",
        "thermal_expansion": 0.0000206,
        "valence_electrons": 2
    },
    {
        "name": "Lanthanum",
        "symbol": "La",
        "abundance": {
            "universe": 2e-7,
            "solar": 2e-7,
            "meteor": 0.000028,
            "crust": 0.0034,
            "ocean": 3.4e-10
        },
        "appearance": "silvery white",
        "atomic_mass": 138.905477,
        "atomic_number": 57,
        "block": "f-block",
        "boiling_point": 3737,
        "classifications": {
            "cas_number": "CAS7439-91-0",
            "cid_number": "CID23926",
            "dot_numbers": 3178,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 13,
            "electric": 1.6
        },
        "cpk_hex": "70d4ff",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 6146,
            "liquid": 5940
        },
        "discovered": {
            "year": 1839,
            "by": "Carl Gustaf Mosander",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 53,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 5d¹",
        "electron_configuration_semantic": "[Xe] 5d¹⁶s²",
        "electronegativity_pauling": 1.1,
        "electrons_per_shell": [
            2,
            8,
            18,
            18,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 18, 9, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 491,
            "brinell": 363,
            "mohs": 2.5
        },
        "heat": {
            "specific": 195,
            "vaporization": 400,
            "fusion": 6.2,
            "molar": 27.11
        },
        "ionization_energies": [
            538.1,
            1067,
            1850.3,
            4819,
            5940
        ],
        "isotopes_known": "¹¹⁷La, ¹¹⁸La, ¹¹⁹La, ¹²⁰La, ¹²¹La, ¹²²La, ¹²³La, ¹²⁴La, ¹²⁵La, ¹²⁶La, ¹²⁷La, ¹²⁸La, ¹²⁹La, ¹³⁰La, ¹³¹La, ¹³²La, ¹³³La, ¹³⁴La, ¹³⁵La, ¹³⁶La, ¹³⁷La, ¹³⁸La, ¹³⁹La, ¹⁴⁰La, ¹⁴¹La, ¹⁴²La, ¹⁴³La, ¹⁴⁴La, ¹⁴⁵La, ¹⁴⁶La, ¹⁴⁷La, ¹⁴⁸La, ¹⁴⁹La, ¹⁵⁰La, ¹⁵¹La, ¹⁵²La, ¹⁵³La, ¹⁵⁴La, ¹⁵⁵La",
        "isotopes_stable": "¹³⁹La",
        "isotopic_abundances": "¹³⁸La: 0.09%, ¹³⁹La: 99.91%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "377.2, 377.2, 1214.4",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.1e-8,
            "molar": 1.528e-9,
            "volume": 0.00006761
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1193,
        "modulus": {
            "bulk": 28,
            "shear": 14,
            "young": 37
        },
        "molar_volume": 0.000022601,
        "neutron_cross_section": 8.98,
        "neutron_mass_absorption": 0.0023,
        "oxidation_states": "2,3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.28,
        "quantum_numbers": "2D3/2",
        "radius": {
            "empirical": 195,
            "covalent": 169
        },
        "resistivity": 6.1e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Lanthanum",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2475,
        "summary": "<p>Lanthanum is a chemical element with the symbol La and atomic number 57. It is a soft, ductile, silvery-white metal that tarnishes slowly when exposed to air. It is the eponym of the lanthanide series, a group of 15 similar elements between lanthanum and lutetium in the periodic table, of which lanthanum is the first and the prototype. Lanthanum is traditionally counted among the rare earth elements. The usual oxidation state is +3. Lanthanum has no biological role in humans but is essential to some bacteria. It is not particularly toxic to humans but does show some antimicrobial activity.</p><p>Lanthanum usually occurs together with cerium and the other rare earth elements. Lanthanum was first found by the Swedish chemist Carl Gustaf Mosander in 1839 as an impurity in cerium nitrate – hence the name lanthanum, from the Ancient Greek λανθάνειν (lanthanein), meaning \"to lie hidden\". Although it is classified as a rare earth element, lanthanum is the 28th most abundant element in the Earth's crust, almost three times as abundant as lead. In minerals such as monazite and bastnäsite, lanthanum composes about a quarter of the lanthanide content. It is extracted from those minerals by a process of such complexity that pure lanthanum metal was not isolated until 1923.</p><p>Lanthanum compounds have numerous applications as catalysts, additives in glass, carbon arc lamps for studio lights and projectors, ignition elements in lighters and torches, electron cathodes, scintillators, gas tungsten arc welding electrodes, and other things. Lanthanum carbonate is used as a phosphate binder in cases of high levels of phosphate in the blood seen with kidney failure.</p>",
        "superconducting_point": 4.88,
        "thermal_expansion": 0.0000121,
        "valence_electrons": 3
    },
    {
        "name": "Cerium",
        "symbol": "Ce",
        "abundance": {
            "universe": 0.000001,
            "solar": 4e-7,
            "meteor": 0.000075,
            "crust": 0.006,
            "ocean": 1.2e-10
        },
        "appearance": "silvery white",
        "atomic_mass": 140.1161,
        "atomic_number": 58,
        "block": "f-block",
        "boiling_point": 3716,
        "classifications": {
            "cas_number": "CAS7440-45-1",
            "cid_number": "CID23974",
            "dot_numbers": 1333,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 11,
            "electric": 1.4
        },
        "cpk_hex": "ffffc7",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 6689,
            "liquid": 6550
        },
        "discovered": {
            "year": 1803,
            "by": "Martin Heinrich Klaproth",
            "location": "Germany and Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 55,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 5d¹ 4f¹",
        "electron_configuration_semantic": "[Xe] 4f¹ 5d¹ 6s²",
        "electronegativity_pauling": 1.12,
        "electrons_per_shell": [
            2,
            8,
            18,
            19,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 19, 9, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 270,
            "brinell": 412,
            "mohs": 2.5
        },
        "heat": {
            "specific": 192,
            "vaporization": 350,
            "fusion": 5.5,
            "molar": 26.94
        },
        "ionization_energies": [
            534.4,
            1050,
            1949,
            3547,
            6325,
            7490
        ],
        "isotopes_known": "¹¹⁹Ce, ¹²⁰Ce, ¹²¹Ce, ¹²²Ce, ¹²³Ce, ¹²⁴Ce, ¹²⁵Ce, ¹²⁶Ce, ¹²⁷Ce, ¹²⁸Ce, ¹²⁹Ce, ¹³⁰Ce, ¹³¹Ce, ¹³²Ce, ¹³³Ce, ¹³⁴Ce, ¹³⁵Ce, ¹³⁶Ce, ¹³⁷Ce, ¹³⁸Ce, ¹³⁹Ce, ¹⁴⁰Ce, ¹⁴¹Ce, ¹⁴²Ce, ¹⁴³Ce, ¹⁴⁴Ce, ¹⁴⁵Ce, ¹⁴⁶Ce, ¹⁴⁷Ce, ¹⁴⁸Ce, ¹⁴⁹Ce, ¹⁵⁰Ce, ¹⁵¹Ce, ¹⁵²Ce, ¹⁵³Ce, ¹⁵⁴Ce, ¹⁵⁵Ce, ¹⁵⁶Ce, ¹⁵⁷Ce",
        "isotopes_stable": "¹³⁶Ce, ¹³⁸Ce, ¹⁴⁰Ce, ¹⁴²Ce",
        "isotopic_abundances": "¹³⁶Ce: 0.185%, ¹³⁸Ce: 0.251%, ¹⁴⁰Ce: 88.45%, ¹⁴²Ce: 11.114%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "362, 362, 599",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 2.2e-7,
            "molar": 3.0826e-8,
            "volume": 0.0014716
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1068,
        "modulus": {
            "bulk": 22,
            "shear": 14,
            "young": 34
        },
        "molar_volume": 0.000020947,
        "neel_point": 12.5,
        "neutron_cross_section": 0.6,
        "neutron_mass_absorption": 0.00021,
        "oxidation_states": "2,3c,4c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.24,
        "quantum_numbers": "1G4",
        "radius": {
            "empirical": 185
        },
        "resistivity": 7.5e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Cerium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2100,
        "summary": "<p>Cerium is a chemical element with the symbol Ce and atomic number 58. Cerium is a soft, ductile, and silvery-white metal that tarnishes when exposed to air, and it is soft enough to be cut with a steel kitchen knife. Cerium is the second element in the lanthanide series, and while it often shows the +3 oxidation state characteristic of the series, it also has a stable +4 state that does not oxidize water. It is also considered one of the rare-earth elements. Cerium has no biological role in humans and is not very toxic.</p><p>Despite always occurring in combination with the other rare-earth elements in minerals such as those of the monazite and bastnäsite groups, cerium is easy to extract from its ores, as it can be distinguished among the lanthanides by its unique ability to be oxidized to the +4 state. It is the most common of the lanthanides, followed by neodymium, lanthanum, and praseodymium. It is the 26th-most abundant element, making up 66 ppm of the Earth's crust, half as much as chlorine and five times as much as lead.</p><p>Cerium was the first of the lanthanides to be discovered, in Bastnäs, Sweden, by Jöns Jakob Berzelius and Wilhelm Hisinger in 1803, and independently by Martin Heinrich Klaproth in Germany in the same year. In 1839 Carl Gustaf Mosander became the first to isolate the metal. Today, cerium and its compounds have a variety of uses: for example, cerium(IV) oxide is used to polish glass and is an important part of catalytic converters. Cerium metal is used in ferrocerium lighters for its pyrophoric properties. Cerium-doped YAG phosphor is used in conjunction with blue light-emitting diodes to produce white light in most commercial white LED light sources.</p>",
        "superconducting_point": 0.022,
        "thermal_expansion": 0.0000063,
        "valence_electrons": 4
    },
    {
        "name": "Praseodymium",
        "symbol": "Pr",
        "abundance": {
            "universe": 2e-7,
            "solar": 1e-7,
            "meteor": 0.0000098,
            "crust": 0.00086,
            "ocean": 6e-11
        },
        "appearance": "grayish white",
        "atomic_mass": 140.907662,
        "atomic_number": 59,
        "block": "f-block",
        "boiling_point": 3403,
        "classifications": {
            "cas_number": "CAS7440-10-0",
            "cid_number": "CID23942"
        },
        "conductivity": {
            "thermal": 13,
            "electric": 1.4
        },
        "cpk_hex": "d9ffc7",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 6640,
            "liquid": 6500
        },
        "discovered": {
            "year": 1885,
            "by": "Carl Auer von Welsbach",
            "location": "Austria"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 93,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f³",
        "electron_configuration_semantic": "[Xe] 4f³ 6s²",
        "electronegativity_pauling": 1.13,
        "electrons_per_shell": [
            2,
            8,
            18,
            21,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 21, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 400,
            "brinell": 481
        },
        "heat": {
            "specific": 193,
            "vaporization": 330,
            "fusion": 6.9,
            "molar": 27.2
        },
        "ionization_energies": [
            527,
            1020,
            2086,
            3761,
            5551
        ],
        "isotopes_known": "¹²¹Pr, ¹²²Pr, ¹²³Pr, ¹²⁴Pr, ¹²⁵Pr, ¹²⁶Pr, ¹²⁷Pr, ¹²⁸Pr, ¹²⁹Pr, ¹³⁰Pr, ¹³¹Pr, ¹³²Pr, ¹³³Pr, ¹³⁴Pr, ¹³⁵Pr, ¹³⁶Pr, ¹³⁷Pr, ¹³⁸Pr, ¹³⁹Pr, ¹⁴⁰Pr, ¹⁴¹Pr, ¹⁴²Pr, ¹⁴³Pr, ¹⁴⁴Pr, ¹⁴⁵Pr, ¹⁴⁶Pr, ¹⁴⁷Pr, ¹⁴⁸Pr, ¹⁴⁹Pr, ¹⁵⁰Pr, ¹⁵¹Pr, ¹⁵²Pr, ¹⁵³Pr, ¹⁵⁴Pr, ¹⁵⁵Pr, ¹⁵⁶Pr, ¹⁵⁷Pr, ¹⁵⁸Pr, ¹⁵⁹Pr",
        "isotopes_stable": "¹⁴¹Pr",
        "isotopic_abundances": "¹⁴¹Pr: 100%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "367.25, 367.25, 1183.54",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 4.23e-7,
            "molar": 5.9604e-8,
            "volume": 0.0028087
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1208,
        "modulus": {
            "bulk": 29,
            "shear": 15,
            "young": 37
        },
        "molar_volume": 0.000021221,
        "neutron_cross_section": 11.4,
        "neutron_mass_absorption": 0.0029,
        "oxidation_states": "2,3c,4",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.28,
        "quantum_numbers": "4I9/2",
        "radius": {
            "calculated": 247,
            "empirical": 185
        },
        "resistivity": 7e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Praseodymium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2280,
        "summary": "<p>Praseodymium is a chemical element with the symbol Pr and atomic number 59. It is the third member of the lanthanide series and is traditionally considered to be one of the rare-earth metals. Praseodymium is a soft, silvery, malleable and ductile metal, valued for its magnetic, electrical, chemical, and optical properties. It is too reactive to be found in native form, and pure praseodymium metal slowly develops a green oxide coating when exposed to air.</p><p>Praseodymium always occurs naturally together with the other rare-earth metals. It is the fourth most common rare-earth element, making up 9.1 parts per million of the Earth's crust, an abundance similar to that of boron. In 1841, Swedish chemist Carl Gustav Mosander extracted a rare-earth oxide residue he called didymium from a residue he called \"lanthana\", in turn separated from cerium salts. In 1885, the Austrian chemist Baron Carl Auer von Welsbach separated didymium into two elements that gave salts of different colours, which he named praseodymium and neodymium. The name praseodymium comes from the Greek prasinos (πράσινος), meaning \"green\", and didymos (δίδυμος), \"twin\".</p><p>Like most rare-earth elements, praseodymium most readily forms the +3 oxidation state, which is the only stable state in aqueous solution, although the +4 oxidation state is known in some solid compounds and, uniquely among the lanthanides, the +5 oxidation state is attainable in matrix-isolation conditions. Aqueous praseodymium ions are yellowish-green, and similarly praseodymium results in various shades of yellow-green when incorporated into glasses. Many of praseodymium's industrial uses involve its ability to filter yellow light from light sources.</p>",
        "thermal_expansion": 0.0000067,
        "valence_electrons": 4
    },
    {
        "name": "Neodymium",
        "symbol": "Nd",
        "abundance": {
            "universe": 0.000001,
            "solar": 3e-7,
            "meteor": 0.00005,
            "crust": 0.0033,
            "ocean": 2.8e-10
        },
        "appearance": "silvery white",
        "atomic_mass": 144.2423,
        "atomic_number": 60,
        "block": "f-block",
        "boiling_point": 3347,
        "classifications": {
            "cas_number": "CAS7440-00-8",
            "cid_number": "CID23934",
            "rtecs_number": "RTECSQO8575000"
        },
        "conductivity": {
            "thermal": 17,
            "electric": 1.6
        },
        "cpk_hex": "c7ffc7",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 7010,
            "liquid": 6890
        },
        "discovered": {
            "year": 1885,
            "by": "Carl Auer von Welsbach",
            "location": "Austria"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 184.87,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁴",
        "electron_configuration_semantic": "[Xe] 4f⁴ 6s²",
        "electronegativity_pauling": 1.14,
        "electrons_per_shell": [
            2,
            8,
            18,
            22,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 22, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 343,
            "brinell": 265
        },
        "heat": {
            "specific": 190,
            "vaporization": 285,
            "fusion": 7.1,
            "molar": 27.45
        },
        "ionization_energies": [
            533.1,
            1040,
            2130,
            3900
        ],
        "isotopes_known": "¹²⁴Nd, ¹²⁵Nd, ¹²⁶Nd, ¹²⁷Nd, ¹²⁸Nd, ¹²⁹Nd, ¹³⁰Nd, ¹³¹Nd, ¹³²Nd, ¹³³Nd, ¹³⁴Nd, ¹³⁵Nd, ¹³⁶Nd, ¹³⁷Nd, ¹³⁸Nd, ¹³⁹Nd, ¹⁴⁰Nd, ¹⁴¹Nd, ¹⁴²Nd, ¹⁴³Nd, ¹⁴⁴Nd, ¹⁴⁵Nd, ¹⁴⁶Nd, ¹⁴⁷Nd, ¹⁴⁸Nd, ¹⁴⁹Nd, ¹⁵⁰Nd, ¹⁵¹Nd, ¹⁵²Nd, ¹⁵³Nd, ¹⁵⁴Nd, ¹⁵⁵Nd, ¹⁵⁶Nd, ¹⁵⁷Nd, ¹⁵⁸Nd, ¹⁵⁹Nd, ¹⁶⁰Nd, ¹⁶¹Nd",
        "isotopes_stable": "¹⁴²Nd, ¹⁴³Nd, ¹⁴⁵Nd, ¹⁴⁶Nd, ¹⁴⁸Nd",
        "isotopic_abundances": "¹⁴²Nd: 27.2%, ¹⁴³Nd: 12.2%, ¹⁴⁴Nd: 23.8%, ¹⁴⁵Nd: 8.3%, ¹⁴⁶Nd: 17.2%, ¹⁴⁸Nd: 5.7%, ¹⁵⁰Nd: 5.6%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "365.8, 365.8, 1179.9",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 4.8e-7,
            "molar": 6.9235e-8,
            "volume": 0.0033648
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1297,
        "modulus": {
            "bulk": 32,
            "shear": 16,
            "young": 41
        },
        "molar_volume": 0.000020577,
        "neel_point": 19.2,
        "neutron_cross_section": 49,
        "neutron_mass_absorption": 0.011,
        "oxidation_states": "2,3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.28,
        "quantum_numbers": "5I4",
        "radius": {
            "calculated": 206,
            "empirical": 185
        },
        "resistivity": 6.4e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Neodymium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2330,
        "summary": "<p>Neodymium is a chemical element with the symbol Nd and atomic number 60. Neodymium belongs to the lanthanide series and is a rare-earth element. It is a hard, slightly malleable silvery metal that quickly tarnishes in air and moisture. When oxidized, neodymium reacts quickly to produce pink, purple/blue and yellow compounds in the +2, +3 and +4 oxidation states. Neodymium was discovered in 1885 by the Austrian chemist Carl Auer von Welsbach. It is present in significant quantities in the ore minerals monazite and bastnäsite. Neodymium is not found naturally in metallic form or unmixed with other lanthanides, and it is usually refined for general use. Although neodymium is classed as a rare-earth element, it is fairly common, no rarer than cobalt, nickel, or copper, and is widely distributed in the Earth's crust. Most of the world's commercial neodymium is mined in China.</p><p>Neodymium compounds were first commercially used as glass dyes in 1927, and they remain a popular additive in glasses. The color of neodymium compounds is due to the Nd3+ ion and is often a reddish-purple, but it changes with the type of lighting, because of the interaction of the sharp light absorption bands of neodymium with ambient light enriched with the sharp visible emission bands of mercury, trivalent europium or terbium. Some neodymium-doped glasses are used in lasers that emit infrared with wavelengths between 1047 and 1062 nanometers. These have been used in extremely-high-power applications, such as experiments in inertial confinement fusion. Neodymium is also used with various other substrate crystals, such as yttrium aluminium garnet in the Nd:YAG laser.</p><p>Another important use of neodymium is as a component in the alloys used to make high-strength neodymium magnets—powerful permanent magnets. These magnets are widely used in such products as microphones, professional loudspeakers, in-ear headphones, high performance hobby DC electric motors, and computer hard disks, where low magnet mass (or volume) or strong magnetic fields are required. Larger neodymium magnets are used in high-power-versus-weight electric motors (for example in hybrid cars) and generators (for example aircraft and wind turbine electric generators).</p>",
        "thermal_expansion": 0.0000096,
        "valence_electrons": 3
    },
    {
        "name": "Promethium",
        "symbol": "Pm",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "metallic",
        "atomic_mass": 145,
        "atomic_number": 61,
        "block": "f-block",
        "boiling_point": 3273,
        "classifications": {
            "cas_number": "CAS7440-12-2"
        },
        "conductivity": {
            "thermal": 15,
            "electric": 1.3
        },
        "cpk_hex": "a3ffc7",
        "decay_mode": "ElectronCapture",
        "density": {
            "stp": 7264
        },
        "discovered": {
            "year": 1945,
            "by": "Chien Shiung Wu",
            "location": "The United States"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 12.45,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁵",
        "electron_configuration_semantic": "[Xe] 4f⁵ 6s²",
        "electronegativity_pauling": 1.13,
        "electrons_per_shell": [
            2,
            8,
            18,
            23,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 23, 8, 2",
        "group": 3,
        "half_life": 17.72577371892,
        "heat": {
            "vaporization": 290,
            "fusion": 7.7
        },
        "ionization_energies": [
            540,
            1050,
            2150,
            3970
        ],
        "isotopes_known": "¹²⁶Pm, ¹²⁷Pm, ¹²⁸Pm, ¹²⁹Pm, ¹³⁰Pm, ¹³¹Pm, ¹³²Pm, ¹³³Pm, ¹³⁴Pm, ¹³⁵Pm, ¹³⁶Pm, ¹³⁷Pm, ¹³⁸Pm, ¹³⁹Pm, ¹⁴⁰Pm, ¹⁴¹Pm, ¹⁴²Pm, ¹⁴³Pm, ¹⁴⁴Pm, ¹⁴⁵Pm, ¹⁴⁶Pm, ¹⁴⁷Pm, ¹⁴⁸Pm, ¹⁴⁹Pm, ¹⁵⁰Pm, ¹⁵¹Pm, ¹⁵²Pm, ¹⁵³Pm, ¹⁵⁴Pm, ¹⁵⁵Pm, ¹⁵⁶Pm, ¹⁵⁷Pm, ¹⁵⁸Pm, ¹⁵⁹Pm, ¹⁶⁰Pm, ¹⁶¹Pm, ¹⁶²Pm, ¹⁶³Pm",
        "isotopes_stable": "None",
        "lifetime": 25.55809233891,
        "melting_point": 1315,
        "modulus": {
            "bulk": 33,
            "shear": 18,
            "young": 46
        },
        "molar_volume": 0.00001996145374449,
        "neutron_cross_section": 8400,
        "oxidation_states": "3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.28,
        "quantum_numbers": "6H5/2",
        "radius": {
            "calculated": 205,
            "empirical": 185
        },
        "resistivity": 7.5e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Promethium",
        "summary": "<p>Promethium is a chemical element with the symbol Pm and atomic number 61. All of its isotopes are radioactive; it is extremely rare, with only about 500–600 grams naturally occurring in Earth's crust at any given time. Promethium is one of only two radioactive elements that are followed in the periodic table by elements with stable forms, the other being technetium. Chemically, promethium is a lanthanide. Promethium shows only one stable oxidation state of +3.</p><p>In 1902 Bohuslav Brauner suggested that there was a then-unknown element with properties intermediate between those of the known elements neodymium (60) and samarium (62); this was confirmed in 1914 by Henry Moseley, who, having measured the atomic numbers of all the elements then known, found that atomic number 61 was missing. In 1926, two groups (one Italian and one American) claimed to have isolated a sample of element 61; both \"discoveries\" were soon proven to be false. In 1938, during a nuclear experiment conducted at The Ohio State University, a few radioactive nuclides were produced that certainly were not radioisotopes of neodymium or samarium, but there was a lack of chemical proof that element 61 was produced, and the discovery was not generally recognized. Promethium was first produced and characterized at Oak Ridge National Laboratory in 1945 by the separation and analysis of the fission products of uranium fuel irradiated in a graphite reactor. The discoverers proposed the name \"prometheum\" (the spelling was subsequently changed), derived from Prometheus, the Titan in Greek mythology who stole fire from Mount Olympus and brought it down to humans, to symbolize \"both the daring and the possible misuse of mankind's intellect\". However, a sample of the metal was made only in 1963.</p><p>There are two possible sources for natural promethium: rare decays of natural europium-151 (producing promethium-147) and uranium (various isotopes). Practical applications exist only for chemical compounds of promethium-147, which are used in luminous paint, atomic batteries and thickness-measurement devices, even though promethium-145 is the most stable promethium isotope. Because natural promethium is exceedingly scarce, it is typically synthesized by bombarding uranium-235 (enriched uranium) with thermal neutrons to produce promethium-147 as a fission product.</p>",
        "thermal_expansion": 0.000011,
        "valence_electrons": 3
    },
    {
        "name": "Samarium",
        "symbol": "Sm",
        "abundance": {
            "universe": 5e-7,
            "solar": 1e-7,
            "meteor": 0.000017,
            "crust": 0.0006,
            "ocean": 4.5e-11
        },
        "appearance": "silvery white",
        "atomic_mass": 150.362,
        "atomic_number": 62,
        "block": "f-block",
        "boiling_point": 2173,
        "classifications": {
            "cas_number": "CAS7440-19-9",
            "cid_number": "CID23951",
            "dot_numbers": 1325,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 13,
            "electric": 1.1
        },
        "cpk_hex": "8fffc7",
        "crystal_structure": "Simple Trigonal",
        "density": {
            "stp": 7353,
            "liquid": 7160
        },
        "discovered": {
            "year": 1879,
            "by": "Lecoq de Boisbaudran",
            "location": "France"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 15.63,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁶",
        "electron_configuration_semantic": "[Xe] 4f⁶ 6s²",
        "electronegativity_pauling": 1.17,
        "electrons_per_shell": [
            2,
            8,
            18,
            24,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 24, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 412,
            "brinell": 441
        },
        "heat": {
            "specific": 196,
            "vaporization": 175,
            "fusion": 8.6,
            "molar": 29.54
        },
        "ionization_energies": [
            544.5,
            1070,
            2260,
            3990
        ],
        "isotopes_known": "¹²⁸Sm, ¹²⁹Sm, ¹³⁰Sm, ¹³¹Sm, ¹³²Sm, ¹³³Sm, ¹³⁴Sm, ¹³⁵Sm, ¹³⁶Sm, ¹³⁷Sm, ¹³⁸Sm, ¹³⁹Sm, ¹⁴⁰Sm, ¹⁴¹Sm, ¹⁴²Sm, ¹⁴³Sm, ¹⁴⁴Sm, ¹⁴⁵Sm, ¹⁴⁶Sm, ¹⁴⁷Sm, ¹⁴⁸Sm, ¹⁴⁹Sm, ¹⁵⁰Sm, ¹⁵¹Sm, ¹⁵²Sm, ¹⁵³Sm, ¹⁵⁴Sm, ¹⁵⁵Sm, ¹⁵⁶Sm, ¹⁵⁷Sm, ¹⁵⁸Sm, ¹⁵⁹Sm, ¹⁶⁰Sm, ¹⁶¹Sm, ¹⁶²Sm, ¹⁶³Sm, ¹⁶⁴Sm, ¹⁶⁵Sm",
        "isotopes_stable": "¹⁴⁴Sm, ¹⁴⁹Sm, ¹⁵⁰Sm, ¹⁵²Sm, ¹⁵⁴Sm",
        "isotopic_abundances": "¹⁴⁴Sm: 3.07%, ¹⁴⁷Sm: 14.99%, ¹⁴⁸Sm: 11.24%, ¹⁴⁹Sm: 13.82%, ¹⁵⁰Sm: 7.38%, ¹⁵²Sm: 26.75%, ¹⁵⁴Sm: 22.75%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "362.1, 362.1, 2625",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.11e-7,
            "molar": 1.669e-8,
            "volume": 0.00081618
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1345,
        "modulus": {
            "bulk": 38,
            "shear": 20,
            "young": 50
        },
        "molar_volume": 0.000020449,
        "neel_point": 106,
        "neutron_cross_section": 5900,
        "neutron_mass_absorption": 4.7,
        "oxidation_states": "2,3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.27,
        "quantum_numbers": "7F0",
        "radius": {
            "calculated": 238,
            "empirical": 185
        },
        "resistivity": 9.4e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Samarium",
        "space_group_name": "R_3m",
        "space_group_number": 166,
        "speed_of_sound": 2130,
        "summary": "<p>Samarium is a chemical element with the symbol Sm and atomic number 62. It is a moderately hard silvery metal that slowly oxidizes in air. Being a typical member of the lanthanide series, samarium usually assumes the oxidation state +3. Compounds of samarium(II) are also known, most notably the monoxide SmO, monochalcogenides SmS, SmSe and SmTe, as well as samarium(II) iodide. The last compound is a common reducing agent in chemical synthesis. Samarium has no significant biological role but is only slightly toxic.</p><p>Samarium was discovered in 1879 by the French chemist Paul-Émile Lecoq de Boisbaudran and named after the mineral samarskite from which it was isolated. The mineral itself was earlier named after a Russian mine official, Colonel Vassili Samarsky-Bykhovets, who thereby became the first person to have a chemical element named after him, albeit indirectly. Although classified as a rare-earth element, samarium is the 40th most abundant element in the Earth's crust and is more common than metals such as tin. Samarium occurs with concentration up to 2.8% in several minerals including cerite, gadolinite, samarskite, monazite and bastnäsite, the last two being the most common commercial sources of the element. These minerals are mostly found in China, the United States, Brazil, India, Sri Lanka and Australia; China is by far the world leader in samarium mining and production.</p><p>The major commercial application of samarium is in samarium–cobalt magnets, which have permanent magnetization second only to neodymium magnets; however, samarium compounds can withstand significantly higher temperatures, above 700 °C (1,292 °F), without losing their magnetic properties, due to the alloy's higher Curie point. The radioactive isotope samarium-153 is the active component of the drug samarium (153Sm) lexidronam (Quadramet), which kills cancer cells in the treatment of lung cancer, prostate cancer, breast cancer and osteosarcoma. Another isotope, samarium-149, is a strong neutron absorber and is therefore added to the control rods of nuclear reactors. It is also formed as a decay product during the reactor operation and is one of the important factors considered in the reactor design and operation. Other applications of samarium include catalysis of chemical reactions, radioactive dating and X-ray lasers.</p>",
        "thermal_expansion": 0.0000127,
        "valence_electrons": 3
    },
    {
        "name": "Europium",
        "symbol": "Eu",
        "abundance": {
            "universe": 5e-8,
            "solar": 5e-8,
            "meteor": 0.0000059,
            "crust": 0.00018,
            "ocean": 1.3e-11
        },
        "atomic_mass": 151.9641,
        "atomic_number": 63,
        "block": "f-block",
        "boiling_point": 1802,
        "classifications": {
            "cas_number": "CAS7440-53-1",
            "cid_number": "CID23981"
        },
        "conductivity": {
            "thermal": 14,
            "electric": 1.1
        },
        "cpk_hex": "61ffc7",
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 5244,
            "liquid": 5130
        },
        "discovered": {
            "year": 1901,
            "by": "Eugène-Anatole Demarçay",
            "location": "France"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 11.2,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁷",
        "electron_configuration_semantic": "[Xe] 4f⁷ 6s²",
        "electronegativity_pauling": 1.2,
        "electrons_per_shell": [
            2,
            8,
            18,
            25,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 25, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 167
        },
        "heat": {
            "specific": 182,
            "vaporization": 175,
            "fusion": 9.2,
            "molar": 27.66
        },
        "ionization_energies": [
            547.1,
            1085,
            2404,
            4120
        ],
        "isotopes_known": "¹³⁰Eu, ¹³¹Eu, ¹³²Eu, ¹³³Eu, ¹³⁴Eu, ¹³⁵Eu, ¹³⁶Eu, ¹³⁷Eu, ¹³⁸Eu, ¹³⁹Eu, ¹⁴⁰Eu, ¹⁴¹Eu, ¹⁴²Eu, ¹⁴³Eu, ¹⁴⁴Eu, ¹⁴⁵Eu, ¹⁴⁶Eu, ¹⁴⁷Eu, ¹⁴⁸Eu, ¹⁴⁹Eu, ¹⁵⁰Eu, ¹⁵¹Eu, ¹⁵²Eu, ¹⁵³Eu, ¹⁵⁴Eu, ¹⁵⁵Eu, ¹⁵⁶Eu, ¹⁵⁷Eu, ¹⁵⁸Eu, ¹⁵⁹Eu, ¹⁶⁰Eu, ¹⁶¹Eu, ¹⁶²Eu, ¹⁶³Eu, ¹⁶⁴Eu, ¹⁶⁵Eu, ¹⁶⁶Eu, ¹⁶⁷Eu",
        "isotopes_stable": "¹⁵¹Eu, ¹⁵³Eu",
        "isotopic_abundances": "¹⁵¹Eu: 47.81%, ¹⁵³Eu: 52.19%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "458.1, 458.1, 458.1",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 2.76e-7,
            "molar": 4.1942e-8,
            "volume": 0.0014473
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1099,
        "modulus": {
            "bulk": 8.3,
            "shear": 7.9,
            "young": 18
        },
        "molar_volume": 0.000028979,
        "neel_point": 90.5,
        "neutron_cross_section": 4570,
        "neutron_mass_absorption": 0.6,
        "oxidation_states": "2c,3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.15,
        "quantum_numbers": "8S7/2",
        "radius": {
            "calculated": 231,
            "empirical": 185
        },
        "resistivity": 9e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Europium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "summary": "<p>Europium is a chemical element with the symbol Eu and atomic number 63. Europium is the most reactive lanthanide by far, having to be stored under an inert fluid to protect it from atmospheric oxygen or moisture. Europium is also the softest lanthanide, as it can be dented with a fingernail and easily cut with a knife. When oxidation is removed a shiny-white metal is visible. Europium was isolated in 1901 and is named after the continent of Europe. Being a typical member of the lanthanide series, europium usually assumes the oxidation state +3, but the oxidation state +2 is also common. All europium compounds with oxidation state +2 are slightly reducing. Europium has no significant biological role and is relatively non-toxic compared to other heavy metals. Most applications of europium exploit the phosphorescence of europium compounds. Europium is one of the rarest of the rare-earth elements on Earth.</p>",
        "superconducting_point": 1.8,
        "thermal_expansion": 0.000035,
        "valence_electrons": 3
    },
    {
        "name": "Gadolinium",
        "symbol": "Gd",
        "abundance": {
            "universe": 2e-7,
            "solar": 2e-7,
            "meteor": 0.000023,
            "crust": 0.00052,
            "ocean": 7e-11
        },
        "appearance": "silvery white",
        "atomic_mass": 157.253,
        "atomic_number": 64,
        "block": "f-block",
        "boiling_point": 3273,
        "classifications": {
            "cas_number": "CAS7440-54-2",
            "cid_number": "CID23982",
            "rtecs_number": "RTECSLW3850000"
        },
        "conductivity": {
            "thermal": 11,
            "electric": 0.77
        },
        "cpk_hex": "45ffc7",
        "crystal_structure": "Simple Hexagonal",
        "curie_point": 292,
        "density": {
            "stp": 7901,
            "liquid": 7400
        },
        "discovered": {
            "year": 1880,
            "by": "Jean Charles Galissard de Marignac",
            "location": "Switzerland"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 13.22,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁷ 5d¹",
        "electron_configuration_semantic": "[Xe] 4f⁷ 5d¹ 6s²",
        "electronegativity_pauling": 1.2,
        "electrons_per_shell": [
            2,
            8,
            18,
            25,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 25, 9, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 570
        },
        "heat": {
            "specific": 240,
            "vaporization": 305,
            "fusion": 10,
            "molar": 37.03
        },
        "ionization_energies": [
            593.4,
            1170,
            1990,
            4250
        ],
        "isotopes_known": "¹³⁴Gd, ¹³⁵Gd, ¹³⁶Gd, ¹³⁷Gd, ¹³⁸Gd, ¹³⁹Gd, ¹⁴⁰Gd, ¹⁴¹Gd, ¹⁴²Gd, ¹⁴³Gd, ¹⁴⁴Gd, ¹⁴⁵Gd, ¹⁴⁶Gd, ¹⁴⁷Gd, ¹⁴⁸Gd, ¹⁴⁹Gd, ¹⁵⁰Gd, ¹⁵¹Gd, ¹⁵²Gd, ¹⁵³Gd, ¹⁵⁴Gd, ¹⁵⁵Gd, ¹⁵⁶Gd, ¹⁵⁷Gd, ¹⁵⁸Gd, ¹⁵⁹Gd, ¹⁶⁰Gd, ¹⁶¹Gd, ¹⁶²Gd, ¹⁶³Gd, ¹⁶⁴Gd, ¹⁶⁵Gd, ¹⁶⁶Gd, ¹⁶⁷Gd, ¹⁶⁸Gd, ¹⁶⁹Gd",
        "isotopes_stable": "¹⁵⁴Gd, ¹⁵⁵Gd, ¹⁵⁶Gd, ¹⁵⁷Gd, ¹⁵⁸Gd, ¹⁶⁰Gd",
        "isotopic_abundances": "¹⁵²Gd: 0.2%, ¹⁵⁴Gd: 2.18%, ¹⁵⁵Gd: 14.8%, ¹⁵⁶Gd: 20.47%, ¹⁵⁷Gd: 15.65%, ¹⁵⁸Gd: 24.84%, ¹⁶⁰Gd: 21.86%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "363.6, 363.6, 578.26",
        "lifetime": "Stable",
        "magnetic_type": "ferromagnetic",
        "melting_point": 1585,
        "modulus": {
            "bulk": 38,
            "shear": 22,
            "young": 55
        },
        "molar_volume": 0.000019903,
        "neutron_cross_section": 49000,
        "neutron_mass_absorption": 7.3,
        "oxidation_states": "1,2,3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.26,
        "quantum_numbers": "9D2",
        "radius": {
            "calculated": 233,
            "empirical": 180
        },
        "resistivity": 0.0000013,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Gadolinium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2680,
        "summary": "<p>Gadolinium is a chemical element with the symbol Gd and atomic number 64. Gadolinium is a silvery-white metal when oxidation is removed. It is only slightly malleable and is a ductile rare-earth element. Gadolinium reacts with atmospheric oxygen or moisture slowly to form a black coating. Gadolinium below its Curie point of 20 °C (68 °F) is ferromagnetic, with an attraction to a magnetic field higher than that of nickel. Above this temperature it is the most paramagnetic element. It is found in nature only in an oxidized form. When separated, it usually has impurities of the other rare-earths because of their similar chemical properties.</p><p>Gadolinium was discovered in 1880 by Jean Charles de Marignac, who detected its oxide by using spectroscopy. It is named after the mineral gadolinite, one of the minerals in which gadolinium is found, itself named for the Finnish chemist Johan Gadolin. Pure gadolinium was first isolated by the chemist Paul Emile Lecoq de Boisbaudran around 1886.</p><p>Gadolinium possesses unusual metallurgical properties, to the extent that as little as 1% of gadolinium can significantly improve the workability and resistance to oxidation at high temperatures of iron, chromium, and related metals. Gadolinium as a metal or a salt absorbs neutrons and is, therefore, used sometimes for shielding in neutron radiography and in nuclear reactors.</p><p>Like most of the rare earths, gadolinium forms trivalent ions with fluorescent properties, and salts of gadolinium(III) are used as phosphors in various applications.</p><p>Gadolinium(III) ions in water-soluble salts are highly toxic to mammals. However, chelated gadolinium(III) compounds prevent the gadolinium(III) from being exposed to the organism and the majority is excreted by sane kidneys before it can deposit in tissues. Because of its paramagnetic properties, solutions of chelated organic gadolinium complexes are used as intravenously administered gadolinium-based MRI contrast agents in medical magnetic resonance imaging. Varying amounts deposit in tissues of the brain, cardiac muscle, kidney, other organs and the skin, mainly depending on kidney function, structure of the chelates (linear or macrocyclic) and the dose administered.</p>",
        "thermal_expansion": 0.0000094,
        "valence_electrons": 3
    },
    {
        "name": "Terbium",
        "symbol": "Tb",
        "abundance": {
            "universe": 5e-8,
            "solar": 1e-8,
            "meteor": 0.0000039,
            "crust": 0.000093,
            "ocean": 1.4e-11
        },
        "appearance": "silvery white",
        "atomic_mass": 158.925352,
        "atomic_number": 65,
        "block": "f-block",
        "boiling_point": 3396,
        "classifications": {
            "cas_number": "CAS7440-27-9",
            "cid_number": "CID23958"
        },
        "conductivity": {
            "thermal": 11,
            "electric": 0.83
        },
        "cpk_hex": "30ffc7",
        "crystal_structure": "Simple Hexagonal",
        "curie_point": 222,
        "density": {
            "stp": 8219,
            "liquid": 7650
        },
        "discovered": {
            "year": 1843,
            "by": "Carl Gustaf Mosander",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 112.4,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f⁹",
        "electron_configuration_semantic": "[Xe] 4f⁹ 6s²",
        "electronegativity_pauling": 1.1,
        "electrons_per_shell": [
            2,
            8,
            18,
            27,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 27, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 863,
            "brinell": 677
        },
        "heat": {
            "specific": 182,
            "vaporization": 295,
            "fusion": 10.8,
            "molar": 28.91
        },
        "ionization_energies": [
            565.8,
            1110,
            2114,
            3839
        ],
        "isotopes_known": "¹³⁶Tb, ¹³⁷Tb, ¹³⁸Tb, ¹³⁹Tb, ¹⁴⁰Tb, ¹⁴¹Tb, ¹⁴²Tb, ¹⁴³Tb, ¹⁴⁴Tb, ¹⁴⁵Tb, ¹⁴⁶Tb, ¹⁴⁷Tb, ¹⁴⁸Tb, ¹⁴⁹Tb, ¹⁵⁰Tb, ¹⁵¹Tb, ¹⁵²Tb, ¹⁵³Tb, ¹⁵⁴Tb, ¹⁵⁵Tb, ¹⁵⁶Tb, ¹⁵⁷Tb, ¹⁵⁸Tb, ¹⁵⁹Tb, ¹⁶⁰Tb, ¹⁶¹Tb, ¹⁶²Tb, ¹⁶³Tb, ¹⁶⁴Tb, ¹⁶⁵Tb, ¹⁶⁶Tb, ¹⁶⁷Tb, ¹⁶⁸Tb, ¹⁶⁹Tb, ¹⁷⁰Tb, ¹⁷¹Tb",
        "isotopes_stable": "¹⁵⁹Tb",
        "isotopic_abundances": "¹⁵⁹Tb: 100%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "360.1, 360.1, 569.36",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 0.0000136,
            "molar": 0.000002161385,
            "volume": 0.1117784
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1629,
        "modulus": {
            "bulk": 38.7,
            "shear": 22,
            "young": 56
        },
        "molar_volume": 0.000019336,
        "neel_point": 230,
        "neutron_cross_section": 23,
        "neutron_mass_absorption": 0.009,
        "oxidation_states": "1,3c,4",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.26,
        "quantum_numbers": "6H15/2",
        "radius": {
            "calculated": 225,
            "empirical": 175
        },
        "resistivity": 0.0000012,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Terbium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2620,
        "summary": "<p>Terbium is a chemical element with the symbol Tb and atomic number 65. It is a silvery-white, rare earth metal that is malleable, ductile, and soft enough to be cut with a knife. The ninth member of the lanthanide series, terbium is a fairly electropositive metal that reacts with water, evolving hydrogen gas. Terbium is never found in nature as a free element, but it is contained in many minerals, including cerite, gadolinite, monazite, xenotime, and euxenite.</p><p>Swedish chemist Carl Gustaf Mosander discovered terbium as a chemical element in 1843. He detected it as an impurity in yttrium oxide, Y2O3. Yttrium and terbium, as well as erbium and ytterbium, are named after the village of Ytterby in Sweden. Terbium was not isolated in pure form until the advent of ion exchange techniques.</p><p>Terbium is used to dope calcium fluoride, calcium tungstate and strontium molybdate, materials that are used in solid-state devices, and as a crystal stabilizer of fuel cells which operate at elevated temperatures. As a component of Terfenol-D (an alloy that expands and contracts when exposed to magnetic fields more than any other alloy), terbium is of use in actuators, in naval sonar systems and in sensors.</p><p>Most of the world's terbium supply is used in green phosphors. Terbium oxide is in fluorescent lamps and television and monitor cathode ray tubes (CRTs). Terbium green phosphors are combined with divalent europium blue phosphors and trivalent europium red phosphors to provide trichromatic lighting technology, a high-efficiency white light used for standard illumination in indoor lighting.</p>",
        "thermal_expansion": 0.0000103,
        "valence_electrons": 3
    },
    {
        "name": "Dysprosium",
        "symbol": "Dy",
        "abundance": {
            "universe": 2e-7,
            "solar": 2e-7,
            "meteor": 0.000027,
            "crust": 0.00062,
            "ocean": 9.1e-11
        },
        "appearance": "silvery white",
        "atomic_mass": 162.5001,
        "atomic_number": 66,
        "block": "f-block",
        "boiling_point": 2840,
        "classifications": {
            "cas_number": "CAS7429-91-6",
            "cid_number": "CID23912"
        },
        "conductivity": {
            "thermal": 11,
            "electric": 1.1
        },
        "cpk_hex": "1fffc7",
        "crystal_structure": "Simple Hexagonal",
        "curie_point": 87,
        "density": {
            "stp": 8551,
            "liquid": 8370
        },
        "discovered": {
            "year": 1886,
            "by": "Lecoq de Boisbaudran",
            "location": "France"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 33.96,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁰",
        "electron_configuration_semantic": "[Xe] 4f¹⁰ 6s²",
        "electronegativity_pauling": 1.22,
        "electrons_per_shell": [
            2,
            8,
            18,
            28,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 28, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 540,
            "brinell": 500
        },
        "heat": {
            "specific": 167,
            "vaporization": 280,
            "fusion": 11.1,
            "molar": 27.7
        },
        "ionization_energies": [
            573,
            1130,
            2200,
            3990
        ],
        "isotopes_known": "¹³⁸Dy, ¹³⁹Dy, ¹⁴⁰Dy, ¹⁴¹Dy, ¹⁴²Dy, ¹⁴³Dy, ¹⁴⁴Dy, ¹⁴⁵Dy, ¹⁴⁶Dy, ¹⁴⁷Dy, ¹⁴⁸Dy, ¹⁴⁹Dy, ¹⁵⁰Dy, ¹⁵¹Dy, ¹⁵²Dy, ¹⁵³Dy, ¹⁵⁴Dy, ¹⁵⁵Dy, ¹⁵⁶Dy, ¹⁵⁷Dy, ¹⁵⁸Dy, ¹⁵⁹Dy, ¹⁶⁰Dy, ¹⁶¹Dy, ¹⁶²Dy, ¹⁶³Dy, ¹⁶⁴Dy, ¹⁶⁵Dy, ¹⁶⁶Dy, ¹⁶⁷Dy, ¹⁶⁸Dy, ¹⁶⁹Dy, ¹⁷⁰Dy, ¹⁷¹Dy, ¹⁷²Dy, ¹⁷³Dy",
        "isotopes_stable": "¹⁵⁶Dy, ¹⁵⁸Dy, ¹⁶⁰Dy, ¹⁶¹Dy, ¹⁶²Dy, ¹⁶³Dy, ¹⁶⁴Dy",
        "isotopic_abundances": "¹⁵⁶Dy: 0.06%, ¹⁵⁸Dy: 0.1%, ¹⁶⁰Dy: 2.34%, ¹⁶¹Dy: 18.91%, ¹⁶²Dy: 25.51%, ¹⁶³Dy: 24.9%, ¹⁶⁴Dy: 28.18%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "359.3, 359.3, 565.37",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 0.00000545,
            "molar": 8.85625e-7,
            "volume": 0.046603
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1680,
        "modulus": {
            "bulk": 41,
            "shear": 25,
            "young": 61
        },
        "molar_volume": 0.000019004,
        "neel_point": 178,
        "neutron_cross_section": 950,
        "neutron_mass_absorption": 0.2,
        "oxidation_states": "2,3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.25,
        "quantum_numbers": "5I8",
        "radius": {
            "calculated": 228,
            "empirical": 175
        },
        "resistivity": 9.1e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Dysprosium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2710,
        "summary": "<p>Dysprosium is the chemical element with the symbol Dy and atomic number 66. It is a rare-earth element with a metallic silver luster. Dysprosium is never found in nature as a free element, though it is found in various minerals, such as xenotime. Naturally occurring dysprosium is composed of seven isotopes, the most abundant of which is 164Dy.</p><p>Dysprosium was first identified in 1886 by Paul Émile Lecoq de Boisbaudran, but it was not isolated in pure form until the development of ion-exchange techniques in the 1950s. Dysprosium has relatively few applications where it cannot be replaced by other chemical elements. It is used for its high thermal neutron absorption cross-section in making control rods in nuclear reactors, for its high magnetic susceptibility (χv ≈ 5.44×10−3) in data-storage applications, and as a component of Terfenol-D (a magnetostrictive material). Soluble dysprosium salts are mildly toxic, while the insoluble salts are considered non-toxic.</p>",
        "thermal_expansion": 0.00001,
        "valence_electrons": 3
    },
    {
        "name": "Holmium",
        "symbol": "Ho",
        "abundance": {
            "universe": 5e-8,
            "solar": 0,
            "meteor": 0.0000059,
            "crust": 0.00012,
            "ocean": 2.2e-11
        },
        "appearance": "silvery white",
        "atomic_mass": 164.930332,
        "atomic_number": 67,
        "block": "f-block",
        "boiling_point": 2873,
        "classifications": {
            "cas_number": "CAS7440-60-0",
            "cid_number": "CID23988",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 16,
            "electric": 1.1
        },
        "cpk_hex": "00ff9c",
        "crystal_structure": "Simple Hexagonal",
        "curie_point": 20,
        "density": {
            "stp": 8795,
            "liquid": 8340
        },
        "discovered": {
            "year": 1878,
            "by": "Marc Delafontaine",
            "location": "Switzerland"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 32.61,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹¹",
        "electron_configuration_semantic": "[Xe] 4f¹¹ 6s²",
        "electronegativity_pauling": 1.23,
        "electrons_per_shell": [
            2,
            8,
            18,
            29,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 29, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 481,
            "brinell": 746
        },
        "heat": {
            "specific": 165,
            "vaporization": 265,
            "fusion": 17,
            "molar": 27.15
        },
        "ionization_energies": [
            581,
            1140,
            2204,
            4100
        ],
        "isotopes_known": "¹⁴⁰Ho, ¹⁴¹Ho, ¹⁴²Ho, ¹⁴³Ho, ¹⁴⁴Ho, ¹⁴⁵Ho, ¹⁴⁶Ho, ¹⁴⁷Ho, ¹⁴⁸Ho, ¹⁴⁹Ho, ¹⁵⁰Ho, ¹⁵¹Ho, ¹⁵²Ho, ¹⁵³Ho, ¹⁵⁴Ho, ¹⁵⁵Ho, ¹⁵⁶Ho, ¹⁵⁷Ho, ¹⁵⁸Ho, ¹⁵⁹Ho, ¹⁶⁰Ho, ¹⁶¹Ho, ¹⁶²Ho, ¹⁶³Ho, ¹⁶⁴Ho, ¹⁶⁵Ho, ¹⁶⁶Ho, ¹⁶⁷Ho, ¹⁶⁸Ho, ¹⁶⁹Ho, ¹⁷⁰Ho, ¹⁷¹Ho, ¹⁷²Ho, ¹⁷³Ho, ¹⁷⁴Ho, ¹⁷⁵Ho",
        "isotopes_stable": "¹⁶⁵Ho",
        "isotopic_abundances": "¹⁶⁵Ho: 100%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "357.73, 357.73, 561.58",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 0.00000549,
            "molar": 9.05467e-7,
            "volume": 0.0482845
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1734,
        "modulus": {
            "bulk": 40,
            "shear": 26,
            "young": 65
        },
        "molar_volume": 0.000018753,
        "neel_point": 132,
        "neutron_cross_section": 64,
        "neutron_mass_absorption": 0.015,
        "oxidation_states": "3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.23,
        "quantum_numbers": "4I15/2",
        "radius": {
            "calculated": 226,
            "empirical": 175
        },
        "resistivity": 9.4e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Holmium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2760,
        "summary": "<p>Holmium is a chemical element with the symbol Ho and atomic number 67. Part of the lanthanide series, holmium is a rare-earth element.</p><p>Holmium was discovered through isolation by Swedish chemist Per Theodor Cleve and independently by Jacques-Louis Soret and Marc Delafontaine, who observed it spectroscopically in 1878. Its oxide was first isolated from rare-earth ores by Cleve in 1878. The element's name comes from Holmia, the Latin name for the city of Stockholm.</p><p>Elemental holmium is a relatively soft and malleable silvery-white metal. It is too reactive to be found uncombined in nature, but when isolated, is relatively stable in dry air at room temperature. However, it reacts with water and corrodes readily, and also burns in air when heated.</p><p>Holmium is found in the minerals monazite and gadolinite and is usually commercially extracted from monazite using ion-exchange techniques. Its compounds in nature and in nearly all of its laboratory chemistry are trivalently oxidized, containing Ho(III) ions. Trivalent holmium ions have fluorescent properties similar to many other rare-earth ions (while yielding their own set of unique emission light lines), and thus are used in the same way as some other rare earths in certain laser and glass-colorant applications.</p><p>Holmium has the highest magnetic permeability of any element and is thus used for the polepieces of the strongest static magnets. Because holmium strongly absorbs neutrons, it is also used as a burnable poison in nuclear reactors.</p>",
        "thermal_expansion": 0.0000112,
        "valence_electrons": 3
    },
    {
        "name": "Erbium",
        "symbol": "Er",
        "abundance": {
            "universe": 2e-7,
            "solar": 1e-7,
            "meteor": 0.000018,
            "crust": 0.0003,
            "ocean": 9e-11
        },
        "appearance": "silvery white",
        "atomic_mass": 167.2593,
        "atomic_number": 68,
        "block": "f-block",
        "boiling_point": 3141,
        "classifications": {
            "cas_number": "CAS7440-52-0",
            "cid_number": "CID23980"
        },
        "conductivity": {
            "thermal": 15,
            "electric": 1.2
        },
        "cpk_hex": "00e675",
        "crystal_structure": "Simple Hexagonal",
        "curie_point": 32,
        "density": {
            "stp": 9066,
            "liquid": 8860
        },
        "discovered": {
            "year": 1842,
            "by": "Carl Gustaf Mosander",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 30.1,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹²",
        "electron_configuration_semantic": "[Xe] 4f¹² 6s²",
        "electronegativity_pauling": 1.24,
        "electrons_per_shell": [
            2,
            8,
            18,
            30,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 30, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 589,
            "brinell": 814
        },
        "heat": {
            "specific": 168,
            "vaporization": 285,
            "fusion": 19.9,
            "molar": 28.12
        },
        "ionization_energies": [
            589.3,
            1150,
            2194,
            4120
        ],
        "isotopes_known": "¹⁴³Er, ¹⁴⁴Er, ¹⁴⁵Er, ¹⁴⁶Er, ¹⁴⁷Er, ¹⁴⁸Er, ¹⁴⁹Er, ¹⁵⁰Er, ¹⁵¹Er, ¹⁵²Er, ¹⁵³Er, ¹⁵⁴Er, ¹⁵⁵Er, ¹⁵⁶Er, ¹⁵⁷Er, ¹⁵⁸Er, ¹⁵⁹Er, ¹⁶⁰Er, ¹⁶¹Er, ¹⁶²Er, ¹⁶³Er, ¹⁶⁴Er, ¹⁶⁵Er, ¹⁶⁶Er, ¹⁶⁷Er, ¹⁶⁸Er, ¹⁶⁹Er, ¹⁷⁰Er, ¹⁷¹Er, ¹⁷²Er, ¹⁷³Er, ¹⁷⁴Er, ¹⁷⁵Er, ¹⁷⁶Er, ¹⁷⁷Er",
        "isotopes_stable": "¹⁶²Er, ¹⁶⁴Er, ¹⁶⁶Er, ¹⁶⁷Er, ¹⁶⁸Er, ¹⁷⁰Er",
        "isotopic_abundances": "¹⁶²Er: 0.14%, ¹⁶⁴Er: 1.61%, ¹⁶⁶Er: 33.61%, ¹⁶⁷Er: 22.93%, ¹⁶⁸Er: 26.78%, ¹⁷⁰Er: 14.93%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "355.88, 355.88, 558.74",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 0.00000377,
            "molar": 6.30566e-7,
            "volume": 0.0341788
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1802,
        "modulus": {
            "bulk": 44,
            "shear": 28,
            "young": 70
        },
        "molar_volume": 0.000018449,
        "neel_point": 82,
        "neutron_cross_section": 165,
        "neutron_mass_absorption": 0.036,
        "oxidation_states": "3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.24,
        "quantum_numbers": "3H6",
        "radius": {
            "calculated": 226,
            "empirical": 175
        },
        "resistivity": 8.6e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Erbium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 2830,
        "summary": "<p>Erbium is a chemical element with the symbol Er and atomic number 68. A silvery-white solid metal when artificially isolated, natural erbium is always found in chemical combination with other elements. It is a lanthanide, a rare-earth element, originally found in the gadolinite mine in Ytterby, Sweden, which is the source of the element's name.</p><p>Erbium's principal uses involve its pink-colored Er3+ ions, which have optical fluorescent properties particularly useful in certain laser applications. Erbium-doped glasses or crystals can be used as optical amplification media, where Er3+ ions are optically pumped at around 980 or 1480 nm and then radiate light at 1530 nm in stimulated emission. This process results in an unusually mechanically simple laser optical amplifier for signals transmitted by fiber optics. The 1550 nm wavelength is especially important for optical communications because standard single mode optical fibers have minimal loss at this particular wavelength.</p><p>In addition to optical fiber amplifier-lasers, a large variety of medical applications (i.e. dermatology, dentistry) rely on the erbium ion's 2940 nm emission (see Er:YAG laser) when lit at another wavelength, which is highly absorbed in water in tissues, making its effect very superficial. Such shallow tissue deposition of laser energy is helpful in laser surgery, and for the efficient production of steam which produces enamel ablation by common types of dental laser.</p>",
        "thermal_expansion": 0.0000122,
        "valence_electrons": 3
    },
    {
        "name": "Thulium",
        "symbol": "Tm",
        "abundance": {
            "universe": 1e-8,
            "solar": 2e-8,
            "meteor": 0.0000029,
            "crust": 0.000045,
            "ocean": 2e-11
        },
        "appearance": "silvery gray",
        "atomic_mass": 168.934222,
        "atomic_number": 69,
        "block": "f-block",
        "boiling_point": 2223,
        "classifications": {
            "cas_number": "CAS7440-30-4",
            "cid_number": "CID23961",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 17,
            "electric": 1.4
        },
        "cpk_hex": "00d452",
        "crystal_structure": "Simple Hexagonal",
        "curie_point": 25,
        "density": {
            "stp": 9320,
            "liquid": 8560
        },
        "discovered": {
            "year": 1879,
            "by": "Per Teodor Cleve",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 99,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹³",
        "electron_configuration_semantic": "[Xe] 4f¹³ 6s²",
        "electronegativity_pauling": 1.25,
        "electrons_per_shell": [
            2,
            8,
            18,
            31,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 31, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 520,
            "brinell": 471
        },
        "heat": {
            "specific": 160,
            "vaporization": 250,
            "fusion": 16.8,
            "molar": 27.03
        },
        "ionization_energies": [
            596.7,
            1160,
            2285,
            4120
        ],
        "isotopes_known": "¹⁴⁵Tm, ¹⁴⁶Tm, ¹⁴⁷Tm, ¹⁴⁸Tm, ¹⁴⁹Tm, ¹⁵⁰Tm, ¹⁵¹Tm, ¹⁵²Tm, ¹⁵³Tm, ¹⁵⁴Tm, ¹⁵⁵Tm, ¹⁵⁶Tm, ¹⁵⁷Tm, ¹⁵⁸Tm, ¹⁵⁹Tm, ¹⁶⁰Tm, ¹⁶¹Tm, ¹⁶²Tm, ¹⁶³Tm, ¹⁶⁴Tm, ¹⁶⁵Tm, ¹⁶⁶Tm, ¹⁶⁷Tm, ¹⁶⁸Tm, ¹⁶⁹Tm, ¹⁷⁰Tm, ¹⁷¹Tm, ¹⁷²Tm, ¹⁷³Tm, ¹⁷⁴Tm, ¹⁷⁵Tm, ¹⁷⁶Tm, ¹⁷⁷Tm, ¹⁷⁸Tm, ¹⁷⁹Tm",
        "isotopes_stable": "¹⁶⁹Tm",
        "isotopic_abundances": "¹⁶⁹Tm: 100%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "353.75, 353.75, 555.46",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 0.00000199,
            "molar": 3.36179e-7,
            "volume": 0.0185488
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1818,
        "modulus": {
            "bulk": 45,
            "shear": 31,
            "young": 74
        },
        "molar_volume": 0.000018126,
        "neel_point": 56,
        "neutron_cross_section": 105,
        "neutron_mass_absorption": 0.025,
        "oxidation_states": "2,3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.21,
        "quantum_numbers": "2F7/2",
        "radius": {
            "calculated": 222,
            "empirical": 175
        },
        "resistivity": 7e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Thulium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "summary": "<p>Thulium is a chemical element with the symbol Tm and atomic number 69. It is the thirteenth and third-last element in the lanthanide series. Like the other lanthanides, the most common oxidation state is +3, seen in its oxide, halides and other compounds; because it occurs so late in the series, however, the +2 oxidation state is also stabilized by the nearly full 4f shell that results. In aqueous solution, like compounds of other late lanthanides, soluble thulium compounds form coordination complexes with nine water molecules.</p><p>In 1879, the Swedish chemist Per Teodor Cleve separated from the rare earth oxide erbia another two previously unknown components, which he called holmia and thulia; these were the oxides of holmium and thulium, respectively. A relatively pure sample of thulium metal was first obtained in 1911.</p><p>Thulium is the second-least abundant of the lanthanides, after radioactively unstable promethium which is only found in trace quantities on Earth. It is an easily workable metal with a bright silvery-gray luster. It is fairly soft and slowly tarnishes in air. Despite its high price and rarity, thulium is used as the radiation source in portable X-ray devices, and in some solid-state lasers. It has no significant biological role and is not particularly toxic.</p>",
        "thermal_expansion": 0.0000133,
        "valence_electrons": 3
    },
    {
        "name": "Ytterbium",
        "symbol": "Yb",
        "abundance": {
            "universe": 2e-7,
            "solar": 1e-7,
            "meteor": 0.000018,
            "crust": 0.00028,
            "ocean": 8e-11
        },
        "atomic_mass": 173.0451,
        "atomic_number": 70,
        "block": "f-block",
        "boiling_point": 1469,
        "classifications": {
            "cas_number": "CAS7440-64-4",
            "cid_number": "CID23992",
            "rtecs_number": "RTECSZG1925000"
        },
        "conductivity": {
            "thermal": 39,
            "electric": 3.6
        },
        "cpk_hex": "00bf38",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 6570,
            "liquid": 6210
        },
        "discovered": {
            "year": 1878,
            "by": "Jean Charles Galissard de Marignac",
            "location": "Switzerland"
        },
        "electrical_type": "Conductor",
        "electron_affinity": -1.93,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 6s²",
        "electronegativity_pauling": 1.1,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 8, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 206,
            "brinell": 343
        },
        "heat": {
            "specific": 154,
            "vaporization": 160,
            "fusion": 7.7,
            "molar": 26.74
        },
        "ionization_energies": [
            603.4,
            1174.8,
            2417,
            4203
        ],
        "isotopes_known": "¹⁴⁸Yb, ¹⁴⁹Yb, ¹⁵⁰Yb, ¹⁵¹Yb, ¹⁵²Yb, ¹⁵³Yb, ¹⁵⁴Yb, ¹⁵⁵Yb, ¹⁵⁶Yb, ¹⁵⁷Yb, ¹⁵⁸Yb, ¹⁵⁹Yb, ¹⁶⁰Yb, ¹⁶¹Yb, ¹⁶²Yb, ¹⁶³Yb, ¹⁶⁴Yb, ¹⁶⁵Yb, ¹⁶⁶Yb, ¹⁶⁷Yb, ¹⁶⁸Yb, ¹⁶⁹Yb, ¹⁷⁰Yb, ¹⁷¹Yb, ¹⁷²Yb, ¹⁷³Yb, ¹⁷⁴Yb, ¹⁷⁵Yb, ¹⁷⁶Yb, ¹⁷⁷Yb, ¹⁷⁸Yb, ¹⁷⁹Yb, ¹⁸⁰Yb, ¹⁸¹Yb, ¹⁸²Yb",
        "isotopes_stable": "¹⁶⁸Yb, ¹⁷⁰Yb, ¹⁷¹Yb, ¹⁷²Yb, ¹⁷³Yb, ¹⁷⁴Yb, ¹⁷⁶Yb",
        "isotopic_abundances": "¹⁶⁸Yb: 0.13%, ¹⁷⁰Yb: 3.04%, ¹⁷¹Yb: 14.28%, ¹⁷²Yb: 21.83%, ¹⁷³Yb: 16.13%, ¹⁷⁴Yb: 31.83%, ¹⁷⁶Yb: 12.76%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "548.47, 548.47, 548.47",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 5.9e-9,
            "molar": 1.02e-9,
            "volume": 0.0000388
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1097,
        "modulus": {
            "bulk": 31,
            "shear": 9.9,
            "young": 24
        },
        "molar_volume": 0.000026339,
        "neutron_cross_section": 35,
        "neutron_mass_absorption": 0.0076,
        "oxidation_states": "2,3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.21,
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 222,
            "empirical": 175
        },
        "resistivity": 2.8e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Ytterbium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 1590,
        "summary": "<p>Ytterbium is a chemical element with the symbol Yb and atomic number 70. It is the fourteenth and penultimate element in the lanthanide series, which is the basis of the relative stability of its +2 oxidation state. However, like the other lanthanides, its most common oxidation state is +3, as in its oxide, halides, and other compounds. In aqueous solution, like compounds of other late lanthanides, soluble ytterbium compounds form complexes with nine water molecules. Because of its closed-shell electron configuration, its density and melting and boiling points differ significantly from those of most other lanthanides.</p><p>In 1878, the Swiss chemist Jean Charles Galissard de Marignac separated from the rare earth \"erbia\" another independent component, which he called \"ytterbia\", for Ytterby, the village in Sweden near where he found the new component of erbium. He suspected that ytterbia was a compound of a new element that he called \"ytterbium\" (in total, four elements were named after the village, the others being yttrium, terbium, and erbium). In 1907, the new earth \"lutecia\" was separated from ytterbia, from which the element \"lutecium\" (now lutetium) was extracted by Georges Urbain, Carl Auer von Welsbach, and Charles James. After some discussion, Marignac's name \"ytterbium\" was retained. A relatively pure sample of the metal was not obtained until 1953. At present, ytterbium is mainly used as a dopant of stainless steel or active laser media, and less often as a gamma ray source.</p><p>Natural ytterbium is a mixture of seven stable isotopes, which altogether are present at concentrations of 0.3 parts per million. This element is mined in China, the United States, Brazil, and India in form of the minerals monazite, euxenite, and xenotime. The ytterbium concentration is low because it is found only among many other rare-earth elements; moreover, it is among the least abundant. Once extracted and prepared, ytterbium is somewhat hazardous as an eye and skin irritant. The metal is a fire and explosion hazard.</p>",
        "thermal_expansion": 0.0000263,
        "valence_electrons": 3
    },
    {
        "name": "Lutetium",
        "symbol": "Lu",
        "abundance": {
            "universe": 1e-8,
            "solar": 1e-7,
            "meteor": 0.0000029,
            "crust": 0.000056,
            "ocean": 1.5e-11
        },
        "appearance": "silvery white",
        "atomic_mass": 174.96681,
        "atomic_number": 71,
        "block": "d-block",
        "boiling_point": 3675,
        "classifications": {
            "cas_number": "CAS7439-94-3",
            "cid_number": "CID23929",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 16,
            "electric": 1.8
        },
        "cpk_hex": "00ab24",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 9841,
            "liquid": 9300
        },
        "discovered": {
            "year": 1907,
            "by": "Georges Urbain",
            "location": "France and Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 33.4,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d¹ 6s²",
        "electronegativity_pauling": 1.27,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 9, 2",
        "group": 3,
        "half_life": "Stable",
        "hardness": {
            "vickers": 1160,
            "brinell": 893
        },
        "heat": {
            "specific": 154,
            "vaporization": 415,
            "fusion": 22,
            "molar": 26.86
        },
        "ionization_energies": [
            523.5,
            1340,
            2022.3,
            4370,
            6445
        ],
        "isotopes_known": "¹⁵⁰Lu, ¹⁵¹Lu, ¹⁵²Lu, ¹⁵³Lu, ¹⁵⁴Lu, ¹⁵⁵Lu, ¹⁵⁶Lu, ¹⁵⁷Lu, ¹⁵⁸Lu, ¹⁵⁹Lu, ¹⁶⁰Lu, ¹⁶¹Lu, ¹⁶²Lu, ¹⁶³Lu, ¹⁶⁴Lu, ¹⁶⁵Lu, ¹⁶⁶Lu, ¹⁶⁷Lu, ¹⁶⁸Lu, ¹⁶⁹Lu, ¹⁷⁰Lu, ¹⁷¹Lu, ¹⁷²Lu, ¹⁷³Lu, ¹⁷⁴Lu, ¹⁷⁵Lu, ¹⁷⁶Lu, ¹⁷⁷Lu, ¹⁷⁸Lu, ¹⁷⁹Lu, ¹⁸⁰Lu, ¹⁸¹Lu, ¹⁸²Lu, ¹⁸³Lu, ¹⁸⁴Lu",
        "isotopes_stable": "¹⁷⁵Lu",
        "isotopic_abundances": "¹⁷⁵Lu: 97.41%, ¹⁷⁶Lu: 2.59%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "350.31, 350.31, 555.09",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.2e-9,
            "molar": 2.1e-10,
            "volume": 0.0000118
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1925,
        "modulus": {
            "bulk": 48,
            "shear": 27,
            "young": 69
        },
        "molar_volume": 0.000017779,
        "neutron_cross_section": 85,
        "neutron_mass_absorption": 0.022,
        "oxidation_states": "3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.26,
        "quantum_numbers": "2D3/2",
        "radius": {
            "calculated": 217,
            "empirical": 175,
            "covalent": 160
        },
        "resistivity": 5.7e-7,
        "series": "lanthanide",
        "source": "https://en.wikipedia.org/wiki/Lutetium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "summary": "<p>Lutetium is a chemical element with the symbol Lu and atomic number 71. It is a silvery white metal, which resists corrosion in dry air, but not in moist air. Lutetium is the last element in the lanthanide series, and it is traditionally counted among the rare earths. Lutetium is generally considered the first element of the 6th-period transition metals by those who study the matter, although there has been some dispute on this point.</p><p>Lutetium was independently discovered in 1907 by French scientist Georges Urbain, Austrian mineralogist Baron Carl Auer von Welsbach, and American chemist Charles James. All of these researchers found lutetium as an impurity in the mineral ytterbia, which was previously thought to consist entirely of ytterbium. The dispute on the priority of the discovery occurred shortly after, with Urbain and Welsbach accusing each other of publishing results influenced by the published research of the other; the naming honor went to Urbain, as he had published his results earlier. He chose the name lutecium for the new element, but in 1949 the spelling was changed to lutetium. In 1909, the priority was finally granted to Urbain and his names were adopted as official ones; however, the name cassiopeium (or later cassiopium) for element 71 proposed by Welsbach was used by many German scientists until the 1950s.</p><p>Lutetium is not a particularly abundant element, although it is significantly more common than silver in the earth's crust. It has few specific uses. Lutetium-176 is a relatively abundant (2.5%) radioactive isotope with a half_life of about 38 billion years, used to determine the age of minerals and meteorites. Lutetium usually occurs in association with the element yttrium and is sometimes used in metal alloys and as a catalyst in various chemical reactions. 177Lu-DOTA-TATE is used for radionuclide therapy (see Nuclear medicine) on neuroendocrine tumours. Lutetium has the highest Brinell hardness of any lanthanide, at 890–1300 MPa.</p>",
        "superconducting_point": 0.1,
        "thermal_expansion": 0.00001,
        "valence_electrons": 3
    },
    {
        "name": "Hafnium",
        "symbol": "Hf",
        "abundance": {
            "universe": 7e-8,
            "solar": 1e-7,
            "meteor": 0.000017,
            "crust": 0.00033,
            "ocean": 8e-10
        },
        "appearance": "steel gray",
        "atomic_mass": 178.492,
        "atomic_number": 72,
        "block": "d-block",
        "boiling_point": 4876,
        "classifications": {
            "cas_number": "CAS7440-58-6",
            "cid_number": "CID23986",
            "rtecs_number": "RTECSMG4600000",
            "dot_numbers": 2545,
            "dot_hazard_class": 4.2
        },
        "conductivity": {
            "thermal": 23,
            "electric": 3.3
        },
        "cpk_hex": "4dc2ff",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 13310,
            "liquid": 12000
        },
        "discovered": {
            "year": 1923,
            "by": "Dirk Coster",
            "location": "Denmark"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 17.18,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d²",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d² 6s²",
        "electronegativity_pauling": 1.3,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            10,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 10, 2",
        "group": 4,
        "half_life": "Stable",
        "hardness": {
            "vickers": 1760,
            "brinell": 1700,
            "mohs": 5.5
        },
        "heat": {
            "specific": 144,
            "vaporization": 630,
            "fusion": 25.5,
            "molar": 25.73
        },
        "ionization_energies": [
            658.5,
            1440,
            2250,
            3216
        ],
        "isotopes_known": "¹⁵³Hf, ¹⁵⁴Hf, ¹⁵⁵Hf, ¹⁵⁶Hf, ¹⁵⁷Hf, ¹⁵⁸Hf, ¹⁵⁹Hf, ¹⁶⁰Hf, ¹⁶¹Hf, ¹⁶²Hf, ¹⁶³Hf, ¹⁶⁴Hf, ¹⁶⁵Hf, ¹⁶⁶Hf, ¹⁶⁷Hf, ¹⁶⁸Hf, ¹⁶⁹Hf, ¹⁷⁰Hf, ¹⁷¹Hf, ¹⁷²Hf, ¹⁷³Hf, ¹⁷⁴Hf, ¹⁷⁵Hf, ¹⁷⁶Hf, ¹⁷⁷Hf, ¹⁷⁸Hf, ¹⁷⁹Hf, ¹⁸⁰Hf, ¹⁸¹Hf, ¹⁸²Hf, ¹⁸³Hf, ¹⁸⁴Hf, ¹⁸⁵Hf, ¹⁸⁶Hf, ¹⁸⁷Hf, ¹⁸⁸Hf",
        "isotopes_stable": "¹⁷⁶Hf, ¹⁷⁷Hf, ¹⁷⁸Hf, ¹⁷⁹Hf, ¹⁸⁰Hf",
        "isotopic_abundances": "¹⁷⁴Hf: 0.16%, ¹⁷⁶Hf: 5.26%, ¹⁷⁷Hf: 18.6%, ¹⁷⁸Hf: 27.28%, ¹⁷⁹Hf: 13.62%, ¹⁸⁰Hf: 35.08%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "319.64, 319.64, 505.11",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 5.3e-9,
            "molar": 9.46e-10,
            "volume": 0.0000705
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2506,
        "modulus": {
            "bulk": 110,
            "shear": 30,
            "young": 78
        },
        "molar_volume": 0.0000134102,
        "neutron_cross_section": 104,
        "neutron_mass_absorption": 0.02,
        "oxidation_states": "2,3,4c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.37,
        "quantum_numbers": "3F2",
        "radius": {
            "calculated": 208,
            "empirical": 155,
            "covalent": 150
        },
        "resistivity": 3e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Hafnium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 3010,
        "summary": "<p>Hafnium is a chemical element with the symbol Hf and atomic number 72. A lustrous, silvery gray, tetravalent transition metal, hafnium chemically resembles zirconium and is found in many zirconium minerals. Its existence was predicted by Dmitri Mendeleev in 1869, though it was not identified until 1923, by Coster and Hevesy, making it the second-last stable element to be discovered (the last being rhenium). Hafnium is named after Hafnia, the Latin name for Copenhagen, where it was discovered.</p><p>Hafnium is used in filaments and electrodes. Some semiconductor fabrication processes use its oxide for integrated circuits at 45 nm and smaller feature lengths. Some superalloys used for special applications contain hafnium in combination with niobium, titanium, or tungsten.</p><p>Hafnium's large neutron capture cross section makes it a good material for neutron absorption in control rods in nuclear power plants, but at the same time requires that it be removed from the neutron-transparent corrosion-resistant zirconium alloys used in nuclear reactors.</p>",
        "superconducting_point": 0.128,
        "thermal_expansion": 0.0000059,
        "valence_electrons": 4
    },
    {
        "name": "Tantalum",
        "symbol": "Ta",
        "abundance": {
            "universe": 8e-9,
            "meteor": 0.000002,
            "crust": 0.00017,
            "ocean": 2e-10
        },
        "appearance": "gray blue",
        "atomic_mass": 180.947882,
        "atomic_number": 73,
        "block": "d-block",
        "boiling_point": 5731,
        "classifications": {
            "cas_number": "CAS7440-25-7",
            "cid_number": "CID23956",
            "rtecs_number": "RTECSWW5505000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 57,
            "electric": 7.7
        },
        "cpk_hex": "4da6ff",
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 16650,
            "liquid": 15000
        },
        "discovered": {
            "year": 1802,
            "by": "Anders Gustaf Ekeberg",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 31,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d³",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d³ 6s²",
        "electronegativity_pauling": 1.5,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            11,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 11, 2",
        "group": 5,
        "half_life": "Stable",
        "hardness": {
            "vickers": 873,
            "brinell": 800,
            "mohs": 6.5
        },
        "heat": {
            "specific": 140,
            "vaporization": 735,
            "fusion": 36,
            "molar": 25.36
        },
        "ionization_energies": [
            761,
            1500
        ],
        "isotopes_known": "¹⁵⁵Ta, ¹⁵⁶Ta, ¹⁵⁷Ta, ¹⁵⁸Ta, ¹⁵⁹Ta, ¹⁶⁰Ta, ¹⁶¹Ta, ¹⁶²Ta, ¹⁶³Ta, ¹⁶⁴Ta, ¹⁶⁵Ta, ¹⁶⁶Ta, ¹⁶⁷Ta, ¹⁶⁸Ta, ¹⁶⁹Ta, ¹⁷⁰Ta, ¹⁷¹Ta, ¹⁷²Ta, ¹⁷³Ta, ¹⁷⁴Ta, ¹⁷⁵Ta, ¹⁷⁶Ta, ¹⁷⁷Ta, ¹⁷⁸Ta, ¹⁷⁹Ta, ¹⁸⁰Ta, ¹⁸¹Ta, ¹⁸²Ta, ¹⁸³Ta, ¹⁸⁴Ta, ¹⁸⁵Ta, ¹⁸⁶Ta, ¹⁸⁷Ta, ¹⁸⁸Ta, ¹⁸⁹Ta, ¹⁹⁰Ta",
        "isotopes_stable": "¹⁸¹Ta",
        "isotopic_abundances": "¹⁸¹Ta: 99.988%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "330.13, 330.13, 330.13",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.07e-8,
            "molar": 1.936e-9,
            "volume": 0.0001782
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 3290,
        "modulus": {
            "bulk": 200,
            "shear": 69,
            "young": 186
        },
        "molar_volume": 0.0000108677,
        "neutron_cross_section": 20.5,
        "neutron_mass_absorption": 0.0041,
        "oxidation_states": "-1,2,3,4,5c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.34,
        "quantum_numbers": "4F3/2",
        "radius": {
            "calculated": 200,
            "empirical": 145,
            "covalent": 138
        },
        "resistivity": 1.3e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Tantalum",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 3400,
        "summary": "<p>Tantalum is a chemical element with the symbol Ta and atomic number 73. Previously known as tantalium, it is named after Tantalus, a villain from Greek mythology. Tantalum is a rare, hard, blue-gray, lustrous transition metal that is highly corrosion-resistant. It is part of the refractory metals group, which are widely used as minor components in alloys. The chemical inertness of tantalum makes it a valuable substance for laboratory equipment, and as a substitute for platinum. Its main use today is in tantalum capacitors in electronic equipment such as mobile phones, DVD players, video game systems and computers. Tantalum, always together with the chemically similar niobium, occurs in the mineral groups tantalite, columbite and coltan (the latter is a mix of columbite and tantalite, though not recognised as a separate mineral species). Tantalum is considered a technology-critical element.</p>",
        "superconducting_point": 4.47,
        "thermal_expansion": 0.0000063,
        "valence_electrons": 5
    },
    {
        "name": "Tungsten",
        "symbol": "W",
        "abundance": {
            "universe": 5e-8,
            "solar": 4e-7,
            "meteor": 0.000012,
            "crust": 0.00011,
            "ocean": 1.2e-8
        },
        "alternate_names": "Wolfram",
        "appearance": "grayish white, lustrous",
        "atomic_mass": 183.841,
        "atomic_number": 74,
        "block": "d-block",
        "boiling_point": 6203,
        "classifications": {
            "cas_number": "CAS7440-33-7",
            "cid_number": "CID23964",
            "rtecs_number": "RTECSYO7175000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 170,
            "electric": 20
        },
        "cpk_hex": "2194d6",
        "crystal_structure": "Body-centered Cubic",
        "density": {
            "stp": 19250,
            "liquid": 17600
        },
        "discovered": {
            "year": 1783,
            "by": "Carl Wilhelm Scheele",
            "location": "Spain"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 78.76,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d⁴",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d⁴ 6s²",
        "electronegativity_pauling": 2.36,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            12,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 12, 2",
        "group": 6,
        "half_life": "Stable",
        "hardness": {
            "vickers": 3430,
            "brinell": 2570,
            "mohs": 7.5
        },
        "heat": {
            "specific": 132,
            "vaporization": 800,
            "fusion": 35,
            "molar": 24.27
        },
        "ionization_energies": [
            770,
            1700
        ],
        "isotopes_known": "¹⁵⁸W, ¹⁵⁹W, ¹⁶⁰W, ¹⁶¹W, ¹⁶²W, ¹⁶³W, ¹⁶⁴W, ¹⁶⁵W, ¹⁶⁶W, ¹⁶⁷W, ¹⁶⁸W, ¹⁶⁹W, ¹⁷⁰W, ¹⁷¹W, ¹⁷²W, ¹⁷³W, ¹⁷⁴W, ¹⁷⁵W, ¹⁷⁶W, ¹⁷⁷W, ¹⁷⁸W, ¹⁷⁹W, ¹⁸⁰W, ¹⁸¹W, ¹⁸²W, ¹⁸³W, ¹⁸⁴W, ¹⁸⁵W, ¹⁸⁶W, ¹⁸⁷W, ¹⁸⁸W, ¹⁸⁹W, ¹⁹⁰W, ¹⁹¹W, ¹⁹²W",
        "isotopes_stable": "¹⁸⁰W, ¹⁸²W, ¹⁸³W, ¹⁸⁴W, ¹⁸⁶W",
        "isotopic_abundances": "¹⁸⁰W: 0.12%, ¹⁸²W: 26.5%, ¹⁸³W: 14.31%, ¹⁸⁴W: 30.64%, ¹⁸⁶W: 28.43%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "316.52, 316.52, 316.52",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 4.59e-9,
            "molar": 8.44e-10,
            "volume": 0.0000884
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 3695,
        "modulus": {
            "bulk": 310,
            "shear": 161,
            "young": 411
        },
        "molar_volume": 0.0000095501,
        "neutron_cross_section": 18.4,
        "neutron_mass_absorption": 0.0036,
        "oxidation_states": "-2,-1,1,2,3,4c,5,6c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.28,
        "quantum_numbers": "5D0",
        "radius": {
            "calculated": 193,
            "empirical": 135,
            "covalent": 146
        },
        "resistivity": 4.999999999997e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Tungsten",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "speed_of_sound": 5174,
        "summary": "<p>Tungsten, or wolfram, is a chemical element with the symbol W and atomic number 74. Tungsten is a rare metal found naturally on Earth almost exclusively as compounds with other elements. It was identified as a new element in 1781 and first isolated as a metal in 1783. Its important ores include scheelite, and wolframite, the latter lending the element its alternate name.</p><p>The free element is remarkable for its robustness, especially the fact that it has the highest melting point of all the elements discovered except carbon (which sublimes at normal pressure), melting at 3,422 °C (6,192 °F; 3,695 K). It also has the highest boiling point, at 5,930 °C (10,710 °F; 6,200 K). Its density is 19.25 grams per cubic centimetre, comparable with that of uranium and gold, and much higher (about 1.7 times) than that of lead. Polycrystalline tungsten is an intrinsically brittle and hard material (under standard conditions, when uncombined), making it difficult to work. However, pure single-crystalline tungsten is more ductile and can be cut with a hard-steel hacksaw.</p><p>Tungsten occurs in many alloys, which have numerous applications, including incandescent light bulb filaments, X-ray tubes, electrodes in gas tungsten arc welding, superalloys, and radiation shielding. Tungsten's hardness and high density make it suitable for military applications in penetrating projectiles. Tungsten compounds are often used as industrial catalysts.</p><p>Tungsten is the only metal in the third transition series that is known to occur in biomolecules, being found in a few species of bacteria and archaea. However, tungsten interferes with molybdenum and copper metabolism and is somewhat toxic to most forms of animal life.</p>",
        "superconducting_point": 0.015,
        "thermal_expansion": 0.0000045,
        "valence_electrons": 6
    },
    {
        "name": "Rhenium",
        "symbol": "Re",
        "abundance": {
            "universe": 2e-8,
            "solar": 1e-8,
            "meteor": 0.0000049,
            "crust": 2.6e-7,
            "ocean": 1e-10
        },
        "appearance": "silvery-grayish",
        "atomic_mass": 186.2071,
        "atomic_number": 75,
        "block": "d-block",
        "boiling_point": 5869,
        "classifications": {
            "cas_number": "CAS7440-15-5",
            "cid_number": "CID23947",
            "rtecs_number": "RTECSVI0780000"
        },
        "conductivity": {
            "thermal": 48,
            "electric": 5.6
        },
        "cpk_hex": "267dab",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 21020,
            "liquid": 18900
        },
        "discovered": {
            "year": 1925,
            "by": "Masataka Ogawa",
            "location": "Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 5.8273,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d⁵",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d⁵ 6s²",
        "electronegativity_pauling": 1.9,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            13,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 13, 2",
        "group": 7,
        "half_life": "Stable",
        "hardness": {
            "vickers": 2450,
            "brinell": 1320,
            "mohs": 7
        },
        "heat": {
            "specific": 137,
            "vaporization": 705,
            "fusion": 33,
            "molar": 25.48
        },
        "ionization_energies": [
            760,
            1260,
            2510,
            3640
        ],
        "isotopes_known": "¹⁶⁰Re, ¹⁶¹Re, ¹⁶²Re, ¹⁶³Re, ¹⁶⁴Re, ¹⁶⁵Re, ¹⁶⁶Re, ¹⁶⁷Re, ¹⁶⁸Re, ¹⁶⁹Re, ¹⁷⁰Re, ¹⁷¹Re, ¹⁷²Re, ¹⁷³Re, ¹⁷⁴Re, ¹⁷⁵Re, ¹⁷⁶Re, ¹⁷⁷Re, ¹⁷⁸Re, ¹⁷⁹Re, ¹⁸⁰Re, ¹⁸¹Re, ¹⁸²Re, ¹⁸³Re, ¹⁸⁴Re, ¹⁸⁵Re, ¹⁸⁶Re, ¹⁸⁷Re, ¹⁸⁸Re, ¹⁸⁹Re, ¹⁹⁰Re, ¹⁹¹Re, ¹⁹²Re, ¹⁹³Re, ¹⁹⁴Re",
        "isotopes_stable": "¹⁸⁵Re",
        "isotopic_abundances": "¹⁸⁵Re: 37.4%, ¹⁸⁷Re: 62.6%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "276.1, 276.1, 445.6",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 4.56e-9,
            "molar": 8.49e-10,
            "volume": 0.0000959
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 3459,
        "modulus": {
            "bulk": 370,
            "shear": 178,
            "young": 463
        },
        "molar_volume": 0.00000885856,
        "neutron_cross_section": 90,
        "neutron_mass_absorption": 0.016,
        "oxidation_states": "-3,-1,1,2,3,4c,5,6,7",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.3,
        "quantum_numbers": "6S5/2",
        "radius": {
            "calculated": 188,
            "empirical": 135,
            "covalent": 159
        },
        "resistivity": 1.8e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Rhenium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 4700,
        "summary": "<p>Rhenium is a chemical element with the symbol Re and atomic number 75. It is a silvery-gray, heavy, third-row transition metal in group 7 of the periodic table. With an estimated average concentration of 1 part per billion (ppb), rhenium is one of the rarest elements in the Earth's crust. Rhenium has the third-highest melting point and highest boiling point of any stable element at 5869 K. Rhenium resembles manganese and technetium chemically and is mainly obtained as a by-product of the extraction and refinement of molybdenum and copper ores. Rhenium shows in its compounds a wide variety of oxidation states ranging from −1 to +7.</p><p>Discovered in 1925, rhenium was the last stable element to be discovered. It was named after the river Rhine in Europe.</p><p>Nickel-based superalloys of rhenium are used in the combustion chambers, turbine blades, and exhaust nozzles of jet engines. These alloys contain up to 6% rhenium, making jet engine construction the largest single use for the element. The second-most important use is as a catalyst: rhenium is an excellent catalyst for hydrogenation and isomerization, and is used for example in catalytic reforming of naphtha for use in gasoline (rheniforming process). Because of the low availability relative to demand, rhenium is expensive, with price reaching an all-time high in 2008/2009 of US$10,600 per kilogram (US$4,800 per pound). Due to increases in rhenium recycling and a drop in demand for rhenium in catalysts, the price of rhenium has dropped to US$2,844 per kilogram (US$1,290 per pound) as of July 2018.</p>",
        "superconducting_point": 1.7,
        "thermal_expansion": 0.0000062,
        "valence_electrons": 7
    },
    {
        "name": "Osmium",
        "symbol": "Os",
        "abundance": {
            "universe": 3e-7,
            "solar": 2e-7,
            "meteor": 0.000066,
            "crust": 1.8e-7
        },
        "appearance": "silvery, blue cast",
        "atomic_mass": 190.233,
        "atomic_number": 76,
        "block": "d-block",
        "boiling_point": 5285,
        "classifications": {
            "cas_number": "CAS7440-04-2",
            "cid_number": "CID23937",
            "rtecs_number": "RTECSRN1100000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 88,
            "electric": 12
        },
        "cpk_hex": "266696",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 22590,
            "liquid": 20000
        },
        "discovered": {
            "year": 1803,
            "by": "Smithson Tennant",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 103.99,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d⁶",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d⁶ 6s²",
        "electronegativity_pauling": 2.2,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            14,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 14, 2",
        "group": 8,
        "half_life": "Stable",
        "hardness": {
            "brinell": 3920,
            "mohs": 7
        },
        "heat": {
            "specific": 130,
            "vaporization": 630,
            "fusion": 31,
            "molar": 24.7
        },
        "ionization_energies": [
            840,
            1600
        ],
        "isotopes_known": "¹⁶²Os, ¹⁶³Os, ¹⁶⁴Os, ¹⁶⁵Os, ¹⁶⁶Os, ¹⁶⁷Os, ¹⁶⁸Os, ¹⁶⁹Os, ¹⁷⁰Os, ¹⁷¹Os, ¹⁷²Os, ¹⁷³Os, ¹⁷⁴Os, ¹⁷⁵Os, ¹⁷⁶Os, ¹⁷⁷Os, ¹⁷⁸Os, ¹⁷⁹Os, ¹⁸⁰Os, ¹⁸¹Os, ¹⁸²Os, ¹⁸³Os, ¹⁸⁴Os, ¹⁸⁵Os, ¹⁸⁶Os, ¹⁸⁷Os, ¹⁸⁸Os, ¹⁸⁹Os, ¹⁹⁰Os, ¹⁹¹Os, ¹⁹²Os, ¹⁹³Os, ¹⁹⁴Os, ¹⁹⁵Os, ¹⁹⁶Os",
        "isotopes_stable": "¹⁸⁴Os, ¹⁸⁷Os, ¹⁸⁸Os, ¹⁸⁹Os, ¹⁹⁰Os, ¹⁹²Os",
        "isotopic_abundances": "¹⁸⁴Os: 0.02%, ¹⁸⁶Os: 1.59%, ¹⁸⁷Os: 1.96%, ¹⁸⁸Os: 13.24%, ¹⁸⁹Os: 16.15%, ¹⁹⁰Os: 26.26%, ¹⁹²Os: 40.78%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "273.44, 273.44, 431.73",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 6e-10,
            "molar": 1.1e-10,
            "volume": 0.000014
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 3306,
        "modulus": {
            "shear": 222
        },
        "molar_volume": 0.000008421,
        "neutron_cross_section": 15,
        "neutron_mass_absorption": 0.0023,
        "oxidation_states": "-2,1,2,3,4c,5,6,7,8",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.25,
        "quantum_numbers": "5D4",
        "radius": {
            "calculated": 185,
            "empirical": 130,
            "covalent": 128
        },
        "resistivity": 8.000000000001e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Osmium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 4940,
        "summary": "<p>Osmium (from Greek ὀσμή, osme, 'smell') is a chemical element with the symbol Os and atomic number 76. It is a hard, brittle, bluish-white transition metal in the platinum group that is found as a trace element in alloys, mostly in platinum ores. Osmium is the densest naturally occurring element, with an experimentally measured (using x-ray crystallography) density of 22.59 g/cm3. Manufacturers use its alloys with platinum, iridium, and other platinum-group metals to make fountain pen nib tipping, electrical contacts, and in other applications that require extreme durability and hardness. The element's abundance in the Earth's crust is among the rarest, with an abundance of only 50 ppt in the earth's crust. It is estimated to be about 0.6 parts per billion in the universe and is therefore the rarest precious metal.</p>",
        "superconducting_point": 0.66,
        "thermal_expansion": 0.0000051,
        "valence_electrons": 6
    },
    {
        "name": "Iridium",
        "symbol": "Ir",
        "abundance": {
            "universe": 2e-7,
            "solar": 2e-7,
            "meteor": 0.000054,
            "crust": 4e-8
        },
        "appearance": "silvery white",
        "atomic_mass": 192.2173,
        "atomic_number": 77,
        "block": "d-block",
        "boiling_point": 4403,
        "classifications": {
            "cas_number": "CAS7439-88-5",
            "cid_number": "CID23924",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 150,
            "electric": 21
        },
        "cpk_hex": "175487",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 22560,
            "liquid": 19000
        },
        "discovered": {
            "year": 1803,
            "by": "Smithson Tennant",
            "location": "France and The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 150.94,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d⁷",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d⁷ 6s²",
        "electronegativity_pauling": 2.2,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            15,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 15, 2",
        "group": 9,
        "half_life": "Stable",
        "hardness": {
            "vickers": 1760,
            "brinell": 1670,
            "mohs": 6.5
        },
        "heat": {
            "specific": 131,
            "vaporization": 560,
            "fusion": 26,
            "molar": 25.1
        },
        "ionization_energies": [
            880,
            1600
        ],
        "isotopes_known": "¹⁶⁴Ir, ¹⁶⁵Ir, ¹⁶⁶Ir, ¹⁶⁷Ir, ¹⁶⁸Ir, ¹⁶⁹Ir, ¹⁷⁰Ir, ¹⁷¹Ir, ¹⁷²Ir, ¹⁷³Ir, ¹⁷⁴Ir, ¹⁷⁵Ir, ¹⁷⁶Ir, ¹⁷⁷Ir, ¹⁷⁸Ir, ¹⁷⁹Ir, ¹⁸⁰Ir, ¹⁸¹Ir, ¹⁸²Ir, ¹⁸³Ir, ¹⁸⁴Ir, ¹⁸⁵Ir, ¹⁸⁶Ir, ¹⁸⁷Ir, ¹⁸⁸Ir, ¹⁸⁹Ir, ¹⁹⁰Ir, ¹⁹¹Ir, ¹⁹²Ir, ¹⁹³Ir, ¹⁹⁴Ir, ¹⁹⁵Ir, ¹⁹⁶Ir, ¹⁹⁷Ir, ¹⁹⁸Ir, ¹⁹⁹Ir",
        "isotopes_stable": "¹⁹¹Ir, ¹⁹³Ir",
        "isotopic_abundances": "¹⁹¹Ir: 37.3%, ¹⁹³Ir: 62.7%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "383.9, 383.9, 383.9",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.67e-9,
            "molar": 3.21e-10,
            "volume": 0.0000377
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2719,
        "modulus": {
            "bulk": 320,
            "shear": 210,
            "young": 528
        },
        "molar_volume": 0.0000085203,
        "neutron_cross_section": 425,
        "neutron_mass_absorption": 0.081,
        "oxidation_states": "-3,-1,1,2,3c,4c,5,6,7,8",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.26,
        "quantum_numbers": "4F9/2",
        "radius": {
            "calculated": 180,
            "empirical": 135,
            "covalent": 137
        },
        "resistivity": 4.699999999998e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Iridium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 4825,
        "summary": "<p>Iridium is a chemical element with the symbol Ir and atomic number 77. A very hard, brittle, silvery-white transition metal of the platinum group, iridium is considered to be the second-densest naturally occurring metal (after osmium) with a density of 22.56 g/cm3 as defined by experimental X-ray crystallography. However, at room temperature and standard atmospheric pressure, iridium has been calculated to have a density of 22.65 g/cm3, 0.04 g/cm3 higher than osmium measured the same way. Still, the experimental X-ray crystallography value is considered to be the most accurate, and as such iridium is considered to be the second densest element. It is the most corrosion-resistant metal, even at temperatures as high as 2000 °C. Although only certain molten salts and halogens are corrosive to solid iridium, finely divided iridium dust is much more reactive and can be flammable.</p><p>Iridium was discovered in 1803 among insoluble impurities in natural platinum. Smithson Tennant, the primary discoverer, named iridium after the Greek goddess Iris, personification of the rainbow, because of the striking and diverse colors of its salts. Iridium is one of the rarest elements in Earth's crust, with annual production and consumption of only three metric tons. 191Ir and 193Ir are the only two naturally occurring isotopes of iridium, as well as the only stable isotopes; the latter is the more abundant.</p><p>The most important iridium compounds in use are the salts and acids it forms with chlorine, though iridium also forms a number of organometallic compounds used in industrial catalysis, and in research. Iridium metal is employed when high corrosion resistance at high temperatures is needed, as in high-performance spark plugs, crucibles for recrystallization of semiconductors at high temperatures, and electrodes for the production of chlorine in the chloralkali process. Iridium radioisotopes are used in some radioisotope thermoelectric generators.</p><p>Iridium is found in meteorites in much higher abundance than in the Earth's crust. For this reason, the unusually high abundance of iridium in the clay layer at the Cretaceous–Paleogene boundary gave rise to the Alvarez hypothesis that the impact of a massive extraterrestrial object caused the extinction of dinosaurs and many other species 66 million years ago. Similarly, an iridium anomaly in core samples from the Pacific Ocean suggested the Eltanin impact of about 2.5 million years ago.</p><p>It is thought that the total amount of iridium in the planet Earth is much higher than that observed in crustal rocks, but as with other platinum-group metals, the high density and tendency of iridium to bond with iron caused most iridium to descend below the crust when the planet was young and still molten.</p>",
        "superconducting_point": 0.11,
        "thermal_expansion": 0.0000064,
        "valence_electrons": 6
    },
    {
        "name": "Platinum",
        "symbol": "Pt",
        "abundance": {
            "universe": 5e-7,
            "solar": 9e-7,
            "meteor": 0.000098,
            "crust": 0.0000037
        },
        "appearance": "silvery white",
        "atomic_mass": 195.0849,
        "atomic_number": 78,
        "block": "d-block",
        "boiling_point": 4098,
        "classifications": {
            "cas_number": "CAS7440-06-4",
            "cid_number": "CID23939",
            "rtecs_number": "RTECSTP2160000",
            "dot_numbers": 3089,
            "dot_hazard_class": 4.1
        },
        "conductivity": {
            "thermal": 72,
            "electric": 9.4
        },
        "cpk_hex": "d0d0e0",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 21450,
            "liquid": 19770
        },
        "discovered": {
            "year": 1735,
            "by": "Antonio de Ulloa",
            "location": "Peru"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 205.041,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s¹ 4f¹⁴ 5d⁹",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d⁹ 6s¹",
        "electronegativity_pauling": 2.28,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            17,
            1
        ],
        "energy_levels": "2, 8, 18, 32, 17, 1",
        "group": 10,
        "half_life": "Stable",
        "hardness": {
            "vickers": 549,
            "brinell": 392,
            "mohs": 3.5
        },
        "heat": {
            "specific": 133,
            "vaporization": 490,
            "fusion": 20,
            "molar": 25.86
        },
        "ionization_energies": [
            870,
            1791
        ],
        "isotopes_known": "¹⁶⁶Pt, ¹⁶⁷Pt, ¹⁶⁸Pt, ¹⁶⁹Pt, ¹⁷⁰Pt, ¹⁷¹Pt, ¹⁷²Pt, ¹⁷³Pt, ¹⁷⁴Pt, ¹⁷⁵Pt, ¹⁷⁶Pt, ¹⁷⁷Pt, ¹⁷⁸Pt, ¹⁷⁹Pt, ¹⁸⁰Pt, ¹⁸¹Pt, ¹⁸²Pt, ¹⁸³Pt, ¹⁸⁴Pt, ¹⁸⁵Pt, ¹⁸⁶Pt, ¹⁸⁷Pt, ¹⁸⁸Pt, ¹⁸⁹Pt, ¹⁹⁰Pt, ¹⁹¹Pt, ¹⁹²Pt, ¹⁹³Pt, ¹⁹⁴Pt, ¹⁹⁵Pt, ¹⁹⁶Pt, ¹⁹⁷Pt, ¹⁹⁸Pt, ¹⁹⁹Pt, ²⁰⁰Pt, ²⁰¹Pt, ²⁰²Pt",
        "isotopes_stable": "¹⁹²Pt, ¹⁹⁴Pt, ¹⁹⁵Pt, ¹⁹⁶Pt, ¹⁹⁸Pt",
        "isotopic_abundances": "¹⁹⁰Pt: 0.014%, ¹⁹²Pt: 0.782%, ¹⁹⁴Pt: 32.967%, ¹⁹⁵Pt: 33.832%, ¹⁹⁶Pt: 25.242%, ¹⁹⁸Pt: 7.163%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "392.42, 392.42, 392.42",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": 1.22e-8,
            "molar": 2.38e-9,
            "volume": 0.0002573
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2041.4,
        "modulus": {
            "bulk": 230,
            "shear": 61,
            "young": 168
        },
        "molar_volume": 0.0000090948,
        "neutron_cross_section": 10,
        "neutron_mass_absorption": 0.002,
        "oxidation_states": "2c,4c,5,6",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.38,
        "quantum_numbers": "3D3",
        "radius": {
            "calculated": 177,
            "empirical": 135,
            "covalent": 128,
            "vanderwaals": 175
        },
        "resistivity": 1.1e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Platinum",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 2680,
        "summary": "<p>Platinum is a chemical element with the symbol Pt and atomic number 78. It is a dense, malleable, ductile, highly unreactive, precious, silverish-white transition metal. Its name is derived from the Spanish term platino, meaning \"little silver\".</p><p>Platinum is a member of the platinum group of elements and group 10 of the periodic table of elements. It has six naturally occurring isotopes. It is one of the rarer elements in Earth's crust, with an average abundance of approximately 5 μg/kg. It occurs in some nickel and copper ores along with some native deposits, mostly in South Africa, which accounts for 80% of the world production. Because of its scarcity in Earth's crust, only a few hundred tonnes are produced annually, and given its important uses, it is highly valuable and is a major precious metal commodity.</p><p>Platinum is one of the least reactive metals. It has remarkable resistance to corrosion, even at high temperatures, and is therefore considered a noble metal. Consequently, platinum is often found chemically uncombined as native platinum. Because it occurs naturally in the alluvial sands of various rivers, it was first used by pre-Columbian South American natives to produce artifacts. It was referenced in European writings as early as 16th century, but it was not until Antonio de Ulloa published a report on a new metal of Colombian origin in 1748 that it began to be investigated by scientists.</p><p>Platinum is used in catalytic converters, laboratory equipment, electrical contacts and electrodes, platinum resistance thermometers, dentistry equipment, and jewelry. Being a heavy metal, it leads to health problems upon exposure to its salts; but due to its corrosion resistance, metallic platinum has not been linked to adverse health effects. Compounds containing platinum, such as cisplatin, oxaliplatin and carboplatin, are applied in chemotherapy against certain types of cancer.</p><p>In early 2021, the value of platinum ranged from US$1,055 per troy ounce to US$1,320 per troy ounce.</p>",
        "thermal_expansion": 0.0000089,
        "valence_electrons": 6
    },
    {
        "name": "Gold",
        "symbol": "Au",
        "abundance": {
            "universe": 6e-8,
            "solar": 1e-7,
            "meteor": 0.000017,
            "crust": 3.1e-7,
            "ocean": 5e-9,
            "human": 0.00001
        },
        "alternate_names": "Aurum",
        "appearance": "metallic yellow",
        "atomic_mass": 196.9665695,
        "atomic_number": 79,
        "block": "d-block",
        "boiling_point": 3243,
        "classifications": {
            "cas_number": "CAS7440-57-5",
            "cid_number": "CID23985",
            "rtecs_number": "RTECSMD5070000"
        },
        "conductivity": {
            "thermal": 320,
            "electric": 45
        },
        "cpk_hex": "ffd123",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 19300,
            "liquid": 17310
        },
        "discovered": {
            "year": -2500,
            "location": "Middle East"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 222.747,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s¹ 4f¹⁴ 5d¹⁰",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d¹⁰ 6s¹",
        "electronegativity_pauling": 2.54,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            1
        ],
        "energy_levels": "2, 8, 18, 32, 18, 1",
        "group": 11,
        "half_life": "Stable",
        "hardness": {
            "vickers": 216,
            "brinell": 25,
            "mohs": 2.5
        },
        "heat": {
            "specific": 129.1,
            "vaporization": 330,
            "fusion": 12.5,
            "molar": 25.418
        },
        "ionization_energies": [
            890.1,
            1980
        ],
        "isotopes_known": "¹⁶⁹Au, ¹⁷⁰Au, ¹⁷¹Au, ¹⁷²Au, ¹⁷³Au, ¹⁷⁴Au, ¹⁷⁵Au, ¹⁷⁶Au, ¹⁷⁷Au, ¹⁷⁸Au, ¹⁷⁹Au, ¹⁸⁰Au, ¹⁸¹Au, ¹⁸²Au, ¹⁸³Au, ¹⁸⁴Au, ¹⁸⁵Au, ¹⁸⁶Au, ¹⁸⁷Au, ¹⁸⁸Au, ¹⁸⁹Au, ¹⁹⁰Au, ¹⁹¹Au, ¹⁹²Au, ¹⁹³Au, ¹⁹⁴Au, ¹⁹⁵Au, ¹⁹⁶Au, ¹⁹⁷Au, ¹⁹⁸Au, ¹⁹⁹Au, ²⁰⁰Au, ²⁰¹Au, ²⁰²Au, ²⁰³Au, ²⁰⁴Au, ²⁰⁵Au",
        "isotopes_stable": "¹⁹⁷Au",
        "isotopic_abundances": "¹⁹⁷Au: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "407.82, 407.82, 407.82",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -1.78e-9,
            "molar": -3.51e-10,
            "volume": -0.0000344
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 1337.33,
        "modulus": {
            "bulk": 220,
            "shear": 27,
            "young": 78
        },
        "molar_volume": 0.00001021,
        "neutron_cross_section": 98.7,
        "neutron_mass_absorption": 0.017,
        "oxidation_states": "-1,1,2,3c,5",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.44,
        "quantum_numbers": "2S1/2",
        "radius": {
            "calculated": 174,
            "empirical": 135,
            "covalent": 144,
            "vanderwaals": 166
        },
        "resistivity": 2.2e-8,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Gold",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 1740,
        "summary": "<p>Gold is a chemical element with the symbol Au (from Latin: aurum) and atomic number 79, making it one of the higher atomic number elements that occur naturally. In a pure form, it is a bright, slightly reddish yellow, dense, soft, malleable, and ductile metal. Chemically, gold is a transition metal and a group 11 element. It is one of the least reactive chemical elements and is solid under standard conditions. Gold often occurs in free elemental (native) form, as nuggets or grains, in rocks, in veins, and in alluvial deposits. It occurs in a solid solution series with the native element silver (as electrum), naturally alloyed with other metals like copper and palladium and also as mineral inclusions such as within pyrite. Less commonly, it occurs in minerals as gold compounds, often with tellurium (gold tellurides).</p><p>Gold is resistant to most acids, though it does dissolve in aqua regia (a mixture of nitric acid and hydrochloric acid), which forms a soluble tetrachloroaurate anion. Gold is insoluble in nitric acid, which dissolves silver and base metals, a property that has long been used to refine gold and to confirm the presence of gold in metallic substances, giving rise to the term acid test. Gold also dissolves in alkaline solutions of cyanide, which are used in mining and electroplating. Gold dissolves in mercury, forming amalgam alloys, and as the gold acts simply as a solute this is not a chemical reaction.</p><p>A relatively rare element, gold is a precious metal that has been used for coinage, jewelry, and other arts throughout recorded history. In the past, a gold standard was often implemented as a monetary policy, but gold coins ceased to be minted as a circulating currency in the 1930s, and the world gold standard was abandoned for a fiat currency system after 1971.</p><p>A total of 197,576 tonnes of gold exists above ground, as of 2019. This is equal to a cube with each side measuring roughly 21.7 meters (71 ft). The world consumption of new gold produced is about 50% in jewelry, 40% in investments, and 10% in industry. Gold's high malleability, ductility, resistance to corrosion and most other chemical reactions, and conductivity of electricity have led to its continued use in corrosion resistant electrical connectors in all types of computerized devices (its chief industrial use). Gold is also used in infrared shielding, colored-glass production, gold leafing, and tooth restoration. Certain gold salts are still used as anti-inflammatories in medicine. As of 2017, the world's largest gold producer by far was China with 440 tonnes per year.</p>",
        "thermal_expansion": 0.0000142,
        "valence_electrons": 5
    },
    {
        "name": "Mercury",
        "symbol": "Hg",
        "abundance": {
            "universe": 1e-7,
            "solar": 0.000002,
            "meteor": 0.000025,
            "crust": 0.0000067,
            "ocean": 5e-9
        },
        "alternate_names": "Hydrargyrum",
        "appearance": "silvery",
        "atomic_mass": 200.5923,
        "atomic_number": 80,
        "block": "d-block",
        "boiling_point": 629.88,
        "classifications": {
            "cas_number": "CAS7439-97-6",
            "cid_number": "CID23931",
            "rtecs_number": "RTECSOV4550000",
            "dot_numbers": 2809,
            "dot_hazard_class": 8
        },
        "conductivity": {
            "thermal": 8.3,
            "electric": 1
        },
        "cpk_hex": "b8b8d0",
        "critical_pressure": 172,
        "critical_temperature": 1750,
        "crystal_structure": "Simple Trigonal",
        "density": {
            "stp": 13534,
            "liquid": 13534
        },
        "discovered": {
            "year": -2000
        },
        "electrical_type": "Conductor",
        "electron_affinity": -48,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d¹⁰ 6s²",
        "electronegativity_pauling": 2,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 18, 2",
        "group": 12,
        "half_life": "Stable",
        "heat": {
            "specific": 139.5,
            "vaporization": 59.2,
            "fusion": 2.29,
            "molar": 27.983
        },
        "ionization_energies": [
            1007.1,
            1810,
            3300
        ],
        "isotopes_known": "¹⁷¹Hg, ¹⁷²Hg, ¹⁷³Hg, ¹⁷⁴Hg, ¹⁷⁵Hg, ¹⁷⁶Hg, ¹⁷⁷Hg, ¹⁷⁸Hg, ¹⁷⁹Hg, ¹⁸⁰Hg, ¹⁸¹Hg, ¹⁸²Hg, ¹⁸³Hg, ¹⁸⁴Hg, ¹⁸⁵Hg, ¹⁸⁶Hg, ¹⁸⁷Hg, ¹⁸⁸Hg, ¹⁸⁹Hg, ¹⁹⁰Hg, ¹⁹¹Hg, ¹⁹²Hg, ¹⁹³Hg, ¹⁹⁴Hg, ¹⁹⁵Hg, ¹⁹⁶Hg, ¹⁹⁷Hg, ¹⁹⁸Hg, ¹⁹⁹Hg, ²⁰⁰Hg, ²⁰¹Hg, ²⁰²Hg, ²⁰³Hg, ²⁰⁴Hg, ²⁰⁵Hg, ²⁰⁶Hg, ²⁰⁷Hg, ²⁰⁸Hg, ²⁰⁹Hg, ²¹⁰Hg",
        "isotopes_stable": "¹⁹⁶Hg, ¹⁹⁸Hg, ¹⁹⁹Hg, ²⁰⁰Hg, ²⁰¹Hg, ²⁰²Hg, ²⁰⁴Hg",
        "isotopic_abundances": "¹⁹⁶Hg: 0.15%, ¹⁹⁸Hg: 9.97%, ¹⁹⁹Hg: 16.87%, ²⁰⁰Hg: 23.1%, ²⁰¹Hg: 13.18%, ²⁰²Hg: 29.86%, ²⁰⁴Hg: 6.87%",
        "lattice_angles": "1.23081, 1.23081, 1.23081",
        "lattice_constants": "300.5, 300.5, 300.5",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -2.1e-9,
            "molar": -4.21e-10,
            "volume": -0.0000284
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 234.321,
        "modulus": {
            "bulk": 25
        },
        "molar_volume": 0.0000148213,
        "neutron_cross_section": 374,
        "neutron_mass_absorption": 0.063,
        "oxidation_states": "1c,2c,4",
        "period": 6,
        "phase": "Liquid",
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 171,
            "empirical": 150,
            "covalent": 149,
            "vanderwaals": 155
        },
        "refractive_index": 1.000933,
        "resistivity": 9.6e-7,
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Mercury (Element)",
        "space_group_name": "R_3m",
        "space_group_number": 166,
        "speed_of_sound": 1407,
        "summary": "<p>Mercury is a chemical element with the symbol Hg and atomic number 80. It is commonly known as quicksilver and was formerly named hydrargyrum (/haɪˈdrɑːrdʒərəm/ hy-DRAR-jər-əm). A heavy, silvery d-block element, mercury is the only metallic element that is liquid at standard conditions for temperature and pressure; the only other element that is liquid under these conditions is the halogen bromine, though metals such as caesium, gallium, and rubidium melt just above room temperature.</p><p>Mercury occurs in deposits throughout the world mostly as cinnabar (mercuric sulfide). The red pigment vermilion is obtained by grinding natural cinnabar or synthetic mercuric sulfide.</p><p>Mercury is used in thermometers, barometers, manometers, sphygmomanometers, float valves, mercury switches, mercury relays, fluorescent lamps and other devices, though concerns about the element's toxicity have led to mercury thermometers and sphygmomanometers being largely phased out in clinical environments in favor of alternatives such as alcohol- or galinstan-filled glass thermometers and thermistor- or infrared-based electronic instruments. Likewise, mechanical pressure gauges and electronic strain gauge sensors have replaced mercury sphygmomanometers.</p><p>Mercury remains in use in scientific research applications and in amalgam for dental restoration in some locales. It is also used in fluorescent lighting. Electricity passed through mercury vapor in a fluorescent lamp produces short-wave ultraviolet light, which then causes the phosphor in the tube to fluoresce, making visible light.</p><p>Mercury poisoning can result from exposure to water-soluble forms of mercury (such as mercuric chloride or methylmercury), by inhalation of mercury vapor, or by ingesting any form of mercury.</p>",
        "superconducting_point": 4.154,
        "thermal_expansion": 0.000181,
        "valence_electrons": 2
    },
    {
        "name": "Thallium",
        "symbol": "Tl",
        "abundance": {
            "universe": 5e-8,
            "solar": 1e-7,
            "meteor": 0.0000078,
            "crust": 0.000053,
            "ocean": 1e-10
        },
        "appearance": "silvery white",
        "atomic_mass": 204.38,
        "atomic_number": 81,
        "block": "p-block",
        "boiling_point": 1746,
        "classifications": {
            "cas_number": "CAS7440-28-0",
            "cid_number": "CID5359464",
            "rtecs_number": "RTECSXG3425000",
            "dot_numbers": 1707
        },
        "conductivity": {
            "thermal": 46,
            "electric": 6.7
        },
        "cpk_hex": "a6544d",
        "crystal_structure": "Simple Hexagonal",
        "density": {
            "stp": 11850,
            "liquid": 11220
        },
        "discovered": {
            "year": 1861,
            "by": "William Crookes",
            "location": "The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 36.4,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p¹",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d¹⁰ 6s² 6p¹",
        "electronegativity_pauling": 1.62,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            3
        ],
        "energy_levels": "2, 8, 18, 32, 18, 3",
        "group": 13,
        "half_life": "Stable",
        "hardness": {
            "brinell": 26.4,
            "mohs": 1.2
        },
        "heat": {
            "specific": 129,
            "vaporization": 165,
            "fusion": 4.2,
            "molar": 26.32
        },
        "ionization_energies": [
            589.4,
            1971,
            2878
        ],
        "isotopes_known": "¹⁷⁶Tl, ¹⁷⁷Tl, ¹⁷⁸Tl, ¹⁷⁹Tl, ¹⁸⁰Tl, ¹⁸¹Tl, ¹⁸²Tl, ¹⁸³Tl, ¹⁸⁴Tl, ¹⁸⁵Tl, ¹⁸⁶Tl, ¹⁸⁷Tl, ¹⁸⁸Tl, ¹⁸⁹Tl, ¹⁹⁰Tl, ¹⁹¹Tl, ¹⁹²Tl, ¹⁹³Tl, ¹⁹⁴Tl, ¹⁹⁵Tl, ¹⁹⁶Tl, ¹⁹⁷Tl, ¹⁹⁸Tl, ¹⁹⁹Tl, ²⁰⁰Tl, ²⁰¹Tl, ²⁰²Tl, ²⁰³Tl, ²⁰⁴Tl, ²⁰⁵Tl, ²⁰⁶Tl, ²⁰⁷Tl, ²⁰⁸Tl, ²⁰⁹Tl, ²¹⁰Tl, ²¹¹Tl, ²¹²Tl",
        "isotopes_stable": "²⁰³Tl, ²⁰⁵Tl",
        "isotopic_abundances": "²⁰³Tl: 29.524%, ²⁰⁵Tl: 70.476%",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "345.66, 345.66, 552.48",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -3e-9,
            "molar": -6.13e-10,
            "volume": -0.0000356
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 577,
        "modulus": {
            "bulk": 43,
            "shear": 2.8,
            "young": 8
        },
        "molar_volume": 0.0000172473,
        "neutron_cross_section": 3.4,
        "neutron_mass_absorption": 0.00059,
        "oxidation_states": "1c,3c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.45,
        "quantum_numbers": "2P1/2",
        "radius": {
            "calculated": 156,
            "empirical": 190,
            "covalent": 148,
            "vanderwaals": 196
        },
        "resistivity": 1.5e-7,
        "series": "post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Thallium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "speed_of_sound": 818,
        "summary": "<p>Thallium is a chemical element with the symbol Tl and atomic number 81. It is a gray post-transition metal that is not found free in nature. When isolated, thallium resembles tin, but discolors when exposed to air. Chemists William Crookes and Claude-Auguste Lamy discovered thallium independently in 1861, in residues of sulfuric acid production. Both used the newly developed method of flame spectroscopy, in which thallium produces a notable green spectral line. Thallium, from Greek θαλλός, thallós, meaning \"green shoot\" or \"twig\", was named by Crookes. It was isolated by both Lamy and Crookes in 1862; Lamy by electrolysis, and Crookes by precipitation and melting of the resultant powder. Crookes exhibited it as a powder precipitated by zinc at the International exhibition, which opened on 1 May that year.</p><p>Thallium tends to form the +3 and +1 oxidation states. The +3 state resembles that of the other elements in group 13 (boron, aluminium, gallium, indium). However, the +1 state, which is far more prominent in thallium than the elements above it, recalls the chemistry of alkali metals, and thallium(I) ions are found geologically mostly in potassium-based ores, and (when ingested) are handled in many ways like potassium ions (K+) by ion pumps in living cells.</p><p>Commercially, thallium is produced not from potassium ores, but as a byproduct from refining of heavy-metal sulfide ores. Approximately 60–70% of thallium production is used in the electronics industry, and the remainder is used in the pharmaceutical industry and in glass manufacturing. It is also used in infrared detectors. The radioisotope thallium-201 (as the soluble chloride TlCl) is used in small amounts as an agent in a nuclear medicine scan, during one type of nuclear cardiac stress test.</p><p>Soluble thallium salts (many of which are nearly tasteless) are highly toxic, and they were historically used in rat poisons and insecticides. Use of these compounds has been restricted or banned in many countries, because of their nonselective toxicity. Thallium poisoning usually results in hair loss, although this characteristic symptom does not always manifest. Because of its historic popularity as a murder weapon, thallium has gained notoriety as \"the poisoner's poison\" and \"inheritance powder\" (alongside arsenic).</p>",
        "superconducting_point": 2.38,
        "thermal_expansion": 0.0000299,
        "valence_electrons": 3
    },
    {
        "name": "Lead",
        "symbol": "Pb",
        "abundance": {
            "universe": 0.000001,
            "solar": 0.000001,
            "meteor": 0.00014,
            "crust": 0.00099,
            "ocean": 3e-9,
            "human": 0.00017
        },
        "alternate_names": "Plumbum",
        "appearance": "metallic gray",
        "atomic_mass": 207.21,
        "atomic_number": 82,
        "block": "p-block",
        "boiling_point": 2022,
        "classifications": {
            "cas_number": "CAS7439-92-1",
            "cid_number": "CID5352425",
            "rtecs_number": "RTECSOF7525000",
            "dot_numbers": 3077
        },
        "conductivity": {
            "thermal": 35,
            "electric": 4.8
        },
        "cpk_hex": "575961",
        "crystal_structure": "Face-centered Cubic",
        "density": {
            "stp": 11340,
            "liquid": 10660
        },
        "discovered": {
            "year": -4000,
            "location": "Middle East"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 34.4204,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p²",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d¹⁰ 6s² 6p²",
        "electronegativity_pauling": 1.87,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            4
        ],
        "energy_levels": "2, 8, 18, 32, 18, 4",
        "group": 14,
        "half_life": "Stable",
        "hardness": {
            "brinell": 38.3,
            "mohs": 1.5
        },
        "heat": {
            "specific": 127,
            "vaporization": 178,
            "fusion": 4.77,
            "molar": 26.65
        },
        "ionization_energies": [
            715.6,
            1450.5,
            3081.5,
            4083,
            6640
        ],
        "isotopes_known": "¹⁷⁸Pb, ¹⁷⁹Pb, ¹⁸⁰Pb, ¹⁸¹Pb, ¹⁸²Pb, ¹⁸³Pb, ¹⁸⁴Pb, ¹⁸⁵Pb, ¹⁸⁶Pb, ¹⁸⁷Pb, ¹⁸⁸Pb, ¹⁸⁹Pb, ¹⁹⁰Pb, ¹⁹¹Pb, ¹⁹²Pb, ¹⁹³Pb, ¹⁹⁴Pb, ¹⁹⁵Pb, ¹⁹⁶Pb, ¹⁹⁷Pb, ¹⁹⁸Pb, ¹⁹⁹Pb, ²⁰⁰Pb, ²⁰¹Pb, ²⁰²Pb, ²⁰³Pb, ²⁰⁴Pb, ²⁰⁵Pb, ²⁰⁶Pb, ²⁰⁷Pb, ²⁰⁸Pb, ²⁰⁹Pb, ²¹⁰Pb, ²¹¹Pb, ²¹²Pb, ²¹³Pb, ²¹⁴Pb, ²¹⁵Pb",
        "isotopes_stable": "²⁰⁴Pb, ²⁰⁶Pb, ²⁰⁷Pb, ²⁰⁸Pb",
        "isotopic_abundances": "²⁰⁴Pb: 1.4%, ²⁰⁶Pb: 24.1%, ²⁰⁷Pb: 22.1%, ²⁰⁸Pb: 52.4%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "495.08, 495.08, 495.08",
        "lifetime": "Stable",
        "magnetic_susceptibility": {
            "mass": -1.5e-9,
            "molar": -3.11e-10,
            "volume": -0.000017
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 600.61,
        "modulus": {
            "bulk": 46,
            "shear": 5.6,
            "young": 16
        },
        "molar_volume": 0.000018272,
        "neutron_cross_section": 0.171,
        "neutron_mass_absorption": 0.00003,
        "oxidation_states": "-4,2c,4c",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.44,
        "quantum_numbers": "3P0",
        "radius": {
            "calculated": 154,
            "empirical": 180,
            "covalent": 147,
            "vanderwaals": 202
        },
        "resistivity": 2.1e-7,
        "series": "post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Lead_(element)",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 1260,
        "summary": "<p>Lead is a chemical element with the symbol Pb (from the Latin plumbum) and atomic number 82. It is a heavy metal that is denser than most common materials. Lead is soft and malleable, and also has a relatively low melting point. When freshly cut, lead is silvery with a hint of blue; it tarnishes to a dull gray color when exposed to air. Lead has the highest atomic number of any stable element and three of its isotopes are endpoints of major nuclear decay chains of heavier elements.</p><p>Lead is a relatively unreactive post-transition metal. Its weak metallic character is illustrated by its amphoteric nature; lead and lead oxides react with acids and bases, and it tends to form covalent bonds. Compounds of lead are usually found in the +2 oxidation state rather than the +4 state common with lighter members of the carbon group. Exceptions are mostly limited to organolead compounds. Like the lighter members of the group, lead tends to bond with itself; it can form chains and polyhedral structures.</p><p>Since lead is easily extracted from its ores, prehistoric people in the Near East were aware of it. Galena is a principal ore of lead which often bears silver. Interest in silver helped initiate widespread extraction and use of lead in ancient Rome. Lead production declined after the fall of Rome and did not reach comparable levels until the Industrial Revolution. In 2014, the annual global production of lead was about ten million tonnes, over half of which was from recycling. Lead's high density, low melting point, ductility and relative inertness to oxidation make it useful. These properties, combined with its relative abundance and low cost, resulted in its extensive use in construction, plumbing, batteries, bullets and shot, weights, solders, pewters, fusible alloys, white paints, leaded gasoline, and radiation shielding.</p><p>In the late 19th century, lead's toxicity was recognized, and its use has since been phased out of many applications. However, many countries still allow the sale of products that expose humans to lead, including some types of paints and bullets. Lead is a neurotoxin that accumulates in soft tissues and bones; it damages the nervous system and interferes with the function of biological enzymes, causing neurological disorders, such as brain damage and behavioral problems. Lead also affects general health, cardiovascular, and renal systems.</p>",
        "superconducting_point": 7.2,
        "thermal_expansion": 0.0000289,
        "valence_electrons": 4
    },
    {
        "name": "Bismuth",
        "symbol": "Bi",
        "abundance": {
            "universe": 7e-8,
            "solar": 0.000001,
            "meteor": 0.0000069,
            "crust": 0.0000025,
            "ocean": 2e-9
        },
        "appearance": "lustrous silver",
        "atomic_mass": 208.980401,
        "atomic_number": 83,
        "block": "p-block",
        "boiling_point": 1837,
        "classifications": {
            "cas_number": "CAS7440-69-9",
            "cid_number": "CID5359367",
            "rtecs_number": "RTECSEB2600000",
            "dot_numbers": 3080,
            "dot_hazard_class": 6.1
        },
        "conductivity": {
            "thermal": 8,
            "electric": 0.77
        },
        "cpk_hex": "9e4fb5",
        "crystal_structure": "Base-centered Monoclinic",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 9780,
            "liquid": 10050
        },
        "discovered": {
            "year": 1400,
            "by": "Claude François Geoffroy"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 90.924,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p³",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d¹⁰ 6s² 6p³",
        "electronegativity_pauling": 2.02,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            5
        ],
        "energy_levels": "2, 8, 18, 32, 18, 5",
        "group": 15,
        "half_life": 19025875190260000000,
        "hardness": {
            "brinell": 94.2,
            "mohs": 2.25
        },
        "heat": {
            "specific": 122,
            "vaporization": 160,
            "fusion": 10.9,
            "molar": 25.52
        },
        "ionization_energies": [
            703,
            1610,
            2466,
            4370,
            5400,
            8520
        ],
        "isotopes_known": "¹⁸⁴Bi, ¹⁸⁵Bi, ¹⁸⁶Bi, ¹⁸⁷Bi, ¹⁸⁸Bi, ¹⁸⁹Bi, ¹⁹⁰Bi, ¹⁹¹Bi, ¹⁹²Bi, ¹⁹³Bi, ¹⁹⁴Bi, ¹⁹⁵Bi, ¹⁹⁶Bi, ¹⁹⁷Bi, ¹⁹⁸Bi, ¹⁹⁹Bi, ²⁰⁰Bi, ²⁰¹Bi, ²⁰²Bi, ²⁰³Bi, ²⁰⁴Bi, ²⁰⁵Bi, ²⁰⁶Bi, ²⁰⁷Bi, ²⁰⁸Bi, ²⁰⁹Bi, ²¹⁰Bi, ²¹¹Bi, ²¹²Bi, ²¹³Bi, ²¹⁴Bi, ²¹⁵Bi, ²¹⁶Bi, ²¹⁷Bi, ²¹⁸Bi, ²¹⁹Bi",
        "isotopes_stable": "None",
        "isotopic_abundances": "²⁰⁹Bi: 100%",
        "lattice_angles": "π/2, 1.925622, π/2",
        "lattice_constants": "667.4, 611.7, 330.4",
        "lifetime": 27587519025880000000,
        "magnetic_susceptibility": {
            "mass": -1.7e-8,
            "molar": -3.6e-9,
            "volume": -0.00017
        },
        "magnetic_type": "diamagnetic",
        "melting_point": 544.7,
        "modulus": {
            "bulk": 31,
            "shear": 12,
            "young": 32
        },
        "molar_volume": 0.000021368,
        "neutron_cross_section": 0.034,
        "neutron_mass_absorption": 0.000006,
        "oxidation_states": "-3,3c,5",
        "period": 6,
        "phase": "Solid",
        "poisson_ratio": 0.33,
        "quantum_numbers": "4S3/2",
        "radius": {
            "calculated": 143,
            "empirical": 160,
            "covalent": 146
        },
        "resistivity": 0.0000013,
        "series": "post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Bismuth",
        "space_group_name": "C12/m1",
        "space_group_number": 12,
        "speed_of_sound": 1790,
        "summary": "<p>Bismuth is a chemical element with the symbol Bi and atomic number 83. It is a pentavalent post-transition metal and one of the pnictogens with chemical properties resembling its lighter group 15 siblings arsenic and antimony. Elemental bismuth may occur naturally, although its sulfide and oxide form important commercial ores. The free element is 86% as dense as lead. It is a brittle metal with a silvery-white color when freshly produced, but surface oxidation can give it an iridescent tinge in numerous colours. Bismuth is the most naturally diamagnetic element and has one of the lowest values of thermal conductivity among metals.</p><p>Bismuth was long considered the element with the highest atomic mass that is stable, but in 2003 it was discovered to be extremely weakly radioactive: its only primordial isotope, bismuth-209, decays via alpha decay with a half_life more than a billion times the estimated age of the universe. Because of its tremendously long half_life, bismuth may still be considered stable for almost all purposes.</p><p>Bismuth metal has been known since ancient times, although it was often confused with lead and tin, which share some physical properties. The etymology is uncertain, but the word may come from the German words weiße Masse or Wismuth (\"white mass\"), translated in the mid-sixteenth century to New Latin bisemutum or bisemutium.</p>",
        "thermal_expansion": 0.0000134,
        "valence_electrons": 5
    },
    {
        "name": "Polonium",
        "symbol": "Po",
        "abundance": {
            "universe": 0,
            "ocean": 2e-18,
            "human": 0
        },
        "allotropes": "Alpha Polonium, Beta Polonium",
        "appearance": "silvery",
        "atomic_mass": 209,
        "atomic_number": 84,
        "block": "p-block",
        "boiling_point": 1235,
        "classifications": {
            "cas_number": "CAS7440-08-6"
        },
        "conductivity": {
            "electric": 2.3
        },
        "cpk_hex": "ab5c00",
        "crystal_structure": "Simple Cubic",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 9196
        },
        "discovered": {
            "year": 1898,
            "by": "Pierre Curie",
            "location": "France"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 136,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁴",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d¹⁰ 6s² 6p⁴",
        "electronegativity_pauling": 2,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            6
        ],
        "energy_levels": "2, 8, 18, 32, 18, 6",
        "group": 16,
        "half_life": 102.1055301877,
        "heat": {
            "vaporization": 100,
            "fusion": 13,
            "molar": 26.4
        },
        "ionization_energies": [
            812.1
        ],
        "isotopes_known": "¹⁸⁸Po, ¹⁸⁹Po, ¹⁹⁰Po, ¹⁹¹Po, ¹⁹²Po, ¹⁹³Po, ¹⁹⁴Po, ¹⁹⁵Po, ¹⁹⁶Po, ¹⁹⁷Po, ¹⁹⁸Po, ¹⁹⁹Po, ²⁰⁰Po, ²⁰¹Po, ²⁰²Po, ²⁰³Po, ²⁰⁴Po, ²⁰⁵Po, ²⁰⁶Po, ²⁰⁷Po, ²⁰⁸Po, ²⁰⁹Po, ²¹⁰Po, ²¹¹Po, ²¹²Po, ²¹³Po, ²¹⁴Po, ²¹⁵Po, ²¹⁶Po, ²¹⁷Po, ²¹⁸Po, ²¹⁹Po, ²²⁰Po",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "335.9, 335.9, 335.9",
        "lifetime": 147.1334348047,
        "melting_point": 527,
        "molar_volume": 0.00002272727272727,
        "neutron_cross_section": 0.5,
        "oxidation_states": "-2c,2c,4c,6",
        "period": 6,
        "phase": "Solid",
        "quantum_numbers": "3P2",
        "radius": {
            "calculated": 135,
            "empirical": 190
        },
        "resistivity": 4.3e-7,
        "series": "post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Polonium",
        "space_group_name": "Pm-3m",
        "space_group_number": 221,
        "summary": "<p>Polonium is a chemical element with the symbol Po and atomic number 84. Polonium is a chalcogen. A rare and highly radioactive metal with no stable isotopes, polonium is chemically similar to selenium and tellurium, though its metallic character resembles that of its horizontal neighbors in the periodic table: thallium, lead, and bismuth. Due to the short half_life of all its isotopes, its natural occurrence is limited to tiny traces of the fleeting polonium-210 (with a half_life of 138 days) in uranium ores, as it is the penultimate daughter of natural uranium-238. Though slightly longer-lived isotopes exist, they are much more difficult to produce. Today, polonium is usually produced in milligram quantities by the neutron irradiation of bismuth. Due to its intense radioactivity, which results in the radiolysis of chemical bonds and radioactive self-heating, its chemistry has mostly been investigated on the trace scale only.</p><p>Polonium was discovered in July 1898 by Marie and Pierre Curie, when it was extracted from the uranium ore pitchblende and identified solely by its strong radioactivity: it was the first element to be so discovered. Polonium was named after Marie Curie's homeland of Poland. Polonium has few applications, and those are related to its radioactivity: heaters in space probes, antistatic devices, sources of neutrons and alpha particles, and poison. It is extremely dangerous to humans.</p>",
        "valence_electrons": 6
    },
    {
        "name": "Astatine",
        "symbol": "At",
        "abundance": {
            "universe": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "unknown, probably metallic",
        "atomic_mass": 210,
        "atomic_number": 85,
        "block": "p-block",
        "boiling_point": 610,
        "classifications": {
            "cas_number": "CAS7440-68-8"
        },
        "conductivity": {
            "thermal": 2
        },
        "cpk_hex": "754f45",
        "decay_mode": "BetaPlusDecay",
        "discovered": {
            "year": 1940,
            "by": "Dale R. Corson",
            "location": "The United States"
        },
        "electron_affinity": 233,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁵",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d¹⁰ 6s² 6p⁵",
        "electronegativity_pauling": 2.2,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            7
        ],
        "energy_levels": "2, 8, 18, 32, 18, 7",
        "group": 17,
        "half_life": 8.055555555556,
        "heat": {
            "vaporization": 40,
            "fusion": 6
        },
        "ionization_energies": [
            899.003
        ],
        "isotopes_known": "¹⁹³At, ¹⁹⁴At, ¹⁹⁵At, ¹⁹⁶At, ¹⁹⁷At, ¹⁹⁸At, ¹⁹⁹At, ²⁰⁰At, ²⁰¹At, ²⁰²At, ²⁰³At, ²⁰⁴At, ²⁰⁵At, ²⁰⁶At, ²⁰⁷At, ²⁰⁸At, ²⁰⁹At, ²¹⁰At, ²¹¹At, ²¹²At, ²¹³At, ²¹⁴At, ²¹⁵At, ²¹⁶At, ²¹⁷At, ²¹⁸At, ²¹⁹At, ²²⁰At, ²²¹At, ²²²At, ²²³At",
        "isotopes_stable": "None",
        "lifetime": 11.66666666667,
        "melting_point": 575,
        "oxidation_states": "-1c,1c,3,5,7",
        "period": 6,
        "phase": "Solid",
        "quantum_numbers": "2P3/2",
        "radius": {
            "calculated": 127
        },
        "series": "metalloid",
        "source": "https://en.wikipedia.org/wiki/Astatine",
        "summary": "<p>Astatine is a chemical element with the symbol At and atomic number 85. It is the rarest naturally occurring element in the Earth's crust, occurring only as the decay product of various heavier elements. All of astatine's isotopes are short-lived; the most stable is astatine-210, with a half_life of 8.1 hours. A sample of the pure element has never been assembled, because any macroscopic specimen would be immediately vaporized by the heat of its own radioactivity.</p><p>The bulk properties of astatine are not known with certainty. Many of them have been estimated based on the element's position on the periodic table as a heavier analog of iodine, and a member of the halogens (the group of elements including fluorine, chlorine, bromine, and iodine). However, astatine also falls roughly along the dividing line between metals and nonmetals, and some metallic behavior has also been observed and predicted for it. Astatine is likely to have a dark or lustrous appearance and may be a semiconductor or possibly a metal. Chemically, several anionic species of astatine are known and most of its compounds resemble those of iodine, but it also sometimes displays metallic characteristics and shows some similarities to silver.</p><p>The first synthesis of the element was in 1940 by Dale R. Corson, Kenneth Ross MacKenzie, and Emilio G. Segrè at the University of California, Berkeley, who named it from the Greek astatos (ἄστατος), meaning \"unstable\". Four isotopes of astatine were subsequently found to be naturally occurring, although much less than one gram is present at any given time in the Earth's crust. Neither the most stable isotope astatine-210, nor the medically useful astatine-211, occur naturally; they can only be produced synthetically, usually by bombarding bismuth-209 with alpha particles.</p>",
        "valence_electrons": 7
    },
    {
        "name": "Radon",
        "symbol": "Rn",
        "abundance": {
            "universe": 0,
            "ocean": 6e-20
        },
        "adiabatic_index": "5/3",
        "appearance": "colorless gas, occasionally glows green or red in discharge tubes",
        "atomic_mass": 222,
        "atomic_number": 86,
        "block": "p-block",
        "boiling_point": 211.5,
        "classifications": {
            "cas_number": "CAS10043-92-2",
            "cid_number": "CID24857",
            "rtecs_number": "RTECSVE3750000",
            "dot_numbers": 2912,
            "dot_hazard_class": 7
        },
        "conductivity": {
            "thermal": 0.00361
        },
        "cpk_hex": "428296",
        "critical_pressure": 6.28,
        "critical_temperature": 377,
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 9.73
        },
        "discovered": {
            "year": 1900,
            "by": "Friedrich Ernst Dorn",
            "location": "Germany"
        },
        "electron_affinity": -68,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶",
        "electron_configuration_semantic": "[Xe] 4f¹⁴ 5d¹⁰ 6s² 6p⁶",
        "electronegativity_pauling": 2.2,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            8
        ],
        "energy_levels": "2, 8, 18, 32, 18, 8",
        "gas_phase": "Monoatomic",
        "group": 18,
        "half_life": 3.82349537037,
        "heat": {
            "specific": 93.65,
            "vaporization": 17,
            "fusion": 3
        },
        "ionization_energies": [
            1037
        ],
        "isotopes_known": "¹⁹⁵Rn, ¹⁹⁶Rn, ¹⁹⁷Rn, ¹⁹⁸Rn, ¹⁹⁹Rn, ²⁰⁰Rn, ²⁰¹Rn, ²⁰²Rn, ²⁰³Rn, ²⁰⁴Rn, ²⁰⁵Rn, ²⁰⁶Rn, ²⁰⁷Rn, ²⁰⁸Rn, ²⁰⁹Rn, ²¹⁰Rn, ²¹¹Rn, ²¹²Rn, ²¹³Rn, ²¹⁴Rn, ²¹⁵Rn, ²¹⁶Rn, ²¹⁷Rn, ²¹⁸Rn, ²¹⁹Rn, ²²⁰Rn, ²²¹Rn, ²²²Rn, ²²³Rn, ²²⁴Rn, ²²⁵Rn, ²²⁶Rn, ²²⁷Rn, ²²⁸Rn",
        "isotopes_stable": "None",
        "lifetime": 5.516087962963,
        "melting_point": 202,
        "molar_volume": 0.02281603288798,
        "neutron_cross_section": 0.7,
        "oxidation_states": "2c",
        "period": 6,
        "phase": "Gas",
        "quantum_numbers": "1S0",
        "radius": {
            "calculated": 120,
            "covalent": 145
        },
        "series": "noble gas",
        "source": "https://en.wikipedia.org/wiki/Radon",
        "summary": "<p>Radon is a chemical element with the symbol Rn and atomic number 86. It is a radioactive, colorless, odorless, tasteless noble gas. It occurs naturally in minute quantities as an intermediate step in the normal radioactive decay chains through which thorium and uranium slowly decay into lead and various other short-lived radioactive elements. Radon itself is the immediate decay product of radium. Its most stable isotope, 222Rn, has a half_life of only 3.8 days, making it one of the rarest elements. Since thorium and uranium are two of the most common radioactive elements on Earth, while also having three isotopes with half-lives on the order of several billion years, radon will be present on Earth long into the future despite its short half_life. The decay of radon produces many other short-lived nuclides, known as radon daughters, ending at stable isotopes of lead.</p><p>Unlike all other intermediate elements in the aforementioned decay chains, radon is, under standard conditions, gaseous and easily inhaled, and therefore a health hazard. It is often the single largest contributor to an individual's background radiation dose, but due to local differences in geology, the level of exposure to radon gas differs from place to place. A common source is uranium-containing minerals in the ground, and therefore it accumulates in subterranean areas such as basements. Radon can also occur in some ground water like spring waters and hot springs.</p><p>Epidemiological studies have shown a clear link between breathing high concentrations of radon and incidence of lung cancer. Radon is a contaminant that affects indoor air quality worldwide. According to the United States Environmental Protection Agency (EPA), radon is the second most frequent cause of lung cancer, after cigarette smoking, causing 21,000 lung cancer deaths per year in the United States. About 2,900 of these deaths occur among people who have never smoked. While radon is the second most frequent cause of lung cancer, it is the number one cause among non-smokers, according to EPA policy-oriented estimates. Significant uncertainties exist for the health effects of low-dose exposures. Unlike the gaseous radon itself, radon daughters are solids and stick to surfaces, such as airborne dust particles, which can cause lung cancer if inhaled.</p>",
        "valence_electrons": 6
    },
    {
        "name": "Francium",
        "symbol": "Fr",
        "abundance": {
            "universe": 0,
            "human": 0
        },
        "atomic_mass": 223,
        "atomic_number": 87,
        "block": "s-block",
        "boiling_point": 950,
        "classifications": {
            "cas_number": "CAS7440-73-5"
        },
        "cpk_hex": "420066",
        "decay_mode": "BetaDecay",
        "discovered": {
            "year": 1939,
            "by": "Marguerite Perey",
            "location": "France"
        },
        "electron_affinity": 46.89,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s¹",
        "electron_configuration_semantic": "[Rn] 7s¹",
        "electronegativity_pauling": 0.79,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            8,
            1
        ],
        "energy_levels": "2, 8, 18, 32, 18, 8, 1",
        "group": 1,
        "half_life": 21.66666666667,
        "heat": {
            "vaporization": 65,
            "fusion": 2
        },
        "ionization_energies": [
            380
        ],
        "isotopes_known": "¹⁹⁹Fr, ²⁰⁰Fr, ²⁰¹Fr, ²⁰²Fr, ²⁰³Fr, ²⁰⁴Fr, ²⁰⁵Fr, ²⁰⁶Fr, ²⁰⁷Fr, ²⁰⁸Fr, ²⁰⁹Fr, ²¹⁰Fr, ²¹¹Fr, ²¹²Fr, ²¹³Fr, ²¹⁴Fr, ²¹⁵Fr, ²¹⁶Fr, ²¹⁷Fr, ²¹⁸Fr, ²¹⁹Fr, ²²⁰Fr, ²²¹Fr, ²²²Fr, ²²³Fr, ²²⁴Fr, ²²⁵Fr, ²²⁶Fr, ²²⁷Fr, ²²⁸Fr, ²²⁹Fr, ²³⁰Fr, ²³¹Fr, ²³²Fr",
        "isotopes_stable": "None",
        "lifetime": 31.66666666667,
        "melting_point": 300,
        "oxidation_states": "1c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "2S1/2",
        "series": "alkali metal",
        "source": "https://en.wikipedia.org/wiki/Francium",
        "summary": "<p>Francium is a chemical element with the symbol Fr and atomic number 87. Prior to its discovery, it was referred to as eka-caesium. It is extremely radioactive; its most stable isotope, francium-223 (originally called actinium K after the natural decay chain it appears in), has a half_life of only 22 minutes. It is the second-most electropositive element, behind only caesium, and is the second rarest naturally occurring element (after astatine). The isotopes of francium decay quickly into astatine, radium, and radon. The electronic structure of a francium atom is 7s1, and so the element is classed as an alkali metal.</p><p>Bulk francium has never been seen. Because of the general appearance of the other elements in its periodic table column, it is assumed that francium would appear as a highly reactive metal, if enough could be collected together to be viewed as a bulk solid or liquid. Obtaining such a sample is highly improbable, since the extreme heat of decay resulting from its short half_life would immediately vaporize any viewable quantity of the element.</p><p>Francium was discovered by Marguerite Perey in France (from which the element takes its name) in 1939. It was the last element first discovered in nature, rather than by synthesis. Outside the laboratory, francium is extremely rare, with trace amounts found in uranium and thorium ores, where the isotope francium-223 continually forms and decays. As little as 20–30 g (one ounce) exists at any given time throughout the Earth's crust; aside from francium-221, its other isotopes are entirely synthetic. The largest amount produced in the laboratory was a cluster of more than 300,000 atoms.</p>",
        "valence_electrons": 1
    },
    {
        "name": "Radium",
        "symbol": "Ra",
        "abundance": {
            "universe": 0,
            "crust": 9.9e-12,
            "ocean": 1e-15,
            "human": 1e-13
        },
        "appearance": "silvery white metallic",
        "atomic_mass": 226,
        "atomic_number": 88,
        "block": "s-block",
        "boiling_point": 2010,
        "classifications": {
            "cas_number": "CAS7440-14-4",
            "cid_number": "CID6328144"
        },
        "conductivity": {
            "thermal": 19,
            "electric": 1
        },
        "cpk_hex": "007d00",
        "crystal_structure": "Body-centered Cubic",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 5000
        },
        "discovered": {
            "year": 1898,
            "by": "Pierre Curie",
            "location": "France"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 9.6485,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s²",
        "electron_configuration_semantic": "[Rn] 7s²",
        "electronegativity_pauling": 0.9,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 18, 8, 2",
        "group": 2,
        "half_life": 1585.489599188,
        "heat": {
            "specific": 92,
            "vaporization": 125,
            "fusion": 8
        },
        "ionization_energies": [
            509.3,
            979
        ],
        "isotopes_known": "²⁰²Ra, ²⁰³Ra, ²⁰⁴Ra, ²⁰⁵Ra, ²⁰⁶Ra, ²⁰⁷Ra, ²⁰⁸Ra, ²⁰⁹Ra, ²¹⁰Ra, ²¹¹Ra, ²¹²Ra, ²¹³Ra, ²¹⁴Ra, ²¹⁵Ra, ²¹⁶Ra, ²¹⁷Ra, ²¹⁸Ra, ²¹⁹Ra, ²²⁰Ra, ²²¹Ra, ²²²Ra, ²²³Ra, ²²⁴Ra, ²²⁵Ra, ²²⁶Ra, ²²⁷Ra, ²²⁸Ra, ²²⁹Ra, ²³⁰Ra, ²³¹Ra, ²³²Ra, ²³³Ra, ²³⁴Ra",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "514.8, 514.8, 514.8",
        "lifetime": 2314.814814815,
        "melting_point": 1233,
        "molar_volume": 0.0000452,
        "neutron_cross_section": 13,
        "oxidation_states": "2c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "1S0",
        "radius": {
            "empirical": 215
        },
        "resistivity": 0.000001,
        "series": "alkaline earth metal",
        "source": "https://en.wikipedia.org/wiki/Radium",
        "space_group_name": "Im_3m",
        "space_group_number": 229,
        "summary": "<p>Radium is a chemical element with the symbol Ra and atomic number 88. It is the sixth element in group 2 of the periodic table, also known as the alkaline earth metals. Pure radium is silvery-white, but it readily reacts with nitrogen (rather than oxygen) on exposure to air, forming a black surface layer of radium nitride (Ra3N2). All isotopes of radium are highly radioactive, with the most stable isotope being radium-226, which has a half_life of 1600 years and decays into radon gas (specifically the isotope radon-222). When radium decays, ionizing radiation is a by-product, which can excite fluorescent chemicals and cause radioluminescence.</p><p>Radium, in the form of radium chloride, was discovered by Marie and Pierre Curie in 1898 from ore mined at Jáchymov. They extracted the radium compound from uraninite and published the discovery at the French Academy of Sciences five days later. Radium was isolated in its metallic state by Marie Curie and André-Louis Debierne through the electrolysis of radium chloride in 1911.</p><p>In nature, radium is found in uranium and (to a lesser extent) thorium ores in trace amounts as small as a seventh of a gram per ton of uraninite. Radium is not necessary for living organisms, and adverse health effects are likely when it is incorporated into biochemical processes because of its radioactivity and chemical reactivity. Currently, other than its use in nuclear medicine, radium has no commercial applications; formerly, it was used as a radioactive source for radioluminescent devices and also in radioactive quackery for its supposed curative powers. Today, these former applications are no longer in vogue because radium's toxicity has become known, and less dangerous isotopes are used instead in radioluminescent devices.</p>",
        "valence_electrons": 2
    },
    {
        "name": "Actinium",
        "symbol": "Ac",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "human": 0
        },
        "atomic_mass": 227,
        "atomic_number": 89,
        "block": "f-block",
        "boiling_point": 3500,
        "classifications": {
            "cas_number": "CAS7440-34-8"
        },
        "conductivity": {
            "thermal": 12
        },
        "cpk_hex": "70abfa",
        "crystal_structure": "Face-centered Cubic",
        "decay_mode": "BetaDecay",
        "density": {
            "stp": 10070
        },
        "discovered": {
            "year": 1899,
            "by": "Friedrich Oskar Giesel",
            "location": "France"
        },
        "electron_affinity": 33.77,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 6d¹",
        "electron_configuration_semantic": "[Rn] 6d¹ 7s²",
        "electronegativity_pauling": 1.1,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 18, 9, 2",
        "group": 3,
        "half_life": 21.78652968037,
        "heat": {
            "specific": 120,
            "vaporization": 400,
            "fusion": 14,
            "molar": 27.2
        },
        "ionization_energies": [
            499,
            1170
        ],
        "isotopes_known": "²⁰⁶Ac, ²⁰⁷Ac, ²⁰⁸Ac, ²⁰⁹Ac, ²¹⁰Ac, ²¹¹Ac, ²¹²Ac, ²¹³Ac, ²¹⁴Ac, ²¹⁵Ac, ²¹⁶Ac, ²¹⁷Ac, ²¹⁸Ac, ²¹⁹Ac, ²²⁰Ac, ²²¹Ac, ²²²Ac, ²²³Ac, ²²⁴Ac, ²²⁵Ac, ²²⁶Ac, ²²⁷Ac, ²²⁸Ac, ²²⁹Ac, ²³⁰Ac, ²³¹Ac, ²³²Ac, ²³³Ac, ²³⁴Ac, ²³⁵Ac, ²³⁶Ac",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "567, 567, 567",
        "lifetime": 31.43106291223,
        "melting_point": 1500,
        "molar_volume": 0.00002254220456802,
        "neutron_cross_section": 880,
        "neutron_mass_absorption": 0.078,
        "oxidation_states": "2,3c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "2D3/2",
        "radius": {
            "empirical": 195
        },
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Actinium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "summary": "<p>Actinium is a chemical element with the symbol Ac and atomic number 89. It was first isolated by Friedrich Oskar Giesel in 1902, who gave it the name emanium; the element got its name by being wrongly identified with a substance André-Louis Debierne found in 1899 and called actinium. Actinium gave the name to the actinide series, a group of 15 similar elements between actinium and lawrencium in the periodic table. Together with polonium, radium, and radon, actinium was one of the first non-primordial radioactive elements to be isolated.</p><p>A soft, silvery-white radioactive metal, actinium reacts rapidly with oxygen and moisture in air forming a white coating of actinium oxide that prevents further oxidation. As with most lanthanides and many actinides, actinium assumes oxidation state +3 in nearly all its chemical compounds. Actinium is found only in traces in uranium and thorium ores as the isotope 227Ac, which decays with a half_life of 21.772 years, predominantly emitting beta and sometimes alpha particles, and 228Ac, which is beta active with a half_life of 6.15 hours. One tonne of natural uranium in ore contains about 0.2 milligrams of actinium-227, and one tonne of thorium contains about 5 nanograms of actinium-228. The close similarity of physical and chemical properties of actinium and lanthanum makes separation of actinium from the ore impractical. Instead, the element is prepared, in milligram amounts, by the neutron irradiation of 226Ra in a nuclear reactor. Owing to its scarcity, high price and radioactivity, actinium has no significant industrial use. Its current applications include a neutron source and an agent for radiation therapy.</p>",
        "valence_electrons": 3
    },
    {
        "name": "Thorium",
        "symbol": "Th",
        "abundance": {
            "universe": 4e-8,
            "solar": 3e-8,
            "meteor": 0.0000039,
            "crust": 0.0006,
            "ocean": 4e-12,
            "human": 0
        },
        "appearance": "silvery, often with black tarnish",
        "atomic_mass": 232.03774,
        "atomic_number": 90,
        "block": "f-block",
        "boiling_point": 5061,
        "classifications": {
            "cas_number": "CAS7440-29-1",
            "cid_number": "CID23960",
            "rtecs_number": "RTECSXO6400000",
            "dot_numbers": 2975,
            "dot_hazard_class": 7
        },
        "conductivity": {
            "thermal": 54,
            "electric": 6.7
        },
        "cpk_hex": "00baff",
        "crystal_structure": "Face-centered Cubic",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 11724
        },
        "discovered": {
            "year": 1829,
            "by": "Jöns Jakob Berzelius",
            "location": "Sweden"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 112.72,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 6d²",
        "electron_configuration_semantic": "[Rn] 6d² 7s²",
        "electronegativity_pauling": 1.3,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            18,
            10,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 18, 10, 2",
        "group": 3,
        "half_life": 14060121765.6,
        "hardness": {
            "vickers": 350,
            "brinell": 400,
            "mohs": 3
        },
        "heat": {
            "specific": 118,
            "vaporization": 530,
            "fusion": 16,
            "molar": 26.23
        },
        "ionization_energies": [
            587,
            1110,
            1930,
            2780
        ],
        "isotopes_known": "²⁰⁹Th, ²¹⁰Th, ²¹¹Th, ²¹²Th, ²¹³Th, ²¹⁴Th, ²¹⁵Th, ²¹⁶Th, ²¹⁷Th, ²¹⁸Th, ²¹⁹Th, ²²⁰Th, ²²¹Th, ²²²Th, ²²³Th, ²²⁴Th, ²²⁵Th, ²²⁶Th, ²²⁷Th, ²²⁸Th, ²²⁹Th, ²³⁰Th, ²³¹Th, ²³²Th, ²³³Th, ²³⁴Th, ²³⁵Th, ²³⁶Th, ²³⁷Th, ²³⁸Th",
        "isotopes_stable": "²³²Th",
        "isotopic_abundances": "²³²Th: 100%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "508.42, 508.42, 508.42",
        "lifetime": 20284753932.01,
        "magnetic_susceptibility": {
            "mass": 7.2e-9,
            "molar": 1.7e-9,
            "volume": 0.000084
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 2023,
        "modulus": {
            "bulk": 54,
            "shear": 31,
            "young": 79
        },
        "molar_volume": 0.0000197917,
        "neutron_cross_section": 7.4,
        "neutron_mass_absorption": 0.001,
        "oxidation_states": "2,3,4c",
        "period": 7,
        "phase": "Solid",
        "poisson_ratio": 0.27,
        "quantum_numbers": "3F2",
        "radius": {
            "empirical": 180
        },
        "resistivity": 1.5e-7,
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Thorium",
        "space_group_name": "Fm_3m",
        "space_group_number": 225,
        "speed_of_sound": 2490,
        "summary": "<p>Thorium is a weakly radioactive metallic chemical element with the symbol Th and atomic number 90. Thorium is silvery and tarnishes black when it is exposed to air, forming thorium dioxide; it is moderately soft, malleable, and has a high melting point. Thorium is an electropositive actinide whose chemistry is dominated by the +4 oxidation state; it is quite reactive and can ignite in air when finely divided.</p><p>All known thorium isotopes are unstable. The most stable isotope, 232Th, has a half_life of 14.05 billion years, or about the age of the universe; it decays very slowly via alpha decay, starting a decay chain named the thorium series that ends at stable 208Pb. On Earth, thorium and uranium are the only significantly radioactive elements that still occur naturally in large quantities as primordial elements. Thorium is estimated to be over three times as abundant as uranium in the Earth's crust, and is chiefly refined from monazite sands as a by-product of extracting rare-earth metals.</p><p>Thorium was discovered in 1828 by the Norwegian amateur mineralogist Morten Thrane Esmark and identified by the Swedish chemist Jöns Jacob Berzelius, who named it after Thor, the Norse god of thunder. Its first applications were developed in the late 19th century. Thorium's radioactivity was widely acknowledged during the first decades of the 20th century. In the second half of the century, thorium was replaced in many uses due to concerns about its radioactivity.</p><p>Thorium is still being used as an alloying element in TIG welding electrodes but is slowly being replaced in the field with different compositions. It was also material in high-end optics and scientific instrumentation, used in some broadcast vacuum tubes, and as the light source in gas mantles, but these uses have become marginal. It has been suggested as a replacement for uranium as nuclear fuel in nuclear reactors, and several thorium reactors have been built. Thorium is also used in strengthening magnesium, coating tungsten wire in electrical equipment, controlling the grain size of tungsten in electric lamps, high-temperature crucibles, and glasses including camera and scientific instrument lenses. Other uses for thorium include heat-resistant ceramics, aircraft engines, and in light bulbs. Ocean science has utilized (231)Pa/(230)Th isotope ratios to understand the ancient ocean.</p>",
        "superconducting_point": 1.38,
        "thermal_expansion": 0.000011,
        "valence_electrons": 4
    },
    {
        "name": "Protactinium",
        "symbol": "Pa",
        "abundance": {
            "universe": 0,
            "crust": 9.9e-13,
            "ocean": 2e-23,
            "human": 0
        },
        "appearance": "bright, silvery metallic luster",
        "atomic_mass": 231.035882,
        "atomic_number": 91,
        "block": "f-block",
        "boiling_point": 4300,
        "classifications": {
            "cas_number": "CAS7440-13-3"
        },
        "conductivity": {
            "thermal": 47,
            "electric": 5.6
        },
        "cpk_hex": "00a1ff",
        "crystal_structure": "Centered Tetragonal",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 15370
        },
        "discovered": {
            "year": 1913,
            "by": "William Crookes",
            "location": "Germany and The United Kingdom"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 53.03,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f² 6d¹",
        "electron_configuration_semantic": "[Rn] 5f² 6d¹ 7s²",
        "electronegativity_pauling": 1.5,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            20,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 20, 9, 2",
        "group": 3,
        "half_life": 32787.92491121,
        "heat": {
            "specific": 99.1,
            "vaporization": 470,
            "fusion": 15
        },
        "ionization_energies": [
            568
        ],
        "isotopes_known": "²¹²Pa, ²¹³Pa, ²¹⁴Pa, ²¹⁵Pa, ²¹⁶Pa, ²¹⁷Pa, ²¹⁸Pa, ²¹⁹Pa, ²²⁰Pa, ²²¹Pa, ²²²Pa, ²²³Pa, ²²⁴Pa, ²²⁵Pa, ²²⁶Pa, ²²⁷Pa, ²²⁸Pa, ²²⁹Pa, ²³⁰Pa, ²³¹Pa, ²³²Pa, ²³³Pa, ²³⁴Pa, ²³⁵Pa, ²³⁶Pa, ²³⁷Pa, ²³⁸Pa, ²³⁹Pa, ²⁴⁰Pa",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "392.5, 392.5, 323.8",
        "lifetime": 47279.29984779,
        "magnetic_susceptibility": {
            "mass": 3.25e-8,
            "molar": 7.509e-9,
            "volume": 0.0004995
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1841,
        "molar_volume": 0.0000150316,
        "neutron_cross_section": 200,
        "oxidation_states": "2,3,4,5c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "4K11/2",
        "radius": {
            "empirical": 180
        },
        "resistivity": 1.8e-7,
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Protactinium",
        "space_group_name": "I4/mmm",
        "space_group_number": 139,
        "summary": "<p>Protactinium (formerly protoactinium) is a chemical element with the symbol Pa and atomic number 91. It is a dense, silvery-gray actinide metal which readily reacts with oxygen, water vapor and inorganic acids. It forms various chemical compounds in which protactinium is usually present in the oxidation state +5, but it can also assume +4 and even +3 or +2 states. Concentrations of protactinium in the Earth's crust are typically a few parts per trillion, but may reach up to a few parts per million in some uraninite ore deposits. Because of its scarcity, high radioactivity and high toxicity, there are currently no uses for protactinium outside scientific research, and for this purpose, protactinium is mostly extracted from spent nuclear fuel.</p><p>Protactinium was first identified in 1913 by Kazimierz Fajans and Oswald Helmuth Göhring and named brevium because of the short half_life of the specific isotope studied, i.e. protactinium-234. A more stable isotope of protactinium, 231Pa, was discovered in 1917/18 by Otto Hahn and Lise Meitner, and they chose the name proto-actinium, but the IUPAC finally named it \"protactinium\" in 1949 and confirmed Hahn and Meitner as discoverers. The new name meant \"(nuclear) precursor of actinium\" and reflected that actinium is a product of radioactive decay of protactinium. John Arnold Cranston (working with Frederick Soddy and Ada Hitchins) is also credited with discovering the most stable isotope in 1915, but delayed his announcement due to being called up for service in the First World War.</p><p>The longest-lived and most abundant (nearly 100%) naturally occurring isotope of protactinium, protactinium-231, has a half_life of 32,760 years and is a decay product of uranium-235. Much smaller trace amounts of the short-lived protactinium-234 and its nuclear isomer protactinium-234m occur in the decay chain of uranium-238. Protactinium-233 results from the decay of thorium-233 as part of the chain of events used to produce uranium-233 by neutron irradiation of thorium-232. It is an undesired intermediate product in thorium-based nuclear reactors and is therefore removed from the active zone of the reactor during the breeding process. Analysis of the relative concentrations of various uranium, thorium and protactinium isotopes in water and minerals is used in radiometric dating of sediments which are up to 175,000 years old and in modeling of various geological processes. Ocean science utilize the element to understand the ancient ocean.</p>",
        "superconducting_point": 1.41,
        "valence_electrons": 5
    },
    {
        "name": "Uranium",
        "symbol": "U",
        "abundance": {
            "universe": 2e-8,
            "solar": 1e-7,
            "meteor": 9.8e-7,
            "crust": 0.00018,
            "ocean": 3.3e-7,
            "human": 1e-7
        },
        "atomic_mass": 238.028913,
        "atomic_number": 92,
        "block": "f-block",
        "boiling_point": 4404,
        "classifications": {
            "cas_number": "CAS7440-61-1",
            "cid_number": "CID23989",
            "rtecs_number": "RTECSYR3490000",
            "dot_numbers": 2979,
            "dot_hazard_class": 7
        },
        "conductivity": {
            "thermal": 27,
            "electric": 3.6
        },
        "cpk_hex": "008fff",
        "crystal_structure": "Base Orthorhombic",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 19050,
            "liquid": 17300
        },
        "discovered": {
            "year": 1789,
            "by": "Martin Heinrich Klaproth",
            "location": "Germany"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 50.94,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f³ 6d¹",
        "electron_configuration_semantic": "[Rn] 5f³ 6d¹ 7s²",
        "electronegativity_pauling": 1.38,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            21,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 21, 9, 2",
        "group": 3,
        "half_life": 4471080669.711,
        "hardness": {
            "vickers": 1960,
            "brinell": 2400,
            "mohs": 6
        },
        "heat": {
            "specific": 116,
            "vaporization": 420,
            "fusion": 14,
            "molar": 27.665
        },
        "ionization_energies": [
            597.6,
            1420
        ],
        "isotopes_known": "²¹⁷U, ²¹⁸U, ²¹⁹U, ²²⁰U, ²²¹U, ²²²U, ²²³U, ²²⁴U, ²²⁵U, ²²⁶U, ²²⁷U, ²²⁸U, ²²⁹U, ²³⁰U, ²³¹U, ²³²U, ²³³U, ²³⁴U, ²³⁵U, ²³⁶U, ²³⁷U, ²³⁸U, ²³⁹U, ²⁴⁰U, ²⁴¹U, ²⁴²U",
        "isotopes_stable": "None",
        "isotopic_abundances": "²³⁴U: 0.0055%, ²³⁵U: 0.72%, ²³⁸U: 99.2745%",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "285.37, 586.95, 495.48",
        "lifetime": 6449771689.498,
        "magnetic_susceptibility": {
            "mass": 2.16e-8,
            "molar": 5.14e-9,
            "volume": 0.000411
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1405.3,
        "modulus": {
            "bulk": 100,
            "shear": 111,
            "young": 208
        },
        "molar_volume": 0.000012495,
        "neutron_cross_section": 7.57,
        "neutron_mass_absorption": 0.0005,
        "oxidation_states": "2,3,4,5,6c",
        "period": 7,
        "phase": "Solid",
        "poisson_ratio": 0.23,
        "quantum_numbers": "5L6",
        "radius": {
            "empirical": 175,
            "vanderwaals": 186
        },
        "resistivity": 2.8e-7,
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Uranium",
        "space_group_name": "Cmcm",
        "space_group_number": 63,
        "speed_of_sound": 3155,
        "summary": "<p>Uranium is a chemical element with the symbol U and atomic number 92. It is a silvery-grey metal in the actinide series of the periodic table. A uranium atom has 92 protons and 92 electrons, of which 6 are valence electrons. Uranium is weakly radioactive because all isotopes of uranium are unstable; the half-lives of its naturally occurring isotopes range between 159,200 years and 4.5 billion years. The most common isotopes in natural uranium are uranium-238 (which has 146 neutrons and accounts for over 99% of uranium on Earth) and uranium-235 (which has 143 neutrons). Uranium has the highest atomic weight of the primordially occurring elements. Its density is about 70% higher than that of lead, and slightly lower than that of gold or tungsten. It occurs naturally in low concentrations of a few parts per million in soil, rock and water, and is commercially extracted from uranium-bearing minerals such as uraninite.</p><p>In nature, uranium is found as uranium-238 (99.2739–99.2752%), uranium-235 (0.7198–0.7202%), and a very small amount of uranium-234 (0.0050–0.0059%). Uranium decays slowly by emitting an alpha particle. The half_life of uranium-238 is about 4.47 billion years and that of uranium-235 is 704 million years, making them useful in dating the age of the Earth.</p><p>Many contemporary uses of uranium exploit its unique nuclear properties. Uranium-235 is the only naturally occurring fissile isotope, which makes it widely used in nuclear power plants and nuclear weapons. However, because of the tiny amounts found in nature, uranium needs to undergo enrichment so that enough uranium-235 is present. Uranium-238 is fissionable by fast neutrons, and is fertile, meaning it can be transmuted to fissile plutonium-239 in a nuclear reactor. Another fissile isotope, uranium-233, can be produced from natural thorium and is studied for future industrial use in nuclear technology. Uranium-238 has a small probability for spontaneous fission or even induced fission with fast neutrons; uranium-235 and to a lesser degree uranium-233 have a much higher fission cross-section for slow neutrons. In sufficient concentration, these isotopes maintain a sustained nuclear chain reaction. This generates the heat in nuclear power reactors, and produces the fissile material for nuclear weapons. Depleted uranium (238U) is used in kinetic energy penetrators and armor plating. Uranium is used as a colorant in uranium glass, producing lemon yellow to green colors. Uranium glass fluoresces green in ultraviolet light. It was also used for tinting and shading in early photography.</p><p>The 1789 discovery of uranium in the mineral pitchblende is credited to Martin Heinrich Klaproth, who named the new element after the recently discovered planet Uranus. Eugène-Melchior Péligot was the first person to isolate the metal and its radioactive properties were discovered in 1896 by Henri Becquerel. Research by Otto Hahn, Lise Meitner, Enrico Fermi and others, such as J. Robert Oppenheimer starting in 1934 led to its use as a fuel in the nuclear power industry and in Little Boy, the first nuclear weapon used in war. An ensuing arms race during the Cold War between the United States and the Soviet Union produced tens of thousands of nuclear weapons that used uranium metal and uranium-derived plutonium-239. The security of those weapons is closely monitored. Since around 2000, plutonium obtained by dismantling cold war era bombs is used as fuel for nuclear reactors.</p><p>The development and deployment of these nuclear reactors continue on a global base. There is increasing interest in these power plants as they are powerful sources of CO2-free energy. In 2019, 440 nuclear power reactors produced 2586 TWh (billion kWh) of CO2-free electricity worldwide, more than the global installations of solar and wind power combined.</p>",
        "superconducting_point": 0.69,
        "thermal_expansion": 0.0000139,
        "valence_electrons": 6
    },
    {
        "name": "Neptunium",
        "symbol": "Np",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "silvery metallic",
        "atomic_mass": 237,
        "atomic_number": 93,
        "block": "f-block",
        "boiling_point": 4447,
        "classifications": {
            "cas_number": "CAS7439-99-8"
        },
        "conductivity": {
            "thermal": 6,
            "electric": 0.83
        },
        "cpk_hex": "0080ff",
        "crystal_structure": "Simple Orthorhombic",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 20450
        },
        "discovered": {
            "year": 1940,
            "by": "Edwin McMillan",
            "location": "The United States"
        },
        "electrical_type": "Conductor",
        "electron_affinity": 45.85,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁴ 6d¹",
        "electron_configuration_semantic": "[Rn] 5f⁴ 6d¹ 7s²",
        "electronegativity_pauling": 1.36,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            22,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 22, 9, 2",
        "group": 3,
        "half_life": 2145484.525622,
        "heat": {
            "vaporization": 335,
            "fusion": 10,
            "molar": 29.46
        },
        "ionization_energies": [
            604.5
        ],
        "isotopes_known": "²²⁵Np, ²²⁶Np, ²²⁷Np, ²²⁸Np, ²²⁹Np, ²³⁰Np, ²³¹Np, ²³²Np, ²³³Np, ²³⁴Np, ²³⁵Np, ²³⁶Np, ²³⁷Np, ²³⁸Np, ²³⁹Np, ²⁴⁰Np, ²⁴¹Np, ²⁴²Np, ²⁴³Np, ²⁴⁴Np",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, π/2",
        "lattice_constants": "666.3, 472.3, 488.7",
        "lifetime": 3095192.795535,
        "melting_point": 912,
        "molar_volume": 0.00001158924205379,
        "neutron_cross_section": 180,
        "oxidation_states": "3,4,5c,6,7",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "6L11/2",
        "radius": {
            "empirical": 175
        },
        "resistivity": 0.0000012,
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Neptunium",
        "space_group_name": "Pnma",
        "space_group_number": 62,
        "summary": "<p>Neptunium is a chemical element with the symbol Np and atomic number 93. A radioactive actinide metal, neptunium is the first transuranic element. Its position in the periodic table just after uranium, named after the planet Uranus, led to it being named after Neptune, the next planet beyond Uranus. A neptunium atom has 93 protons and 93 electrons, of which seven are valence electrons. Neptunium metal is silvery and tarnishes when exposed to air. The element occurs in three allotropic forms and it normally exhibits five oxidation states, ranging from +3 to +7. It is radioactive, poisonous, pyrophoric, and capable of accumulating in bones, which makes the handling of neptunium dangerous.</p><p>Although many false claims of its discovery were made over the years, the element was first synthesized by Edwin McMillan and Philip H. Abelson at the Berkeley Radiation Laboratory in 1940. Since then, most neptunium has been and still is produced by neutron irradiation of uranium in nuclear reactors. The vast majority is generated as a by-product in conventional nuclear power reactors. While neptunium itself has no commercial uses at present, it is used as a precursor for the formation of plutonium-238, and in radioisotope thermal generators to provide electricity for spacecraft. Neptunium has also been used in detectors of high-energy neutrons.</p><p>The longest-lived isotope of neptunium, neptunium-237, is a by-product of nuclear reactors and plutonium production. It, and the isotope neptunium-239, are also found in trace amounts in uranium ores due to neutron capture reactions and beta decay.</p>",
        "valence_electrons": 6
    },
    {
        "name": "Plutonium",
        "symbol": "Pu",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "silvery white, tarnishing to dark gray in air",
        "atomic_mass": 244,
        "atomic_number": 94,
        "block": "f-block",
        "boiling_point": 3505,
        "classifications": {
            "cas_number": "CAS7440-07-5",
            "cid_number": "CID23940"
        },
        "conductivity": {
            "thermal": 6,
            "electric": 0.67
        },
        "cpk_hex": "006bff",
        "crystal_structure": "Simple Monoclinic",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 19816,
            "liquid": 16630
        },
        "discovered": {
            "year": 1940,
            "by": "Glenn T. Seaborg",
            "location": "The United States"
        },
        "electrical_type": "Conductor",
        "electron_affinity": -48.33,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁶",
        "electron_configuration_semantic": "[Rn] 5f⁶ 7s²",
        "electronegativity_pauling": 1.28,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            24,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 24, 8, 2",
        "group": 3,
        "half_life": 79274479.95941,
        "heat": {
            "vaporization": 325,
            "molar": 35.5
        },
        "ionization_energies": [
            584.7
        ],
        "isotopes_known": "²²⁸Pu, ²²⁹Pu, ²³⁰Pu, ²³¹Pu, ²³²Pu, ²³³Pu, ²³⁴Pu, ²³⁵Pu, ²³⁶Pu, ²³⁷Pu, ²³⁸Pu, ²³⁹Pu, ²⁴⁰Pu, ²⁴¹Pu, ²⁴²Pu, ²⁴³Pu, ²⁴⁴Pu, ²⁴⁵Pu, ²⁴⁶Pu, ²⁴⁷Pu",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, 1.776571, π/2",
        "lattice_constants": "618.3, 482.2, 1096.3",
        "lifetime": 114155251.1416,
        "magnetic_susceptibility": {
            "mass": 3.17e-8,
            "molar": 7.735e-9,
            "volume": 0.0006282
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 912.5,
        "modulus": {
            "shear": 43,
            "young": 96
        },
        "molar_volume": 0.00001231328219621,
        "neutron_cross_section": 1.7,
        "oxidation_states": "3,4c,5,6,7,8",
        "period": 7,
        "phase": "Solid",
        "poisson_ratio": 0.21,
        "quantum_numbers": "7F0",
        "radius": {
            "empirical": 175
        },
        "resistivity": 0.0000015,
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Plutonium",
        "space_group_name": "P121/m1",
        "space_group_number": 11,
        "speed_of_sound": 2260,
        "summary": "<p>Plutonium is a radioactive chemical element with the symbol Pu and atomic number 94. It is an actinide metal of silvery-gray appearance that tarnishes when exposed to air, and forms a dull coating when oxidized. The element normally exhibits six allotropes and four oxidation states. It reacts with carbon, halogens, nitrogen, silicon, and hydrogen. When exposed to moist air, it forms oxides and hydrides that can expand the sample up to 70% in volume, which in turn flake off as a powder that is pyrophoric. It is radioactive and can accumulate in bones, which makes the handling of plutonium dangerous.</p><p>Plutonium was first synthetically produced and isolated in late 1940 and early 1941, by a deuteron bombardment of uranium-238 in the 1.5-metre (60 in) cyclotron at the University of California, Berkeley. First, neptunium-238 (half_life 2.1 days) was synthesized, which subsequently beta-decayed to form the new element with atomic number 94 and atomic weight 238 (half_life 88 years). Since uranium had been named after the planet Uranus and neptunium after the planet Neptune, element 94 was named after Pluto, which at the time was considered to be a planet as well. Wartime secrecy prevented the University of California team from publishing its discovery until 1948.</p><p>Plutonium is the element with the highest atomic number to occur in nature. Trace quantities arise in natural uranium-238 deposits when uranium-238 captures neutrons emitted by decay of other uranium-238 atoms.</p><p>Both plutonium-239 and plutonium-241 are fissile, meaning that they can sustain a nuclear chain reaction, leading to applications in nuclear weapons and nuclear reactors. Plutonium-240 exhibits a high rate of spontaneous fission, raising the neutron flux of any sample containing it. The presence of plutonium-240 limits a plutonium sample's usability for weapons or its quality as reactor fuel, and the percentage of plutonium-240 determines its grade (weapons-grade, fuel-grade, or reactor-grade). Plutonium-238 has a half_life of 87.7 years and emits alpha particles. It is a heat source in radioisotope thermoelectric generators, which are used to power some spacecraft. Plutonium isotopes are expensive and inconvenient to separate, so particular isotopes are usually manufactured in specialized reactors.</p><p>Producing plutonium in useful quantities for the first time was a major part of the Manhattan Project during World War II that developed the first atomic bombs. The Fat Man bombs used in the Trinity nuclear test in July 1945, and in the bombing of Nagasaki in August 1945, had plutonium cores. Human radiation experiments studying plutonium were conducted without informed consent, and several criticality accidents, some lethal, occurred after the war. Disposal of plutonium waste from nuclear power plants and dismantled nuclear weapons built during the Cold War is a nuclear-proliferation and environmental concern. Other sources of plutonium in the environment are fallout from numerous above-ground nuclear tests, now banned.</p>",
        "valence_electrons": 6
    },
    {
        "name": "Americium",
        "symbol": "Am",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "silvery white",
        "atomic_mass": 243,
        "atomic_number": 95,
        "block": "f-block",
        "boiling_point": 2880,
        "classifications": {
            "cas_number": "CAS7440-35-9"
        },
        "conductivity": {
            "thermal": 10
        },
        "cpk_hex": "545cf2",
        "crystal_structure": "Simple Hexagonal",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 13670
        },
        "discovered": {
            "year": 1944,
            "by": "Glenn T. Seaborg",
            "location": "The United States"
        },
        "electron_affinity": 9.93,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁷",
        "electron_configuration_semantic": "[Rn] 5f⁷ 7s²",
        "electronegativity_pauling": 1.13,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            25,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 25, 8, 2",
        "group": 3,
        "half_life": 7388.381532217,
        "heat": {
            "molar": 62.7
        },
        "ionization_energies": [
            578
        ],
        "isotopes_known": "²³¹Am, ²³²Am, ²³³Am, ²³⁴Am, ²³⁵Am, ²³⁶Am, ²³⁷Am, ²³⁸Am, ²³⁹Am, ²⁴⁰Am, ²⁴¹Am, ²⁴²Am, ²⁴³Am, ²⁴⁴Am, ²⁴⁵Am, ²⁴⁶Am, ²⁴⁷Am, ²⁴⁸Am, ²⁴⁹Am",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "346.81, 346.81, 1124.1",
        "lifetime": 10654.49010654,
        "magnetic_susceptibility": {
            "mass": 5.15e-8,
            "molar": 1.251e-8,
            "volume": 0.000704
        },
        "magnetic_type": "paramagnetic",
        "melting_point": 1449,
        "molar_volume": 0.00001777615215801,
        "neutron_cross_section": 74,
        "oxidation_states": "2,3c,4,5,6",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "8S7/2",
        "radius": {
            "empirical": 175
        },
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Americium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "summary": "<p>Americium is a synthetic radioactive chemical element with the symbol Am and atomic number 95. It is a transuranic member of the actinide series, in the periodic table located under the lanthanide element europium, and thus by analogy was named after the Americas.</p><p>Americium was first produced in 1944 by the group of Glenn T. Seaborg from Berkeley, California, at the Metallurgical Laboratory of the University of Chicago, as part of the Manhattan Project. Although it is the third element in the transuranic series, it was discovered fourth, after the heavier curium. The discovery was kept secret and only released to the public in November 1945. Most americium is produced by uranium or plutonium being bombarded with neutrons in nuclear reactors – one tonne of spent nuclear fuel contains about 100 grams of americium. It is widely used in commercial ionization chamber smoke detectors, as well as in neutron sources and industrial gauges. Several unusual applications, such as nuclear batteries or fuel for space ships with nuclear propulsion, have been proposed for the isotope 242mAm, but they are as yet hindered by the scarcity and high price of this nuclear isomer.</p><p>Americium is a relatively soft radioactive metal with silvery appearance. Its most common isotopes are 241Am and 243Am. In chemical compounds, americium usually assumes the oxidation state +3, especially in solutions. Several other oxidation states are known, ranging from +2 to +7, and can be identified by their characteristic optical absorption spectra. The crystal lattice of solid americium and its compounds contain small intrinsic radiogenic defects, due to metamictization induced by self-irradiation with alpha particles, which accumulates with time; this can cause a drift of some material properties over time, more noticeable in older samples.</p>",
        "superconducting_point": 0.6,
        "valence_electrons": 4
    },
    {
        "name": "Curium",
        "symbol": "Cm",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "silvery metallic, glows purple in the dark",
        "atomic_mass": 247,
        "atomic_number": 96,
        "block": "f-block",
        "boiling_point": 3383,
        "classifications": {
            "cas_number": "CAS7440-51-9"
        },
        "cpk_hex": "785ce3",
        "crystal_structure": "Simple Hexagonal",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 13510
        },
        "discovered": {
            "year": 1944,
            "by": "Glenn T. Seaborg",
            "location": "The United States"
        },
        "electron_affinity": 27.17,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁷ 6d¹",
        "electron_configuration_semantic": "[Rn] 5f⁷ 6d¹ 7s²",
        "electronegativity_pauling": 1.28,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            25,
            9,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 25, 9, 2",
        "group": 3,
        "half_life": 15601217.65601,
        "ionization_energies": [
            581
        ],
        "isotopes_known": "²³³Cm, ²³⁴Cm, ²³⁵Cm, ²³⁶Cm, ²³⁷Cm, ²³⁸Cm, ²³⁹Cm, ²⁴⁰Cm, ²⁴¹Cm, ²⁴²Cm, ²⁴³Cm, ²⁴⁴Cm, ²⁴⁵Cm, ²⁴⁶Cm, ²⁴⁷Cm, ²⁴⁸Cm, ²⁴⁹Cm, ²⁵⁰Cm, ²⁵¹Cm, ²⁵²Cm",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "349.6, 349.6, 1133.1",
        "lifetime": 22513952.30847,
        "melting_point": 1613,
        "molar_volume": 0.00001828275351591,
        "neutron_cross_section": 60,
        "oxidation_states": "3c,4",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "9D2",
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Curium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "summary": "<p>Curium is a transuranic radioactive chemical element with the symbol Cm and atomic number 96. This element of the actinide series was named after Marie and Pierre Curie, both known for their research on radioactivity. Curium was first intentionally produced and identified in July 1944 by the group of Glenn T. Seaborg at the University of California, Berkeley. The discovery was kept secret and only released to the public in November 1947. Most curium is produced by bombarding uranium or plutonium with neutrons in nuclear reactors – one tonne of spent nuclear fuel contains about 20 grams of curium.</p><p>Curium is a hard, dense, silvery metal with a relatively high melting point and boiling point for an actinide. Whereas it is paramagnetic at ambient conditions, it becomes antiferromagnetic upon cooling, and other magnetic transitions are also observed for many curium compounds. In compounds, curium usually exhibits valence +3 and sometimes +4, and the +3 valence is predominant in solutions. Curium readily oxidizes, and its oxides are a dominant form of this element. It forms strongly fluorescent complexes with various organic compounds, but there is no evidence of its incorporation into bacteria and archaea. When introduced into the human body, curium accumulates in the bones, lungs and liver, where it promotes cancer.</p><p>All known isotopes of curium are radioactive and have a small critical mass for a sustained nuclear chain reaction. They predominantly emit α-particles, and the heat released in this process can serve as a heat source in radioisotope thermoelectric generators, but this application is hindered by the scarcity and high cost of curium isotopes. Curium is used in production of heavier actinides and of the 238Pu radionuclide for power sources in artificial pacemakers and RTGs for spacecraft. It served as the α-source in the alpha particle X-ray spectrometers installed on several space probes, including the Sojourner, Spirit, Opportunity and Curiosity Mars rovers and the Philae lander on comet 67P/Churyumov–Gerasimenko, to analyze the composition and structure of the surface.</p>",
        "valence_electrons": 4
    },
    {
        "name": "Berkelium",
        "symbol": "Bk",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "silvery",
        "atomic_mass": 247,
        "atomic_number": 97,
        "block": "f-block",
        "boiling_point": 2900,
        "classifications": {
            "cas_number": "CAS7440-40-6",
            "cid_number": "CID23971"
        },
        "conductivity": {
            "thermal": 10
        },
        "cpk_hex": "8a4fe3",
        "crystal_structure": "Simple Hexagonal",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 14780
        },
        "discovered": {
            "year": 1949,
            "by": "Lawrence Berkeley National Laboratory",
            "location": "The United States"
        },
        "electron_affinity": -165.24,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f⁹",
        "electron_configuration_semantic": "[Rn] 5f⁹ 7s²",
        "electronegativity_pauling": 1.3,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            27,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 27, 8, 2",
        "group": 3,
        "half_life": 1379.375951294,
        "ionization_energies": [
            601
        ],
        "isotopes_known": "²³⁵Bk, ²³⁶Bk, ²³⁷Bk, ²³⁸Bk, ²³⁹Bk, ²⁴⁰Bk, ²⁴¹Bk, ²⁴²Bk, ²⁴³Bk, ²⁴⁴Bk, ²⁴⁵Bk, ²⁴⁶Bk, ²⁴⁷Bk, ²⁴⁸Bk, ²⁴⁹Bk, ²⁵⁰Bk, ²⁵¹Bk, ²⁵²Bk, ²⁵³Bk, ²⁵⁴Bk",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "341.6, 341.6, 1106.9",
        "lifetime": 1991.37493658,
        "melting_point": 1259,
        "molar_volume": 0.00001671177266576,
        "neutron_cross_section": 710,
        "oxidation_states": "3c,4",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "6H15/2",
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Berkelium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "summary": "<p>Berkelium is a transuranic radioactive chemical element with the symbol Bk and atomic number 97. It is a member of the actinide and transuranium element series. It is named after the city of Berkeley, California, the location of the Lawrence Berkeley National Laboratory (then the University of California Radiation Laboratory) where it was discovered in December 1949. Berkelium was the fifth transuranium element discovered after neptunium, plutonium, curium and americium.</p><p>The major isotope of berkelium, 249Bk, is synthesized in minute quantities in dedicated high-flux nuclear reactors, mainly at the Oak Ridge National Laboratory in Tennessee, USA, and at the Research Institute of Atomic Reactors in Dimitrovgrad, Russia. The production of the second-most important isotope, 247Bk, involves the irradiation of the rare isotope 244Cm with high-energy alpha particles.</p><p>Just over one gram of berkelium has been produced in the United States since 1967. There is no practical application of berkelium outside scientific research which is mostly directed at the synthesis of heavier transuranic elements and transactinides. A 22-milligram batch of berkelium-249 was prepared during a 250-day irradiation period and then purified for a further 90 days at Oak Ridge in 2009. This sample was used to synthesize the new element tennessine for the first time in 2009 at the Joint Institute for Nuclear Research, Russia, after it was bombarded with calcium-48 ions for 150 days. This was the culmination of the Russia–US collaboration on the synthesis of the heaviest elements on the periodic table.</p><p>Berkelium is a soft, silvery-white, radioactive metal. The berkelium-249 isotope emits low-energy electrons and thus is relatively safe to handle. It decays with a half_life of 330 days to californium-249, which is a strong emitter of ionizing alpha particles. This gradual transformation is an important consideration when studying the properties of elemental berkelium and its chemical compounds, since the formation of californium brings not only chemical contamination, but also free-radical effects and self-heating from the emitted alpha particles.</p>",
        "valence_electrons": 4
    },
    {
        "name": "Californium",
        "symbol": "Cf",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "silvery",
        "atomic_mass": 251,
        "atomic_number": 98,
        "block": "f-block",
        "boiling_point": 1743,
        "classifications": {
            "cas_number": "CAS7440-71-3"
        },
        "cpk_hex": "a136d4",
        "crystal_structure": "Simple Hexagonal",
        "decay_mode": "AlphaEmission",
        "density": {
            "stp": 15100
        },
        "discovered": {
            "year": 1950,
            "by": "Lawrence Berkeley National Laboratory",
            "location": "The United States"
        },
        "electron_affinity": -97.31,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁰",
        "electron_configuration_semantic": "[Rn] 5f¹⁰ 7s²",
        "electronegativity_pauling": 1.3,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            28,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 28, 8, 2",
        "group": 3,
        "half_life": 900.5580923389,
        "ionization_energies": [
            608
        ],
        "isotopes_known": "²³⁷Cf, ²³⁸Cf, ²³⁹Cf, ²⁴⁰Cf, ²⁴¹Cf, ²⁴²Cf, ²⁴³Cf, ²⁴⁴Cf, ²⁴⁵Cf, ²⁴⁶Cf, ²⁴⁷Cf, ²⁴⁸Cf, ²⁴⁹Cf, ²⁵⁰Cf, ²⁵¹Cf, ²⁵²Cf, ²⁵³Cf, ²⁵⁴Cf, ²⁵⁵Cf, ²⁵⁶Cf",
        "isotopes_stable": "None",
        "lattice_angles": "π/2, π/2, 2 π/3",
        "lattice_constants": "338, 338, 1102.5",
        "lifetime": 1300.101471334,
        "melting_point": 1173,
        "molar_volume": 0.00001662251655629,
        "neutron_cross_section": 2900,
        "oxidation_states": "2,3c,4",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "5I8",
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Californium",
        "space_group_name": "P63/mmc",
        "space_group_number": 194,
        "summary": "<p>Californium is a radioactive chemical element with the symbol Cf and atomic number 98. The element was first synthesized in 1950 at the Lawrence Berkeley National Laboratory (then the University of California Radiation Laboratory), by bombarding curium with alpha particles (helium-4 ions). It is an actinide element, the sixth transuranium element to be synthesized, and has the second-highest atomic mass of all the elements that have been produced in amounts large enough to see with the unaided eye (after einsteinium). The element was named after the university and the U.S. state of California.</p><p>Two crystalline forms exist for californium under normal pressure: one above and one below 900 °C (1,650 °F). A third form exists at high pressure. Californium slowly tarnishes in air at room temperature. Compounds of californium are dominated by the +3 oxidation state. The most stable of californium's twenty known isotopes is californium-251, which has a half_life of 898 years. This short half_life means the element is not found in significant quantities in the Earth's crust. Californium-252, with a half_life of about 2.645 years, is the most common isotope used and is produced at the Oak Ridge National Laboratory in the United States and the Research Institute of Atomic Reactors in Russia.</p><p>Californium is one of the few transuranium elements that have practical applications. Most of these applications exploit the property of certain isotopes of californium to emit neutrons. For example, californium can be used to help start up nuclear reactors, and it is employed as a source of neutrons when studying materials using neutron diffraction and neutron spectroscopy. Californium can also be used in nuclear synthesis of higher mass elements; oganesson (element 118) was synthesized by bombarding californium-249 atoms with calcium-48 ions. Users of californium must take into account radiological concerns and the element's ability to disrupt the formation of red blood cells by bioaccumulating in skeletal tissue.</p>",
        "valence_electrons": 4
    },
    {
        "name": "Einsteinium",
        "symbol": "Es",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "appearance": "silver-colored",
        "atomic_mass": 252,
        "atomic_number": 99,
        "block": "f-block",
        "boiling_point": 1269,
        "classifications": {
            "cas_number": "CAS7429-92-7"
        },
        "cpk_hex": "b31fd4",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1952,
            "by": "Lawrence Berkeley National Laboratory",
            "location": "The United States"
        },
        "electron_affinity": -28.6,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹¹",
        "electron_configuration_semantic": "[Rn] 5f¹¹ 7s²",
        "electronegativity_pauling": 1.3,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            29,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 29, 8, 2",
        "group": 3,
        "half_life": 1.292174023338,
        "ionization_energies": [
            619
        ],
        "isotopes_known": "²⁴⁰Es, ²⁴¹Es, ²⁴²Es, ²⁴³Es, ²⁴⁴Es, ²⁴⁵Es, ²⁴⁶Es, ²⁴⁷Es, ²⁴⁸Es, ²⁴⁹Es, ²⁵⁰Es, ²⁵¹Es, ²⁵²Es, ²⁵³Es, ²⁵⁴Es, ²⁵⁵Es, ²⁵⁶Es, ²⁵⁷Es, ²⁵⁸Es",
        "isotopes_stable": "None",
        "lifetime": 1.864535768645,
        "melting_point": 1133,
        "neutron_cross_section": 160,
        "oxidation_states": "2,3c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "5I15/2",
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Einsteinium",
        "summary": "<p>Einsteinium is a synthetic element with the symbol Es and atomic number 99. Einsteinium is a member of the actinide series and it is the seventh transuranic element. It was named in honor of Albert Einstein.</p><p>Einsteinium was discovered as a component of the debris of the first hydrogen bomb explosion in 1952. Its most common isotope einsteinium-253 (half_life 20.47 days) is produced artificially from decay of californium-253 in a few dedicated high-power nuclear reactors with a total yield on the order of one milligram per year. The reactor synthesis is followed by a complex process of separating einsteinium-253 from other actinides and products of their decay. Other isotopes are synthesized in various laboratories, but in much smaller amounts, by bombarding heavy actinide elements with light ions. Owing to the small amounts of produced einsteinium and the short half_life of its most easily produced isotope, there are currently almost no practical applications for it outside basic scientific research. In particular, einsteinium was used to synthesize, for the first time, 17 atoms of the new element mendelevium in 1955.</p><p>Einsteinium is a soft, silvery, paramagnetic metal. Its chemistry is typical of the late actinides, with a preponderance of the +3 oxidation state; the +2 oxidation state is also accessible, especially in solids. The high radioactivity of einsteinium-253 produces a visible glow and rapidly damages its crystalline metal lattice, with released heat of about 1000 watts per gram. Difficulty in studying its properties is due to einsteinium-253's decay to berkelium-249 and then californium-249 at a rate of about 3% per day. The isotope of einsteinium with the longest half_life, einsteinium-252 (half_life 471.7 days) would be more suitable for investigation of physical properties, but it has proven far more difficult to produce and is available only in minute quantities, and not in bulk. Einsteinium is the element with the highest atomic number which has been observed in macroscopic quantities in its pure form, and this was the common short-lived isotope einsteinium-253.</p><p>Like all synthetic transuranic elements, isotopes of einsteinium are very radioactive and are considered highly dangerous to health on ingestion.</p>",
        "valence_electrons": 4
    },
    {
        "name": "Fermium",
        "symbol": "Fm",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 257,
        "atomic_number": 100,
        "block": "f-block",
        "classifications": {
            "cas_number": "CAS7440-72-4"
        },
        "cpk_hex": "b31fba",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1952,
            "by": "Lawrence Berkeley National Laboratory",
            "location": "The United States"
        },
        "electron_affinity": 33.96,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹²",
        "electron_configuration_semantic": "[Rn] 5f¹² 7s²",
        "electronegativity_pauling": 1.3,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            30,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 30, 8, 2",
        "group": 3,
        "half_life": 100.4976851852,
        "ionization_energies": [
            627
        ],
        "isotopes_known": "²⁴²Fm, ²⁴³Fm, ²⁴⁴Fm, ²⁴⁵Fm, ²⁴⁶Fm, ²⁴⁷Fm, ²⁴⁸Fm, ²⁴⁹Fm, ²⁵⁰Fm, ²⁵¹Fm, ²⁵²Fm, ²⁵³Fm, ²⁵⁴Fm, ²⁵⁵Fm, ²⁵⁶Fm, ²⁵⁷Fm, ²⁵⁸Fm, ²⁵⁹Fm, ²⁶⁰Fm",
        "isotopes_stable": "None",
        "lifetime": 145.0231481481,
        "melting_point": 1800,
        "neutron_cross_section": 5800,
        "oxidation_states": "2,3c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "3H6",
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Fermium",
        "summary": "<p>Fermium is a synthetic element with the symbol Fm and atomic number 100. It is an actinide and the heaviest element that can be formed by neutron bombardment of lighter elements, and hence the last element that can be prepared in macroscopic quantities, although pure fermium metal has not yet been prepared. A total of 19 isotopes are known, with 257Fm being the longest-lived with a half_life of 100.5 days.</p><p>It was discovered in the debris of the first hydrogen bomb explosion in 1952, and named after Enrico Fermi, one of the pioneers of nuclear physics. Its chemistry is typical for the late actinides, with a preponderance of the +3 oxidation state but also an accessible +2 oxidation state. Owing to the small amounts of produced fermium and all of its isotopes having relatively short half-lives, there are currently no uses for it outside basic scientific research.</p>",
        "valence_electrons": 3
    },
    {
        "name": "Mendelevium",
        "symbol": "Md",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 258,
        "atomic_number": 101,
        "block": "f-block",
        "classifications": {
            "cas_number": "CAS7440-11-1"
        },
        "cpk_hex": "b30da6",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1955,
            "by": "Lawrence Berkeley National Laboratory",
            "location": "The United States"
        },
        "electron_affinity": 93.91,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹³",
        "electron_configuration_semantic": "[Rn] 5f¹³ 7s²",
        "electronegativity_pauling": 1.3,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            31,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 31, 8, 2",
        "group": 3,
        "half_life": 51.50462962963,
        "ionization_energies": [
            635
        ],
        "isotopes_known": "²⁴⁵Md, ²⁴⁶Md, ²⁴⁷Md, ²⁴⁸Md, ²⁴⁹Md, ²⁵⁰Md, ²⁵¹Md, ²⁵²Md, ²⁵³Md, ²⁵⁴Md, ²⁵⁵Md, ²⁵⁶Md, ²⁵⁷Md, ²⁵⁸Md, ²⁵⁹Md, ²⁶⁰Md, ²⁶¹Md, ²⁶²Md",
        "isotopes_stable": "None",
        "lifetime": 74.30555555556,
        "melting_point": 1100,
        "oxidation_states": "2,3c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "2F7/2",
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Mendelevium",
        "summary": "<p>Mendelevium is a synthetic element with the symbol Md (formerly Mv) and atomic number 101. A metallic radioactive transuranium element in the actinide series, it is the first element by atomic number that currently cannot be produced in macroscopic quantities through neutron bombardment of lighter elements. It is the third-to-last actinide and the ninth transuranic element. It can only be produced in particle accelerators by bombarding lighter elements with charged particles. A total of seventeen mendelevium isotopes are known, the most stable being 258Md with a half_life of 51 days; nevertheless, the shorter-lived 256Md (half_life 1.17 hours) is most commonly used in chemistry because it can be produced on a larger scale.</p><p>Mendelevium was discovered by bombarding einsteinium with alpha particles in 1955, the same method still used to produce it today. It was named after Dmitri Mendeleev, father of the periodic table of the chemical elements. Using available microgram quantities of the isotope einsteinium-253, over a million mendelevium atoms may be produced each hour. The chemistry of mendelevium is typical for the late actinides, with a preponderance of the +3 oxidation state but also an accessible +2 oxidation state. All known isotopes of mendelevium have relatively short half-lives; there are currently no uses for it outside basic scientific research, and only small amounts are produced.</p>",
        "valence_electrons": 3
    },
    {
        "name": "Nobelium",
        "symbol": "No",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 259,
        "atomic_number": 102,
        "block": "f-block",
        "classifications": {
            "cas_number": "CAS10028-14-5"
        },
        "cpk_hex": "bd0d87",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1958,
            "by": "Joint Institute for Nuclear Research",
            "location": "Sweden and The United States"
        },
        "electron_affinity": -223.22,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴",
        "electron_configuration_semantic": "[Rn] 5f¹⁴ 7s²",
        "electronegativity_pauling": 1.3,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            8,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 8, 2",
        "group": 3,
        "half_life": 2.777777777778,
        "ionization_energies": [
            642
        ],
        "isotopes_known": "²⁴⁸No, ²⁴⁹No, ²⁵⁰No, ²⁵¹No, ²⁵²No, ²⁵³No, ²⁵⁴No, ²⁵⁵No, ²⁵⁶No, ²⁵⁷No, ²⁵⁸No, ²⁵⁹No, ²⁶⁰No, ²⁶¹No, ²⁶²No, ²⁶³No, ²⁶⁴No",
        "isotopes_stable": "None",
        "lifetime": 5.555555555556,
        "melting_point": 1100,
        "oxidation_states": "2c,3",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "1S0",
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Nobelium",
        "summary": "<p>Nobelium is a synthetic chemical element with the symbol No and atomic number 102. It is named in honor of Alfred Nobel, the inventor of dynamite and benefactor of science. A radioactive metal, it is the tenth transuranic element and is the penultimate member of the actinide series. Like all elements with atomic number over 100, nobelium can only be produced in particle accelerators by bombarding lighter elements with charged particles. A total of twelve nobelium isotopes are known to exist; the most stable is 259No with a half_life of 58 minutes, but the shorter-lived 255No (half_life 3.1 minutes) is most commonly used in chemistry because it can be produced on a larger scale.</p><p>Chemistry experiments have confirmed that nobelium behaves as a heavier homolog to ytterbium in the periodic table. The chemical properties of nobelium are not completely known: they are mostly only known in aqueous solution. Before nobelium's discovery, it was predicted that it would show a stable +2 oxidation state as well as the +3 state characteristic of the other actinides: these predictions were later confirmed, as the +2 state is much more stable than the +3 state in aqueous solution and it is difficult to keep nobelium in the +3 state.</p><p>In the 1950s and 1960s, many claims of the discovery of nobelium were made from laboratories in Sweden, the Soviet Union, and the United States. Although the Swedish scientists soon retracted their claims, the priority of the discovery and therefore the naming of the element was disputed between Soviet and American scientists, and it was not until 1997 that the International Union of Pure and Applied Chemistry (IUPAC) credited the Soviet team with the discovery, but retained nobelium, the Swedish proposal, as the name of the element due to its long-standing use in the literature.</p>",
        "valence_electrons": 3
    },
    {
        "name": "Lawrencium",
        "symbol": "Lr",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 266,
        "atomic_number": 103,
        "block": "d-block",
        "classifications": {
            "cas_number": "CAS22537-19-5"
        },
        "cpk_hex": "c70066",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1961,
            "by": "Lawrence Berkeley National Laboratory",
            "location": "The United States"
        },
        "electron_affinity": -30.04,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 7p¹",
        "electron_configuration_semantic": "[Rn] 5f¹⁴ 7s² 7p¹",
        "electronegativity_pauling": 1.3,
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            8,
            3
        ],
        "energy_levels": "2, 8, 18, 32, 32, 8, 3",
        "group": 3,
        "half_life": 10,
        "ionization_energies": [
            470
        ],
        "isotopes_known": "²⁵¹Lr, ²⁵²Lr, ²⁵³Lr, ²⁵⁴Lr, ²⁵⁵Lr, ²⁵⁶Lr, ²⁵⁷Lr, ²⁵⁸Lr, ²⁵⁹Lr, ²⁶⁰Lr, ²⁶¹Lr, ²⁶²Lr, ²⁶³Lr, ²⁶⁴Lr, ²⁶⁵Lr, ²⁶⁶Lr",
        "isotopes_stable": "None",
        "lifetime": 14.44444444444,
        "melting_point": 1900,
        "oxidation_states": "3c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "2P1/2",
        "series": "actinide",
        "source": "https://en.wikipedia.org/wiki/Lawrencium",
        "summary": "<p>Lawrencium is a synthetic chemical element with the symbol Lr (formerly Lw) and atomic number 103. It is named in honor of Ernest Lawrence, inventor of the cyclotron, a device that was used to discover many artificial radioactive elements. A radioactive metal, lawrencium is the eleventh transuranic element and is also the final member of the actinide series. Like all elements with atomic number over 100, lawrencium can only be produced in particle accelerators by bombarding lighter elements with charged particles. Fourteen isotopes of lawrencium are currently known; the most stable is 266Lr with a half_life of 11 hours, but the shorter-lived 260Lr (half_life 2.7 minutes) is most commonly used in chemistry because it can be produced on a larger scale.</p><p>Chemistry experiments have confirmed that lawrencium behaves as a heavier homolog to lutetium in the periodic table, and is a trivalent element. It thus could also be classified as the first of the 7th-period transition metals: however, its electron configuration is anomalous for its position in the periodic table, having an s2p configuration instead of the s2d configuration of its homolog lutetium. This means that lawrencium may be more volatile than expected for its position in the periodic table and have a volatility comparable to that of lead.</p><p>In the 1950s, 1960s, and 1970s, many claims of the synthesis of lawrencium of varying quality were made from laboratories in the Soviet Union and the United States. The priority of the discovery and therefore the naming of the element was disputed between Soviet and American scientists, and while the International Union of Pure and Applied Chemistry (IUPAC) initially established lawrencium as the official name for the element and gave the American team credit for the discovery, this was reevaluated in 1997, giving both teams shared credit for the discovery but not changing the element's name.</p>",
        "valence_electrons": 3
    },
    {
        "name": "Rutherfordium",
        "symbol": "Rf",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 267,
        "atomic_number": 104,
        "block": "d-block",
        "boiling_point": 5800,
        "classifications": {
            "cas_number": "CAS53850-36-5"
        },
        "cpk_hex": "cc0059",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1964,
            "by": "Joint Institute for Nuclear Research",
            "location": "Russia and The United States"
        },
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d²",
        "electron_configuration_semantic": "[Rn] 5f¹⁴ 6d² 7s²",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            10,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 10, 2",
        "group": 4,
        "half_life": 13.05555555556,
        "ionization_energies": [
            580
        ],
        "isotopes_known": "²⁵³Rf, ²⁵⁴Rf, ²⁵⁵Rf, ²⁵⁶Rf, ²⁵⁷Rf, ²⁵⁸Rf, ²⁵⁹Rf, ²⁶⁰Rf, ²⁶¹Rf, ²⁶²Rf, ²⁶³Rf, ²⁶⁴Rf, ²⁶⁵Rf, ²⁶⁶Rf, ²⁶⁷Rf, ²⁶⁸Rf",
        "isotopes_stable": "None",
        "lifetime": 18.88888888889,
        "melting_point": 2400,
        "oxidation_states": "4c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "3F2",
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Rutherfordium",
        "summary": "<p>Rutherfordium is a synthetic chemical element with the symbol Rf and atomic number 104, named after New Zealand physicist Ernest Rutherford. As a synthetic element, it is not found in nature and can only be created in a laboratory. It is radioactive; the most stable known isotope, 267Rf, has a half_life of approximately 1.3 hours.</p><p>In the periodic table of the elements, it is a d-block element and the second of the fourth-row transition elements. It is a member of the 7th period and belongs to the group 4 elements. Chemistry experiments have confirmed that rutherfordium behaves as the heavier homologue to hafnium in group 4. The chemical properties of rutherfordium are characterized only partly. They compare well with the chemistry of the other group 4 elements, even though some calculations had indicated that the element might show significantly different properties due to relativistic effects.</p><p>In the 1960s, small amounts of rutherfordium were produced in the Joint Institute for Nuclear Research in the Soviet Union and at the Lawrence Berkeley National Laboratory in California. The priority of the discovery and therefore the naming of the element was disputed between Soviet and American scientists, and it was not until 1997 that the International Union of Pure and Applied Chemistry (IUPAC) established rutherfordium as the official name for the element.</p>",
        "valence_electrons": 4
    },
    {
        "name": "Dubnium",
        "symbol": "Db",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 268,
        "atomic_number": 105,
        "block": "d-block",
        "classifications": {
            "cas_number": "CAS53850-35-4"
        },
        "cpk_hex": "d1004f",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1967,
            "by": "Joint Institute for Nuclear Research",
            "location": "Russia and The United States"
        },
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d³",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d³ 7s²",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            11,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 11, 2",
        "group": 5,
        "half_life": 5.555555555556,
        "isotopes_known": "²⁵⁵Db, ²⁵⁶Db, ²⁵⁷Db, ²⁵⁸Db, ²⁵⁹Db, ²⁶⁰Db, ²⁶¹Db, ²⁶²Db, ²⁶³Db, ²⁶⁴Db, ²⁶⁵Db, ²⁶⁶Db, ²⁶⁷Db, ²⁶⁸Db, ²⁶⁹Db, ²⁷⁰Db",
        "isotopes_stable": "None",
        "lifetime": 8.333333333333,
        "oxidation_states": "5c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "4F3/2",
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Dubnium",
        "summary": "<p>Dubnium is a synthetic chemical element with the symbol Db and atomic number 105. Dubnium is highly radioactive: the most stable known isotope, dubnium-268, has a half_life of about 28 hours. This greatly limits extended research on dubnium.</p><p>Dubnium does not occur naturally on Earth and is produced artificially. The Soviet Joint Institute for Nuclear Research (JINR) claimed the first discovery of the element in 1968, followed by the American Lawrence Berkeley Laboratory in 1970. Both teams proposed their names for the new element and used them without formal approval. The long-standing dispute was resolved in 1993 by an official investigation of the discovery claims by the Transfermium Working Group, formed by the International Union of Pure and Applied Chemistry and the International Union of Pure and Applied Physics, resulting in credit for the discovery being officially shared between both teams. The element was formally named dubnium in 1997 after the town of Dubna, the site of the JINR.</p><p>Theoretical research establishes dubnium as a member of group 5 in the 6d series of transition metals, placing it under vanadium, niobium, and tantalum. Dubnium should share most properties, such as its valence electron configuration and having a dominant +5 oxidation state, with the other group 5 elements, with a few anomalies due to relativistic effects. A limited investigation of dubnium chemistry has confirmed this. Solution chemistry experiments have revealed that dubnium often behaves more like niobium rather than tantalum, breaking periodic trends.</p>",
        "valence_electrons": 5
    },
    {
        "name": "Seaborgium",
        "symbol": "Sg",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 269,
        "atomic_number": 106,
        "block": "d-block",
        "classifications": {
            "cas_number": "CAS54038-81-2"
        },
        "cpk_hex": "d90045",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1974,
            "by": "Lawrence Berkeley National Laboratory",
            "location": "The United States"
        },
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁴",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d⁴ 7s²",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            12,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 12, 2",
        "group": 6,
        "half_life": 1.944444444444,
        "isotopes_known": "²⁵⁸Sg, ²⁵⁹Sg, ²⁶⁰Sg, ²⁶¹Sg, ²⁶²Sg, ²⁶³Sg, ²⁶⁴Sg, ²⁶⁵Sg, ²⁶⁶Sg, ²⁶⁷Sg, ²⁶⁸Sg, ²⁶⁹Sg, ²⁷⁰Sg, ²⁷¹Sg, ²⁷²Sg, ²⁷³Sg",
        "isotopes_stable": "None",
        "lifetime": 2.777777777778,
        "oxidation_states": "6c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "5D0",
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Seaborgium",
        "summary": "<p>Seaborgium is a synthetic chemical element with the symbol Sg and atomic number 106. It is named after the American nuclear chemist Glenn T. Seaborg. As a synthetic element, it can be created in a laboratory but is not found in nature. It is also radioactive; the most stable known isotope, 269Sg, has a half_life of approximately 14 minutes.</p><p>In the periodic table of the elements, it is a d-block transactinide element. It is a member of the 7th period and belongs to the group 6 elements as the fourth member of the 6d series of transition metals. Chemistry experiments have confirmed that seaborgium behaves as the heavier homologue to tungsten in group 6. The chemical properties of seaborgium are characterized only partly, but they compare well with the chemistry of the other group 6 elements.</p><p>In 1974, a few atoms of seaborgium were produced in laboratories in the Soviet Union and in the United States. The priority of the discovery and therefore the naming of the element was disputed between Soviet and American scientists, and it was not until 1997 that the International Union of Pure and Applied Chemistry (IUPAC) established seaborgium as the official name for the element. It is one of only two elements named after a living person at the time of naming, the other being oganesson, element 118.</p>",
        "valence_electrons": 6
    },
    {
        "name": "Bohrium",
        "symbol": "Bh",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 270,
        "atomic_number": 107,
        "block": "d-block",
        "classifications": {
            "cas_number": "CAS54037-14-8"
        },
        "cpk_hex": "e00038",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1981,
            "by": "GSI Helmholtz Centre for Heavy Ion Research",
            "location": "Germany"
        },
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁵",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d⁵ 7s²",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            13,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 13, 2",
        "group": 7,
        "half_life": 1.5,
        "isotopes_known": "²⁶⁰Bh, ²⁶¹Bh, ²⁶²Bh, ²⁶³Bh, ²⁶⁴Bh, ²⁶⁵Bh, ²⁶⁶Bh, ²⁶⁷Bh, ²⁶⁸Bh, ²⁶⁹Bh, ²⁷⁰Bh, ²⁷¹Bh, ²⁷²Bh, ²⁷³Bh, ²⁷⁴Bh, ²⁷⁵Bh",
        "isotopes_stable": "None",
        "lifetime": 2.166666666667,
        "oxidation_states": "7c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "6S5/2",
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Bohrium",
        "summary": "<p>Bohrium is a synthetic chemical element with the symbol Bh and atomic number 107. It is named after Danish physicist Niels Bohr. As a synthetic element, it can be created in a laboratory but is not found in nature. All known isotopes of bohrium are extremely radioactive; the most stable known isotope is 270Bh with a half_life of approximately 61 seconds, though the unconfirmed 278Bh may have a longer half_life of about 690 seconds.</p><p>In the periodic table, it is a d-block transactinide element. It is a member of the 7th period and belongs to the group 7 elements as the fifth member of the 6d series of transition metals. Chemistry experiments have confirmed that bohrium behaves as the heavier homologue to rhenium in group 7. The chemical properties of bohrium are characterized only partly, but they compare well with the chemistry of the other group 7 elements.</p>",
        "valence_electrons": 7
    },
    {
        "name": "Hassium",
        "symbol": "Hs",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 269,
        "atomic_number": 108,
        "block": "d-block",
        "classifications": {
            "cas_number": "CAS54037-57-9"
        },
        "cpk_hex": "e6002e",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1984,
            "by": "GSI Helmholtz Centre for Heavy Ion Research",
            "location": "Germany"
        },
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁶",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d⁶ 7s²",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            14,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 14, 2",
        "group": 8,
        "half_life": 1.111111111111,
        "isotopes_known": "²⁶³Hs, ²⁶⁴Hs, ²⁶⁵Hs, ²⁶⁶Hs, ²⁶⁷Hs, ²⁶⁸Hs, ²⁶⁹Hs, ²⁷⁰Hs, ²⁷¹Hs, ²⁷²Hs, ²⁷³Hs, ²⁷⁴Hs, ²⁷⁵Hs, ²⁷⁶Hs, ²⁷⁷Hs",
        "isotopes_stable": "None",
        "lifetime": 1.388888888889,
        "melting_point": 126,
        "oxidation_states": "8c",
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "5D4",
        "series": "transition metal",
        "source": "https://en.wikipedia.org/wiki/Hassium",
        "summary": "<p>Hassium is a chemical element with the symbol Hs and the atomic number 108. Hassium is highly radioactive; its most stable known isotopes have half-lives of approximately ten seconds. One of its isotopes, 270Hs, has magic numbers of both protons and neutrons for deformed nuclei, which gives it greater stability against spontaneous fission. Hassium is a superheavy element; it has been produced in a laboratory only in very small quantities by fusing heavy nuclei with lighter ones. Natural occurrences of the element have been hypothesised but never found.</p><p>In the periodic table of elements, hassium is a transactinide element, a member of the 7th period and group 8; it is thus the sixth member of the 6d series of transition metals. Chemistry experiments have confirmed that hassium behaves as the heavier homologue to osmium, reacting readily with oxygen to form a volatile tetroxide. The chemical properties of hassium have been only partly characterized, but they compare well with the chemistry of the other group 8 elements.</p><p>The principal innovation that led to the discovery of hassium was the technique of cold fusion, in which the fused nuclei did not differ by mass as much as in earlier techniques. It relied on greater stability of target nuclei, which in turn decreased excitation energy. This decreased the number of neutron ejections during synthesis, creating heavier, more stable resulting nuclei. The technique was first tested at the Joint Institute for Nuclear Research (JINR) in Dubna, Moscow Oblast, Russian SFSR, Soviet Union, in 1974. JINR used this technique to attempt synthesis of element 108 in 1978, in 1983, and in 1984; the latter experiment resulted in a claim that element 108 had been produced. Later in 1984, a synthesis claim followed from the GSI Helmholtz Centre for Heavy Ion Research (GSI) in Darmstadt, Hesse, West Germany. The 1993 report by the Transfermium Working Group, formed by the International Union of Pure and Applied Chemistry and the International Union of Pure and Applied Physics, concluded that the report from Darmstadt was conclusive on its own whereas that from Dubna was not, and major credit was assigned to the German scientists. GSI formally announced they wished to name the element hassium after the German state of Hesse (Hassia in Latin) home to the facility in 1992; this name was accepted as final in 1997.</p>"
    },
    {
        "name": "Meitnerium",
        "symbol": "Mt",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 278,
        "atomic_number": 109,
        "block": "d-block",
        "classifications": {
            "cas_number": "CAS54038-01-6"
        },
        "cpk_hex": "eb0026",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1982,
            "by": "GSI Helmholtz Centre for Heavy Ion Research",
            "location": "Germany"
        },
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁷",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d⁷ 7s²",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            15,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 15, 2",
        "group": 9,
        "half_life": 30,
        "isotopes_known": "²⁶⁵Mt, ²⁶⁶Mt, ²⁶⁷Mt, ²⁶⁸Mt, ²⁶⁹Mt, ²⁷⁰Mt, ²⁷¹Mt, ²⁷²Mt, ²⁷³Mt, ²⁷⁴Mt, ²⁷⁵Mt, ²⁷⁶Mt, ²⁷⁷Mt, ²⁷⁸Mt, ²⁷⁹Mt",
        "isotopes_stable": "None",
        "lifetime": 43.33333333333,
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "4F9/2",
        "series": "unknown, probably transition metal",
        "source": "https://en.wikipedia.org/wiki/Meitnerium",
        "summary": "<p>Meitnerium is a synthetic chemical element with the symbol Mt and atomic number 109. It is an extremely radioactive synthetic element (an element not found in nature, but can be created in a laboratory). The most stable known isotope, meitnerium-278, has a half_life of 4.5 seconds, although the unconfirmed meitnerium-282 may have a longer half_life of 67 seconds. The GSI Helmholtz Centre for Heavy Ion Research near Darmstadt, Germany, first created this element in 1982. It is named after Lise Meitner.</p><p>In the periodic table, meitnerium is a d-block transactinide element. It is a member of the 7th period and is placed in the group 9 elements, although no chemical experiments have yet been carried out to confirm that it behaves as the heavier homologue to iridium in group 9 as the seventh member of the 6d series of transition metals. Meitnerium is calculated to have similar properties to its lighter homologues, cobalt, rhodium, and iridium.</p>"
    },
    {
        "name": "Darmstadtium",
        "symbol": "Ds",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 281,
        "atomic_number": 110,
        "block": "d-block",
        "classifications": {
            "cas_number": "CAS54083-77-1"
        },
        "cpk_hex": "ee0023",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1994,
            "by": "GSI Helmholtz Centre for Heavy Ion Research",
            "location": "Germany"
        },
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁸",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d⁹ 7s¹",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            16,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 16, 2",
        "group": 10,
        "half_life": 4,
        "isotopes_known": "²⁶⁷Ds, ²⁶⁸Ds, ²⁶⁹Ds, ²⁷⁰Ds, ²⁷¹Ds, ²⁷²Ds, ²⁷³Ds, ²⁷⁴Ds, ²⁷⁵Ds, ²⁷⁶Ds, ²⁷⁷Ds, ²⁷⁸Ds, ²⁷⁹Ds, ²⁸⁰Ds, ²⁸¹Ds",
        "isotopes_stable": "None",
        "lifetime": 5.833333333333,
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "3D3",
        "series": "unknown, probably transition metal",
        "source": "https://en.wikipedia.org/wiki/Darmstadtium",
        "summary": "<p>Darmstadtium is a chemical element with the symbol Ds and atomic number 110. It is an extremely radioactive synthetic element. The most stable known isotope, darmstadtium-281, has a half_life of approximately 12.7 seconds. Darmstadtium was first created in 1994 by the GSI Helmholtz Centre for Heavy Ion Research in the city of Darmstadt, Germany, after which it was named.</p><p>In the periodic table, it is a d-block transactinide element. It is a member of the 7th period and is placed in the group 10 elements, although no chemical experiments have yet been carried out to confirm that it behaves as the heavier homologue to platinum in group 10 as the eighth member of the 6d series of transition metals. Darmstadtium is calculated to have similar properties to its lighter homologues, nickel, palladium, and platinum.</p>"
    },
    {
        "name": "Roentgenium",
        "symbol": "Rg",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 282,
        "atomic_number": 111,
        "block": "d-block",
        "classifications": {
            "cas_number": "CAS54386-24-2"
        },
        "cpk_hex": "f00021",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1994,
            "by": "GSI Helmholtz Centre for Heavy Ion Research",
            "location": "Germany"
        },
        "electron_affinity": 151,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d⁹",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d¹⁰ 7s¹",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            17,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 17, 2",
        "group": 11,
        "half_life": 10,
        "isotopes_known": "²⁷²Rg, ²⁷³Rg, ²⁷⁴Rg, ²⁷⁵Rg, ²⁷⁶Rg, ²⁷⁷Rg, ²⁷⁸Rg, ²⁷⁹Rg, ²⁸⁰Rg, ²⁸¹Rg, ²⁸²Rg, ²⁸³Rg",
        "isotopes_stable": "None",
        "lifetime": 14.5,
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "2S1/2",
        "series": "unknown, probably transition metal",
        "source": "https://en.wikipedia.org/wiki/Roentgenium",
        "summary": "<p>Roentgenium is a chemical element with the symbol Rg and atomic number 111. It is an extremely radioactive synthetic element that can be created in a laboratory but is not found in nature. The most stable known isotope, roentgenium-282, has a half_life of 100 seconds, although the unconfirmed roentgenium-286 may have a longer half_life of about 10.7 minutes. Roentgenium was first created in 1994 by the GSI Helmholtz Centre for Heavy Ion Research near Darmstadt, Germany. It is named after the physicist Wilhelm Röntgen (also spelled Roentgen), who discovered X-rays. Only a few roentgenium atoms have ever been synthesized, and they contain no current practical application beyond that of scientific study.</p><p>In the periodic table, it is a d-block transactinide element. It is a member of the 7th period and is placed in the group 11 elements, although no chemical experiments have been carried out to confirm that it behaves as the heavier homologue to gold in group 11 as the ninth member of the 6d series of transition metals. Roentgenium is calculated to have similar properties to its lighter homologues, copper, silver, and gold, although it may show some differences from them. Roentgenium is thought to be a solid at room temperature and to have a metallic appearance in its regular state.</p>"
    },
    {
        "name": "Copernicium",
        "symbol": "Cn",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 285,
        "atomic_number": 112,
        "block": "d-block",
        "boiling_point": 3570,
        "classifications": {
            "cas_number": "CAS54084-26-3"
        },
        "cpk_hex": "f3001e",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1996,
            "by": "GSI Helmholtz Centre for Heavy Ion Research",
            "location": "Germany"
        },
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d¹⁰ 7s²",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            18,
            2
        ],
        "energy_levels": "2, 8, 18, 32, 32, 18, 2",
        "group": 12,
        "half_life": 40,
        "isotopes_known": "²⁷⁷Cn, ²⁷⁸Cn, ²⁷⁹Cn, ²⁸⁰Cn, ²⁸¹Cn, ²⁸²Cn, ²⁸³Cn, ²⁸⁴Cn, ²⁸⁵Cn",
        "isotopes_stable": "None",
        "lifetime": 58.33333333333,
        "period": 7,
        "phase": "Gas",
        "quantum_numbers": "1S0",
        "series": "unknown, probably transition metal",
        "source": "https://en.wikipedia.org/wiki/Copernicium",
        "summary": "<p>Copernicium is a synthetic chemical element with the symbol Cn and atomic number 112. Its known isotopes are extremely radioactive, and have only been created in a laboratory. The most stable known isotope, copernicium-285, has a half_life of approximately 28 seconds. Copernicium was first created in 1996 by the GSI Helmholtz Centre for Heavy Ion Research near Darmstadt, Germany. It is named after the astronomer Nicolaus Copernicus.</p><p>In the periodic table of the elements, copernicium is a d-block transactinide element and a group 12 element. During reactions with gold, it has been shown to be an extremely volatile substance, so much so that it is possibly a gas or a volatile liquid at standard temperature and pressure.</p><p>Copernicium is calculated to have several properties that differ from its lighter homologues in group 12, zinc, cadmium and mercury; due to relativistic effects, it may give up its 6d electrons instead of its 7s ones, and it may have more similarities to the noble gases such as radon rather than its group 12 homologues. Calculations indicate that copernicium may show the oxidation state +4, while mercury shows it in only one compound of disputed existence and zinc and cadmium do not show it at all. It has also been predicted to be more difficult to oxidize copernicium from its neutral state than the other group 12 elements. Predictions vary on whether solid copernicium would be a metal, semiconductor, or insulator.</p>"
    },
    {
        "name": "Nihonium",
        "symbol": "Nh",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 286,
        "atomic_number": 113,
        "block": "p-block",
        "boiling_point": 1430,
        "classifications": {
            "cas_number": "CAS54084-70-7"
        },
        "cpk_hex": "f5001c",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 2004,
            "by": "RIKEN",
            "location": "Russia and The United States"
        },
        "electron_affinity": 66.6,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p¹",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d¹⁰ 7s² 7p¹",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            18,
            3
        ],
        "energy_levels": "2, 8, 18, 32, 32, 18, 3",
        "group": 13,
        "half_life": 20,
        "isotopes_known": "²⁸³Nh, ²⁸⁴Nh, ²⁸⁵Nh, ²⁸⁶Nh, ²⁸⁷Nh",
        "isotopes_stable": "None",
        "lifetime": 28.33333333333,
        "melting_point": 700,
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "2P1/2",
        "series": "unknown, probably transition metal",
        "source": "https://en.wikipedia.org/wiki/Ununtrium",
        "summary": "<p>Nihonium is a synthetic chemical element with the symbol Nh and atomic number 113. It is extremely radioactive; its most stable known isotope, nihonium-286, has a half_life of about 10 seconds. In the periodic table, nihonium is a transactinide element in the p-block. It is a member of period 7 and group 13 (boron group).</p><p>Nihonium was first reported to have been created in 2003 by a Russian–American collaboration at the Joint Institute for Nuclear Research (JINR) in Dubna, Russia, and in 2004 by a team of Japanese scientists at Riken in Wakō, Japan. The confirmation of their claims in the ensuing years involved independent teams of scientists working in the United States, Germany, Sweden, and China, as well as the original claimants in Russia and Japan. In 2015, the IUPAC/IUPAP Joint Working Party recognised the element and assigned the priority of the discovery and naming rights for the element to Riken. The Riken team suggested the name nihonium in 2016, which was approved in the same year. The name comes from the common Japanese name for Japan (日本, nihon).</p><p>Very little is known about nihonium, as it has only been made in very small amounts that decay within seconds. The anomalously long lives of some superheavy nuclides, including some nihonium isotopes, are explained by the \"island of stability\" theory. Experiments support the theory, with the half-lives of the confirmed nihonium isotopes increasing from milliseconds to seconds as neutrons are added and the island is approached. Nihonium has been calculated to have similar properties to its homologues boron, aluminium, gallium, indium, and thallium. All but boron are post-transition metals, and nihonium is expected to be a post-transition metal as well. It should also show several major differences from them; for example, nihonium should be more stable in the +1 oxidation state than the +3 state, like thallium, but in the +1 state nihonium should behave more like silver and astatine than thallium. Preliminary experiments in 2017 showed that elemental nihonium is not very volatile; its chemistry remains largely unexplored.</p>"
    },
    {
        "name": "Flerovium",
        "symbol": "Fl",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 289,
        "atomic_number": 114,
        "block": "p-block",
        "boiling_point": 420,
        "classifications": {
            "cas_number": "CAS54085-16-4"
        },
        "cpk_hex": "fd0014",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 1998,
            "by": "Joint Institute for Nuclear Research",
            "location": "Russia"
        },
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p²",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d¹⁰ 7s² 7p²",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            18,
            4
        ],
        "energy_levels": "2, 8, 18, 32, 32, 18, 4",
        "group": 14,
        "half_life": 1.316666666667,
        "isotopes_known": "²⁸⁵Fl, ²⁸⁶Fl, ²⁸⁷Fl, ²⁸⁸Fl, ²⁸⁹Fl",
        "isotopes_stable": "None",
        "lifetime": 2,
        "melting_point": 340,
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "3P0",
        "series": "unknown, probably post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Flerovium",
        "summary": "<p>Flerovium is a superheavy artificial chemical element with the symbol Fl and atomic number 114. It is an extremely radioactive synthetic element. The element is named after the Flerov Laboratory of Nuclear Reactions of the Joint Institute for Nuclear Research in Dubna, Russia, where the element was discovered in 1998. The name of the laboratory, in turn, honours the Russian physicist Georgy Flyorov (Флёров in Cyrillic, hence the transliteration of \"yo\" to \"e\"). The name was adopted by IUPAC on 30 May 2012. The name and symbol had previously been proposed for element 102 (nobelium), but not accepted by IUPAC at that time.</p><p>In the periodic table of the elements, it is a transactinide element in the p-block. It is a member of the 7th period and is the heaviest known member of the carbon group; it is also the heaviest element whose chemistry has been investigated. Initial chemical studies performed in 2007–2008 indicated that flerovium was unexpectedly volatile for a group 14 element; in preliminary results it even seemed to exhibit properties similar to those of the noble gases. More recent results show that flerovium's reaction with gold is similar to that of copernicium, showing that it is a very volatile element that may even be gaseous at standard temperature and pressure, that it would show metallic properties, consistent with it being the heavier homologue of lead, and that it would be the least reactive metal in group 14. The question of whether flerovium behaves more like a metal or a noble gas is still unresolved as of 2020.</p><p>About 90 atoms of flerovium have been observed: 58 were synthesized directly, and the rest were made from the radioactive decay of heavier elements. All of these flerovium atoms have been shown to have mass numbers from 284 to 290. The most stable known flerovium isotope, flerovium-289, has a half_life of around 1.9 seconds, but it is possible that the unconfirmed flerovium-290 (with one extra neutron) may have a longer half_life of 19 seconds; this would be one of the longest half-lives of any isotope of any element at these farthest reaches of the periodic table. Flerovium is predicted to be near the centre of the theorized island of stability, and it is expected that heavier flerovium isotopes, especially the possibly magic flerovium-298, may have even longer half-lives.</p>"
    },
    {
        "name": "Moscovium",
        "symbol": "Mc",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 289,
        "atomic_number": 115,
        "block": "p-block",
        "boiling_point": 1400,
        "classifications": {
            "cas_number": "CAS54085-64-2"
        },
        "cpk_hex": "fa0017",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 2004,
            "by": "Joint Institute for Nuclear Research",
            "location": "Russia and The United States"
        },
        "electron_affinity": 35.3,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p³",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d¹⁰ 7s² 7p³",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            18,
            5
        ],
        "energy_levels": "2, 8, 18, 32, 32, 18, 5",
        "group": 15,
        "half_life": 1,
        "isotopes_known": "²⁸⁷Mc, ²⁸⁸Mc, ²⁸⁹Mc, ²⁹⁰Mc, ²⁹¹Mc",
        "isotopes_stable": "None",
        "lifetime": 1.5,
        "melting_point": 670,
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "4S3/2",
        "series": "unknown, probably post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Ununpentium",
        "summary": "<p>Moscovium is a synthetic chemical element with the symbol Mc and atomic number 115. It was first synthesized in 2003 by a joint team of Russian and American scientists at the Joint Institute for Nuclear Research (JINR) in Dubna, Russia. In December 2015, it was recognized as one of four new elements by the Joint Working Party of international scientific bodies IUPAC and IUPAP. On 28 November 2016, it was officially named after the Moscow Oblast, in which the JINR is situated.</p><p>Moscovium is an extremely radioactive element: its most stable known isotope, moscovium-290, has a half_life of only 0.65 seconds. In the periodic table, it is a p-block transactinide element. It is a member of the 7th period and is placed in group 15 as the heaviest pnictogen, although it has not been confirmed to behave as a heavier homologue of the pnictogen bismuth. Moscovium is calculated to have some properties similar to its lighter homologues, nitrogen, phosphorus, arsenic, antimony, and bismuth, and to be a post-transition metal, although it should also show several major differences from them. In particular, moscovium should also have significant similarities to thallium, as both have one rather loosely bound electron outside a quasi-closed shell. About 100 atoms of moscovium have been observed to date, all of which have been shown to have mass numbers from 287 to 290.</p>"
    },
    {
        "name": "Livermorium",
        "symbol": "Lv",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 293,
        "atomic_number": 116,
        "block": "p-block",
        "boiling_point": 1085,
        "classifications": {
            "cas_number": "CAS54100-71-9"
        },
        "cpk_hex": "fd0014",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 2000,
            "by": "Joint Institute for Nuclear Research",
            "location": "Russia"
        },
        "electron_affinity": 74.9,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p⁴",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d¹⁰ 7s² 7p⁴",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            18,
            6
        ],
        "energy_levels": "2, 8, 18, 32, 32, 18, 6",
        "group": 16,
        "half_life": 120,
        "isotopes_known": "²⁸⁹Lv, ²⁹⁰Lv, ²⁹¹Lv, ²⁹²Lv",
        "isotopes_stable": "None",
        "lifetime": 173,
        "melting_point": 709,
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "3P2",
        "series": "unknown, probably post-transition metal",
        "source": "https://en.wikipedia.org/wiki/Livermorium",
        "summary": "<p>Livermorium is a synthetic chemical element with the symbol Lv and has an atomic number of 116. It is an extremely radioactive element that has only been created in the laboratory and has not been observed in nature. The element is named after the Lawrence Livermore National Laboratory in the United States, which collaborated with the Joint Institute for Nuclear Research (JINR) in Dubna, Russia to discover livermorium during experiments made between 2000 and 2006. The name of the laboratory refers to the city of Livermore, California where it is located, which in turn was named after the rancher and landowner Robert Livermore. The name was adopted by IUPAC on May 30, 2012. Four isotopes of livermorium are known, with mass numbers between 290 and 293 inclusive; the longest-lived among them is livermorium-293 with a half_life of about 60 milliseconds. A fifth possible isotope with mass number 294 has been reported but not yet confirmed.</p><p>In the periodic table, it is a p-block transactinide element. It is a member of the 7th period and is placed in group 16 as the heaviest chalcogen, although it has not been confirmed to behave as the heavier homologue to the chalcogen polonium. Livermorium is calculated to have some similar properties to its lighter homologues (oxygen, sulfur, selenium, tellurium, and polonium), and be a post-transition metal, although it should also show several major differences from them.</p>"
    },
    {
        "name": "Tennessine",
        "symbol": "Ts",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 294,
        "atomic_number": 117,
        "block": "p-block",
        "boiling_point": 883,
        "classifications": {
            "cas_number": "CAS87658-56-8"
        },
        "cpk_hex": "fd0014",
        "discovered": {
            "year": 2010,
            "by": "Joint Institute for Nuclear Research"
        },
        "electron_affinity": 165.9,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p⁵",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d¹⁰ 7s² 7p⁵",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            18,
            7
        ],
        "energy_levels": "2, 8, 18, 32, 32, 18, 7",
        "group": 17,
        "half_life": 50,
        "isotopes_known": "²⁹¹Ts, ²⁹²Ts, ²⁹³Ts, ²⁹⁴Ts",
        "isotopes_stable": "None",
        "lifetime": 72,
        "melting_point": 723,
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "2P3/2",
        "series": "unknown, probably metalloid",
        "source": "https://en.wikipedia.org/wiki/Tennessine",
        "summary": "<p>Tennessine is a synthetic chemical element with the symbol Ts and atomic number 117. It is the second-heaviest known element and the penultimate element of the 7th period of the periodic table.</p><p>The discovery of tennessine was officially announced in Dubna, Russia, by a Russian–American collaboration in April 2010, which makes it the most recently discovered element as of 2021. One of its daughter isotopes was created directly in 2011, partially confirming the results of the experiment. The experiment itself was repeated successfully by the same collaboration in 2012 and by a joint German–American team in May 2014. In December 2015, the Joint Working Party of the International Union of Pure and Applied Chemistry (IUPAC) and the International Union of Pure and Applied Physics, which evaluates claims of discovery of new elements, recognized the element and assigned the priority to the Russian–American team. In June 2016, the IUPAC published a declaration stating that the discoverers had suggested the name tennessine after Tennessee, United States, a name which was officially adopted in November 2016.</p><p>Tennessine may be located in the \"island of stability\", a concept that explains why some superheavy elements are more stable compared to an overall trend of decreasing stability for elements beyond bismuth on the periodic table. The synthesized tennessine atoms have lasted tens and hundreds of milliseconds. In the periodic table, tennessine is expected to be a member of group 17, all other members of which are halogens. Some of its properties may differ significantly from those of the halogens due to relativistic effects. As a result, tennessine is expected to be a volatile metal that neither forms anions nor achieves high oxidation states. A few key properties, such as its melting and boiling points and its first ionization energy, are nevertheless expected to follow the periodic trends of the halogens.</p>"
    },
    {
        "name": "Oganesson",
        "symbol": "Og",
        "abundance": {
            "universe": 0,
            "solar": 0,
            "meteor": 0,
            "crust": 0,
            "ocean": 0,
            "human": 0
        },
        "atomic_mass": 294,
        "atomic_number": 118,
        "block": "p-block",
        "boiling_point": 350,
        "classifications": {
            "cas_number": "CAS54144-19-3"
        },
        "cpk_hex": "fd0014",
        "decay_mode": "AlphaEmission",
        "discovered": {
            "year": 2006,
            "by": "Joint Institute for Nuclear Research",
            "location": "Russia and The United States"
        },
        "electron_affinity": 5.40318,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p⁶",
        "electron_configuration_semantic": "*[Rn] 5f¹⁴ 6d¹⁰ 7s² 7p⁶",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            18,
            8
        ],
        "energy_levels": "2, 8, 18, 32, 32, 18, 8",
        "group": 18,
        "half_life": 5,
        "isotopes_known": "²⁹³Og",
        "isotopes_stable": "None",
        "lifetime": 7,
        "period": 7,
        "phase": "Solid",
        "quantum_numbers": "1S0",
        "series": "unknown, predicted to be noble gas",
        "source": "https://en.wikipedia.org/wiki/Oganesson",
        "summary": "<p>Oganesson is a synthetic chemical element with the symbol Og and atomic number 118. It was first synthesized in 2002 at the Joint Institute for Nuclear Research (JINR) in Dubna, near Moscow, Russia, by a joint team of Russian and American scientists. In December 2015, it was recognized as one of four new elements by the Joint Working Party of the international scientific bodies IUPAC and IUPAP. It was formally named on 28 November 2016. The name honors the nuclear physicist Yuri Oganessian, who played a leading role in the discovery of the heaviest elements in the periodic table. It is one of only two elements named after a person who was alive at the time of naming, the other being seaborgium, and the only element whose eponym is alive today.</p><p>Oganesson has the highest atomic number and highest atomic mass of all known elements. The radioactive oganesson atom is very unstable, and since 2005, only five (possibly six) atoms of the isotope oganesson-294 have been detected. Although this allowed very little experimental characterization of its properties and possible compounds, theoretical calculations have resulted in many predictions, including some surprising ones. For example, although oganesson is a member of group 18 (the noble gases) – the first synthetic element to be so – it may be significantly reactive, unlike all the other elements of that group. It was formerly thought to be a gas under normal conditions but is now predicted to be a solid due to relativistic effects. On the periodic table of the elements it is a p-block element and the last one of period 7.</p>"
    },
    {
        "name": "Ununennium",
        "symbol": "Uue",
        "atomic_mass": 315,
        "atomic_number": 119,
        "boiling_point": 630,
        "cpk_hex": "fd0014",
        "discovered": {
            "by": "GSI Helmholtz Centre for Heavy Ion Research"
        },
        "electron_affinity": 63.87,
        "electron_configuration": "1s² 2s² 2p⁶ 3s² 3p⁶ 4s² 3d¹⁰ 4p⁶ 5s² 4d¹⁰ 5p⁶ 6s² 4f¹⁴ 5d¹⁰ 6p⁶ 7s² 5f¹⁴ 6d¹⁰ 7p⁶ 8s¹",
        "electron_configuration_semantic": "*[Uuo] 8s¹",
        "electrons_per_shell": [
            2,
            8,
            18,
            32,
            32,
            18,
            8,
            1
        ],
        "energy_levels": "2, 8, 18, 32, 32, 18, 8, 1",
        "group": 1,
        "period": 8,
        "phase": "Solid",
        "series": "unknown, but predicted to be an alkali metal",
        "source": "https://en.wikipedia.org/wiki/Ununennium",
        "summary": "<p>Ununennium, also known as eka-francium or element 119, is the hypothetical chemical element with symbol Uue and atomic number 119. Ununennium and Uue are the temporary systematic IUPAC name and symbol respectively, which are used until the element is discovered, confirmed, and a permanent name is decided upon. In the periodic table of the elements, it is expected to be an s-block element, an alkali metal, and the first element in the eighth period. It is the lightest element that has not yet been synthesized.</p><p>Unsuccessful attempts to synthesize the element have been ongoing at RIKEN (Japan) and the Joint Institute for Nuclear Research (Dubna, Russia). Theoretical and experimental evidence has shown that the synthesis of ununennium will likely be far more difficult than that of the previous elements, and it may even be the penultimate element that can be synthesized with current technology.</p><p>Ununennium's position as the seventh alkali metal suggests that it would have similar properties to its lighter congeners. However, relativistic effects may cause some of its properties to differ from those expected from a straight application of periodic trends. For example, ununennium is expected to be less reactive than caesium and francium and to be closer in behavior to potassium or rubidium, and while it should show the characteristic +1 oxidation state of the alkali metals, it is also predicted to show the +3 oxidation state, which is unknown in any other alkali metal.</p>"
    }
];
